"""
Meter Simulator for for Helics.
Research group of Politecnico di Torino Energy Center Lab.
- author: Juan Gilberto Rueda Vásquez
- email: juan.rueda@polito.it
- status: Development
"""
import collections
import pprint
import pickle
import numpy as np
from pathlib import Path
import json

class SMModel:

    def __init__(self, name):
        self.name = name

        self.Pnet = 0.0
        self.Pload = 0.0
        self.Pprod = 0.0
        self.Pexport = 0.0
        self.Pinport = 0.0
        self.Pnetbatt = 0.0

class Meter():
    
    def __init__(self, step_size, collect_data = False, output_name=None, sim_meta= None):

        self.eid_prefix = 'Meter_'
        self.eid = None
        self.entities = {}
        self.step_size = None

        self.step_size = step_size
        self.meta = sim_meta
        self.collect_data = collect_data # TODO: il collettore è da rivedere ma non è fondamentale (sostituisce il
        # collector in parte
        if collect_data:
            self.data = collections.defaultdict(collections.defaultdict(list))
            if output_name == None:
                self.output_name = 'test'
            else:
                self.output_name = output_name

        if self.meta['models'] == {}:
            self.meta['models'] = sim_meta['models']
        # return self.meta
    
    def create(self,num, model, instance_name=None):
        next_eid = len(self.entities)
        entities = []
        if instance_name == None:
            instance_name = list(range(next_eid, next_eid + num))

        for i in range(len(instance_name)):
            eid = f'{model}_{instance_name[i]}'
            self.entities[eid] = SMModel(instance_name[i])
            entities.append({'eid': eid, 'type': model})
        
        self.name_eid = eid # Variable con el nombre del modelo generado

        return self.name_eid, self.entities

    def run(self, time, data):
        NetBatt = 0.0
        Pload = 0.0
        Pprod = 0.0
        var = ''
        for dest_eid, attrs in data.items():
            meter = self.entities[dest_eid]
            # print('meter es:',meter)
            for attr, values in attrs.items():
                var = attr
                # print('attr:',attr)
                # print('values:',type(values))
                # System reference from the consumers (load is positive)
                if attr == 'Load':
                    Pload = sum(values.values())
                elif attr == 'Prod':
                    Pprod = sum(values.values())
                elif attr == 'NetBatt':
                    NetBatt = sum(values.values())

            meter.Pload = Pload
            meter.Pprod = Pprod
            meter.Pnetbatt = NetBatt
            meter.Pnet = Pload - Pprod - NetBatt
            # TODO si puo fare meglio con numpy invece di usare if e usare data type diverso dal float per output
            if meter.Pnet < 0.0:
                meter.Pexport = meter.Pnet
                meter.Pinport = 0.0
            else:
                meter.Pexport = 0.0
                meter.Pinport = meter.Pnet

            if self.collect_data:
                self.data[time][f'{meter.name}:Pload'].append(Pload)
                self.data[time][f'{meter.name}:Pprod'].append(Pprod)
                self.data[time][f'{meter.name}:Pnet'].append(meter.Pnet)
                self.data[time][f'{meter.name}:Pinport'].append(meter.Pinport)
                self.data[time][f'{meter.name}:Pexport'].append(meter.Pexport)

        data = {}
        outputs = {self.name_eid:['P'+str(var.lower())]} # Variable creada para get data
        for eid, attrs in outputs.items():
            meter = self.entities[eid]
            model_type = eid.split('_')[0]
            data[eid] = {}
            for attr in attrs:
                if attr not in self.meta['models'][model_type]['attrs']:
                    raise ValueError('Unknown output attribute: %s' % attr)
                data[eid][attr] = getattr(meter,attr)

        return time + self.step_size, data

META = {'models': {'SmartMeter': {'public': True,'params': ['instance_name'],'attrs': ['Load', 'Prod', 'Pnet', 'Pprod', 'Pload', 'Pexport', 'Pinport'],},},}

input = {}
data = {'Load':{0:20,1:15,2:30}} # Ejemplo de como deben entrar los datos

prueba = Meter(step_size=60,sim_meta=META) 
name, ents =prueba.create(num=1, model='SmartMeter')
input [name] = data

time, salida = prueba.run(0,input)
print(time)
print(salida)