from datetime import datetime
import helics as h
import os
import ast
# import arrow
import gzip
import sys

# # # Loading Libraries #
sys.path.append(os.getcwd().replace('\\', '/')+'/classHelics')
sys.path.append(os.getcwd().replace('\\', '/')+'/Models')

from classHelics.classFederate import Federate
from Models.hl_scheduler import AgentScheduler

# # # META info #
META = {
    'models': {
        'scheduler': {
            'public': True,
            'params': [],
            'attrs': ['Tset'],
        },
    },
}

# # # Checking broker connection #
helicsversion = h.helicsGetVersion()
print("HouseHold: Helics version = {}".format(helicsversion))

day = 0

count = 0
for i in range(len(sys.argv)):
    count = i+1
    if count == len(sys.argv):
        break
    else :
        ent = str(sys.argv[i+1]).split(':')
        if ent[0] == 'PUBLIC':
            pass
        if ent[0] == 'ATTRS':
            pass
        if ent[0] == 'parm_input':
            parm_input = ast.literal_eval(sys.argv[i+1].split("parm_input:")[1].replace("*",'"'))
            schedule = parm_input['schedule']
            # schedule = schedule[1].replace("]","").replace("}","")
            # schedule = list(schedule.split(","))
        if ent[0] == 'days':
            day = ent[1]
        if ent[0] == 'name':
            name = ent[1]
        if ent[0] == 'start_date':
            start_date = datetime.fromtimestamp(int(ent[1]))

model_name = str(name.split('_')[0]).lower()

# # # # Starting the simulator #
x = AgentScheduler(start_date=str(start_date), sim_meta=META)
x.create(num=1, model=model_name, schedule=schedule)

day = int(day)*24*60

# # # Loading JSON info #
current_Path = os.getcwd().replace('\\', '/')
jsons_Path = current_Path+'/Jsons/'
# print(jsons_Path)
os.chdir(jsons_Path)

json_file = name

# # # # Back to main path #
# main_Path = os.path.normpath(os.getcwd() + os.sep + os.pardir).replace('\\', '/')
# os.chdir(main_Path)

fed = Federate()
fed.create_federate(json_file)
print("Creados los federates")
# pub_count = h.helicsFederateGetPublicationCount(fed.vfed)
# # print(pub_count)
# pubid = {}
# for i in range(0, pub_count):
#     pubid[i] = h.helicsFederateGetPublicationByIndex(fed.vfed, i)
#     pub_name = h.helicsPublicationGetKey(pubid[i])
#     print(pub_name)
# print(pubid)
# # # Starting Federates #
fed.start_async()
h.helicsFederateEnterExecutingModeComplete(fed.vfed)
print("Iniciado el Federate")
name = h.helicsFederateGetName(fed.vfed) # Obteniendo el nombre del federate
# print(name)

# # # # Executing loop #
step = -1
salida = 0
# info = x.get_houses()
while step < day:
    for i in range(1):
        step = fed.getCurrentTime()
        print("Current Time =" ,step)
        # print('next_time es:', salida)
        sendData, salida = x.run(salida)
        next_time = salida
        txt = str(sendData)
        # fed.publishString(pubid[i], txt)
        # fed.publish(pubid[i+n], value[i])
        print("Printer: Sending value =" ,txt, "at time =", step , " to DB")
        avanzar = h.helicsFederateRequestTimeAdvance(fed.vfed,next_time)
        if salida == 70: # La función run tiene valor límite 70
            salida = 0
    next = fed.getNextGrantedTime()
    print("Next Time =" ,next)
# # # Executing finish #
fed.destroy()
print("federates finalized")
h.helicsCloseLibrary()