from datetime import datetime
import helics as h
import os
import ast
import gzip
import sys

# # # Loading Libraries #
sys.path.append(os.getcwd().replace('\\', '/')+'/classHelics')
sys.path.append(os.getcwd().replace('\\', '/')+'/Models')

from classHelics.classFederate import Federate
from Models.hl_pv import PV_Sim

# # META info #
META = {'models': {'PVsimulator': {'public': True,'params': ['P_system', 'slope', 'aspect', 'latitude', 'longitude', 'elevation'],'attrs': ['power_dc', 'ghi', 'T_ext'],},},}


# # # Checking broker connection #
helicsversion = h.helicsGetVersion()
print("HouseHold: Helics version = {}".format(helicsversion))
# print(sys.argv[1])

day = 0

count = 0
for i in range(len(sys.argv)):
    count = i+1
    if count == len(sys.argv):
        break
    else :
        ent = str(sys.argv[i+1]).split(':')
        if ent[0] == 'PUBLIC':
            pass
        if ent[0] == 'ATTRS':
            pass
        if ent[0] == 'days':
            day = ent[1]
        if ent[0] == 'name':
            name = ent[1]
        if ent[0] == 'start_date':
            start_date = datetime.fromtimestamp(int(ent[1]))
        if ent[0] == 'step_size':
            step_size = int(ent[1])
        if ent[0] == 'parm_input':
            parm_input = ast.literal_eval(sys.argv[i+1].split("parm_input:")[1].replace("*",'"'))
            # convertedDict = dict((x.strip(), (y.strip()))
            #          for x, y in (element.split(':')
            #                       for element in parm_input.split(',')))

model_name = str(name.split('_')[0]).lower()

body = "x.create(num=1, model='%s'"%model_name
for k,v in parm_input.items():
    body = body+', '+str(k)+'='+str(v)
body = body+')'

# # # # Starting the simulator #
x = PV_Sim(start_date=str(start_date), step_size=step_size, sim_meta=META)
# x.create(num=1, model=model_name)
salida1 = eval(body)

day = int(day)*24*60

# # # # Loading JSON info #
current_Path = os.getcwd().replace('\\', '/')
jsons_Path = current_Path+'/Jsons/'
# # print(jsons_Path)
os.chdir(jsons_Path)

json_file = name

# # # # Back to main path #
# main_Path = os.path.normpath(os.getcwd() + os.sep + os.pardir).replace('\\', '/')
# os.chdir(main_Path)

fed = Federate()
fed.create_federate(json_file)
print("Creados los federates")

pub_count = h.helicsFederateGetPublicationCount(fed.vfed)
sub_count = h.helicsFederateGetInputCount(fed.vfed)

subid = {}
subid_key = []
if sub_count == 0:
    pass
else:
    for i in range(0, sub_count):
        subid[i] = h.helicsFederateGetInputByIndex(fed.vfed, i)
        sub_name = h.helicsSubscriptionGetKey(subid[i])
        subid_key.append(sub_name)

pubid = {}
pub_names = []
if pub_count == 0:
    pass
else:
    for i in range(0, pub_count):
        pubid[i] = h.helicsFederateGetPublicationByIndex(fed.vfed, i)
        pub_name = h.helicsPublicationGetKey(pubid[i])
        pub_names.append(pub_name)

# # # Starting Federates #
fed.start_async()
h.helicsFederateEnterExecutingModeComplete(fed.vfed)
print("Iniciado el Federate")
name = h.helicsFederateGetName(fed.vfed) # Obteniendo el nombre del federate
# print(name)


# # # # Executing loop #
step = -1
salida = 0
# info = x.get_houses()
while step < day:
    if sub_count == 0:
        pass
    else:
        for i in range(sub_count):
            very = fed.check_values_returned(step,subid[i])
            print('validate')
            R_txt = fed.subscribeString(subid[i])
            R_data = ast.literal_eval(R_txt)
            step = fed.getCurrentTime()
            print("Receiving data:",R_data,"at current Time =" ,step )
    if pub_count == 0:
        step = fed.getCurrentTime()
        print("Current Time =" ,step)
        salida = {salida1:{}}
        sendData, next_time = x.run(step,salida)
        print('next_time is:', next_time)
    else:
        for i in range(pub_count):
            step = fed.getCurrentTime()
            print("Current Time =" ,step)
            salida = {salida1:{}}
            sendData, next_time = x.run(step,salida)
            txt = str(sendData)
            fed.publishString(pubid[i], txt)
            print("PV: Sending value =" ,txt, "at time =", step)
            print('next_time is:', next_time)    
    avanzar = h.helicsFederateRequestTimeAdvance(fed.vfed,next_time)
#         if salida == 70: # La función run tiene valor límite 70
#             salida = 0
#     next = fed.getNextGrantedTime()
#     print("Next Time =" ,next)
# # Executing finish #
fed.destroy()
print("federates finalized")
h.helicsCloseLibrary()