from datetime import datetime
import helics as h
import os
import ast
import gzip
import sys
import json
import yaml
import re


# # # Loading Libraries #
sys.path.append(os.getcwd().replace('\\', '/')+'/classHelics')
sys.path.append(os.getcwd().replace('\\', '/')+'/Models')

from classHelics.classFederate import Federate
from Models.hl_fmu_pyfmi import MyFMU_Adapter

# # META info #
META_battery = {
    'models': {
        'battery': {
            'public': True,
            'params': ['fmu_name', 'instance_name', 'start_vrs', 'start_in_vrs'],
            'attrs': ['LoadINW', 'GenINW', 'I', 'V', 'SOC', 'PnetBatt'],
        },
    },
}


META_heat = {
    'models': {
        'heatpump': {
            'public': True,
            'params': ['fmu_name', 'instance_name', 'start_vrs', 'start_in_vrs'],
            'attrs': ['Tset', 'Tamb', 'Power', 'COP', 'Qsensible', 'MV', 'Td', 'TroomSens'],
        },
    },
}

META_building = {
    'models': {
        'building': {
            'public': True,
            'params': ['fmu_name', 'instance_name', 'start_vrs', 'start_in_vrs'],
            'attrs': ['Q', 'Peo', 'TRooMea', 'Tamb', 'Tdew', 'Tbulb', 'RH'],
        },
    },
}
# # # Checking broker connection #
helicsversion = h.helicsGetVersion()
print("HouseHold: Helics version = {}".format(helicsversion))
# print(sys.argv[1])

day = 0

count = 0
for i in range(len(sys.argv)):
    count = i+1
    if count == len(sys.argv):
        break
    else :
        ent = str(sys.argv[i+1]).split(':')
        if ent[0] == 'PUBLIC':
            pass
        if ent[0] == 'ATTRS':
            pass
        if ent[0] == 'days':
            day = ent[1]
        if ent[0] == 'name':
            name = ent[1]
        if ent[0] == 'fmu_class':
            fmu_class = ent[1]
        if ent[0] == 'solver':
            solver = ent[1]
        if ent[0] == 'params':
            params = ent[1]
        if ent[0] == 'parm_input':
            nuevo = ast.literal_eval(sys.argv[i+1].split("parm_input:")[1].replace("*",'"'))
            # print(nuevo)
            # parm_input = sys.argv[i+1].split("parm_input:")[1]#.replace("}","").replace("{","")
            # x = yaml.load(parm_input)
            # print(x, type(x))
            # convertedDict = dict((x.strip(), (y.strip()))
            #          for x, y in (element.split(':')
            #                       for element in parm_input.split(',')))
        if ent[0] == 'step_size':
            step_size = int(ent[1])

fmu_name = nuevo['fmu_name']
instance_name = nuevo['instance_name']
start_vrs = nuevo['start_vrs']
start_in_vrs = nuevo['start_in_vrs']

print(type(instance_name))
print(type(start_vrs))
print(type(start_in_vrs))

new_instance_name = []
for i in range(len(instance_name)):
    new_instance_name.append(str(instance_name[i]))

model_name = str(name.split('_')[0]).lower()
print(model_name)

if fmu_class == 'battery':
    META = META_battery
if fmu_class == 'heatpump':
    META = META_heat
if fmu_class == 'building':
    META = META_building

print(META)


# # # # # Starting the simulator #
# prueba = MyFMU_Adapter(step_size=600, sim_meta=META_battery)
# prueba.solver_call(solver='matlab')
# name = prueba.create(num=1, model='battery', fmu_name='battery3', instance_name=['0'], start_vrs=[], start_in_vrs=[])
# print(list(name.keys())[0], type(name.keys()))
# prueba.finalize()
# x = MyFMU_Adapter(step_size=step_size, sim_meta=META)
# x.solver_call(solver=str(solver))
# # name = x.create(num=1, model=model_name, fmu_name=fmu_name, instance_name=new_instance_name, start_vrs=start_vrs, start_in_vrs=start_in_vrs)
# name = x.create(num=1, model='battery', fmu_name='battery3', instance_name=['0'], start_vrs=[], start_in_vrs=[])
# x.finalize()

day = int(day)*24*60
print(name)
# # # # Loading JSON info #
current_Path = os.getcwd().replace('\\', '/')
jsons_Path = current_Path+'/Jsons/'
# # print(jsons_Path)
os.chdir(jsons_Path)

json_file = name

my_name = str(str(name).split('_')[0])
print('my_name es:',my_name)
# # # # Back to main path #
# main_Path = os.path.normpath(os.getcwd() + os.sep + os.pardir).replace('\\', '/')
# os.chdir(main_Path)

fed = Federate()
fed.create_federate(json_file)
print("Creados los federates")
pub_count = h.helicsFederateGetPublicationCount(fed.vfed)
sub_count = h.helicsFederateGetInputCount(fed.vfed)
# print('las pubs son', pub_count)

subid = {}
subid_key = []
if sub_count == 0:
    pass
else:
    for i in range(0, sub_count):
        subid[i] = h.helicsFederateGetInputByIndex(fed.vfed, i)
        sub_name = h.helicsSubscriptionGetKey(subid[i])
        subid_key.append(sub_name)

pubid = {}
pub_names = []
if pub_count == 0:
    pass
else:
    for i in range(0, pub_count):
        pubid[i] = h.helicsFederateGetPublicationByIndex(fed.vfed, i)
        pub_name = h.helicsPublicationGetKey(pubid[i])
        pub_names.append(pub_name)

print('The publications are:',pub_names)

# # # Starting Federates #
fed.start_async()
h.helicsFederateEnterExecutingModeComplete(fed.vfed)
print("Iniciado el Federate")
name = h.helicsFederateGetName(fed.vfed) # Obteniendo el nombre del federate
# print(name)



x = MyFMU_Adapter(step_size=step_size, sim_meta=META)
if solver == 'matlab':
    x.solver_call(solver=str(solver))
var_1 = x.create(num=1, model=model_name, fmu_name=fmu_name, instance_name=new_instance_name, start_vrs=start_vrs, start_in_vrs=start_in_vrs)
data_name = list(var_1.keys())[0]
print('The instance_name is:', data_name)
# print(list(name.keys())[0], type(name.keys()))
# x.finalize()

# # # # Executing loop #
step = -1
salida = 0
# info = x.get_houses()
while step < day:
    sendData = x.get_data()
    print('El sendData es:', sendData)
    if sub_count == 0:
        step = fed.getCurrentTime()
        print("Current Time =" ,step)
    else:
        for i in range(sub_count):
            very = fed.check_values_returned(step,subid[i])
            print('validate')
            txt = fed.subscribeString(subid[i])
            data = ast.literal_eval(txt)
            step = fed.getCurrentTime()
            print("Receiving data:",data,"at current Time =" ,step )
    if pub_count == 0:
        step = fed.getCurrentTime()
        print("Current Time =" ,step)
    else:
        for i in range(pub_count):
            step = fed.getCurrentTime()
            res = str(pub_names[i]).replace('_','')
            # res = str(pub_names[i].split('_')[1])
            pubid_name = str(re.sub(r'[0-9]+', '', res)).split(my_name)[1]
            pubid_check = ast.literal_eval(pubid_name)
            if type(pubid_check) == list:
                txt = str(sendData[data_name][pubid_check[0]])
            else:
                txt = str(sendData[data_name][pubid_name])
            fed.publishString(pubid[i], txt)
            print("Sending data:",sendData,"at current Time =" ,step )

    next_time = x.step(time=step, inputs=None)
    # x.finalize()
    avanzar = h.helicsFederateRequestTimeAdvance(fed.vfed,next_time)
    print("Next Time =" ,next_time)

# # Executing finish #
x.finalize()
fed.destroy()
print("federates finalized")
h.helicsCloseLibrary()