from datetime import datetime
import helics as h
import os
# import arrow
import gzip
import sys

# # # Loading Libraries #
sys.path.append(os.getcwd().replace('\\', '/')+'/classHelics')
sys.path.append(os.getcwd().replace('\\', '/')+'/Models')

from classHelics.classFederate import Federate
from Models.PV_model import PV

# # # Checking broker connection #
helicsversion = h.helicsGetVersion()
print("PV: Helics version = {}".format(helicsversion))

# print(sys.argv[1])
# print(sys.argv[2])
# print(sys.argv[3])
# print(sys.argv[4])

day = 0

count = 0
for i in range(len(sys.argv)):
    count = i+1
    if count == len(sys.argv):
        break
    else :
        ent = str(sys.argv[i+1]).split(':')
        if ent[0] == 'PUBLIC':
            pass
        if ent[0] == 'ATTRS':
            pass
        if ent[0] == 'days':
            day = ent[1]
        if ent[0] == 'name':
            name = ent[1]
        if ent[0] == 'step_size':
            step_size = int(ent[1])
        if ent[0] == 'sim_start':
            start_date = datetime.fromtimestamp(int(ent[1]))
        if ent[0] == 'datafile':
            datafile = str(ent[1])
# ent1 = str(sys.argv[1]).split(':')
# if ent1[0] == 'sim_start':
#     START = datetime.fromtimestamp(int(ent1[1]))
# if ent1[0] == 'days':
#     day = ent1[1]
# if ent1[0] == 'name':
#     name = ent1[1]
# if ent1[0] == 'datafile':
#     datafile = ent1[1]

# ent2 = str(sys.argv[2]).split(':')
# if ent2[0] == 'sim_start':
#     START = datetime.fromtimestamp(int(ent2[1]))
# if ent2[0] == 'days':
#     day = ent2[1]
# if ent2[0] == 'name':
#     name = ent2[1]
# if ent2[0] == 'datafile':
#     datafile = ent2[1]

# ent3 = str(sys.argv[3]).split(':')
# if ent3[0] == 'sim_start':
#     START = datetime.fromtimestamp(int(ent3[1]))
# if ent3[0] == 'days':
#     day = ent3[1]
# if ent3[0] == 'name':
#     name = ent3[1]
# if ent3[0] == 'datafile':
#     datafile = ent3[1]

# ent4 = str(sys.argv[4]).split(':')
# if ent4[0] == 'sim_start':
#     START = datetime.fromtimestamp(int(ent4[1]))
# if ent4[0] == 'days':
#     day = ent4[1]
# if ent4[0] == 'name':
#     name = ent4[1]
# if ent4[0] == 'datafile':
#     datafile = ent4[1]

# print(START)

# # # Loading Houses information #
current_Path = os.getcwd().replace('\\', '/')
files_Path = current_Path+'/Files/'
os.chdir(files_Path)
print(files_Path)

file = datafile
# date = '2014-01-01 00:00:00'

x = PV()
x.Inicio(file, str(start_date))

# # # Back to main path #
main_Path = os.path.normpath(os.getcwd() + os.sep + os.pardir).replace('\\', '/')
os.chdir(main_Path)

day = int(day)*24*60

# # # Loading JSON info #
current_Path = os.getcwd().replace('\\', '/')
jsons_Path = current_Path+'/Jsons/'
print(jsons_Path)
os.chdir(jsons_Path)

json_file = name

# # # Creating federate #
fed = Federate()
fed.create_federate(json_file)
print("Creados los federates")

pub_count = h.helicsFederateGetPublicationCount(fed.vfed)
# print(pub_count)
pubid = {}
for i in range(0, pub_count):
    pubid[i] = h.helicsFederateGetPublicationByIndex(fed.vfed, i)
    pub_name = h.helicsPublicationGetKey(pubid[i])
    print(pub_name)

# # # Starting Federates #
fed.start_async()
h.helicsFederateEnterExecutingModeComplete(fed.vfed)
print("Iniciando los federates")

# # # Executing loop #
step = -1
x.Crear()
while step < day:
    step = fed.getCurrentTime()
    print("Current Time =" ,step)
    sendData, next_time = x.step(step)
    # sendData = data[int(step)]
    if pub_count == 0:
        step = fed.getCurrentTime()
        print("Current Time =" ,step)
    else:
        for i in range(pub_count):
            step = fed.getCurrentTime()
            txt = str(sendData)
            fed.publishString(pubid[i], txt)
            print("Sending data:",txt,"at current Time =" ,step )
    avanzar = h.helicsFederateRequestTimeAdvance(fed.vfed,int(next_time))
    print("Next Time =" ,next_time)
# # # Executing finish #
fed.destroy()
print("federates finalized")
h.helicsCloseLibrary()