"""
Agent Scheduler simulator for Helics.
Research group of Politecnico di Torino Energy Center Lab.
- author: Juan Gilberto Rueda Vásquez
- email: juan.rueda@polito.it
- status: Development
"""
import pandas as pd

class AgentScheduler():
    
    def __init__(self, start_date=None, days=0, sim_meta=None):
        self.start_date = pd.to_datetime(start_date)  # TODO: la start_date è importante per iniziare nel momento
        # giusto, non viene utilizzata ma si suppone si inizi sempre alle 00:00:00 di un giorno x
        self.step_size = None
        self.times = []
        self.agents = {}
        self.days = 2 + 1  # to guaranteee the sim until the end
        self.meta = sim_meta

        if self.meta['models'] == {}:
            self.meta['models'] = sim_meta['models']
        
    
    def create(self, num, model, schedule, type_schedule='day', unit_schedule='hour'):
        if num != 1:
            raise ValueError('Can only create one entity per each model agent.')  # TODO: per adesso un agente
            # gestisce un parametro solo ma posso creare più modelli
        next_eid = len(self.agents)
        entities = []
        # Schedule structure:
        # list of string in order of time ['', '..'] starting from start_date (at 00:00:00) for unit schedule and it
        # repeat as
        # type_schedule. Example for daily:hour ['0:16','6:20','22:16']
        sch = {}
        day_in_seconds = 1 * 24 * 60 * 60
        counter = 0
        for day in range(self.days):
            for tr_val in schedule:
                tr, val = list(map(float, tr_val.split(':')))

                sch[pd.to_timedelta(tr, unit=unit_schedule).total_seconds() + counter * day_in_seconds] = val
                self.times.append(pd.to_timedelta(tr, unit=unit_schedule).total_seconds() + counter *
                                  day_in_seconds)
            counter += 1

        self.get_data_outputs = [] # Esta nueva variable va a contener los datoscorrespondientes a outputs en la función get_data

        for i in range(next_eid, next_eid + num):
            eid = '%s_%d' % (model, i)
            parameter = self.meta['models'][model]['attrs'][0]  # TODO: for the moment one parameter per each model
            self.get_data_outputs.append({eid:[parameter]})
            self.agents[eid] = {parameter: sch}
            entities.append({'eid': eid, 'type': model})
    
    def run(self, time):
        time = time*3600
        self.cache = {}
        time_new = self.times[self.times.index(time) + 1]
        self.step_size = time_new - time
        for agent, param_sch in self.agents.items():
            par_time_value = {}
            self.cache[agent] = {}
            for param in param_sch.keys():
                self.cache[agent][param] = param_sch[param][time]
        
        data = {}

        outputs = self.get_data_outputs[0]

        for eid, attrs in outputs.items():
            model_type = eid.split('_')[0]
            data[eid] = {}
            for attr in attrs:
                if attr not in self.meta['models'][model_type]['attrs']:
                    raise ValueError('Unknown output attribute: %s' % attr)

                # Get model.val or model.delta:
                data[eid][attr] = self.cache[eid][attr]
        
        return data, (time + int(self.step_size))/3600

### "Pruebas del simulador "###

# META = {
#     'models': {
#         'scheduler': {
#             'public': True,
#             'params': [],
#             'attrs': ['Tset'],
#         },
#     },
# }
# prueba = AgentScheduler(start_date='2015-01-01 00:00:00', sim_meta=META) 
# prueba.create(num=1, model='scheduler', schedule=['0:16','6:20', '22:16'])
# data, salida = prueba.run(70)

# print(data)
# print(salida)