# -*- coding: utf-8 -*-
"""
Created on Mon Apr 26 12:14:25 2021

@author: Juan
"""
import json
import pandas as pd
import arrow
import gzip
from datetime import datetime


class PV():
    
    def Inicio(self, pvfile, start):
        """# Loading data to create entities"""
        self.pv = open(pvfile,"r")
        self.DATE_FORMAT = ['YYYY-MM-DD HH:mm', 'YYYY-MM-DD HH:mm:ss']
        self.START = start
    
    def Crear(self):
        self.data = []
        pv_start = arrow.get(self.START, self.DATE_FORMAT)
        # datafile = open(self.pv, "r")
        datafile = self.pv
        datafile.readline()
        next(datafile).strip()
        # Get attribute names and strip optional comments
        # attrs = next(datafile).strip().split(',')
        attrs = next(datafile)
        self.dates = []
        while attrs != ValueError:
            values = attrs.split(',')
            power = abs(float((values[1])))
            info = {'date':values[0],'P':power,'sim':'PV'}
            self.dates.append(values[0])
            self.data.append(info)
            try:
                attrs = next(datafile)
            except StopIteration:
                break
          
        
    
    def step(self, hora):
        first = datetime.timestamp(datetime.strptime(self.dates[0], "%m/%d/%Y  %H:%M"))
        second = datetime.timestamp(datetime.strptime(self.dates[1], "%m/%d/%Y  %H:%M"))
        difference = second-first
        # print(difference)
        output = self.data
        if hora == 0:
            output = self.data[0]
            next_time = difference
        else:
            next_time = difference + hora
            now_date = datetime.fromtimestamp(first + hora).strftime("%m/%d/%Y  %H:%M")
            
            for i in range(len(self.data)):
                otro = self.data[i]['date']
                final = datetime.strptime(otro,"%m/%d/%Y  %H:%M")
                final = datetime.strftime(final, "%m/%d/%Y  %H:%M")
                if final == now_date:
                    output = self.data[i]
                    break
    
        return output, next_time
        