from classFederate import Federate
from making_Json import JsonConfig
from pypower_model import PypowerModel
import helics as h
import random
import json
import ast
import arrow
import gzip
import time
import sys

# # # Checking broker connection #
helicsversion = h.helicsGetVersion()
print("Pypower: Helics version = {}".format(helicsversion))
n = 37
# # # Loading Grid information #
gridfile = 'demo_lv_grid.json'
grid = PypowerModel()
# # # Creating federate #
conf = JsonConfig('Pypower', of=1)
conf.pubRegister(1,'Power_flow_')
conf.subRegister(n,'Pot_H_','House')
fed = Federate()
fed.create_federate('Pypower.json')
print("Creado Pypower Federate")
sub_count = h.helicsFederateGetInputCount(fed.vfed)
pub_count = h.helicsFederateGetPublicationCount(fed.vfed)
subid = {}
for i in range(0, sub_count):
    subid[i] = h.helicsFederateGetInputByIndex(fed.vfed, i)
    sub_name = h.helicsSubscriptionGetKey(subid[i])
pubid = {}
for i in range(0, pub_count):
    pubid[i] = h.helicsFederateGetPublicationByIndex(fed.vfed, i)
    pub_name = h.helicsPublicationGetKey(pubid[i])
    print(pub_name)
# # # Starting Federates #
fed.start_async()
h.helicsFederateEnterExecutingModeComplete(fed.vfed)
print("Iniciado el Federate")
# # # Executing loop #
step = -1
while step < 300:
    step = fed.getCurrentTime()
    Houses_info = []
    print("Current Time =" ,step)
    if step == 0:
        next = fed.getNextGrantedTime()
        print("Next Time =" ,next)
    
    if step >= 1:
        for i in range(n):
            very = fed.check_values_returned(step,subid[i])
            txt = fed.subscribeString(subid[i])
            # print(txt)
            # # res = txt.split(',')
            res = ast.literal_eval(txt)
            Houses_info.append(res)
        avanzar = h.helicsFederateRequestTimeAdvance(fed.vfed,60)
        # print("DB: Receiving value =" ,value, "at time =", step , " from House_", i)
        print(Houses_info)
        flujo = grid.start(gridfile, Houses_info)
        print(flujo)
        pf = str(flujo)
        fed.publishString(pubid[0], pf)
        print(pf)
        next = fed.getNextGrantedTime()
        print("Next Time =" ,next)
# # # Executing finish #
fed.destroy()
# print(Houses_info)
print("Federate finalized")
h.helicsCloseLibrary()