from classFederate import Federate
from making_Json import JsonConfig
from model_house import HouseModel
import helics as h
import random
import arrow
import gzip
import time
import sys

# # # Checking broker connection #
helicsversion = h.helicsGetVersion()
print("HouseHold: Helics version = {}".format(helicsversion))

# # # Loading Houses information #
PROFILE_FILE = gzip.open('profiles.data.gz', 'rt')
x = HouseModel(PROFILE_FILE, "demo_lv_grid")
START = '2014-01-01 00:15:00'
n= len(x.get_houses())

# # # Creating federate #
conf = JsonConfig('House', period=60)
conf.pubRegister(n,'Pot_H_')
conf.pubRegister(n,'casa')
fed = Federate()
fed.create_federate('House.json')
print("Creados los federates")
pub_count = h.helicsFederateGetPublicationCount(fed.vfed)
# print(pub_count)
pubid = {}
for i in range(0, pub_count):
    pubid[i] = h.helicsFederateGetPublicationByIndex(fed.vfed, i)
    pub_name = h.helicsPublicationGetKey(pubid[i])
    print(pub_name)

# # # Starting Federates #
fed.start_async()
h.helicsFederateEnterExecutingModeComplete(fed.vfed)
print("Iniciado el Federate")

# # # Executing loop #
step = -1
horacasa = 0
info = x.get_houses()
while step < 300:
    sendData = info
    value = x.get(horacasa)
    step = fed.getCurrentTime()
    print("Current Time =" ,step)
    
    for i in range(n):
        sendData[i]['P'] = value[i]
        txt = str(sendData[i])
        fed.publishString(pubid[i], txt)
        # fed.publish(pubid[i+n], value[i])
        print("Printer: Sending value =" ,txt, "at time =", step , " to DB")
    next = fed.getNextGrantedTime()
    horacasa = horacasa+15
    print("Next Time =" ,next)
# # # Executing finish #
fed.destroy()
print("federates finalized")
h.helicsCloseLibrary()