from classFederate import Federate
from making_Json import JsonConfig
from hdf5_model import HDF5
import helics as h
import random
import json
import ast
import os.path
import arrow
import time
import sys

# # # Checking broker connection #
helicsversion = h.helicsGetVersion()
print("HDF5: Helics version = {}".format(helicsversion))
conf = JsonConfig('Hdf5', of=1, dl=1)
n = 37

# # # Loading information #
db = HDF5()
db.Inicio("myDBfile.hdf5")

# # # Creating federate #

conf.subRegister(n,'Pot_H_','House')
conf.subRegister(1,'Power_flow_','Pypower')
fed = Federate()
fed.create_federate("Hdf5.json")
print("Creado Hdf5 Federate")

sub_count = h.helicsFederateGetInputCount(fed.vfed)
subid = {}
for i in range(0, sub_count):
    subid[i] = h.helicsFederateGetInputByIndex(fed.vfed, i)
    sub_name = h.helicsSubscriptionGetKey(subid[i])

# # # Starting Federates #
fed.start_async()
h.helicsFederateEnterExecutingModeComplete(fed.vfed)
print("Iniciado el Federate")
# # # Executing loop #
step = -1
fila = 0
while step < 300:
    step = fed.getCurrentTime()
    Houses_info = []
    print("Current Time =" ,step)
    if step == 0:
        next = fed.getNextGrantedTime()
        print("Next Time =" ,next)
    
    if step >= 1:
        for i in range(n):
            very = fed.check_values_returned(step,subid[i])
            txt = fed.subscribeString(subid[i])
            # res = txt.split(',')
            res = ast.literal_eval(txt)
            Houses_info.append(res)
        # print("DB: Receiving value =" ,value, "at time =", step , " from House_", i)
        avanzar = h.helicsFederateRequestTimeAdvance(fed.vfed,60)
        otrocheck = fed.check_values_returned(step,subid[37])
        pf = fed.subscribeString(subid[37])
        flujo_info = ast.literal_eval(pf)
        # avanzar = h.helicsFederateRequestTimeAdvance(fed.vfed,60)
        print(type(flujo_info))
        print(flujo_info)
        dbDatos= db.escribir(Houses_info, fila, 'P')
        dbFlujo= db.escribirflow(flujo_info, fila)
        fila = fila+1
        print(Houses_info)
        # print(pf)
        next = fed.getNextGrantedTime()
        print("Next Time =" ,next)
# print(db.hset[0,:])
# print(db.f["/Nodes/0-node_a1"][0,:])
# # # Executing finish #
fed.destroy()
# print(Houses_info)
print("Federate finalized")
h.helicsCloseLibrary()