from classFederate import Federate
from making_Json import JsonConfig
from PV_model import PV
import helics as h
import random
import arrow
import gzip
import time
import sys

# # # Checking broker connection #
helicsversion = h.helicsGetVersion()
print("PV: Helics version = {}".format(helicsversion))

# # # Loading Houses information #
file = 'pv_10kw.csv'
date = '2014-01-01 00:00:00'
x = PV()
x.Inicio(file, date)
n= int(sys.argv[1])
print(n)
# # # Creating federate #
conf = JsonConfig('PV', period=60)
conf.pubRegister(n,'Pot_Pv_')
fed = Federate()
fed.create_federate('PV.json')

print("Creados los federates")
pub_count = h.helicsFederateGetPublicationCount(fed.vfed)
# print(pub_count)
pubid = {}
for i in range(0, pub_count):
    pubid[i] = h.helicsFederateGetPublicationByIndex(fed.vfed, i)
    pub_name = h.helicsPublicationGetKey(pubid[i])
    print(pub_name)
# # # Starting Federates #
fed.start_async()
h.helicsFederateEnterExecutingModeComplete(fed.vfed)
print("Iniciando los federates")

# # # Executing loop #
step = -1
data = x.Crear()
while step < 300:
    step = fed.getCurrentTime()
    print("Current Time =" ,step)
    sendData = data[int(step)]
    for i in range(n):
        txt = str(sendData)
        fed.publishString(pubid[i], txt)
        # fed[i].publish(fed[i].pub[0], value[i])
        print("PV: Sending value =" ,txt, "at time =", step , " to Pypower")
    next = fed.getNextGrantedTime()
    print("Next Time =" ,next)
# # # Executing finish #
fed.destroy()
print("federates finalized")
h.helicsCloseLibrary()