# -*- coding: utf-8 -*-
"""
Created on Wed Aug 18 18:10:05 2021

@author: Juan
"""
import json
import yaml
import time
import os
import sys
import random
import mosaik
from mosaik.util import connect_randomly, connect_many_to_one
from datetime import datetime
from pathlib import Path
import socket   

hostname=socket.gethostname()   
ref=socket.gethostbyname(hostname) 
ref = '192.168.16.2'


# =============================================================================
# Loading YAML files
# =============================================================================
main_Path = os.path.normpath(os.getcwd() + os.sep + os.pardir).replace('\\', '/')
dirs = os.listdir(main_Path)
os.chdir(main_Path)

for file in dirs:
    check = file.split(".")
    if len(check) == 1:
        pass
    else:
        if check[1] == 'yaml':
            if file.split("_")[0] == 'scenario':
                scenario = str(file)
            if file.split("_")[0] == 'Models':
                modelos = str(file)
        else:pass

# =============================================================================
# Opening YAML files
# =============================================================================
with open(scenario) as file:
    data = yaml.load(file, Loader=yaml.FullLoader)

with open(modelos) as file:
    models = yaml.load(file, Loader=yaml.FullLoader)


# Back to main path
current_Path = os.getcwd().replace('\\', '/')
main_Path = current_Path+'/Mosaik'
os.chdir(main_Path)

# =============================================================================
# Starting scenario configration
# =============================================================================

n = len(data['SCENARIO SCHEMA YAML']['SIMULATORS CONFIGURATION']['Simulator'])
sim = data['SCENARIO SCHEMA YAML']['SIMULATORS CONFIGURATION']['Simulator']
sce = data['SCENARIO SCHEMA YAML']['SCENARIO CONFIGURATION']
num_sce = 1

for i in range(len(sce)):
    for k,v in sce[i].items():
        if k == 'DAYS':
            END = int(v)*24*3600
        else:
            END = 1*24*3600
    for k,v in sce[i].items():
        if k == 'NUMBER':
            num_sce = int(v)

# print('los escenarios son:', num_sce)

# =============================================================================
# Importando todas las APIs de Mosaik
# =============================================================================
sys.path.append(os.getcwd().replace('\\', '/')+'/Api_Mosaik')

for i in range(len(sim)):
    var = str(sim[i]['API_MOSAIK'].split(':')[0])
    if var == 'mosaik-hdf5':
        pass
    else:
        exec('import '+var)
    # print(var)

# =============================================================================
# Escribiendo el archivo sim_config que contiene la información de los simuladores a usar
# =============================================================================
sim_config = {}
for i in range(len(data['SCENARIO SCHEMA YAML']['SIMULATORS CONFIGURATION']['Simulator'])):
    if sim[i]['RUN PROCESS'][0]['MODE_RUN'] == 'python':
        sim_config[sim[i]['SIMULATOR_NAME']] = {sim[i]['RUN PROCESS'][0]['MODE_RUN']: str(sim[i]['API_MOSAIK'])+':'+str(sim[i]['SIMULATOR_NAME'])}
    elif sim[i]['RUN PROCESS'][0]['MODE_RUN'] == 'cmd':
        sim_config[sim[i]['SIMULATOR_NAME']] = {sim[i]['RUN PROCESS'][0]['MODE_RUN']: str(sim[i]['API_MOSAIK'])+' %(addr)s'}
    elif sim[i]['RUN PROCESS'][0]['MODE_RUN'] == 'connect':
        sim_config[sim[i]['SIMULATOR_NAME']] = {sim[i]['RUN PROCESS'][0]['MODE_RUN']:sim[i]['RUN PROCESS'][2]['HOSTPORT']}
print('line 97 - sim_config es:', sim_config)

for q in sce:
    if 'BROKER_HOST' in (q.keys()):
        central_addres = q['BROKER_HOST']

total_info = []
for g in range(len(sim)):
    add_info = {'api':'',
            'ip':'',
            'port':''}
    add_info['api'] = sim[g]['API_MOSAIK']
    for j in sim[g]['RUN PROCESS']:
        if 'HOSTPORT' in list(j.keys()):
            add_info['ip'] = j['HOSTPORT']
        if 'PORT' in list(j.keys()):
            add_info['port'] = j['PORT']
    total_info.append(add_info)

if central_addres == ref:
    print('--------HOLA BETTO')
else:
    for we in total_info:
        if we['ip'] == ref:
            val = 'python3 '+we['api']+'.py '+we['ip']+':'+we['port']+' --remote -t 60'
            print(val)
        else:
            print('*********NO ES ACÁ')