"""
Home simulator simulator for Mosaik.

Research group of Politecnico di Torino Energy Center Lab.

- author: Lorenzo Bottaccioli
- copyright: Copyright 2020. Energy Center Lab - Politecnico di Torino"
- credits: Lorenzo Bottaccioli, Daniele Salvatore Schiera
- maintainer: Lorenzo Bottaccioli
- email: lorenzo.bottaccioli@polito.it
- status: Development

"""
import sys
from pathlib import Path

import pandas as pd
import mosaik_api

PROJECT_ROOT = str(Path(__file__).resolve().parents[2]).replace('\\', '/')
sys.path.insert(0,PROJECT_ROOT)

from models.homesimu_new import Home
#
# META = {
#     'models': {
#         # We only expose the WECS agent as model to mosaik:
#         'Home': {
#             'public': True,
#             'params': ['people','start_date',
#             ],
#             'attrs': ['Presence','Absent','Aggregate','washday','people','has_wash','has_dish','has_dryer','hasBoiler','dishday','time_dish','time_wash'
#             ],
#         },
#     },
# }

META = {
    'models': {}}

class HouseholdSim(mosaik_api.Simulator):
        def  __init__(self):
            super().__init__(META)
            self.simulator= Home.Simulator()
            self.eid_prefix = ''#'PyModel_'
            self.timetosim=0
            self.entities = {}  # Maps EIDs to model indices in self.simulator
            self.cats_var = {'houseBehaviour':None, 'Consumption':None}  # mettere solo dict e liste
            self.stepsize = 10*60 #fixed timestep

        def init(self,sid,start_date,eid_prefix=None,sim_meta=None):
            if eid_prefix is not None:
                self.eid_prefix = eid_prefix
            self.start_date = pd.to_datetime(start_date).tz_localize('UTC')

            if self.meta['models'] == {}:
                self.meta['models'] = sim_meta['models']

            return self.meta

        def create(self,num,model,people=None):
            # TODO: meglio dare valori di default dentro al dizionario
            next_eid = len(self.entities)
            entities = []

            for i in range(next_eid, next_eid + num):
                eid = '%s_%d' % (model, i)
                self.simulator.add_model(people)
                self.entities[eid] = i
                entities.append({'eid': eid, 'type': model})
                # if len(people)>1:
                #     self.simulator.add_model(people[i])
                #     self.entities[eid] = i
                #     entities.append({'eid': eid, 'type': model})
                # else:
                #     self.simulator.add_model(people[0])
                #     self.entities[eid] = i
                #     entities.append({'eid': eid, 'type': model})

            return entities


        def step(self, time,input):
            self.timetosim=self.start_date + pd.Timedelta(time,unit='s')
            self.simulator.step(time=self.timetosim)

            return time + self.stepsize  # Step size is 10 minute

        def get_data(self, outputs):
            
            models = self.simulator.models
            data = {}
            # Variables list # TODO: @DS: non è un sistema molto efficiente
            
            for eid, attrs in outputs.items():
                model_idx = self.entities[eid]
                for cat in self.cats_var.keys():
                    self.cats_var[cat] = list(getattr(models[model_idx], cat).keys())
                data[eid] = {}
                for attr in attrs:
                    if attr not in self.meta['models']['Home']['attrs']:
                        raise ValueError('Unknown output attribute: %s' % attr)
                    exit=False
                    for cat, var in self.cats_var.items():
                        if attr in var:
                            data[eid][attr] = float(getattr(models[model_idx],cat)[attr]) # TODO: per evitare numpy.int
                            exit=True
                            break
                    if exit==False:
                        data[eid][attr] = float(getattr(models[model_idx],attr))
                        # attimo numpy.int64
                        
            return data

def main():
    return mosaik_api.start_simulation(HouseholdSim())


if __name__ == '__main__':
    main()