import sys, os
import subprocess
import yaml


# # # Loaiding YAML files #
main_Path = os.path.normpath(os.getcwd() + os.sep + os.pardir).replace('\\', '/')
main_Path = main_Path+''
os.chdir(main_Path)
print('camino',main_Path)

# Opening YAML file
with open(r'scenario_scheme_case1.yaml') as file:
    data = yaml.load(file, Loader=yaml.FullLoader)

with open(r'Models_scheme_case1.yaml') as file:
    models = yaml.load(file, Loader=yaml.FullLoader)

sce = data['SCENARIO SCHEMA YAML']['SCENARIO CONFIGURATION']
num_sce = 1

for i in range(len(sce)):
    for k,v in sce[i].items():
        if k == 'NUMBER':
            num_sce = int(v)


# Back to main path
current_Path = os.getcwd().replace('\\', '/')
main_Path = current_Path+'/Helics'
os.chdir(main_Path)

for s in range (num_sce):
    if data['ORCHESTRATOR'] == 'HELICS':
        os.system("python3 opt_scenario_helics.py")
        os.system("python3 network_config.py")
        subprocess.call('helics run --path newconfig_'+str(s)+'.json',shell=True)
    else:
        pass