# -*- coding: utf-8 -*-
"""
Created on Fri Sep 16 10:48:16 2022

@author: Juan
"""
from making_Json import JsonConfig
import json
import yaml
import arrow
import gzip
import os
import copy
import numpy as np

# =============================================================================
# Loading YAML files
# =============================================================================
main_Path = os.path.normpath(os.getcwd() + os.sep + os.pardir).replace('\\', '/')
dirs = os.listdir(main_Path)
os.chdir(main_Path)

for file in dirs:
    check = file.split(".")
    if len(check) == 1:
        pass
    else:
        if check[1] == 'yaml':
            if file.split("_")[0] == 'scenario':
                scenario = str(file)
            if file.split("_")[0] == 'Models':
                modelos = str(file)
        else:pass
 
# =============================================================================
# Opening YAML files
# =============================================================================
with open(scenario) as file:
    data = yaml.load(file, Loader=yaml.FullLoader)

with open(modelos) as file:
    models = yaml.load(file, Loader=yaml.FullLoader)

# =============================================================================
# Removing previous json files
# =============================================================================
current_Path = os.getcwd().replace('\\', '/')
json_Path = current_Path+'/Helics'+'/Jsons/'

dirs = os.listdir(json_Path)
team = []
for file in dirs:
    check = file.split(".")
    if len(check) == 1:
        pass
    else:
        if check[1] == 'json':
            os.remove(str(json_Path)+'/'+str(file))
            
# Back to main path
current_Path = os.getcwd().replace('\\', '/')
main_Path = current_Path+'/Helics'
os.chdir(main_Path)

# =============================================================================
# Here, I am generating all the JSON file for federates and the scenario config
# =============================================================================
config = {}
federates = []
configFederates = []
current_Path = os.getcwd().replace('\\', '/')
json_Path = current_Path+'/Jsons'

    
n = len(data['SCENARIO SCHEMA YAML']['SIMULATORS CONFIGURATION']['Simulator'])
rueda = data['SCENARIO SCHEMA YAML']['SCENARIO CONFIGURATION']
sim = data['SCENARIO SCHEMA YAML']['SIMULATORS CONFIGURATION']['Simulator']
db_data = data['SCENARIO SCHEMA YAML']['CONNECTIONS']
num_sce = 1

# =============================================================================
# Knowing the number of scenarios
# =============================================================================
for i in range(len(rueda)):
    for k,v in rueda[i].items():
        if k == 'NUMBER':
            num_sce = int(v)

# =============================================================================
# Creando info para la base de datos
# =============================================================================
for i in range(len(sim)):
    val = sim[i]['API_HELICS'].split("_")
    if val[0] == 'hdf5':
        db_name = sim[i]['MODELS'][0]['MODEL_NAME']
        # print(db_name)
        break
    else:
        db_name = 'Nothing'

info = []
# print(type(db_data))
if db_name == 'Nothing':
    pass
else:
    if db_data is None:
        pass
    else:    
        for i in range(len(db_data)):
            if db_data[i]['TO'] == db_name:
                for l in range(len(db_data[i]['ATTRIBUTES'])):
                    for k,v in db_data[i]['ATTRIBUTES'][l].items():
                        x = {db_data[i]['FROM']:v}
                        # x = {db_data[i]['FROM']}
                        info.append(x)
            else:
                pass

# =============================================================================
# Generating info for publications and subscriptions
# =============================================================================

pub_sub_info = []
for ct in range(len(sim)):
    for mn in range(int(sim[ct]['MODELS'][0]['NUMBER'])):
        pub_sub_info.append(str(sim[ct]['MODELS'][0]['MODEL_NAME']+'_'+str(mn)))


# =============================================================================
# Getting info about IP addres and port
# =============================================================================
broker_host = ""
broker_port = ""
for q in range(len(rueda)):
    for qy,vu in rueda[q].items():
        if qy == 'BROKER_HOST':
            broker_host = vu
        if qy == 'BROKER_PORT':
            broker_port = vu

# =============================================================================
# Starting the config information
# =============================================================================

for i in range(n):
    if broker_host == 'localhost':
        Simulator = {"Simulator_Name": "",
                "Model_Name": "",
                "key":"",
                "Federate_host": "",
                "Model_instance":{"nameFederate": "",
                                  "namePubs": {},
                                  "nameSubs": {},
                                  "startDate":"",
                                  "amount":1,
                                  "num_fed":1,
                                  "num_inst":1},
                "Inputs":{}}
    else:
        Simulator = {"Simulator_Name": "",
            "Model_Name": "",
            "broker_address": "tcp://"+str(broker_host)+":"+str(broker_port),
            "key":"",
            "Federate_host": "",
            "Model_instance":{"nameFederate": "",
                              "namePubs": {},
                              "nameSubs": {},
                              "startDate":"",
                              "amount":1,
                              "num_fed":1,
                              "num_inst":1},
            "Inputs":{}}
    
    for a in range(len(sim[i]['RUN PROCESS'])):
        for k,v in sim[i]['RUN PROCESS'][a].items():
            if k == 'MODE_RUN_HELICS':
                if v == 'python':
                    Simulator['Simulator_Name'] = sim[i]['API_HELICS']+'.py'
            if k == 'HOSTPORT':
                Simulator['Federate_host'] = v

    Simulator['Model_Name'] = sim[i]['SIMULATOR_NAME']

    # Adding model name and inputs
    
    for m in range(len(models['MODELS'])):
        for t in range(len(sim[i]['MODELS'])):
            if models['MODELS'][m]['MODEL_NAME'] == sim[i]['MODELS'][t]['MODEL_NAME']:
                midx = t
                Simulator['Model_instance']['nameFederate'] = sim[i]['MODELS'][t]['MODEL_NAME']
                Simulator['Model_instance']['num_fed'] = sim[i]['MODELS'][t]['NUMBER'] # Taking how many federates I want to create
                if not models['MODELS'][m]['INPUT']:
                    pass
                else:
                    for r in range(len(models['MODELS'][m]['INPUT'])):
                        for key, value in models['MODELS'][m]['INPUT'][r].items():
                            Simulator['Inputs'][key] = value

    # Adding parameters
    
    if not sim[i]['PARAMETERS']:
        pass
    else:
        for p in range(len(sim[i]['PARAMETERS'])):
            for k,v in sim[i]['PARAMETERS'][p].items():
                if k == 'timeAdvance' and v != 0:
                    Simulator['Model_instance'][k] = v
                elif k == 'stepTime' and v != 0:
                    Simulator['Model_instance'][k] = v
                elif k == 'sim_start':
                    Simulator['Model_instance'][k] = v
                elif k == 'datafile':
                    Simulator['Model_instance'][k] = v
                else:
                    pass
   
    # """Begining new version"""
    if not data['SCENARIO SCHEMA YAML']['CONNECTIONS']:
        configFederates.append(Simulator)
        # for s in range(Simulator['Model_instance']['num_fed']):
        #     configFederates.append(Simulator)
        #     print('ESTE ES EL CONFIGFEDERATES***************')
        #     print(configFederates)
        #     pass
    else:
        con = data['SCENARIO SCHEMA YAML']['CONNECTIONS']
        from_base = ""
        to_base = ""
        var_Federates = False
        newSimulator = copy.deepcopy(Simulator)
        for c in range(len(con)):
            # from_base = ""
            # to_base = ""
            if con[c]['FROM'].split('_')[0] == sim[i]['MODELS'][midx]['MODEL_NAME']:
                if len(con[c]['FROM'].split('_')) > 1:
                    # print('primero-----', con[c]['FROM'])
                    from_base = str(con[c]['FROM'].split('_')[0])
                    if int(con[c]['FROM'].split('_')[1]) == int(s):
                        # print('primero-----', s)
                        if from_base == 'ResidentialLoads':
                                # print(len(con[c]['ATTRIBUTES']))
                                if len(con[c]['ATTRIBUTES']) == 1:
                                    pass
                                else:
                                    con[c]['ATTRIBUTES'] = [con[c]['ATTRIBUTES'][0]]
                                nuevo_data = newSimulator['Inputs']
                                pf = nuevo_data['profile_file']
                                archivo = gzip.open(pf, 'rt')
                                assert next(archivo).startswith('# meta')
                                meta = json.loads(next(archivo))
                                assert next(archivo).startswith('# id_list')
                                id_list_lines = []
                                for line in archivo:
                                    if line.startswith('# attrs'):
                                        break
                                    id_list_lines.append(line)
                                id_lists = json.loads(''.join(id_list_lines))
                                houses_quantity = len(list(id_lists.values())[0])
                                con[c]['TOTAL_PUB'] = houses_quantity
                                con[c]['TOTAL_SUB'] = houses_quantity
                        if from_base == 'PV':
                            for w in range(len(models['MODELS'])):
                                if models['MODELS'][w]['MODEL_NAME'] == con[c]['FROM']:
                                    con[c]['TOTAL_PUB'] = models['MODELS'][w]['PARAMETERS'][0]['NUMBER']
                                    con[c]['TOTAL_SUB'] = models['MODELS'][w]['PARAMETERS'][0]['NUMBER']
                        for a in range(len(con[c]['ATTRIBUTES'])):
                            for k,v in  con[c]['ATTRIBUTES'][a].items():
                                if k == 'ATTR_FROM' or k == 'ATTR_TO' or k == 'ATTR':
                                    # print('este es el valor de V:',v)
                                    newSimulator['Model_instance']['namePubs'][str(con[c]['FROM'])+str(v)] = con[c]['TOTAL_PUB'] 
                        # print('******',Simulator['Model_instance']['namePubs'])
                        var_Federates = True
                        # configFederates.append(newSimulator)
                    else:
                        # print('......',s)
                        var_Federates = False
                        # configFederates.append(Simulator)
                        # print('******',Simulator['Model_instance']['namePubs'])
                else:
                    # print('segundo -------')
                    for mn in range(len(pub_sub_info)):
                        if pub_sub_info[mn].split('_')[0] == con[c]['FROM']:
                            from_base = pub_sub_info[mn].split('_')[0]
                            if from_base == 'ResidentialLoads':
                                if len(con[c]['ATTRIBUTES']) == 1:
                                    pass
                                else:
                                    con[c]['ATTRIBUTES'] = [con[c]['ATTRIBUTES'][0]]
                                nuevo_data = newSimulator['Inputs']
                                pf = nuevo_data['profile_file']
                                archivo = gzip.open(pf, 'rt')
                                assert next(archivo).startswith('# meta')
                                meta = json.loads(next(archivo))
                                assert next(archivo).startswith('# id_list')
                                id_list_lines = []
                                for line in archivo:
                                    if line.startswith('# attrs'):
                                        break
                                    id_list_lines.append(line)
                                id_lists = json.loads(''.join(id_list_lines))
                                houses_quantity = len(list(id_lists.values())[0])
                                con[c]['TOTAL_PUB'] = houses_quantity
                                con[c]['TOTAL_SUB'] = houses_quantity
                                # print('estas son las total pub',con[c]['TOTAL_PUB'] )
                            if from_base == 'PV':
                                for w in range(len(models['MODELS'])):
                                    if models['MODELS'][w]['MODEL_NAME'] == con[c]['FROM']:
                                        con[c]['TOTAL_PUB'] = models['MODELS'][w]['PARAMETERS'][0]['NUMBER']
                                        con[c]['TOTAL_SUB'] = models['MODELS'][w]['PARAMETERS'][0]['NUMBER']
                            for a in range(len(con[c]['ATTRIBUTES'])):
                                for k,v in  con[c]['ATTRIBUTES'][a].items():
                                    if k == 'ATTR_FROM' or k == 'ATTR_TO' or k == 'ATTR':
                                        newSimulator['Model_instance']['namePubs'][str(pub_sub_info[mn])+str(v)] = con[c]['TOTAL_PUB']
                        # configFederates.append(Simulator)
            if con[c]['TO'].split('_')[0] == sim[i]['MODELS'][midx]['MODEL_NAME']:
                if len(con[c]['TO'].split('_')) > 1:
                    to_base = str(con[c]['TO'].split('_')[0])
                    if int(con[c]['TO'].split('_')[1]) == int(s):
                        if con[c]['FROM'] == 'PV':
                            for w in range(len(models['MODELS'])):
                                if models['MODELS'][w]['MODEL_NAME'] == con[c]['FROM']:
                                    con[c]['TOTAL_PUB'] = models['MODELS'][w]['PARAMETERS'][0]['NUMBER']
                                    con[c]['TOTAL_SUB'] = models['MODELS'][w]['PARAMETERS'][0]['NUMBER']
                        for b in range(len(con[c]['ATTRIBUTES'])):
                            for k,v in  con[c]['ATTRIBUTES'][b].items():
                                if k == 'ATTR_FROM' or k == 'ATTR_TO' or k == 'ATTR':
                                    newSimulator['Model_instance']['nameSubs'][str(mn)+str(v)] = con[c]['TOTAL_SUB']
                else:
                    # print('segundo -------')
                    if len(con[c]['FROM'].split('_')) > 1:
                        for tn in range(len(pub_sub_info)):
                            if pub_sub_info[tn] == con[c]['FROM']:
                                if con[c]['FROM'] == 'PV':
                                    for w in range(len(models['MODELS'])):
                                        if models['MODELS'][w]['MODEL_NAME'] == con[c]['FROM']:
                                            con[c]['TOTAL_PUB'] = models['MODELS'][w]['PARAMETERS'][0]['NUMBER']
                                            con[c]['TOTAL_SUB'] = models['MODELS'][w]['PARAMETERS'][0]['NUMBER']
                                for b in range(len(con[c]['ATTRIBUTES'])):
                                    for k,v in  con[c]['ATTRIBUTES'][b].items():
                                        if k == 'ATTR_FROM' or k == 'ATTR_TO' or k == 'ATTR':
                                            newSimulator['Model_instance']['nameSubs'][str(con[c]['FROM'])+str(v)] = con[c]['TOTAL_SUB']
                    else:
                        for tn in range(len(pub_sub_info)):
                            if pub_sub_info[tn].split('_')[0] == con[c]['FROM']:
                                if con[c]['FROM'] == 'PV':
                                    for w in range(len(models['MODELS'])):
                                        if models['MODELS'][w]['MODEL_NAME'] == con[c]['FROM']:
                                            con[c]['TOTAL_PUB'] = models['MODELS'][w]['PARAMETERS'][0]['NUMBER']
                                            con[c]['TOTAL_SUB'] = models['MODELS'][w]['PARAMETERS'][0]['NUMBER']
                                for b in range(len(con[c]['ATTRIBUTES'])):
                                    for k,v in  con[c]['ATTRIBUTES'][b].items():
                                        if k == 'ATTR_FROM' or k == 'ATTR_TO' or k == 'ATTR':
                                            newSimulator['Model_instance']['nameSubs'][str(pub_sub_info[tn])+str(v)] = con[c]['TOTAL_SUB']
                            
            if con[c]['TO'] == 'Database' and sim[i]['MODELS'][midx]['MODEL_NAME'] == 'DB':
                for d in range(len(con[c]['ATTRIBUTES'])):
                    for k,v in  con[c]['ATTRIBUTES'][d].items():
                        if k == 'ATTR_FROM' or k == 'ATTR_TO' or k == 'ATTR':
                            newSimulator['Model_instance']['nameSubs'][str(con[c]['FROM'])+str(v)] = con[c]['TOTAL_SUB']
                                   
        configFederates.append(newSimulator)
      # """End new version"""
newConfigFederates = []

for i in configFederates:
    for k in range (int(i['Model_instance']['num_fed'])):
        newConfigFederates.append(copy.deepcopy(i))

# Renaming confiFederates

sim_name_dos = []
# copy_new_Federates = copy.deepcopy(new_Federates) 
for g in range(len(newConfigFederates)):
    name_dos = newConfigFederates[g]['Model_Name']
    n_name_dos = 0
    for s in sim_name_dos:
        if s.split("_")[0] == name_dos:
            n_name_dos += 1
    sim_nombre_dos = str(name_dos)+'_'+str(n_name_dos)
    sim_name_dos.append(sim_nombre_dos)
    newConfigFederates[g]['Model_name'] = sim_nombre_dos

# Checking numPubs
new_info_federates = copy.deepcopy(newConfigFederates)
for nt in range(len(newConfigFederates)):
    var_elim = []
    myvar1 = newConfigFederates[nt]['Model_name'].split('_')[1]
    myvar2 = newConfigFederates[nt]['Model_instance']['nameFederate']
    myvar3 = myvar2+'_'+myvar1
    for k,v in newConfigFederates[nt]['Model_instance']['namePubs'].items():
        if len(k.split(myvar3)) > 1 and k.split(myvar3)[0] == '' and k.split(myvar3)[1][0].isnumeric() != True:
            print(k)
        else:
            var_elim.append(k)
    for kl in range(len(var_elim)):
        del newConfigFederates[nt]['Model_instance']['namePubs'][var_elim[kl]]

# Making JSON config for each federate
names = []
for f in range(len(newConfigFederates)):
    jsonfile = newConfigFederates[f]
    # print()
    # jsonfile['Model_name'] = sim_name_dos[f]
    # print(sim_name_dos[f])
    gen = JsonConfig(jsonfile)
    jsonname = gen.run()
    names.append(jsonname)

# Taking number of days from YAML
days = 0
for q in range(len(rueda)):
    for k,v in rueda[q].items():
        if k == 'DAYS':
            days = v
        else:
            pass
# """Writen Scenario info"""
# "exec": "helics_broker -f "+str(len(data['SCENARIO SCHEMA YAML']['SIMULATORS CONFIGURATION']['Simulator']))+" --key="""+" --loglevel=1",
if broker_port == "":
    scenario = {"directory": "./",
            "exec": "helics_broker -f "+str(len(newConfigFederates))+" --all --loglevel=TRACE",
            "host": data['SCENARIO SCHEMA YAML']['SCENARIO CONFIGURATION'][3]['BROKER_HOST'],
            "name": data['SCENARIO SCHEMA YAML']['SCENARIO CONFIGURATION'][5]['BROKER_NAME']}
    federates.append(scenario)
else:
    scenario = {"directory": "./",
                "exec": "helics_broker -f "+str(len(newConfigFederates))+" --all --loglevel=TRACE --port="+str(data['SCENARIO SCHEMA YAML']['SCENARIO CONFIGURATION'][4]['BROKER_PORT']),
                "host": data['SCENARIO SCHEMA YAML']['SCENARIO CONFIGURATION'][3]['BROKER_HOST'],
                "name": data['SCENARIO SCHEMA YAML']['SCENARIO CONFIGURATION'][5]['BROKER_NAME']}
    federates.append(scenario)

# """Writen Simulators info"""
for i in range(len(newConfigFederates)):
    ## Espacio para insertar pasar META info
    for n in range(len(sim)):
        name_model = ""
        if newConfigFederates[i]['Model_instance']['nameFederate'] == sim[n]['MODELS'][0]['MODEL_NAME']:
        # if newConfigFederates[i]['Model_Name'] == sim[n]['SIMULATOR_NAME']:
            name_model = sim[n]['MODELS'][0]['MODEL_NAME']
            for m in range(len(models['MODELS'])):
                if name_model == models['MODELS'][m]['MODEL_NAME']:
                    for l in range (len(models['MODELS'][m]['Model instance'])):
                        for k,v in models['MODELS'][m]['Model instance'][l].items():
                            if k == 'ATTRS':
                                meta_attr = v # Tomando los attributos del simulador
                    meta_parm = []
                    parm_input = {}
                    for ke,va in models['MODELS'][m]['PARAMETERS'][0].items():
                        if ke == 'PARAMS_SET_NAME' or ke == 'NUMBER':
                            pass
                        else:
                            meta_parm.append(ke) # Tomando los parámetros del simulador
                            parm_input[ke] = va         
    parm_input = str(parm_input).replace(" ", "").replace("'", '*')
    # print('Meta es:', meta_parm)
    # print('Otro meta es:',parm_input)
    ## Espacio para insertar pasar META info
    if not meta_parm:
        if len(newConfigFederates[i]['Inputs']) != 0:
            for k,v in newConfigFederates[i]['Model_instance'].items():
                if k != 'timeAdvance':
                    simulator = {"directory": "./",
                            "exec": "python -u "+ newConfigFederates[i]['Simulator_Name']+" "+'days:'+str(days)+" "+'name:'+str(names[i]),
                            "host": newConfigFederates[i]['Federate_host'],
                            "name": sim_name_dos[i]}
                    for key, value in newConfigFederates[i]['Inputs'].items():
                        if key == 'info' and value == 'yes':
                            x =  simulator['exec']
                            simulator['exec'] = x+" "+str(key)+":"+str(info).replace(" ", "")
                        else:
                            x =  simulator['exec']
                            simulator['exec'] = x+" "+str(key)+":"+str(value)
                    # federates.append(simulator)
                else:
                    simulator = {"directory": "./",
                            "exec": "python -u "+ newConfigFederates[i]['Simulator_Name']+" "+str(newConfigFederates[i]['Model_instance']['timeAdvance'])+" "+'days:'+str(days)+" "+'name:'+str(names[i]),
                            "host": newConfigFederates[i]['Federate_host'],
                            "name": sim_name_dos[i]}
                    for key, value in newConfigFederates[i]['Inputs'].items():
                        if key == 'info' and value == 'yes':
                            x =  simulator['exec']
                            simulator['exec'] = x+" "+str(key)+":"+str(info).replace(" ", "")
                        else:
                            x =  simulator['exec']
                            simulator['exec'] = x+" "+str(key)+":"+str(value)
            federates.append(simulator)
        else:
            simulator = {"directory": "./",
                            "exec": "python -u "+ newConfigFederates[i]['Simulator_Name']+" "+'days:'+str(days)+" "+'name:'+str(names[i]),
                            "host": newConfigFederates[i]['Federate_host'],
                            "name": sim_name_dos[i]}
            for k,v in newConfigFederates[i]['Model_instance'].items():
                if k != 'nameFederate' and k != 'namePubs' and k != 'nameSubs' and k != 'startDate' and k != 'amount' and k != 'metadata' and k != 'stepTime' and k != 'num_fed':
                    if k == 'timeAdvance':
                        x =  simulator['exec']
                        simulator['exec'] = x+" "+str(v)
                    else:
                        x =  simulator['exec']
                        simulator['exec'] = x+" "+str(k)+":"+str(v)
                else:
                    pass
                    # simulator = {"directory": "./",
                    #         "exec": "python -u "+ newConfigFederates[i]['Simulator_Name']+" "+str(newConfigFederates[i]['Model_instance']['timeAdvance'])+" "+'days:'+str(days)+" "+'name:'+str(names[i]),
                    #         "host": newConfigFederates[i]['Federate_host'],
                    #         "name": newConfigFederates[i]['Model_Name']}
            federates.append(simulator)
    else:
        if len(newConfigFederates[i]['Inputs']) != 0:
            for k,v in newConfigFederates[i]['Model_instance'].items():
                if k != 'timeAdvance':
                    simulator = {"directory": "./",
                            "exec": "python -u "+ newConfigFederates[i]['Simulator_Name']+" "+'days:'+str(days)+" "+'name:'+str(names[i])+" "+'meta_attr:'+str(meta_attr).replace(" ", "")+" "+'meta_parm:'+str(meta_parm).replace(" ", "")+" "+'parm_input:'+parm_input,
                            "host": newConfigFederates[i]['Federate_host'],
                            "name": sim_name_dos[i]}
                    for key, value in newConfigFederates[i]['Inputs'].items():
                        if key == 'info' and value == 'yes':
                            x =  simulator['exec']
                            simulator['exec'] = x+" "+str(key)+":"+str(info).replace(" ", "")
                        else:
                            x =  simulator['exec']
                            simulator['exec'] = x+" "+str(key)+":"+str(value)
                    # federates.append(simulator)
                else:
                    simulator = {"directory": "./",
                            "exec": "python -u "+ newConfigFederates[i]['Simulator_Name']+" "+str(newConfigFederates[i]['Model_instance']['timeAdvance'])+" "+'days:'+str(days)+" "+'name:'+str(names[i])+" "+'meta_attr:'+str(meta_attr).replace(" ", "")+" "+'meta_parm:'+str(meta_parm).replace(" ", "")+" "+'parm_input:'+parm_input,
                            "host": newConfigFederates[i]['Federate_host'],
                            "name": sim_name_dos[i]}
                    for key, value in newConfigFederates[i]['Inputs'].items():
                        if key == 'info' and value == 'yes':
                            x =  simulator['exec']
                            simulator['exec'] = x+" "+str(key)+":"+str(info).replace(" ", "")
                        else:
                            x =  simulator['exec']
                            simulator['exec'] = x+" "+str(key)+":"+str(value)
            federates.append(simulator)
        else:
            simulator = {"directory": "./",
                            "exec": "python -u "+ newConfigFederates[i]['Simulator_Name']+" "+'days:'+str(days)+" "+'name:'+str(names[i]),
                            "host": newConfigFederates[i]['Federate_host'],
                            "name": sim_name_dos[i]}
            for k,v in newConfigFederates[i]['Model_instance'].items():
                if k != 'nameFederate' and k != 'namePubs' and k != 'nameSubs' and k != 'startDate' and k != 'amount' and k != 'metadata' and k != 'stepTime' and k != 'num_fed':
                    if k == 'timeAdvance':
                        x =  simulator['exec']
                        simulator['exec'] = x+" "+str(v)
                    else:
                        x =  simulator['exec']
                        simulator['exec'] = x+" "+str(k)+":"+str(v)
                else:
                    pass
                    # simulator = {"directory": "./",
                    #         "exec": "python -u "+ newConfigFederates[i]['Simulator_Name']+" "+str(newConfigFederates[i]['Model_instance']['timeAdvance'])+" "+'days:'+str(days)+" "+'name:'+str(names[i]),
                    #         "host": newConfigFederates[i]['Federate_host'],
                    #         "name": newConfigFederates[i]['Model_Name']}
            federates.append(simulator)


"""Generating config JSON file"""
config["federates"] = federates
config["name"] = data['SCENARIO SCHEMA YAML']['SCENARIO CONFIGURATION'][0]['SCENARIO_NAME']

"""Saving JSON file"""
for i in range(int(num_sce)):
    with open('config_'+str(i)+'.json', 'w') as fp:
        json.dump(config, fp, indent=1)