from datetime import datetime
import helics as h
import os
# import arrow
import gzip
import sys

# # # Loading Libraries #
sys.path.append(os.getcwd().replace('\\', '/')+'/classHelics')
sys.path.append(os.getcwd().replace('\\', '/')+'/Models')

from classHelics.classFederate import Federate
from Models.PV_model import PV
from pypower_model import PypowerModel

# # # Loading Houses information #
current_Path = os.getcwd().replace('\\', '/')
files_Path = current_Path+'/Files/'
os.chdir(files_Path)
print(files_Path)

file = 'pv_10kw.csv'
date = '2014-01-01 00:00:00'
gridfile = 'demo_lv_grid.json'
# perd = int(sys.argv[1])
# file = str(sys.argv[2])

hhsim_data = [{'eid': '0-node_d1', 'P': 330.67},
              {'eid': '0-node_d4', 'P': 200},
              {'eid': '0-node_c12', 'P': 310.67},
              {'eid': '0-node_d10', 'P': 500.67}]

# x = PV()
# x.Inicio(file, date)

x =  PypowerModel()
flujo, children = x.start(gridfile, hhsim_data, files_Path)
buses = []
for i in range(len(children)):
    if children[i]['type'] == 'PQBus':
        buses.append(children[i])
print(buses)