import json
import os

# =============================================================================
# Here, I am generating the JSON file with the pubs and subs I want
# =============================================================================
class JsonConfig():
    
    def __init__(self, jsonfile):
        # Opening JSON file 
        # f = open('scheme.json',)
        # self.data = json.load(f)
        # self.jsonfile = open(jsonfile)
        # self.inputdata = json.load(self.jsonfile)
        self.inputdata = jsonfile       
        self.id = "--federates="
        self.name = self.inputdata['Model_instance']['nameFederate']
        self.core = "Federate"
        # self.name = self.name+str("_")
        self.core = "Federate"
        if 'broker_address' in list(self.inputdata.keys()):
            self.broker_address = self.inputdata['broker_address']
        else:
            self.broker_address = 'empty'
        # self.data['coreName'] = self.name+" "+self.core
        # self.data['name'] = self.name
        # print(self.inputdata)
        self.p = len(self.inputdata['Model_instance']['namePubs'].keys())
        self.s = len(self.inputdata['Model_instance']['nameSubs'].keys())
        # print(self.p)
        # print(self.s)
        self.pubId = self.inputdata['Model_instance']['namePubs'].keys()
        # print(type(self.pubId))
        # self.data['period'] = self.inputdata['Model_instance']['stepTime']
        # self.data['offset'] = of
        # self.data['input_delay'] = dl

    def run(self):
        
        current_Path = os.getcwd().replace('\\', '/')
        json_Path = current_Path+'/Jsons/'
                        
        self.pubs = self.inputdata['Model_instance']['namePubs']
        self.subs = self.inputdata['Model_instance']['nameSubs']
        self.n = self.inputdata['Model_instance']['amount']
        # init_p = 0
        # init_s = 0
        
        self_check_data = []
        
        for j in range(self.n):
            """Loading JSON scheme"""
            f = open('scheme.json',)
            self.data = json.load(f)
            # self.data['coreName'] = self.name+" "+self.core
            # self.data['name'] = self.name
            
            dirs = os.listdir(json_Path)
            num = 0
            for file in dirs:
                check = file.split(".")
                if len(check) == 1:
                    pass
                else:
                    if check[1] == 'json':
                        if file.split("_")[0] == self.name:
                            num = num + 1  
            
            self.data['name'] = self.name+'_'+str(num)
            # self.data['coreName'] = self.name+" "+self.core
            self.data['coreName'] = self.name+'_'+str(num)+" "+self.core
            if self.broker_address == 'empty':
                pass
            else:
                self.data['broker_address'] = self.broker_address
            
            for k,v in self.inputdata['Model_instance'].items():
                if k == 'stepTime':
                    self.data['period'] = self.inputdata['Model_instance']['stepTime']
                else:
                    self.data['period'] = 0
            self.data['key'] = self.inputdata['key']
            
            """Generating publications info"""
            pub = self.data['publications']
            for key, value in self.pubs.items():
                init_p = 0
                for i in range(value):
                    x = {"global":True, "name":key+str(init_p)}
                    init_p += 1
                    pub.append(x)
            
            """Generating subscrition info"""
            subs = self.data['subscriptions']
            for key, value in self.subs.items():
                init_s = 0
                for i in range(value):
                    y = {"name":key+str(init_s)}
                    init_s +=1
                    subs.append(y)
            
            """Checking publications and subscriptions"""
            self.data['publications'] = pub
            self.data['subscriptions'] = subs
            name_data = str(self.name+'_'+str(num)+'.json')
            self_check_data.append(name_data)
            
            """Saving JSON file"""
            self.data['publications'] = pub
            self.data['subscriptions'] = subs
            with open(json_Path+self.name+'_'+str(num)+'.json', 'w+') as fp:
                json.dump(self.data, fp, indent=1)
            
            return self.name+'_'+str(num)+'.json'
        
# x = JsonConfig('house_setup.json')
# x.run()

# f = open('scenario_scheme.json',)
# data = json.load(f)
# n = len(data['Simulator'])
# # print(len(data['Simulator']))
# x = data['Simulator'][0]
# for i in range(n):
#     jsonfile = data['Simulator'][i]
#     gen = JsonConfig(jsonfile)
#     gen.run()
    