/*
 * Copyright (c) 2015 Huawei, Inc. and others. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
/* Generated By:JavaCC: Do not edit this line. NEMOparserTokenManager.java */
package org.opendaylight.nemo.user.vnspacemanager.languagestyle.NEMOParse;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.NEMOParse.NEMOparser;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.NEMOParse.NEMOparserTokenManager;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.NEMOParse.SimpleCharStream;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.NEMOParse.Token;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

import static org.junit.Assert.*;
import static org.mockito.Mockito.*;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.api.support.membermodification.MemberMatcher;
import org.powermock.api.support.membermodification.MemberModifier;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
/**
 * Created by zhangmeng on 2015/12/17.
 */
@RunWith(PowerMockRunner.class)
@PrepareForTest({NEMOparserTokenManager.class,SimpleCharStream.class})
public class NEMOparserTokenManagerTest extends TestCase {
    private SimpleCharStream simpleCharStream;
    private int lexState;
    private NEMOparserTokenManager nemOparserTokenManager;
    private Class<NEMOparserTokenManager> class1;
    private Field field;
    @Before
    public void setUp() throws Exception {
        class1 = NEMOparserTokenManager.class;
        field = class1.getDeclaredField("input_stream");
        field.setAccessible(true);
        field.set(class1,null);

        simpleCharStream = mock(SimpleCharStream.class);
        lexState = 0;
    }

    @Test
    public void Init_ReInit() throws Exception{
        nemOparserTokenManager = new NEMOparserTokenManager(simpleCharStream);
        NEMOparserTokenManager.ReInit(null);
        nemOparserTokenManager = new NEMOparserTokenManager(simpleCharStream,lexState);//curLexstate = 0
        NEMOparserTokenManager.ReInit(null, lexState);

        Assert.assertTrue(field.get(class1) == null);
    }

    @Test
    public void testSetDebugStream() throws Exception {
        NEMOparserTokenManager.setDebugStream(null);
        Field field1 = class1.getField("debugStream");
        field1.setAccessible(true);
        Assert.assertTrue(field1.get(class1) == null);
    }


    @Test
    public void testJjFillToken() throws Exception {
        nemOparserTokenManager = new NEMOparserTokenManager(simpleCharStream);
        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.GetImage()).thenReturn("test");
        Assert.assertTrue(NEMOparserTokenManager.jjFillToken() != null);
    }

    @Test
    public void testGetNextToken() throws Exception {
        char curChar = 40;
        nemOparserTokenManager = new NEMOparserTokenManager(simpleCharStream);
        Assert.assertTrue(field.get(nemOparserTokenManager) == simpleCharStream);
        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.BeginToken()).thenReturn(curChar);
//        System.out.println("out :" + NEMOparserTokenManager.getNextToken());
        Assert.assertTrue(NEMOparserTokenManager.getNextToken() != null);
    }

    @Test
    public void testjjStartNfa_0() throws Exception{
        Method method = class1.getDeclaredMethod("jjStartNfa_0",new Class[]{int.class,long.class});
        method.setAccessible(true);
        int pos = 1;
        long active0 = 1L;

        Assert.assertTrue((Integer) method.invoke(class1, pos, active0) == 3);
//        System.out.println("method.invoke(class1,pos,active0):" + method.invoke(class1,pos,active0));
    }

    @Test
    public void testjjStopStringLiteralDfa_0() throws Exception{
        Method method = class1.getDeclaredMethod("jjStopStringLiteralDfa_0",new Class[]{
                int.class,
                long.class
        });
        method.setAccessible(true);
//        System.out.println("testjjStopStringLiteralDfa_0" + method.invoke(class1, 0, 0));
        Assert.assertTrue((Integer) method.invoke(class1, 0, 0) == -1);
//        System.out.println("testjjStopStringLiteralDfa_0" + method.invoke(class1, 0, 0x74800000000000L));
        Assert.assertTrue((Integer) method.invoke(class1, 0, 0x74800000000000L) == 205);
//        System.out.println("testjjStopStringLiteralDfa_0" + method.invoke(class1, 0, 0x3000000000000L));
        Assert.assertTrue((Integer) method.invoke(class1, 0, 0x3000000000000L) == 81);
        //case1
        Assert.assertTrue((Integer) method.invoke(class1, 1, 0x77800000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 1, 0) == -1);
        //case2
        Assert.assertTrue((Integer) method.invoke(class1, 2, 0x77800000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 2, 0) == -1);
        //case3
        Assert.assertTrue((Integer) method.invoke(class1, 3, 0x77800000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 3, 0) == -1);
        //case4
        Assert.assertTrue((Integer) method.invoke(class1, 4, 0x35000000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 4, 0x42800000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 4, 0) == -1);
        //case5
        Assert.assertTrue((Integer) method.invoke(class1, 5, 0x25000000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 5, 0x10000000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 5, 0) == -1);
        //case6
        Assert.assertTrue((Integer) method.invoke(class1, 6, 0x5000000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 6, 0x20000000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 6, 0) == -1);
        //case7
        Assert.assertTrue((Integer) method.invoke(class1, 7, 0x5000000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 7, 0) == -1);
        //case8
        Assert.assertTrue((Integer) method.invoke(class1, 8, 0x5000000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 8, 0) == -1);
        //case9
        Assert.assertTrue((Integer) method.invoke(class1, 9, 0x4000000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 9, 0x1000000000000L) == 205);
        Assert.assertTrue((Integer) method.invoke(class1, 9, 0) == -1);
        //case default
        Assert.assertTrue((Integer) method.invoke(class1, 10, 0) == -1);

    }

    @Test
    public void testjjStopAtPos() throws Exception{
        Method method = class1.getDeclaredMethod("jjStopAtPos",new Class[]{
                int.class,
                int.class
        });
        method.setAccessible(true);

        Assert.assertTrue((Integer) method.invoke(class1,1,1) == 2);
    }

    @Test
    public void testjjMoveStringLiteralDfa0_0() throws Exception{
        Method method = class1.getDeclaredMethod("jjMoveStringLiteralDfa0_0");
        method.setAccessible(true);
        Field field = class1.getDeclaredField("curChar");
        field.setAccessible(true);

        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.readChar()).thenReturn((char) 0);

        NEMOparserTokenManager.curChar = 33;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 38;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 40;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 41;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 42;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 43;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 44;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 58;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 59;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 60;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 61;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 65;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 66;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 67;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 68;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 69;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 70;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 73;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 77;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 78;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 79;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 80;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 81;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 84;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 85;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 91;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 93;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 99;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 102;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 105;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 110;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 111;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 114;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 115;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 124;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
        NEMOparserTokenManager.curChar = 1;
//        System.out.println("jjMoveStringLiteralDfa0_0" + method.invoke(class1));
        Assert.assertTrue((Integer) method.invoke(class1) != 0);
    }

    @Test
    public void testjjMoveStringLiteralDfa1_0() throws Exception{
        Method method = class1.getDeclaredMethod("jjMoveStringLiteralDfa1_0",new Class[]{long.class});
        method.setAccessible(true);

        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.readChar())
                .thenReturn((char) 0)
                .thenReturn((char) 38)
                .thenReturn((char) 61)
                .thenReturn((char) 61)
                .thenReturn((char) 61)
                .thenReturn((char) 69)
                .thenReturn((char) 77)
                .thenReturn((char) 80)
                .thenReturn((char) 82)
                .thenReturn((char) 97)
                .thenReturn((char) 99)
                .thenReturn((char) 101)
                .thenReturn((char) 108)
                .thenReturn((char) 110)
                .thenReturn((char) 111)
                .thenReturn((char) 112)
                .thenReturn((char) 114)
                .thenReturn((char) 116)
                .thenReturn((char) 117)
                .thenReturn((char) 121)
                .thenReturn((char) 124);

        //case default
        Assert.assertTrue((Integer) method.invoke(class1, 1L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 0);
        //case 38 and so on
//        System.out.println("0x8000L" + method.invoke(class1, 0x1000L));
        Assert.assertTrue((Integer) method.invoke(class1, 0x1000L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 38);
//        System.out.println("0x8000L" + method.invoke(class1, 0x8000L));
        Assert.assertTrue((Integer) method.invoke(class1, 0x8000L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 61);
//        System.out.println("0x8000L" + method.invoke(class1,0x40000L));
        Assert.assertTrue((Integer) method.invoke(class1, 0x40000L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 61);
//        System.out.println("0x8000L" + method.invoke(class1,0x80000L));
        Assert.assertTrue((Integer) method.invoke(class1, 0x80000L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 61);
//        System.out.println("0x8000L" + method.invoke(class1,0L));
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 69);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 77);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 80);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 82);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 97);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 99);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 101);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 108);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 111);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 112);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 114);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 116);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 117);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 121);
        Assert.assertTrue((Integer) method.invoke(class1, 0L) == 2);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 124);
    }

    @Test
    public void testjjMoveStringLiteralDfa2_0() throws Exception{
        Method method = class1.getDeclaredMethod("jjMoveStringLiteralDfa2_0",new Class[]{
                long.class,
                long.class
        });
        method.setAccessible(true);

        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.readChar())
                .thenReturn((char) 0)
                .thenReturn((char) 68)
                .thenReturn((char) 69)
                .thenReturn((char) 76)
                .thenReturn((char) 80)
                .thenReturn((char) 97)
                .thenReturn((char) 100)
                .thenReturn((char) 101)
                .thenReturn((char) 103)
                .thenReturn((char) 105)
                .thenReturn((char) 110)
                .thenReturn((char) 111)
                .thenReturn((char) 112)
                .thenReturn((char) 114)
                .thenReturn((char) 116);

        //case default
//        System.out.println("0x8000L" + method.invoke(class1, 1L, 1L));
        Assert.assertTrue((Integer)method.invoke(class1,1L,1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 0);
        //case others
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 68);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 69);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 76);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 80);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 97);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 100);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 101);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 103);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 105);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 111);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 112);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 114);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 3);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 116);

    }

    @Test
    public void testjjMoveStringLiteralDfa3_0() throws Exception{
        Method method = class1.getDeclaredMethod("jjMoveStringLiteralDfa3_0",new Class[]{
                long.class,
                long.class
        });
        method.setAccessible(true);

        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.readChar())
                .thenReturn((char) 0)
                .thenReturn((char) 65)
                .thenReturn((char) 69)
                .thenReturn((char) 79)
                .thenReturn((char) 99)
                .thenReturn((char) 100)
                .thenReturn((char) 101)
                .thenReturn((char) 103)
                .thenReturn((char) 105)
                .thenReturn((char) 109)
                .thenReturn((char) 110)
                .thenReturn((char) 111)
                .thenReturn((char) 112)
                .thenReturn((char) 114)
                .thenReturn((char) 116)
                .thenReturn((char) 119);

        //case default
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 0);
        //case others
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 65);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 69);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 79);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 99);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 100);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 101);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 103);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 105);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 109);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 111);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 112);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 114);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 116);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 4);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 119);

    }

    @Test
    public void testjjMoveStringLiteralDfa4_0() throws Exception{
        Method method = class1.getDeclaredMethod("jjMoveStringLiteralDfa4_0",new Class[]{
                long.class,
                long.class
        });
        method.setAccessible(true);

        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.readChar())
                .thenReturn((char) 0)
                .thenReturn((char) 77)
                .thenReturn((char) 82)
                .thenReturn((char) 84)
                .thenReturn((char) 97)
                .thenReturn((char) 101)
//                .thenReturn((char) 101)
                .thenReturn((char) 103)
                .thenReturn((char) 104)
//                .thenReturn((char) 104)
                .thenReturn((char) 105)
//                .thenReturn((char) 110)
                .thenReturn((char) 110)
                .thenReturn((char) 111)
                .thenReturn((char) 114)
//                .thenReturn((char) 115)
//                .thenReturn((char) 115)
                .thenReturn((char) 115)
                .thenReturn((char) 121);

        //case default:
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 0);
        //case others
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 77);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 82);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 84);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 97);
//        Assert.assertTrue((Integer) method.invoke(class1, 0x40000000000000L, 0x40000000000000L) == 5);
//        System.out.println("0x40000000000000L" + method.invoke(class1, 0x40000000000000L, 0x40000000000000L));
//        Assert.assertTrue(NEMOparserTokenManager.curChar == 101);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 101);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 103);
//        System.out.println("0x40000000000000L" + method.invoke(class1, 0x1000000000L, 0x1000000000L));
//        Assert.assertTrue(NEMOparserTokenManager.curChar == 104);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 104);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 105);
//        System.out.println("0x40000000000000L" + method.invoke(class1, 0x200000000000L, 0x200000000000L));
//        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 111);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 114);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 115);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 5);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 121);
    }

    @Test
    public void testjjMoveStringLiteralDfa5_0() throws Exception{
        Method method = class1.getDeclaredMethod("jjMoveStringLiteralDfa5_0",new Class[]{
                long.class,
                long.class
        });
        method.setAccessible(true);

        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.readChar())
                .thenReturn((char) 0)
                .thenReturn((char) 69)
                .thenReturn((char) 69)
                .thenReturn((char) 69)
                .thenReturn((char) 84)
                .thenReturn((char) 97)
                .thenReturn((char) 99)
                .thenReturn((char) 100)
                .thenReturn((char) 101)
                .thenReturn((char) 103)
                .thenReturn((char) 105)
                .thenReturn((char) 110)
                .thenReturn((char) 111)
                .thenReturn((char) 114)
                .thenReturn((char) 116)
                .thenReturn((char) 116);


        //case default:
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 0);
        //case others
        Assert.assertTrue((Integer) method.invoke(class1, 0x2000000L, 0x2000000L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 69);
        Assert.assertTrue((Integer) method.invoke(class1, 0x10000000L, 0x10000000L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 69);
        Assert.assertTrue((Integer) method.invoke(class1, 0x8000000L, 0x8000000L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 69);
        Assert.assertTrue((Integer) method.invoke(class1, 0x4000000L, 0x4000000L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 84);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 97);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 99);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 100);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 101);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 103);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 105);
        Assert.assertTrue((Integer) method.invoke(class1, 0x10000000000L, 0x10000000000L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 111);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 114);
        Assert.assertTrue((Integer) method.invoke(class1, 0x4000000000L, 0x4000000000L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 116);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 6);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 116);
    }

    @Test
    public void testjjMoveStringLiteralDfa6_0() throws Exception{
        Method method = class1.getDeclaredMethod("jjMoveStringLiteralDfa6_0",new Class[]{
                long.class,
                long.class
        });
        method.setAccessible(true);

        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.readChar())
                .thenReturn((char) 0)
                .thenReturn((char) 99)
                .thenReturn((char) 100)
                .thenReturn((char) 101)
                .thenReturn((char) 105)
                .thenReturn((char) 110)
                .thenReturn((char) 114)
                .thenReturn((char) 116);

        //case default
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 7);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 0);
        //case others
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 7);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 99);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 7);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 100);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 7);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 101);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 7);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 105);
        Assert.assertTrue((Integer) method.invoke(class1, 0x80000000L, 0x80000000L) == 7);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 7);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 114);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 7);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 116);

    }

    @Test
    public void testjjMoveStringLiteralDfa7_0() throws Exception{
        Method method = class1.getDeclaredMethod("jjMoveStringLiteralDfa7_0",new Class[]{
                long.class,
                long.class
        });
        method.setAccessible(true);

        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.readChar())
                .thenReturn((char) 0)
                .thenReturn((char) 101)
                .thenReturn((char) 105)
                .thenReturn((char) 111)
                .thenReturn((char) 115)
                .thenReturn((char) 116)
                .thenReturn((char) 121)
                .thenReturn((char) 121);

        //case default:
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 8);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 0);

        //case others:
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 8);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 101);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 8);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 105);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 8);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 111);
        Assert.assertTrue((Integer) method.invoke(class1, 0x400000000L, 0x400000000L) == 8);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 115);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 8);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 116);
        Assert.assertTrue((Integer) method.invoke(class1, 0x100000000L, 0x100000000L) == 8);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 121);
        Assert.assertTrue((Integer) method.invoke(class1, 0x80000000000L, 0x80000000000L) == 8);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 121);
    }

    @Test
    public void testjjMoveStringLiteralDfa8_0() throws Exception{
        Method method = class1.getDeclaredMethod("jjMoveStringLiteralDfa8_0",new Class[]{
                long.class,
                long.class
        });
        method.setAccessible(true);

        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.readChar())
                .thenReturn((char) 0)
                .thenReturn((char) 105)
                .thenReturn((char) 108)
                .thenReturn((char) 110)
                .thenReturn((char) 110)
                .thenReturn((char) 110)
                .thenReturn((char) 111);

        //case default:
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 9);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 0);

        //case others
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 9);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 105);
        Assert.assertTrue((Integer) method.invoke(class1, 0x8000000000000L, 0x8000000000000L) == 9);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 108);
        Assert.assertTrue((Integer) method.invoke(class1, 0x2000000000L, 0x2000000000L) == 9);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 0x8000000000L, 0x8000000000L) == 9);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 9);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 9);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 111);
    }

    @Test
    public void testjjMoveStringLiteralDfa9_0() throws Exception{
        Method method = class1.getDeclaredMethod("jjMoveStringLiteralDfa9_0",new Class[]{
                long.class,
                long.class
        });
        method.setAccessible(true);

        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.readChar())
                .thenReturn((char) 0)
                .thenReturn((char) 110)
                .thenReturn((char) 110)
                .thenReturn((char) 111)
                .thenReturn((char) 115);

        //case default:
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 10);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 0);

        //case others
        Assert.assertTrue((Integer) method.invoke(class1, 0x200000000L, 0x200000000L) == 10);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 10);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 10);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 111);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 10);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 115);
    }

    @Test
    public void testjjMoveStringLiteralDfa10_0() throws Exception {
        Method method = class1.getDeclaredMethod("jjMoveStringLiteralDfa10_0", new Class[]{
                long.class,
                long.class
        });
        method.setAccessible(true);

        PowerMockito.mockStatic(SimpleCharStream.class);
        PowerMockito.when(SimpleCharStream.readChar())
                .thenReturn((char) 0)
                .thenReturn((char) 110)
                .thenReturn((char) 115);

        //case default:
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 11);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 0);

        //case others
        Assert.assertTrue((Integer) method.invoke(class1, 0x100000000000L, 0x100000000000L) == 11);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 110);
        Assert.assertTrue((Integer) method.invoke(class1, 1L, 1L) == 11);
        Assert.assertTrue(NEMOparserTokenManager.curChar == 115);
    }

    @Test
    public void testjjStartNfaWithStates_0() throws Exception {
    }

    @Test
    public void testjjMoveNfa_0() throws Exception {
    }

    @Test
    public void testjjCheckNAdd() throws Exception {
        Field field = class1.getDeclaredField("jjrounds");
        field.setAccessible(true);
        Field field1 = class1.getDeclaredField("jjround");
        field1.setAccessible(true);

        int state  = 1;
        int jjrounds[] = new int[205];
        jjrounds[0] = 1;
        int jjround = 1;

    }
}