/*
 * Copyright (c) 2015 Huawei, Inc. and others. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
/* Generated By:JavaCC: Do not edit this line. NEMOparser.java */
package org.opendaylight.nemo.user.vnspacemanager.languagestyle.NEMOParse;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.updateintentlang.UpdateNodeLang;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.updateintentlang.UpdateConnectionLang;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.updateintentlang.UpdateFlowLang;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.updateintentlang.UpdateOperationLang;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.deleteintentlang.DeleteNodeLang;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.deleteintentlang.DeleteConnectionLang;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.deleteintentlang.DeleteFlowLang;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.deleteintentlang.DeleteOperationLang;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.deleteintentlang.DeleteTemplateInstanceLang;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.deleteintentlang.DeleteTemplateDefinitionLang;

import org.opendaylight.nemo.user.vnspacemanager.languagestyle.Query;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.NEMOConstants;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.updateintentlang.UpdateTemplateDefinitionLang;
import org.opendaylight.nemo.user.vnspacemanager.languagestyle.deleteintentlang.DeleteConnectionPointLang;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.nemo.user.tenantmanager.TenantManage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.nemo.common.rev151010.UserId;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.LinkedList;
import java.util.ArrayList;
import java.io.StringReader;

public class NEMOparser implements NEMOparserConstants {
  public String parseNEMO(UserId userId,String strNEMO, DataBroker dataBroker, TenantManage tenantManage) throws ParseException
    {
        String strReturn = null ;
        ReInit(new StringReader(strNEMO));
      try
      {
           strReturn = NEMO(userId,dataBroker,tenantManage);
      }
      catch ( ParseException objException )
      {
      throw objException;
      }
      catch ( TokenMgrError objError )
      {
      throw new ParseException(objError.getMessage());
      }
     return strReturn;
  }

  static final public String NEMO(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CREATE:
    case IMPORT:
    case UPDATE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CREATE:
        jj_consume_token(CREATE);
        break;
      case IMPORT:
        jj_consume_token(IMPORT);
        break;
      case UPDATE:
        jj_consume_token(UPDATE);
        break;
      default:
        jj_la1[0] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    {if (true) return UpdateIntent(userId,dataBroker,tenantManage);}
      break;
    case DELETE:
      jj_consume_token(DELETE);
    {if (true) return DeleteIntent(userId,dataBroker,tenantManage);}
      break;
    case QUERY:
      jj_consume_token(QUERY);
    {if (true) return Query(userId,dataBroker,tenantManage);}
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  static final public String UpdateIntent(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NODE:
      jj_consume_token(NODE);
    {if (true) return UpdateNode(userId,dataBroker,tenantManage);}
      break;
    case CONNECTION:
      jj_consume_token(CONNECTION);
    {if (true) return UpdateConnection(userId,dataBroker,tenantManage);}
      break;
    case FLOW:
      jj_consume_token(FLOW);
    {if (true) return  UpdateFlow(userId,dataBroker,tenantManage);}
      break;
    case OPERATION:
      jj_consume_token(OPERATION);
    {if (true) return UpdateOperation(userId,dataBroker,tenantManage);}
      break;
    case NODEMODEL:
      jj_consume_token(NODEMODEL);
    {if (true) return NodeModel(userId,dataBroker,tenantManage);}
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  static final public String DeleteIntent(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NODE:
      jj_consume_token(NODE);
    {if (true) return DeleteNode(userId,dataBroker,tenantManage);}
      break;
    case CONNECTION:
      jj_consume_token(CONNECTION);
    {if (true) return DeleteConnection(userId,dataBroker,tenantManage);}
      break;
    case FLOW:
      jj_consume_token(FLOW);
    {if (true) return  DeleteFlow(userId,dataBroker,tenantManage);}
      break;
    case OPERATION:
      jj_consume_token(OPERATION);
    {if (true) return DeleteOperation(userId,dataBroker,tenantManage);}
      break;
    case TEMPLATEINSTANCE:
      jj_consume_token(TEMPLATEINSTANCE);
   {if (true) return DeleteTemplateInstance(userId,dataBroker,tenantManage);}
      break;
    case CONNECTIONPOINT:
      jj_consume_token(CONNECTIONPOINT);
   {if (true) return DeleteConnectionPoint(userId,dataBroker,tenantManage);}
      break;
    case NODEMODEL:
      jj_consume_token(NODEMODEL);
   {if (true) return DeleteTemplateDefinition(userId,dataBroker,tenantManage);}
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  static final public String UpdateNode(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
  Token objNameToken = null;
  Token objTypeToken = null;
  Token objSubNodeNameToken = null;
  Token objSubNodeNameToken1 = null;
  Token objPropertyNameToken = null;
  Token objPropertyNameToken1 = null;
  List<String> subNodeNameList = new ArrayList<String>();
  LinkedHashMap<String,LinkedHashMap<String,String>> properties = new LinkedHashMap<String,LinkedHashMap<String,String>>();
  UpdateNodeLang updateNodeLang = new UpdateNodeLang(dataBroker, tenantManage);
    objNameToken = jj_consume_token(ID);
    jj_consume_token(TYPE);
    objTypeToken = jj_consume_token(ID);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONTAIN:
      jj_consume_token(CONTAIN);
      objSubNodeNameToken = jj_consume_token(ID);
      subNodeNameList.add(objSubNodeNameToken.image);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[4] = jj_gen;
          break label_1;
        }
        jj_consume_token(COMMA);
        objSubNodeNameToken1 = jj_consume_token(ID);
        subNodeNameList.add(objSubNodeNameToken1.image);
      }
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROPERTY:
      jj_consume_token(PROPERTY);
      objPropertyNameToken = jj_consume_token(ID);
      jj_consume_token(COLON);
      LinkedHashMap<String,String> property = property();
      properties.put(objPropertyNameToken.image, property);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[6] = jj_gen;
          break label_2;
        }
        jj_consume_token(COMMA);
        objPropertyNameToken1 = jj_consume_token(ID);
        jj_consume_token(COLON);
        LinkedHashMap<String,String> property1 = property();
        properties.put(objPropertyNameToken1.image, property1);
      }
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    {if (true) return updateNodeLang.NodeHandling(userId, objNameToken.image, objTypeToken.image,subNodeNameList, properties);}
    throw new Error("Missing return statement in function");
  }

  static final public String UpdateConnection(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
    Token objConnNameToken = null;
    Token objConnTypeToken = null;
    Token objConnEndNodeToken = null;
    Token objPropertyNameToken = null;
  Token objPropertyNameToken1 = null;
    List<String> endNodes = new ArrayList<String>();
    LinkedHashMap<String,LinkedHashMap<String,String>> properties = new LinkedHashMap<String,LinkedHashMap<String,String>>();
    UpdateConnectionLang updateConnLang = new UpdateConnectionLang(dataBroker,tenantManage);
    objConnNameToken = jj_consume_token(ID);
    jj_consume_token(TYPE);
    objConnTypeToken = jj_consume_token(ID);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENDNODES:
      jj_consume_token(ENDNODES);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        objConnEndNodeToken = jj_consume_token(ID);
           endNodes.add(objConnEndNodeToken.image);
        break;
      case TEMPID:
        objConnEndNodeToken = jj_consume_token(TEMPID);
          endNodes.add(objConnEndNodeToken.image);
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[9] = jj_gen;
          break label_3;
        }
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
          objConnEndNodeToken = jj_consume_token(ID);
          endNodes.add(objConnEndNodeToken.image);
          break;
        case TEMPID:
          objConnEndNodeToken = jj_consume_token(TEMPID);
          endNodes.add(objConnEndNodeToken.image);
          break;
        default:
          jj_la1[10] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROPERTY:
      jj_consume_token(PROPERTY);
      objPropertyNameToken = jj_consume_token(ID);
      jj_consume_token(COLON);
      LinkedHashMap<String,String> property = property();
      properties.put(objPropertyNameToken.image, property);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[12] = jj_gen;
          break label_4;
        }
        jj_consume_token(COMMA);
        objPropertyNameToken1 = jj_consume_token(ID);
        jj_consume_token(COLON);
        LinkedHashMap<String,String> property1 = property();
        properties.put(objPropertyNameToken1.image, property1);
      }
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    {if (true) return updateConnLang.ConnectionHandling(userId, objConnNameToken.image, objConnTypeToken.image,endNodes, properties);}
    throw new Error("Missing return statement in function");
  }

  static final public String UpdateFlow(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
  Token objFlowNameToken = null;
  Token objFlowMatchItem = null;
  Token objFlowMatchItem1 = null;
  Token objPropertyNameToken = null;
  Token objPropertyNameToken1 = null;
  LinkedHashMap<String,LinkedHashMap<String,String>> matchItems = new LinkedHashMap<String,LinkedHashMap<String,String>>();
  LinkedHashMap<String,LinkedHashMap<String,String>> properties = new LinkedHashMap<String,LinkedHashMap<String,String>>();
  UpdateFlowLang updateFlowLang = new UpdateFlowLang(dataBroker, tenantManage);
    objFlowNameToken = jj_consume_token(ID);
    jj_consume_token(MATCH);
    objFlowMatchItem = jj_consume_token(ID);
    jj_consume_token(COLON);
      LinkedHashMap<String,String> match = property();
      matchItems.put(objFlowMatchItem.image, match);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      objFlowMatchItem1 = jj_consume_token(ID);
      jj_consume_token(COLON);
        LinkedHashMap<String,String> match1= property();
        matchItems.put(objFlowMatchItem1.image, match1);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROPERTY:
      jj_consume_token(PROPERTY);
      objPropertyNameToken = jj_consume_token(ID);
      jj_consume_token(COLON);
      LinkedHashMap<String,String> property = property();
      properties.put(objPropertyNameToken.image, property);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[15] = jj_gen;
          break label_6;
        }
        jj_consume_token(COMMA);
        objPropertyNameToken1 = jj_consume_token(ID);
        jj_consume_token(COLON);
        LinkedHashMap<String,String> property1 = property();
        properties.put(objPropertyNameToken1.image, property1);
      }
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    {if (true) return updateFlowLang.FlowHandling(userId, objFlowNameToken.image, matchItems, properties);}
    throw new Error("Missing return statement in function");
  }

  static final public String UpdateOperation(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
  Token objOperNameToken = null;
  Token objOperTargetToken = null;
  Token objOperPrioToken = null;
  Token objCondRelationToken = null;
  Token objCondNameToken = null;
  Token objCondMatchPattern = null;
  Token objActionNameToken = null;
  LinkedHashMap<String,LinkedHashMap<String,String>> conditions = new LinkedHashMap<String,LinkedHashMap<String,String>>();
  LinkedHashMap<String,LinkedHashMap<String,String>> actions = new LinkedHashMap<String,LinkedHashMap<String,String>>();
  UpdateOperationLang updateOperationLang  = new UpdateOperationLang(dataBroker, tenantManage);
    objOperNameToken = jj_consume_token(ID);
    jj_consume_token(TARGET);
    objOperTargetToken = jj_consume_token(ID);
    jj_consume_token(PRIORITY);
    objOperPrioToken = jj_consume_token(UNUMBER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONDITION:
      jj_consume_token(CONDITION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        objCondRelationToken = jj_consume_token(NOT);
        break;
      default:
        jj_la1[17] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      objCondNameToken = jj_consume_token(ID);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL:
        objCondMatchPattern = jj_consume_token(EQUAL);
        break;
      case GTHAN:
        objCondMatchPattern = jj_consume_token(GTHAN);
        break;
      case LTHAN:
        objCondMatchPattern = jj_consume_token(LTHAN);
        break;
      case NLTHAN:
        objCondMatchPattern = jj_consume_token(NLTHAN);
        break;
      case NMTHAN:
        objCondMatchPattern = jj_consume_token(NMTHAN);
        break;
      case BETWEEN:
        objCondMatchPattern = jj_consume_token(BETWEEN);
        break;
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      LinkedHashMap<String,String> targetValue = conditionTarget();
      String s = (objCondRelationToken==null)?null:objCondRelationToken.image;
      conditions.put(s+","+objCondNameToken.image+","+objCondMatchPattern.image, targetValue);
      jj_consume_token(RPAREN);
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND:
        case OR:
        case NOT:
          ;
          break;
        default:
          jj_la1[19] = jj_gen;
          break label_7;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT:
          objCondRelationToken = jj_consume_token(NOT);
          break;
        case AND:
          objCondRelationToken = jj_consume_token(AND);
          break;
        case OR:
          objCondRelationToken = jj_consume_token(OR);
          break;
        default:
          jj_la1[20] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQUAL:
          objCondMatchPattern = jj_consume_token(EQUAL);
          break;
        case GTHAN:
          objCondMatchPattern = jj_consume_token(GTHAN);
          break;
        case LTHAN:
          objCondMatchPattern = jj_consume_token(LTHAN);
          break;
        case NLTHAN:
          objCondMatchPattern = jj_consume_token(NLTHAN);
          break;
        case NMTHAN:
          objCondMatchPattern = jj_consume_token(NMTHAN);
          break;
        case BETWEEN:
          objCondMatchPattern = jj_consume_token(BETWEEN);
          break;
        default:
          jj_la1[21] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        LinkedHashMap<String,String> targetValue1 = conditionTarget();
        String s1 = (objCondRelationToken==null)?null:objCondRelationToken.image;
        conditions.put(s1+","+objCondNameToken.image+","+objCondMatchPattern.image, targetValue1);
        jj_consume_token(RPAREN);
      }
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ACTION:
      jj_consume_token(ACTION);
      objActionNameToken = jj_consume_token(ID);
      LinkedHashMap<String,String> action = null;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        jj_consume_token(COLON);
      action = property();
        break;
      default:
        jj_la1[23] = jj_gen;
        ;
      }
      actions.put(objActionNameToken.image, action);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[24] = jj_gen;
          break label_8;
        }
        jj_consume_token(COMMA);
        objActionNameToken = jj_consume_token(ID);
        LinkedHashMap<String,String> action1 = null;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COLON:
          jj_consume_token(COLON);
        action1 = property();
          break;
        default:
          jj_la1[25] = jj_gen;
          ;
        }
        actions.put(objActionNameToken.image, action1);
      }
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    {if (true) return updateOperationLang.OperationHandling(userId, objOperNameToken.image, objOperTargetToken.image, objOperPrioToken.image,conditions,actions);}
    throw new Error("Missing return statement in function");
  }

  static final public String NodeModel(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
  String strReturn = null;
  Token nodeModelName = null;
  Token parameterType = null;
  Token parameterName = null;
  Token parameterType1 = null;
  Token parameterName1 = null;
  Token vnfUri = null;
  LinkedHashMap<String, String> parameters = new LinkedHashMap< String, String >();
  UpdateTemplateDefinitionLang definition = new UpdateTemplateDefinitionLang(dataBroker, tenantManage);
  String vnfUriLang=null;
  List<String > nodeErrorList = new LinkedList<String>();
  List<String > connErrorList = new LinkedList<String>();
  List<String > connPointErrorList = new LinkedList<String>();
  List<String > flowErrorList = new LinkedList<String>();
  List<String > operationErrorList = new LinkedList<String>();
    nodeModelName = jj_consume_token(ID);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROPERTY:
      jj_consume_token(PROPERTY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        parameterType = jj_consume_token(STRING);
        break;
      case INTEGER:
        parameterType = jj_consume_token(INTEGER);
        break;
      case RANGE:
        parameterType = jj_consume_token(RANGE);
        break;
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(COLON);
      parameterName = jj_consume_token(ID);
      parameters.put(parameterName.image, parameterType.image);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[28] = jj_gen;
          break label_9;
        }
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING:
          parameterType1 = jj_consume_token(STRING);
          break;
        case INTEGER:
          parameterType1 = jj_consume_token(INTEGER);
          break;
        case RANGE:
          parameterType1 = jj_consume_token(RANGE);
          break;
        default:
          jj_la1[29] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(COLON);
        parameterName1 = jj_consume_token(ID);
      parameters.put(parameterName1.image, parameterType1.image);
      }
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VNFD:
      jj_consume_token(VNFD);
   System.out.println("parseado vnfd");
      vnfUri = jj_consume_token(URI);
      vnfUriLang= vnfUri.image;
      System.out.println(vnfUri);
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NODE:
      case CONNECTION:
      case CONNECTIONPOINT:
      case FLOW:
      case OPERATION:
        ;
        break;
      default:
        jj_la1[32] = jj_gen;
        break label_10;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NODE:
        jj_consume_token(NODE);
      strReturn = abstractNode(userId, definition);
      if(strReturn !=null && !strReturn.split("\u005c\u005c|")[0].equals("Warning"))
    {
        {if (true) return strReturn;}
        }
        break;
      case CONNECTION:
        jj_consume_token(CONNECTION);
    strReturn = abstractConnection(userId, definition);
    if(strReturn !=null && !strReturn.split("\u005c\u005c|")[0].equals("Warning"))
    {
        {if (true) return strReturn;}
        }
        break;
      case FLOW:
        jj_consume_token(FLOW);
    strReturn = abstractFlow(definition);
    if(strReturn !=null && !strReturn.split("\u005c\u005c|")[0].equals("Warning"))
    {
        {if (true) return strReturn;}
        }
        break;
      case OPERATION:
        jj_consume_token(OPERATION);
    strReturn = abstractOperation(definition);
    if(strReturn !=null && !strReturn.split("\u005c\u005c|")[0].equals("Warning"))
    {
        {if (true) return strReturn;}
        }
        break;
      case CONNECTIONPOINT:
        jj_consume_token(CONNECTIONPOINT);
    strReturn= abstractConnectionPoint(definition);
    if(strReturn !=null && !strReturn.split("\u005c\u005c|")[0].equals("Warning"))
    {
        {if (true) return strReturn;}
        }
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if(strReturn !=null)
    {
      {if (true) return strReturn;}
    }
    else
    {
      {if (true) return definition.templateDefinitionLang(userId, nodeModelName.image, parameters,vnfUriLang);}
    }
    throw new Error("Missing return statement in function");
  }

  static final public String abstractNode(UserId userId, UpdateTemplateDefinitionLang definition) throws ParseException {
  Token objNameToken = null;
  Token objTypeToken = null;
  Token objSubNodeNameToken = null;
  Token objSubNodeNameToken1 = null;
  Token objPropertyNameToken = null;
  Token objPropertyNameToken1 = null;
  List<String> subNodeNameList = new ArrayList<String>();
  LinkedHashMap<String,LinkedHashMap<String,String>> properties = new LinkedHashMap<String,LinkedHashMap<String,String>>();
    objNameToken = jj_consume_token(ID);
    jj_consume_token(TYPE);
    objTypeToken = jj_consume_token(ID);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONTAIN:
      jj_consume_token(CONTAIN);
      objSubNodeNameToken = jj_consume_token(ID);
      subNodeNameList.add(objSubNodeNameToken.image);
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[34] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        objSubNodeNameToken1 = jj_consume_token(ID);
        subNodeNameList.add(objSubNodeNameToken1.image);
      }
      break;
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROPERTY:
      jj_consume_token(PROPERTY);
      objPropertyNameToken = jj_consume_token(ID);
      jj_consume_token(COLON);
      LinkedHashMap<String,String> property = property();
      properties.put(objPropertyNameToken.image, property);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[36] = jj_gen;
          break label_12;
        }
        jj_consume_token(COMMA);
        objPropertyNameToken1 = jj_consume_token(ID);
        jj_consume_token(COLON);
        LinkedHashMap<String,String> property1 = property();
        properties.put(objPropertyNameToken1.image, property1);
      }
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    {if (true) return definition.createAbstractNode(userId, objNameToken.image, objTypeToken.image,subNodeNameList, properties);};
    throw new Error("Missing return statement in function");
  }

  static final public String abstractConnection(UserId userId, UpdateTemplateDefinitionLang definition) throws ParseException {
    Token objConnNameToken = null;
    Token objConnTypeToken = null;
    Token objConnEndNodeToken = null;
    Token objPropertyNameToken = null;
  Token objPropertyNameToken1 = null;
    List<String> endNodes = new ArrayList<String>();
    LinkedHashMap<String,LinkedHashMap<String,String>> properties = new LinkedHashMap<String,LinkedHashMap<String,String>>();
    objConnNameToken = jj_consume_token(ID);
    jj_consume_token(TYPE);
    objConnTypeToken = jj_consume_token(ID);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENDNODES:
      jj_consume_token(ENDNODES);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        objConnEndNodeToken = jj_consume_token(ID);
          endNodes.add(objConnEndNodeToken.image);
        break;
      case TEMPID:
        objConnEndNodeToken = jj_consume_token(TEMPID);
          endNodes.add(objConnEndNodeToken.image);
        break;
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[39] = jj_gen;
          break label_13;
        }
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
          objConnEndNodeToken = jj_consume_token(ID);
          endNodes.add(objConnEndNodeToken.image);
          break;
        case TEMPID:
          objConnEndNodeToken = jj_consume_token(TEMPID);
          endNodes.add(objConnEndNodeToken.image);
          break;
        default:
          jj_la1[40] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROPERTY:
      jj_consume_token(PROPERTY);
      objPropertyNameToken = jj_consume_token(ID);
      jj_consume_token(COLON);
      LinkedHashMap<String,String> property = property();
      properties.put(objPropertyNameToken.image, property);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[42] = jj_gen;
          break label_14;
        }
        jj_consume_token(COMMA);
        objPropertyNameToken1 = jj_consume_token(ID);
        jj_consume_token(COLON);
        LinkedHashMap<String,String> property1 = property();
        properties.put(objPropertyNameToken1.image, property1);
      }
      break;
    default:
      jj_la1[43] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    {if (true) return definition.createAbstractConnection(userId, objConnNameToken.image, objConnTypeToken.image,endNodes, properties);}
    throw new Error("Missing return statement in function");
  }

  static final public String abstractFlow(UpdateTemplateDefinitionLang definition) throws ParseException {
  Token objFlowNameToken = null;
  Token objFlowMatchItem = null;
  Token objFlowMatchItem1 = null;
  Token objPropertyNameToken = null;
  Token objPropertyNameToken1 = null;
  LinkedHashMap<String,LinkedHashMap<String,String>> matchItems = new LinkedHashMap<String,LinkedHashMap<String,String>>();
  LinkedHashMap<String,LinkedHashMap<String,String>> properties = new LinkedHashMap<String,LinkedHashMap<String,String>>();
    objFlowNameToken = jj_consume_token(ID);
    jj_consume_token(MATCH);
    objFlowMatchItem = jj_consume_token(ID);
    jj_consume_token(COLON);
      LinkedHashMap<String,String> match = property();
      matchItems.put(objFlowMatchItem.image, match);
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[44] = jj_gen;
        break label_15;
      }
      jj_consume_token(COMMA);
      objFlowMatchItem1 = jj_consume_token(ID);
      jj_consume_token(COLON);
        LinkedHashMap<String,String> match1 = property();
        matchItems.put(objFlowMatchItem1.image, match1);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROPERTY:
      jj_consume_token(PROPERTY);
      objPropertyNameToken = jj_consume_token(ID);
      jj_consume_token(COLON);
      LinkedHashMap<String,String> property = property();
      properties.put(objPropertyNameToken.image, property);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[45] = jj_gen;
          break label_16;
        }
        jj_consume_token(COMMA);
        objPropertyNameToken1 = jj_consume_token(ID);
        jj_consume_token(COLON);
        LinkedHashMap<String,String> property1 = property();
        properties.put(objPropertyNameToken1.image, property1);
      }
      break;
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    {if (true) return definition.createAbstractFlow(objFlowNameToken.image, matchItems, properties);};
    throw new Error("Missing return statement in function");
  }

  static final public String abstractOperation(UpdateTemplateDefinitionLang definition) throws ParseException {
  Token objOperNameToken = null;
  Token objOperTargetToken = null;
  Token objOperPrioToken = null;
  Token objCondRelationToken = null;
  Token objCondNameToken = null;
  Token objCondMatchPattern = null;
  Token objActionNameToken = null;
  LinkedHashMap<String,LinkedHashMap<String,String>> conditions = new LinkedHashMap<String,LinkedHashMap<String,String>>();
  LinkedHashMap<String,LinkedHashMap<String,String>> actions = new LinkedHashMap<String,LinkedHashMap<String,String>>();
    objOperNameToken = jj_consume_token(ID);
    jj_consume_token(TARGET);
    objOperTargetToken = jj_consume_token(ID);
    jj_consume_token(PRIORITY);
    objOperPrioToken = jj_consume_token(UNUMBER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONDITION:
      jj_consume_token(CONDITION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        objCondRelationToken = jj_consume_token(NOT);
        break;
      default:
        jj_la1[47] = jj_gen;
        ;
      }
      jj_consume_token(LPAREN);
      objCondNameToken = jj_consume_token(ID);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL:
        objCondMatchPattern = jj_consume_token(EQUAL);
        break;
      case GTHAN:
        objCondMatchPattern = jj_consume_token(GTHAN);
        break;
      case LTHAN:
        objCondMatchPattern = jj_consume_token(LTHAN);
        break;
      case NLTHAN:
        objCondMatchPattern = jj_consume_token(NLTHAN);
        break;
      case NMTHAN:
        objCondMatchPattern = jj_consume_token(NMTHAN);
        break;
      case BETWEEN:
        objCondMatchPattern = jj_consume_token(BETWEEN);
        break;
      default:
        jj_la1[48] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      LinkedHashMap<String,String> targetValue = conditionTarget();
      String s = (objCondRelationToken==null)?null:objCondRelationToken.image;
      conditions.put(s+","+objCondNameToken.image+","+objCondMatchPattern.image, targetValue);
      jj_consume_token(RPAREN);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND:
        case OR:
        case NOT:
          ;
          break;
        default:
          jj_la1[49] = jj_gen;
          break label_17;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT:
          objCondRelationToken = jj_consume_token(NOT);
          break;
        case AND:
          objCondRelationToken = jj_consume_token(AND);
          break;
        case OR:
          objCondRelationToken = jj_consume_token(OR);
          break;
        default:
          jj_la1[50] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPAREN);
        objCondNameToken = jj_consume_token(ID);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQUAL:
          objCondMatchPattern = jj_consume_token(EQUAL);
          break;
        case GTHAN:
          objCondMatchPattern = jj_consume_token(GTHAN);
          break;
        case LTHAN:
          objCondMatchPattern = jj_consume_token(LTHAN);
          break;
        case NLTHAN:
          objCondMatchPattern = jj_consume_token(NLTHAN);
          break;
        case NMTHAN:
          objCondMatchPattern = jj_consume_token(NMTHAN);
          break;
        case BETWEEN:
          objCondMatchPattern = jj_consume_token(BETWEEN);
          break;
        default:
          jj_la1[51] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        LinkedHashMap<String,String> targetValue1 = conditionTarget();
        conditions.put(objCondRelationToken.image+","+objCondNameToken.image+","+objCondMatchPattern.image, targetValue1);
        jj_consume_token(RPAREN);
      }
      break;
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ACTION:
      jj_consume_token(ACTION);
      objActionNameToken = jj_consume_token(ID);
      LinkedHashMap<String,String> action = null;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        jj_consume_token(COLON);
      action = property();
        break;
      default:
        jj_la1[53] = jj_gen;
        ;
      }
      actions.put(objActionNameToken.image, action);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[54] = jj_gen;
          break label_18;
        }
        jj_consume_token(COMMA);
        objActionNameToken = jj_consume_token(ID);
        LinkedHashMap<String,String> action1 = null;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COLON:
          jj_consume_token(COLON);
        action1 = property();
          break;
        default:
          jj_la1[55] = jj_gen;
          ;
        }
        actions.put(objActionNameToken.image, action1);
      }
      break;
    default:
      jj_la1[56] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    {if (true) return definition.createAbstractOperation(objOperNameToken.image, objOperTargetToken.image, objOperPrioToken.image,conditions,actions);};
    throw new Error("Missing return statement in function");
  }

  static final public String abstractConnectionPoint(UpdateTemplateDefinitionLang definition) throws ParseException {
  String strReturn = null;
  Token connectionPointName = null;
  Token extInterfaceName = null;
  String extInt=null;
    connectionPointName = jj_consume_token(ID);
    System.out.println(connectionPointName.image);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AT:
      jj_consume_token(AT);
      jj_consume_token(VNFD);
      jj_consume_token(COLON);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TEMPID:
        extInterfaceName = jj_consume_token(TEMPID);
                extInt=extInterfaceName.image;
        System.out.println(extInterfaceName.image);
        break;
      case ID:
        extInterfaceName = jj_consume_token(ID);
        extInt=extInterfaceName.image;
        System.out.println(extInterfaceName.image);
        break;
      default:
        jj_la1[57] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
  {if (true) return definition.createAbstractConnectionPoint(connectionPointName.image, extInt);}
    throw new Error("Missing return statement in function");
  }

  static final public String DeleteNode(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
    Token objNodeNameToken = null;
    DeleteNodeLang deleteNodelang = new DeleteNodeLang(dataBroker, tenantManage);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      objNodeNameToken = jj_consume_token(ID);
      break;
    case TEMPID:
      objNodeNameToken = jj_consume_token(TEMPID);
      break;
    default:
      jj_la1[59] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
    {if (true) return deleteNodelang.DeleteNodeHandling(userId, objNodeNameToken.image);}
    throw new Error("Missing return statement in function");
  }

  static final public String DeleteConnection(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
    Token objConnNameToken = null;
    DeleteConnectionLang deleteConnectionlang = new DeleteConnectionLang(dataBroker, tenantManage);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      objConnNameToken = jj_consume_token(ID);
      break;
    case TEMPID:
      objConnNameToken = jj_consume_token(TEMPID);
      break;
    default:
      jj_la1[60] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
    {if (true) return deleteConnectionlang.DeleteConnectionHandling(userId, objConnNameToken.image);}
    throw new Error("Missing return statement in function");
  }

  static final public String DeleteFlow(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
    Token objFlowNameToken = null;
    DeleteFlowLang deleteFlowlang = new DeleteFlowLang(dataBroker, tenantManage);
    objFlowNameToken = jj_consume_token(ID);
    jj_consume_token(SEMICOLON);
    {if (true) return deleteFlowlang.DeleteFlowHandling(userId, objFlowNameToken.image);}
    throw new Error("Missing return statement in function");
  }

  static final public String DeleteOperation(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
    Token objOperationNameToken = null;
    DeleteOperationLang deleteOperationlang = new DeleteOperationLang(dataBroker, tenantManage);
    objOperationNameToken = jj_consume_token(ID);
    jj_consume_token(SEMICOLON);
    {if (true) return deleteOperationlang.DeleteOperationHandling(userId, objOperationNameToken.image);}
    throw new Error("Missing return statement in function");
  }

  static final public String DeleteTemplateInstance(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
    Token objTemplateInstanceNameToken = null;
    DeleteTemplateInstanceLang deleteTemplateInstancelang = new DeleteTemplateInstanceLang(dataBroker, tenantManage);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      objTemplateInstanceNameToken = jj_consume_token(ID);
      break;
    case TEMPID:
      objTemplateInstanceNameToken = jj_consume_token(TEMPID);
      break;
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
    {if (true) return deleteTemplateInstancelang.DeleteTemplateInstanceHandling(userId, objTemplateInstanceNameToken.image);}
    throw new Error("Missing return statement in function");
  }

  static final public String DeleteConnectionPoint(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
    Token objConnPointNameToken = null;
    DeleteConnectionPointLang deleteConnectionPointlang = new DeleteConnectionPointLang(dataBroker, tenantManage);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      objConnPointNameToken = jj_consume_token(ID);
      break;
    case TEMPID:
      objConnPointNameToken = jj_consume_token(TEMPID);
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return deleteConnectionPointlang.DeleteConnectionPointHandling(userId, objConnPointNameToken.image);}
    throw new Error("Missing return statement in function");
  }

  static final public String DeleteTemplateDefinition(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
    Token objTemplateDefinitionNameToken = null;
    DeleteTemplateDefinitionLang deleteTemplateDefinitionlang = new DeleteTemplateDefinitionLang(dataBroker, tenantManage);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      objTemplateDefinitionNameToken = jj_consume_token(ID);
      break;
    case TEMPID:
      objTemplateDefinitionNameToken = jj_consume_token(TEMPID);
      break;
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
    {if (true) return deleteTemplateDefinitionlang.DeleteTemplateDefinitionHandling(userId, objTemplateDefinitionNameToken.image);}
    throw new Error("Missing return statement in function");
  }

  static final public String Query(UserId userId, DataBroker dataBroker, TenantManage tenantManage) throws ParseException {
  String strReturn = null;
  Token objItemToken = null;
  Token objTargetToken = null;
  Query query = new Query(tenantManage);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TYPE:
      objItemToken = jj_consume_token(TYPE);
      break;
    case CONTAIN:
      objItemToken = jj_consume_token(CONTAIN);
      break;
    case PROPERTY:
      objItemToken = jj_consume_token(PROPERTY);
      break;
    case ENDNODES:
      objItemToken = jj_consume_token(ENDNODES);
      break;
    case MATCH:
      objItemToken = jj_consume_token(MATCH);
      break;
    case PRIORITY:
      objItemToken = jj_consume_token(PRIORITY);
      break;
    case TARGET:
      objItemToken = jj_consume_token(TARGET);
      break;
    case CONDITION:
      objItemToken = jj_consume_token(CONDITION);
      break;
    case ACTION:
      objItemToken = jj_consume_token(ACTION);
      break;
    case ID:
      objItemToken = jj_consume_token(ID);
      break;
    case NODES:
      objItemToken = jj_consume_token(NODES);
      break;
    case CONNECTIONS:
      objItemToken = jj_consume_token(CONNECTIONS);
      break;
    case FLOWS:
      objItemToken = jj_consume_token(FLOWS);
      break;
    case OPERATIONS:
      objItemToken = jj_consume_token(OPERATIONS);
      break;
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      objTargetToken = jj_consume_token(ID);
      break;
    default:
      jj_la1[65] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    if (objTargetToken == null)
    {
      String target = null;
      {if (true) return query.query(userId,objItemToken.image,target);}
    }
    else
    {
      {if (true) return query.query(userId,objItemToken.image,objTargetToken.image);}
    }
    throw new Error("Missing return statement in function");
  }

  static final public LinkedHashMap<String,String> conditionTarget() throws ParseException {
  Token objCondTarget = null;
  Token objRangeLeft = null;
  Token objRangeRight = null;
  LinkedHashMap<String,String> targetValue = new LinkedHashMap<String,String>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      objCondTarget = jj_consume_token(ID);
        targetValue.put(objCondTarget.image,"string");
      break;
    case TIMEVAL:
      objCondTarget = jj_consume_token(TIMEVAL);
        targetValue.put(objCondTarget.image,"string");
      break;
    case FULLTIME:
      objCondTarget = jj_consume_token(FULLTIME);
        targetValue.put(objCondTarget.image,"string");
      break;
    case UNUMBER:
      objCondTarget = jj_consume_token(UNUMBER);
        targetValue.put(objCondTarget.image,"integer");
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      objRangeLeft = jj_consume_token(UNUMBER);
      jj_consume_token(COMMA);
      objRangeRight = jj_consume_token(UNUMBER);
      jj_consume_token(RPAREN);
        targetValue.put(objRangeLeft.image+","+objRangeRight.image,"range");
      break;
    default:
      jj_la1[66] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return targetValue;}
    throw new Error("Missing return statement in function");
  }

  static final public LinkedHashMap<String,String> property() throws ParseException {
  Token objPropertyValueToken = null;
  Token objRangeLeft = null;
  Token objRangeRight = null;
  LinkedHashMap<String,String> propertyvalue= new LinkedHashMap<String,String>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
    case UNUMBER:
    case ID:
    case TEMPID:
    case IPV4PREF:
    case TIMEVAL:
    case FULLTIME:
    case ETHADDR:
    case IPV4ADDR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
      case TEMPID:
      case IPV4PREF:
      case TIMEVAL:
      case FULLTIME:
      case ETHADDR:
      case IPV4ADDR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
          objPropertyValueToken = jj_consume_token(ID);
      propertyvalue.put(objPropertyValueToken.image, "string");
          break;
        case ETHADDR:
          objPropertyValueToken = jj_consume_token(ETHADDR);
      propertyvalue.put(objPropertyValueToken.image, "string");
          break;
        case IPV4PREF:
          objPropertyValueToken = jj_consume_token(IPV4PREF);
      propertyvalue.put(objPropertyValueToken.image, "string");
          break;
        case IPV4ADDR:
          objPropertyValueToken = jj_consume_token(IPV4ADDR);
      propertyvalue.put(objPropertyValueToken.image, "string");
          break;
        case TIMEVAL:
          objPropertyValueToken = jj_consume_token(TIMEVAL);
      propertyvalue.put(objPropertyValueToken.image, "string");
          break;
        case FULLTIME:
          objPropertyValueToken = jj_consume_token(FULLTIME);
      propertyvalue.put(objPropertyValueToken.image, "string");
          break;
        case TEMPID:
          objPropertyValueToken = jj_consume_token(TEMPID);
      propertyvalue.put(objPropertyValueToken.image, "string");
          break;
        default:
          jj_la1[67] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      case UNUMBER:
        objPropertyValueToken = jj_consume_token(UNUMBER);
       propertyvalue.put(objPropertyValueToken.image, "integer");
        break;
      case LPAREN:
        jj_consume_token(LPAREN);
        objRangeLeft = jj_consume_token(UNUMBER);
        jj_consume_token(COMMA);
        objRangeRight = jj_consume_token(UNUMBER);
        jj_consume_token(RPAREN);
      propertyvalue.put(objRangeLeft.image+","+objRangeRight.image,"range");
        break;
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[69] = jj_gen;
      LinkedHashMap<String,String> multiProperty = nodeMultiProperty();
      for (String value : multiProperty.keySet())
      {
        propertyvalue.put(value, multiProperty.get(value));
      }
    }
  {if (true) return propertyvalue;}
    throw new Error("Missing return statement in function");
  }

  static final public LinkedHashMap<String,String> nodeMultiProperty() throws ParseException {
  Token objPropertyValueToken = null;
  Token objRangeLeft = null;
  Token objRangeRight = null;
  LinkedHashMap<String,String> propertyvalue= new LinkedHashMap<String,String>();
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      objPropertyValueToken = jj_consume_token(ID);
      propertyvalue.put(objPropertyValueToken.image, "string");
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[70] = jj_gen;
          break label_19;
        }
        jj_consume_token(COMMA);
        objPropertyValueToken = jj_consume_token(ID);
      propertyvalue.put(objPropertyValueToken.image, "string");
      }
      break;
    case TEMPID:
      objPropertyValueToken = jj_consume_token(TEMPID);
      propertyvalue.put(objPropertyValueToken.image, "string");
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[71] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        objPropertyValueToken = jj_consume_token(TEMPID);
      propertyvalue.put(objPropertyValueToken.image, "string");
      }
      break;
    case ETHADDR:
      objPropertyValueToken = jj_consume_token(ETHADDR);
      propertyvalue.put(objPropertyValueToken.image, "string");
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[72] = jj_gen;
          break label_21;
        }
        jj_consume_token(COMMA);
        objPropertyValueToken = jj_consume_token(ETHADDR);
      propertyvalue.put(objPropertyValueToken.image, "string");
      }
      break;
    case IPV4PREF:
      objPropertyValueToken = jj_consume_token(IPV4PREF);
      propertyvalue.put(objPropertyValueToken.image, "string");
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[73] = jj_gen;
          break label_22;
        }
        jj_consume_token(COMMA);
        objPropertyValueToken = jj_consume_token(IPV4PREF);
      propertyvalue.put(objPropertyValueToken.image, "string");
      }
      break;
    case IPV4ADDR:
      objPropertyValueToken = jj_consume_token(IPV4ADDR);
      propertyvalue.put(objPropertyValueToken.image, "string");
      label_23:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[74] = jj_gen;
          break label_23;
        }
        jj_consume_token(COMMA);
        objPropertyValueToken = jj_consume_token(IPV4ADDR);
      propertyvalue.put(objPropertyValueToken.image, "string");
      }
      break;
    case TIMEVAL:
      objPropertyValueToken = jj_consume_token(TIMEVAL);
      propertyvalue.put(objPropertyValueToken.image, "string");
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[75] = jj_gen;
          break label_24;
        }
        jj_consume_token(COMMA);
        objPropertyValueToken = jj_consume_token(TIMEVAL);
      propertyvalue.put(objPropertyValueToken.image, "string");
      }
      break;
    case FULLTIME:
      objPropertyValueToken = jj_consume_token(FULLTIME);
      propertyvalue.put(objPropertyValueToken.image, "string");
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[76] = jj_gen;
          break label_25;
        }
        jj_consume_token(COMMA);
        objPropertyValueToken = jj_consume_token(FULLTIME);
      propertyvalue.put(objPropertyValueToken.image, "string");
      }
      break;
    case UNUMBER:
      objPropertyValueToken = jj_consume_token(UNUMBER);
      propertyvalue.put(objPropertyValueToken.image, "integer");
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[77] = jj_gen;
          break label_26;
        }
        jj_consume_token(COMMA);
        objPropertyValueToken = jj_consume_token(UNUMBER);
      propertyvalue.put(objPropertyValueToken.image, "integer");
      }
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      objRangeLeft = jj_consume_token(UNUMBER);
      jj_consume_token(COMMA);
      objRangeRight = jj_consume_token(UNUMBER);
      jj_consume_token(RPAREN);
        propertyvalue.put(objRangeLeft.image+","+objRangeRight.image,"range");
      break;
    default:
      jj_la1[78] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACKET);
   {if (true) return propertyvalue;}
    throw new Error("Missing return statement in function");
  }

  static private boolean jj_initialized_once = false;
  /** Generated Token Manager. */
  static public NEMOparserTokenManager token_source;
  static SimpleCharStream jj_input_stream;
  /** Current token. */
  static public Token token;
  /** Next token. */
  static public Token jj_nt;
  static private int jj_ntk;
  static private int jj_gen;
  static final private int[] jj_la1 = new int[79];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0xe000000,0x1e000000,0x20000000,0x20000000,0x40,0x80000000,0x40,0x0,0x0,0x40,0x0,0x0,0x40,0x0,0x40,0x40,0x0,0x4000,0x1f8000,0x7000,0x7000,0x1f8000,0x0,0x20,0x40,0x20,0x0,0x0,0x40,0x0,0x0,0x0,0x20000000,0x20000000,0x40,0x80000000,0x40,0x0,0x0,0x40,0x0,0x0,0x40,0x0,0x40,0x40,0x0,0x4000,0x1f8000,0x7000,0x7000,0x1f8000,0x0,0x20,0x40,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x0,0x100,0x0,0x100,0x100,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x100,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x400,0x200052,0x60005a,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x4,0x0,0x1,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x200,0x7000000,0x0,0x7000000,0x1,0x1000,0x5a,0x5a,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x4,0x0,0x1,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x200,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x1e23a5,0x800,0x80000000,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x3,0x3,0x3,0x3,0x3,0x1,0x0,0x61,0x1eb,0x1eb,0x1eb,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1eb,};
   }

  /** Constructor with InputStream. */
  public NEMOparser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public NEMOparser(java.io.InputStream stream, String encoding) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  ");
      System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new NEMOparserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 79; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  static public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  static public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 79; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public NEMOparser(java.io.Reader stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser. ");
      System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new NEMOparserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 79; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  static public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 79; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public NEMOparser(NEMOparserTokenManager tm) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser. ");
      System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 79; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(NEMOparserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 79; i++) jj_la1[i] = -1;
  }

  static private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  static final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  static final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  static private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  static private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  static private int[] jj_expentry;
  static private int jj_kind = -1;

  /** Generate ParseException. */
  static public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[87];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 79; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 87; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  static final public void enable_tracing() {
  }

  /** Disable tracing. */
  static final public void disable_tracing() {
  }

}
