/*
 * Copyright (c) 2015 Huawei, Inc. and others. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
package org.opendaylight.nemo.user.processingmanager;

import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.nemo.user.tenantmanager.AAA;
import org.opendaylight.nemo.user.tenantmanager.TenantManage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.nemo.common.rev151010.*;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.nemo.intent.rev151010.CreateVnfdInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.nemo.intent.rev151010.user.intent.objects.Connection;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.nemo.intent.rev151010.user.intent.objects.ConnectionPoint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.nemo.intent.rev151010.user.intent.objects.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.nemo.intent.rev151010.user.intent.template.definitions.TemplateDefinition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.nemo.intent.rev151010.user.intent.template.instances.TemplateInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.nemo.object.rev151010.node.instance.Property;

import java.io.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;


/**
 * Created by ebg on 2017/06/14.
 */
public class VNFDGenericManager {
    private final TenantManage tenantManage;
    private final VNFDOperations vnfdOperations;

    public VNFDGenericManager(DataBroker dataBroker, TenantManage tenantManage) {
        this.tenantManage = tenantManage;
        vnfdOperations = new VNFDOperations();
    }
    /**questa funzione non rispetta tutti i canoni di programmazione di nemo, infatti vado ad eliminare l'oggetto VNFDOperation
     * che mi rimuove una certa flessibilità in termini di modifica, ma questo non interessa appunto perchè mostro
     * come può essere esteso il framework inserendo nuovi manager. Docker non è un sistema di vNSF come ad esempio
     * Kubernetes che possiede un orchestratore e vede cluster di macchine fisiche come un unica risorsa.
     * il goal qui è generare una configurazione che mi permetta di costruire una istanziazione automatica di un container docker
     * in modo da poterlo caricare sul sistema che più mi interessa*/
    public String generateVNFD(AAA aaa, CreateVnfdInput createVnfdInput) throws IOException {
        String erroInfo = null;
        TemplateInstanceName instance = null;
        String results_path = null;
        String type = null;
        boolean defaultConf = false; //questo parametro mi serve a capire se esistono dei valori di default per inizializzare il mio file di configurazione generico
        Map<NodeId, Node> nodeMap = new HashMap<NodeId, Node>();
        Map<NodeId, Node> nodeDSMap = new HashMap<NodeId, Node>();
        Map<ConnectionId, Connection> connectionMap = new HashMap<ConnectionId, Connection>();
        Map<ConnectionId, Connection> connectionDSMap = new HashMap<ConnectionId, Connection>();
        Map<TemplateName, TemplateDefinition> templateDefinitionMap = new HashMap<TemplateName, TemplateDefinition>();
        Map<TemplateName, TemplateDefinition> templateDefinitionDSMap = new HashMap<TemplateName, TemplateDefinition>();
        Map<TemplateInstanceId, TemplateInstance> templateInstanceMap = new HashMap<TemplateInstanceId, TemplateInstance>();
        Map<TemplateInstanceName, TemplateInstance> templateInstanceNameMap = new HashMap<TemplateInstanceName, TemplateInstance>();
        Map<TemplateInstanceName, TemplateInstance> templateInstanceNameDSMap = new HashMap<TemplateInstanceName, TemplateInstance>();
        Map<TemplateInstanceId, TemplateInstance> templateInstanceDSMap = new HashMap<TemplateInstanceId, TemplateInstance>();
        Map<ConnectionPointId, ConnectionPoint> connectionPointMap = new HashMap<ConnectionPointId, ConnectionPoint>();
        Map<ConnectionPointId, ConnectionPoint> connectionPointDSMap = new HashMap<ConnectionPointId, ConnectionPoint>();
        Map<String, String> property = new HashMap<>();

        /*vado a controllare se l'uid dell'utente esiste veramente ed è già registrato
         * se lo è mi conservo le sue info altrimenti errore*/
        erroInfo = aaa.checkUser(createVnfdInput.getUserId());

        if (erroInfo != null) {
            return erroInfo;
        } else {

            /*mi prendo il tipo di stile*/
            instance = createVnfdInput.getInstanceName(); //prendo il nome dell'istanza del nodo da eseguire
            results_path = createVnfdInput.getResultsPath(); //prendo il path dove salvare le informazioni finali
            if(results_path==null){
                erroInfo = "Error specify destination folder to save configuration" ;
                return erroInfo;
            }
            /*alcune cose non sono necessarie quindi le lascio ma potrebbero benissimo essere eliminate*/
            //quando mi tiro le istanze dei nodi sottostanti a quello principale, quindi i sottonodi vengono messe qui insieme alle proprietà
            if (tenantManage.getNode(createVnfdInput.getUserId()) != null) {
                nodeMap = tenantManage.getNode(createVnfdInput.getUserId());
            }

            if (tenantManage.getConnection(createVnfdInput.getUserId()) != null) {
                connectionMap = tenantManage.getConnection(createVnfdInput.getUserId());
            }

            if (tenantManage.getConnectionPoint(createVnfdInput.getUserId()) != null) {
                connectionPointMap = tenantManage.getConnectionPoint(createVnfdInput.getUserId());
            }
            /*--------------------------------------------------------------------------------------------------------------*/
            //questo è l'unica cosa che mi serve
            if (tenantManage.getTempalteDefinition(createVnfdInput.getUserId()) != null) {
                templateDefinitionMap = tenantManage.getTempalteDefinition(createVnfdInput.getUserId());
            }

            if (tenantManage.getTemplateInstance(createVnfdInput.getUserId()) != null) {
                templateInstanceMap = tenantManage.getTemplateInstance(createVnfdInput.getUserId());
                //qui ci dovrebbe essere il template con le sue proprietà bisogna provare a prendere le proprietà da qui
                for(TemplateInstanceId key: templateInstanceMap.keySet()){
                    //System.out.println(key.getValue());
                    //System.out.println(templateInstanceMap.get(key).toString());
                }
            }

            if (tenantManage.getUserTemplateInstanceName(createVnfdInput.getUserId()) != null) {
                templateInstanceNameMap = tenantManage.getUserTemplateInstanceName(createVnfdInput.getUserId());
            }
            //------------------------------------------------------------------------------------------
            if (tenantManage.getNodeDataStore(createVnfdInput.getUserId()) != null) {
                nodeDSMap = tenantManage.getNodeDataStore(createVnfdInput.getUserId());
            }
            //entra in questo if la prima volta e tira fuori i due valori di connection point settati nello schema
            if (tenantManage.getConnectionDataStore(createVnfdInput.getUserId()) != null) {
                connectionDSMap = tenantManage.getConnectionDataStore(createVnfdInput.getUserId());
            }
            //entra anche qua dentro e tira fuori il tipo di template definito in precedenza tramite intenti
            //nel nostro caso di utilizzo tira lo schema "waflvl1"
            if (tenantManage.getConnectionPointDataStore(createVnfdInput.getUserId()) != null) {
                connectionPointDSMap = tenantManage.getConnectionPointDataStore(createVnfdInput.getUserId());
            }
            //qui invece preleva tutti i template salvati per l'utente selezionato
            if (tenantManage.getDefinitionDataStore(createVnfdInput.getUserId()) != null) {
                templateDefinitionDSMap = tenantManage.getDefinitionDataStore(createVnfdInput.getUserId());
            }
            //anche qui possiamo trovare delle informazioni relative all'istanza virtuale del oggetto creato.
            if (tenantManage.getInstanceDataStore(createVnfdInput.getUserId()) != null) {
                templateInstanceDSMap = tenantManage.getInstanceDataStore(createVnfdInput.getUserId());
            }

            if (tenantManage.getInstanceNameDataStore(createVnfdInput.getUserId()) != null) {
                templateInstanceNameDSMap = tenantManage.getInstanceNameDataStore(createVnfdInput.getUserId());
            }

            //System.out.println(nodeDSMap + "\n" + connectionDSMap + "\n" + connectionPointDSMap + "\n" + templateDefinitionDSMap + "\n" + templateInstanceDSMap + "\nTenant manage \n" + nodeMap + "\n" + connectionMap + "\n" + connectionPointMap + "\n" + templateDefinitionMap + "\n" + templateInstanceMap);
            vnfdOperations.clear_vnfdOperations();

            String templateDefinitionName = null;
            Node templateInstance=null;
            String nodeType = "";
            for (Node nod: nodeMap.values()){
                if(nod.getNodeName().getValue().equals(instance.getValue())){
                    templateInstance  = nod;
                    nodeType = nod.getNodeType().getValue();
                }
            }
            Node templateInstanceDS=null;
            for (Node nod: nodeDSMap.values()){
                if(nod.getNodeName().getValue().equals(instance.getValue())){
                    templateInstanceDS  = nod;
                    nodeType = nod.getNodeType().getValue();
                }
            }

            //il codice seguente mi serve per identificare i template generici che nemo non vede come nodi standard ma caricati da un utente admin
             //templateInstanceNameMap.get(instance); //qua mi dovrei prendere l'istanza del nodo creato
            // TemplateInstance templateInstanceDS = templateInstanceNameDSMap.get(instance); //mi prendo l'istanza creata del template definito in questo caso demo waflvl1

            //riesco a prendermi i parametri della vNSF istanziata in virtuale, ne vado a leggere le proprietà configurate
            /*if (templateInstance != null) {
                templateDefinitionName = templateInstance.getTemplateName().getValue();
                for(TemplateParameter par: templateInstance.getTemplateParameter()){
                    String key = par.getKey().getParameterName().getValue();
                    for(StringValue v: par.getParameterValues().getStringValue()) {
                        property.put(key, v.getValue());
                        System.out.println(templateInstance.getTemplateInstanceName().getValue()+templateInstance.getKey()+key + " ----- " + v.getValue()); //stampo parametro e valore, sopra mi costruisco una MAP che mi servirà poi per creare l'istanza
                    }
                }
            } else if (templateInstanceDS != null) {
                templateDefinitionName = templateInstanceDS.getTemplateName().getValue();
                for(TemplateParameter par: templateInstanceDS.getTemplateParameter()){
                    String key = par.getKey().getParameterName().getValue();
                    for(StringValue v: par.getParameterValues().getStringValue()) {
                        property.put(key, v.getValue());
                        System.out.println(templateInstanceDS.getTemplateInstanceName().getValue()+templateInstanceDS.getKey()+key +" ----- " + v.getValue());
                    }
                }

            } else {
                erroInfo = "The instance name has not been defined";
                return erroInfo;
            }*/
            if (templateInstance != null) {
                templateDefinitionName = templateInstance.getNodeName().getValue();
                for(Property par: templateInstance.getProperty()){
                    //System.out.println(templateInstance.getNodeType().getValue()+" property "+
                           // par.getPropertyName().getValue()+" have value ");
                    if(par.getPropertyValues().getIntValue()==null
                            && par.getPropertyValues().getStringValue()!=null
                            && par.getPropertyValues().getRangeValue()==null){
                        property.put(par.getPropertyName().getValue(), String.valueOf(par.getPropertyValues().getStringValue().get(0).getValue()));
                        //System.out.println(par.getPropertyValues().getStringValue().get(0).getValue());
                    }else if (par.getPropertyValues().getIntValue()!=null
                            && par.getPropertyValues().getStringValue()==null
                            && par.getPropertyValues().getRangeValue()==null){
                        property.put(par.getPropertyName().getValue(), String.valueOf(par.getPropertyValues().getIntValue().get(0).getValue()));
                       // System.out.println(par.getPropertyValues().getIntValue().get(0).getValue());
                    }else if(par.getPropertyValues().getIntValue()==null
                            && par.getPropertyValues().getStringValue()==null
                            && par.getPropertyValues().getRangeValue()!=null){
                        property.put(par.getPropertyName().getValue(),
                                par.getPropertyValues().getRangeValue().getMin() + "-" + par.getPropertyValues().getRangeValue().getMax());
                       // System.out.print(par.getPropertyValues().getRangeValue().getMin() + "-" + par.getPropertyValues().getRangeValue().getMax());
                    }
                }
            } else if (templateInstanceDS != null) {
                templateDefinitionName = templateInstanceDS.getNodeName().getValue();
                for(Property par: templateInstanceDS.getProperty()){
                    //< >
                   // System.out.print(templateInstanceDS.getNodeType().getValue()+" property "+
                         //   par.getPropertyName().getValue()+" have value ");
                    if(par.getPropertyValues().getIntValue()==null
                            && par.getPropertyValues().getStringValue()!=null
                            && par.getPropertyValues().getRangeValue()==null){
                        property.put(par.getPropertyName().getValue(), String.valueOf(par.getPropertyValues().getStringValue().get(0).getValue()));
                      //  System.out.println(par.getPropertyValues().getStringValue().get(0).getValue());
                    }else if (par.getPropertyValues().getIntValue()!=null
                            && par.getPropertyValues().getStringValue()==null
                            && par.getPropertyValues().getRangeValue()==null){
                        property.put(par.getPropertyName().getValue(), String.valueOf(par.getPropertyValues().getIntValue().get(0).getValue()));
                       // System.out.println(par.getPropertyValues().getIntValue().get(0).getValue());
                    }else if(par.getPropertyValues().getIntValue()==null
                            && par.getPropertyValues().getStringValue()==null
                            && par.getPropertyValues().getRangeValue()!=null){
                        property.put(par.getPropertyName().getValue(),
                                par.getPropertyValues().getRangeValue().getMin() + "-" + par.getPropertyValues().getRangeValue().getMax());
                       // System.out.print(par.getPropertyValues().getRangeValue().getMin() + "-" + par.getPropertyValues().getRangeValue().getMax());
                    }
                }

            } else {
                erroInfo = "The instance name has not been defined";
                return erroInfo;
            }
            //-------------------------------------------------------------------------------------
            //adesso mi prendo la vnsf uri, lo devo fare due volte perchè ci sono diverse fasi di salvataggio delle info
            Map<String, String> nodeVnfUriMap = new HashMap<String, String>();
            if (templateDefinitionMap.containsKey(new TemplateName(templateDefinitionName))) {
                String vnfuri = null;
                vnfuri = templateDefinitionMap.get(new TemplateName(templateDefinitionName)).getVnfUriValue();
               // System.out.println(instance.getValue()+"---"+vnfuri);
                if (vnfuri != null) {
                    nodeVnfUriMap.put(instance.getValue(), vnfuri);
                }
            }else if (templateDefinitionDSMap.containsKey(new TemplateName(templateDefinitionName))) {
                String vnfuri = null;
                vnfuri = templateDefinitionDSMap.get(new TemplateName(templateDefinitionName)).getVnfUriValue();
               // System.out.println(instance.getValue()+"---"+vnfuri);
                if (vnfuri != null) {
                    nodeVnfUriMap.put(instance.getValue(), vnfuri);
                }
            }


            /**vado quindi a costruire la configurazione in base alle proprietà precedentemente settate, come il container.
             * quindi faccio una serie di if dove vado a valutare se ci sono i parametri che mi servono ed eventualmente
             * a modificare i "-" con il simbolo che più si addice al parametro, perchè il parser di nemo segna i ":" i ";"
             * lo "/" come caratteri speciali che non possono essere inseriti come stringa.
             * Definisco quindi una serie di property standard che vanno a creare una generica istanza docker, posso inserire
             * anche delle proprietà exstra ma queste devono essere previste nell'istanziazione concreta del container, quindi
             * se si vogliono estendere opzioni e funzionalità bisogna nuovamente modificare nemo, in particolare questo manager.*/
            //result path deve essere una cartella precisa
            String command = "Service_Name=" + instance.getValue() + "\n";
            command = command + "type=" + nodeType+ "\n";
            String newFileName = results_path+File.separator+templateInstance.getNodeType().getValue()+"-GenericConf.txt";
            File file = null;
            try{
                file = new File(newFileName);
            }catch(Exception e){
                file = new File(results_path+File.separator+templateInstanceDS.getNodeType().getValue()+"-GenericConf.txt");
            }
            FileWriter fw = null;
            try{
                if(file.createNewFile())  System.out.println("New Configuration File created: " + file.getName());
                fw = new FileWriter(file);
            }catch (IOException e){
                erroInfo = "It's impossible create a new configuration file, insert a valid path folder";
                return erroInfo;
            }


            String fileconf = nodeVnfUriMap.get(instance.getValue()); //questo dovrebbe essere il file dove è inserita la configurazione del nodo
            //se il file di configurazione è presente allora lo apro con tranquillità e setto un valore booleano per ricordarmi che esiste
            File fileTemplate = null;
            if(fileconf != null) {

                try {
                    fileconf = fileconf.replaceAll("file://","");
                    fileTemplate = new File(fileconf);  //qua apro il file di configurazione e in teoria dovrei leggerlo
                    defaultConf = true;
                }catch(Exception e){
                    erroInfo = "Impossible read file Template configuration. Update model and use new file template.";
                    return erroInfo;
                }
            }
            else defaultConf = false;
            //vado a verificare se il tipo di nodo che sto considerando è un nodo noto, se lo è agisco di conseguenza e vado a
            //verificare se gli attributi rispecchiano il valore corretto.
            if(templateInstance.getNodeType().getValue().equals("waf") || templateInstanceDS.getNodeType().getValue().equals("waf")){
                //guardo nelle property quello che mi interessa dal punto di vista dei nomi delle proprietà per elaborare correttamente
                //la creazione del file generico.
                Map<String, String> protectionValue = new HashMap<>();
                protectionValue.put("xss","xss_protection");
                protectionValue.put("sql","sql_protection");
                protectionValue.put("dos","dos_protection");
                protectionValue.put("php","php_protection");
                protectionValue.put("java","java_protection");
                protectionValue.put("rce","rce_protection");
                protectionValue.put("ip","ip_reputation_control");
                protectionValue.put("shell","shell_protection");
                protectionValue.put("bot","bot_protection");
                protectionValue.put("crawler","crawler_protection");
                protectionValue.put("scanner","scanner_protection");
                for(String key : property.keySet()){
                    switch (key){
                        case "block_bad_user_agent":
                            String tmpListUA = property.get("block_bad_user_agent");
                            String[] listUA = tmpListUA.split("-"); //ora devo andare a vedere che sta scritto
                            for (String val : listUA){
                                if(protectionValue.containsKey(val)){
                                    command = command + protectionValue.get(val) +"=active\n";
                                }else{
                                    erroInfo= "Syntax error, the only value that can be accepted is 'bot,crawler,scanner', separeted by '-', for the attribute "+key+". Update attribute node.";
                                    return erroInfo;
                                }
                            }
                            break;
                        case "active_protection_attack":
                            String tmpList = property.get("active_protection_attack");
                            String[] list = tmpList.split("-"); //ora devo andare a vedere che sta scritto
                            for (String val : list){
                                if(protectionValue.containsKey(val)){
                                    command = command + protectionValue.get(val) +"=active\n";
                                }else{
                                    erroInfo= "Syntax error, the only value that can be accepted is 'xss,sql,dos,php,java,rce,ip,shell', separeted by '-', for the attribute "+key+". Update attribute node.";
                                    return erroInfo;
                                }
                            }
                            break;
                        case "log":
                            //se qua è diverso da active dare errore e suggerire di inserire active nella richiesta
                            if(!property.get(key).equalsIgnoreCase("active")){
                                erroInfo= "Syntax error, the only value that can be accepted is 'active' for the attribute "+key+". Update attribute node.";
                                return erroInfo;
                            }else{
                                command = command + key +"="+ property.get(key) + "\n";
                            }
                            break;
                        case "alert_level":
                            String tmp = property.get(key).toLowerCase(Locale.ROOT);
                            if(tmp.contains("low")
                            || tmp.contains("medium")
                            || tmp.contains("none")
                            || tmp.contains("higth")
                            || tmp.contains("extreme")){
                                command = command + key +"="+ property.get(key) + "\n";
                            }else{
                                erroInfo= "Syntax error, the only value that can be accepted is 'none','low','medium', 'higth' and 'extreme' for the attribute "+key+". Update attribute node.";
                                return erroInfo;
                            }
                            break;
                        default:
                            command = command + key +"="+ property.get(key) + "\n";
                            break;
                    }

                }
            }else{
                for(String key : property.keySet()){
                    command = command + key +"="+ property.get(key) + "\n";
                }
            }

            if(fw != null) {
                fw.write(command);
                fw.flush();
                fw.close();
            }else{
                erroInfo = "File configuration error write, retry.";
                return erroInfo;
            }
        }
            return erroInfo;
    }
}
