#!/usr/bin/python3
import time
import shutil
import re
import jinja2
import paramiko
import os
import time
import requests,json
import argparse, sys
from requests.auth import HTTPBasicAuth


USERNAME = 'admin'
PASSWORD = 'admin'
USER_ID = 'af4fc2be-e3f4-4388-a8ef-3aabae872f2a'

API = '/restconf/operations/nemo-intent:'
controller = ""
port = ""

TRANSACTION_BEGIN = 'begin-transaction'
TRANSACTION_END = 'end-transaction'
REGISTER_USER = 'register-user'
LANGUAGE_INTENT = 'language-style-nemo-request'
GENERATE_YAML = 'create-vnfd'      


def register_admin():
    data={
        "input":{
            "user-id": USER_ID,
            "user-name": USERNAME,
            "user-password": PASSWORD,
            "user-role": "admin"
        }
    }
    post(REGISTER_USER, data)

def transaction_begin_admin():
    data={
        "input":{
            "user-id": USER_ID                                
        }
    }
    post(TRANSACTION_BEGIN, data)
        
def transaction_end_admin():
    data={
        "input":{
            "user-id": USER_ID                                
        }
    }
    post(TRANSACTION_END, data)
        
def register_template_definition(intent):
    data={
        "input":{
            "user-id": USER_ID,
            "nemo-statement": intent
        }
    }
    post(LANGUAGE_INTENT, data)
        
        
def create_yaml(instance, path, style):
    data={
        "input":{
            "user-id": USER_ID,
            "instance-name": instance,
            "results-path": path,
            "vnfd-style": style                      
        }
    }
    post(GENERATE_YAML, data)

def post(endpoint, data):
    headers = { 'Content-type': 'application/yang.data+json',
                'Accept': 'application/yang.data+json'}
    print("POST %s", get_url(endpoint))
    print(json.dumps(data, indent=4, sort_keys=True))
    start_time_partiall = time.time()
    r = requests.post(get_url(endpoint), data=json.dumps(data), headers=headers, auth=HTTPBasicAuth(USERNAME, PASSWORD))
    print("--- %s seconds --- " % (time.time() - start_time_partiall))
    print(r.text)
    r.raise_for_status()

def get_url(endpoint):
    return 'http://' + controller + ':' + port + API + endpoint
    
        
if __name__ == '__main__':

    path_result_default=os.getcwd()
    parser = argparse.ArgumentParser()
    parser.add_argument('--intent', dest='intent', help='Path of your intent', required=True)
    parser.add_argument('--instance', dest='instance', help='Instance\'s name from which you want to generate the VNFD, Nan if you do not create the istance', required=True)
    parser.add_argument('--style', dest='style', choices={'osm', 'openmano','generic'}, help='Choose VNFD style between osm, openmano and docker', required=True)
    parser.add_argument('--path', dest='path', default=path_result_default, help='Destination path where the VNF Descriptor will be saved')
    parser.add_argument('--controller', dest='controller', default='127.0.0.1', help='Controller IP')
    parser.add_argument('--port', dest='port', default='8181', help='Controller port')
    args=parser.parse_args()
    
    #mi servono per capire se ho inviato istruzioni di update o delete
    delete = False
    update = False
    #-----------------------------------------------------------------

    controller = args.controller
    port = args.port

    try:
        register_admin()
    except Exception:
        sys.exit('Register Admin ERROR')

    try:
        transaction_begin_admin()
    except Exception:
        sys.exit('Transaction Begin ERROR')

    start_time = time.time()
    try:
        f = open(args.intent, 'r')
        for line in f:
            if(line != "\n"):
                register_template_definition(line.split("\n")[0])
                #qua mi serve vedere se è presente nella linea Update or Delete, così da poter intercettare le intenzioni cancellare le istanze vecchie e inserire le nuove
                if line.find("UPDATE") != -1:
                    #la stringa è presente mi segno il risultato
                    update = True
                    print("segno un update")
                if line.find("DELETE") != -1:
                    #la stringa è presente mi segno il risultato
                    delete = True
                    print("segno una cancellazione", delete)
    except IOError: 
        transaction_end_admin()
        sys.exit("The path introduced: " + args.intent + " is incorrect")
    
    if args.instance == "Nan":
        sys.exit("non c'è bisogno di effettuare altre operazioni, dal momento che non si sta avviando l'interazione con il provider")

    try:
    	if delete != True:
            create_yaml(args.instance, args.path, args.style)
        #print("salto questa parte che non mi serve per adesso")
    except NameError: 
        transaction_end_admin()
        sys.exit("The instance's name: " + args.instance + " is not valid")
    
    transaction_end_admin()    
    
    #eseguo la cancellazione per l'update e il delete, se è delete fermo l'esecuzione
#------------------------ esamino le operazioni da svolgere ------------------------------------------------------------------------------------
    if update == True or delete == True:
        print("procedo alla cancellazione del componente")
        start_time_cancellazione = time.time()
        client = paramiko.SSHClient()
        client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
        client.connect(hostname='192.168.1.14', username='poppo', password='')

        configCommand = 'minikube kubectl -- delete configmap '+ args.instance +'configmap'
        stdin, stdout, stderr = client.exec_command(configCommand)
        print(stdout.read().decode())
        
        configCommand = 'minikube kubectl -- delete service '+ args.instance +'service'
        stdin, stdout, stderr = client.exec_command(configCommand)
        print(stdout.read().decode())

        configCommand = 'minikube kubectl -- delete pod '+ args.instance
        stdin, stdout, stderr = client.exec_command(configCommand)
        print(stdout.read().decode())

        client.close()
        print("--- %s seconds --- cancellazione del waf" % (time.time() - start_time_cancellazione))
        #se devo eseguire solo una delete devo fermarmi e non andare avanti
        if delete == True:
            sys.exit("esco dal sistema")

    print("procedo con il modulo di traduzione del file")
#-------------------------------- modulo di traduzione ---------------------------------------------------------
    start_time_traduzione = time.time()
    paranoia = { "none": 0, "low": 2, "medium": 3, "higth": 4, "extreme": 5}
    pathNameConfigMap = []
    fileNameConfigMapThreat = []   #mi serve a salvare i nomi dei file di configurazione    
    fileNameConfigMapMSec = []   #mi serve a salvare i nomi dei file di configurazione        
    nodeName = ""                #coincide con il nome del servizio che voglio esporre
    port = ""                    #coincide con la porta di comunicazione del servizio
    applicationName = ""         #coincide con l'applicazione a cui voglio fare da wrapper se necessario
    alert_level= ""              #coincide con delle fasce di allerta che mi servono a configurare le regole per mod security


    genericConfFileName = os.path.join(os.path.dirname(__file__),'waf-GenericConf.txt')
    fileConfOpen = open(genericConfFileName,"r")
    lines = fileConfOpen.readlines()
    fileConfOpen.close()
    rules = {}
    for line in lines:
        op = line.split('=')
        rules[op[0]] = op[1].replace('\n','')

    if 'type' in rules:
        if rules['type'] == 'waf':
            # se sto esaminando un waf allora eseguo tutte le operazioni per istanziarlo dentro k8s.
            # svolgo quindi le operazioni di traduzione che possono essere piu' o meno complesse, in questo caso mi limito a prendere una configurazione standard e 
            # a modificare template
            
            #block_country_traffic se e' presente questo campo vado a definire un nuovo default nella cartella conf
            #questo tramite template, altrimenti copio quello normale, cioe' quello senza geoip, dalla cartella confd in conf
            if 'block_country_traffic' in rules:
                if len(rules['block_country_traffic']) == 2:
                    path=os.path.join(os.path.dirname(__file__),'templates')
                    templateLoader = jinja2.FileSystemLoader(searchpath=path)
                    templateEnv = jinja2.Environment(loader=templateLoader)
                    TEMPLATE_FILE = "default.txt"
                    data= {
                        "paese": rules['block_country_traffic'].upper()
                    }
                    template = templateEnv.get_template(TEMPLATE_FILE)
                    outputText = template.render(data)  # qua e' dove inserisco i dati per riempire il template, faccio il render
                    # non mi resta che creare un file del template preimpostato
                    mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','conf','default.conf')
                    templateFile = open(mypath,'w')
                    templateFile.write(outputText)
                    templateFile.flush()
                    templateFile.close()
                else:
                    #errore bisogna caricare il default senza template
                    mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','confd','default.conf')
                    dest = os.path.join(os.path.dirname(__file__),'mod_sec_conf','conf','default.conf')
                    shutil.copy(mypath,dest)
            else:
                mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','confd','default.conf')
                dest = os.path.join(os.path.dirname(__file__),'mod_sec_conf','conf','default.conf')
                shutil.copy(mypath,dest)

            if 'block_domain_name' in rules:
                path=os.path.join(os.path.dirname(__file__),'templates')
                templateLoader = jinja2.FileSystemLoader(searchpath=path)
                templateEnv = jinja2.Environment(loader=templateLoader)
                TEMPLATE_FILE = "fqdn.txt"
                data= {
                    "fqdn": rules['block_domain_name']
                }
                template = templateEnv.get_template(TEMPLATE_FILE)
                outputText = template.render(data)  # qua e' dove inserisco i dati per riempire il template, faccio il render
                # non mi resta che creare un file del template preimpostato
                mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','default','fqdn.conf')
                templateFile = open(mypath,'w')
                templateFile.write(outputText)
                templateFile.flush()
                templateFile.close()
            else:
                mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','default','fqdn.conf')
                if os.path.exists(mypath):
                    os.remove(mypath)

            #parto con l'analisi degli user agent malevoli inserendo le liste di default se richieste
            if 'bot_protection' in rules:
                mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','bot','scripting-user-agents.data')
                dest = os.path.join(os.path.dirname(__file__),'mod_sec_conf','default','scripting-user-agents.data')
                shutil.copy(mypath,dest)
            else:
                mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','default','scripting-user-agents.data')
                templateFile = open(mypath,'w')
                templateFile.write("nan")
                templateFile.flush()
                templateFile.close()
            
            if 'crawler_protection' in rules:
                mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','crawler','crawlers-user-agents.data')
                dest = os.path.join(os.path.dirname(__file__),'mod_sec_conf','default','crawlers-user-agents.data')
                shutil.copy(mypath,dest)
            else:
                mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','default','crawlers-user-agents.data')
                templateFile = open(mypath,'w')
                templateFile.write("nan")
                templateFile.flush()
                templateFile.close()
            
            if 'scanner_protection' in rules:
                mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','scanner','scanners-user-agents.data')
                dest = os.path.join(os.path.dirname(__file__),'mod_sec_conf','default','scanners-user-agents.data')
                shutil.copy(mypath,dest)
            else:
                mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','default','scanners-user-agents.data')
                templateFile = open(mypath,'w')
                templateFile.write("nan")
                templateFile.flush()
                templateFile.close()

            # a questo punto le cartelle sono correttamente riempite, l'unica cosa che mi resta da  fare e' prelevare le giuste configurazioni ed inviarle, 
            # parto dalla cartella di default:

            mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','default')
            pathNameConfigMap.append(mypath)
            for (_, _, filenames) in os.walk(mypath):
                fileNameConfigMapThreat.extend(filenames)

            if 'xss_protection' in rules:
                if rules['xss_protection'] == 'active':
                    mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','xss')
                    pathNameConfigMap.append(mypath)
                    for (_, _, filenames) in os.walk(mypath):
                        fileNameConfigMapThreat.extend(filenames)

            if 'sql_protection' in rules:
                if rules['sql_protection'] == 'active':
                    mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','sql')
                    pathNameConfigMap.append(mypath)
                    for (_, _, filenames) in os.walk(mypath):
                        fileNameConfigMapThreat.extend(filenames)

            if 'dos_protection' in rules:
                if rules['dos_protection'] == 'active':
                    mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','dos')
                    pathNameConfigMap.append(mypath)
                    for (_, _, filenames) in os.walk(mypath):
                        fileNameConfigMapThreat.extend(filenames)

            if 'php_protection' in rules:
                if rules['php_protection'] == 'active':
                    mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','php')
                    pathNameConfigMap.append(mypath)
                    for (_, _, filenames) in os.walk(mypath):
                        fileNameConfigMapThreat.extend(filenames)

            if 'shell_protection' in rules:
                if rules['shell_protection'] == 'active':
                    mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','shell')
                    pathNameConfigMap.append(mypath)
                    for (_, _, filenames) in os.walk(mypath):
                        fileNameConfigMapThreat.extend(filenames)


            if 'java_protection' in rules:
                if rules['java_protection'] == 'active':
                    mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','java')
                    pathNameConfigMap.append(mypath)
                    for (_, _, filenames) in os.walk(mypath):
                        fileNameConfigMapThreat.extend(filenames)    

            if 'ip_reputation_control' in rules:
                if rules['ip_reputation_control'] == 'active':
                    mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','ip')
                    pathNameConfigMap.append(mypath)
                    for (_, _, filenames) in os.walk(mypath):
                        fileNameConfigMapThreat.extend(filenames) 
               
            mypath = os.path.join(os.path.dirname(__file__),'mod_sec_conf','conf')
            pathNameConfigMap.append(mypath)
            

            for (dirpath, dirnames, filenames) in os.walk(mypath):
                fileNameConfigMapMSec.extend(filenames)

            #print(fileNameConfigMapThreat)
            #print(pathNameConfigMap)
            path=os.path.join(os.path.dirname(__file__),'templates')
            templateLoader = jinja2.FileSystemLoader(searchpath=path)
            templateEnv = jinja2.Environment(loader=templateLoader)
            TEMPLATE_FILE = "k8s-waf.txt"
            #io ho già un template valido che devo riempire in base ai file di configurazione noti che ho.
            #devo essere in grado di prendere le info-
            data= {
                "nodeName": rules['Service_Name'],
                "port": rules['service_port'],
                "applicationName": rules['application_to_protect'],
                "alert_level": paranoia[rules['alert_level']],
                "fileNameThreatProtection": fileNameConfigMapThreat,
                "fileNameConf": fileNameConfigMapMSec,
                "configMapName": rules['Service_Name']+'configmap'
            }
            template = templateEnv.get_template(TEMPLATE_FILE)
            outputText = template.render(data)  # this is where to put args to the template renderer
            # non mi resta che creare un file del template preimpostato

            templateFile = open('config'+rules['Service_Name']+'.yaml','w')
            templateFile.write(outputText)
            templateFile.flush()
            templateFile.close()
            print("--- %s seconds --- Fine modulo di traduzione" % (time.time() - start_time))
    #---------------------------------------------- inizia il modulo di caricamento, eseguo connessioni ssh --------------------------------------
            print("procedo con l'inserimento in k8s")
            start_time_k8s = time.time()
            client = paramiko.SSHClient()
            client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
            client.connect(hostname='192.168.1.14', username='poppo', password='')
            
            
            ftpTranfert = client.open_sftp()
            for name in pathNameConfigMap:
                #prese le cartelle di configurazione necessarie prendo i file per trasferirli in scp su un apparato remoto
                for (_, _, filenames) in os.walk(name):
                    for fil in filenames:
                        mylocalpath = os.path.join(name,fil)
                        pathdest= "C:\\Users\\poppo\\Desktop\\wafConfModSec\\"+fil
                        #carico i miei file uno alla volta in modo ricorsivo
                        sendTest=ftpTranfert.put(localpath=mylocalpath, remotepath=pathdest, confirm=True)
                    
            #dopo aver lanciato scp in realta il programma è bloccante quindi aspetta fin quando non carica tutti i file.
            # dopo il caricamento posso eseguire le azioni per creare una config map personalizzata e lanciare il template personalizzato       
            concString = 'config'+rules['Service_Name']+'.yaml'            
            pathConfigYaml = os.path.join(os.path.dirname(__file__),concString)
            pathdest= "C:\\Users\\poppo\\Desktop\\"+concString
            print(pathConfigYaml)
            print(pathdest)
            sendTest=ftpTranfert.put(localpath=pathConfigYaml, remotepath=pathdest, confirm=True)     
            # creo la config map per il nodo waf

            configCommand = 'minikube kubectl -- create configmap '+ rules['Service_Name']+'configmap' + ' --from-file=C:\\Users\\poppo\\Desktop\\wafConfModSec'
            print(configCommand)
            stdin, stdout, stderr = client.exec_command(configCommand)
            
            print(stdout.read().decode())
            
            configCommand = 'minikube kubectl -- apply -f C:\\Users\\poppo\\Desktop\\'+'config'+rules['Service_Name']+'.yaml'
            print(configCommand)
            stdin, stdout, stderr = client.exec_command(configCommand)
            
            print(stdout.read().decode())
            
            ftpTranfert.close()
            client.close()
            print("--- %s seconds --- fine comunicazione k8s" % (time.time() - start_time_k8s))
    print("--- %s seconds --- fine scenario operativo" % (time.time() - start_time))
