import matplotlib
matplotlib.rcParams['text.usetex'] = True
from matplotlib.patches import Patch
from matplotlib.lines import Line2D
import matplotlib.pyplot as plt
import numpy as np

#%% DATA FROM SIMULATIONS

#RL Algorithm - RL DISC@0.9 
RL_cost = [0, 428670.483073, 590442.817060, 638443.615882, 655128.809876, 674517.620213, 690793.440435, 706498.478910, 720474.721055, 735366.227751, 768297.066676, 
           819108.626937, 826209.494165, 861728.179652, 882457.270346, 915948.389031, 
           941979.014489, 950438.606500, 965374.083368, 972461.091699, 
           973236.556323, 987942.850531, 1002815.150120, 1004499.893605,
           1013604.827842, 1022041.962385, 1026144.887510, 1030663.155791,
           1047040.794118, 1065470.670695, 1078495.605664, 1082623.577813, 1093112.030638, 1101204.153811,
           1102141.663013, 1104667.643836, 1108030.910952, 1108494.407348, 1115263.509633, 1138759.647587]
RL_loss = [136.142857, 59.14, 44.14, 39.285714, 36.71, 35, 35, 31.714286, 30.285714, 30.14, 27.571429, 22.71, 22.428571, 19.714286, 
           18.714286, 16.285714, 15.428571, 15.285714, 14.142857, 12, 
           13.142857, 11.285714, 11.285714, 10.571429, 10, 9.857143,
           10.428571, 9.571429, 8.142857, 7.857143, 7.571429, 6.428571, 6.857143, 5.571429, 5.857143, 5.142857, 5.571429, 5.428571, 5.142857, 3.571429]
RL_beta = [0, 0.001, 0.003, 0.005, 0.006, 0.0075, 0.01, 0.012, 0.013, 0.015, 0.02, 0.05, 0.06, 0.1, 0.15, 0.2, 0.25, 0.3, 
           0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85,
           0.9, 0.925, 0.95, 0.96, 0.97, 0.975, 0.98, 0.9825, 0.985, 0.99, 0.999]

#RL DISC@0.7
RL2_cost = [557982.100034, 572893.952444, 630129.104527, 648573.336965, 691204.478333, 749551.162577]
RL2_loss = [44.428571, 43.428571, 37.285714, 37.142857, 31.857143, 26.857143]
RL2_beta = [0.8, 0.85, 0.9, 0.95, 0.975, 0.98]

#DP Algorithm - DP DISC@0.9
DP_cost = [725624.313061, 781719.794443, 893849.546046, 941520.965612,
           959462.114165, 990854.499231, 1013521.814163, 1016266.732124,
           1028215.151186, 1031083.516188, 1040985.406927, 1042189.955641,
           1053698.245040, 1062547.082806, 1062981.469306, 1065708.083785,
           1069617.560938, 1076796.842032, 1089053.097909, 1101853.039857,
           1107627.498552, 1119892.815629, 1121962.514613, 1126229.743402, 
           1126489.019619, 1126807.080711, 1148733.473532]
DP_loss = [34, 29.571429, 18, 15.714286, 14.571429, 12.857143, 11.428571,
           11, 10.428571, 10, 9.428571, 10, 9, 8.714286, 8.428571, 8, 7.857143,
           6.714286, 6.428571, 5.714286, 5.142857, 4.000000, 3.857143, 3.714286, 
           3.857143, 3.714286, 2.428571]
DP_beta = [0.005, 0.01, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5,
           0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 0.975, 0.98, 0.9825, 0.985, 0.99, 0.999]

#DP DISC@0.7
DP2_cost = [410498.698728, 414820.025567, 432770.811830, 450605.945837, 470021.506499,
            504573.585870, 545014.996458, 647036.648434, 669457.539240, 753105.474031,
            802999.965591]
DP2_loss = [63.857143, 62.857143, 60.857143, 59.285714, 58, 53.857143, 50.428571,
            40.714286, 38.714286, 31.714286, 27.428571]
DP2_beta = [0.005, 0.01, 0.1, 0.2, 0.3, 0.4, 0.5, 0.7, 0.8, 0.9, 0.95]

#Heuristic
H_cost = [1176462.480192, 1133983.099182, 1101299.885129, 1077303.751413, 1034635.359362, 976525.707511, 955191.994355, 894831.490269, 894590.617017, 845081.023689, 715361.712351]
H_loss = [2.142857, 5.428571, 8.142857, 10, 12.714286, 16.571429, 17.857143, 22.000000, 21.857143, 25.000000, 31.285714]

#Always ON
AON_cost = [1201443.880597]
AON_loss = [0.571429]

#ALways OFF
AOFF_cost = [0]
AOFF_loss = [136.142857]

#%% DATA PREPARATION

Min_cost = AOFF_cost[0]
Max_cost = AON_cost[0]

Min_loss = AON_loss[0]
Max_loss= AOFF_loss[0]

def normalize_cost(Min_cost, Max_cost, data):
    data = np.array(data)
    data = (data-Min_cost)/(Max_cost-Min_cost)
    return data

def normalize_loss(Min_loss, Max_loss, data):
    data = np.array(data)
    data = (data-Min_loss)/(Max_loss-Min_loss)
    return data

RL_cost = normalize_cost(Min_cost, Max_cost, RL_cost)
RL_loss = normalize_loss(Min_loss, Max_loss, RL_loss)

RL2_cost = normalize_cost(Min_cost, Max_cost, RL2_cost)
RL2_loss = normalize_loss(Min_loss, Max_loss, RL2_loss)

DP_cost = normalize_cost(Min_cost, Max_cost, DP_cost)
DP_loss = normalize_loss(Min_loss, Max_loss, DP_loss)

DP2_cost = normalize_cost(Min_cost, Max_cost, DP2_cost)
DP2_loss = normalize_loss(Min_loss, Max_loss, DP2_loss)

H_cost = normalize_cost(Min_cost, Max_cost, H_cost)
H_loss = normalize_loss(Min_loss, Max_loss, H_loss)

AOFF_cost = normalize_cost(Min_cost, Max_cost, AOFF_cost)
AOFF_loss = normalize_loss(Min_loss, Max_loss, AOFF_loss)

AON_cost = normalize_cost(Min_cost, Max_cost, AON_cost)
AON_loss = normalize_loss(Min_loss, Max_loss, AON_loss)


#%% PLOTS

plt.plot(RL_loss, RL_cost,  '*', label= r"RL $\alpha $@0.9")
#plt.plot(RL2_loss, RL2_cost, label= "RL DISC@0.7")
plt.plot(DP_loss, DP_cost,  '*', label= r"DP $\alpha $@0.9")
#plt.plot(DP2_loss, DP2_cost, label= "DP DISC@0.7")
plt.plot(H_loss, H_cost, '*', label="Heuristics")
plt.plot(AON_loss, AON_cost, 'o', label="Always ON")
plt.plot(AOFF_loss, AOFF_cost, 'o', label="Always OFF")
plt.xlabel("Normalized mean losses")
plt.ylabel("Normalized mean grid cost")
plt.xlim([0, 0.15])
plt.ylim([0.7, 1])
plt.grid(linestyle='--', linewidth=0.5)
plt.legend()
plt.show()

plt.plot(RL_loss, RL_cost,  '*', label= r"RL $\alpha $@0.9")
#plt.plot(RL2_loss, RL2_cost, label= "RL DISC@0.7")
plt.plot(DP_loss, DP_cost,  '*', label= r"DP $\alpha $@0.9")
#plt.plot(DP2_loss, DP2_cost, label= "DP DISC@0.7")
plt.plot(H_loss, H_cost, '*', label="Heuristics")
plt.plot(AON_loss, AON_cost, 'o', label="Always ON")
plt.plot(AOFF_loss, AOFF_cost, 'o', label="Always OFF")
plt.xlabel("Normalized mean losses")
plt.ylabel("Normalized mean grid cost")
plt.grid(linestyle='--', linewidth=0.5)
plt.legend()
#plt.plot(RL_loss, RL_cost, label= r"RL $\alpha $@0.9", color="royalblue")
plt.savefig("comp_whole_plot.eps", format="eps", bbox_inches='tight')
plt.show()

DP_cost = [0, 725624.313061, 781719.794443, 893849.546046, 941520.965612,
           959462.114165, 990854.499231, 1013521.814163, 1016266.732124,
           1028215.151186, 1031083.516188, 1040985.406927, 1042189.955641,
           1053698.245040, 1062547.082806, 1062981.469306, 1065708.083785,
           1069617.560938, 1076796.842032, 1089053.097909, 1101853.039857,
           1107627.498552, 1119892.815629, 1121962.514613, 1126229.743402, 
           1126489.019619, 1126807.080711, 1148733.473532, 1201443.880597]
DP_loss = [136.142857, 34, 29.571429, 18, 15.714286, 14.571429, 12.857143, 11.428571,
           11, 10.428571, 10, 9.428571, 10, 9, 8.714286, 8.428571, 8, 7.857143,
           6.714286, 6.428571, 5.714286, 5.142857, 4.000000, 3.857143, 3.714286, 
           3.857143, 3.714286, 2.428571, 0.571429]
DP_beta = [0, 0.005, 0.01, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5,
           0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 0.975, 0.98, 0.9825, 0.985, 0.99, 0.999, 1]

DP_cost = normalize_cost(Min_cost, Max_cost, DP_cost)
DP_loss = normalize_loss(Min_loss, Max_loss, DP_loss)

plt.plot(DP_beta, DP_cost, label= r"Mean grid cost")
plt.plot(DP_beta, DP_loss, label= r"Mean losses")
plt.xlabel(r"$\beta$")
plt.ylabel("Normalized KPI")
plt.grid(linestyle='--', linewidth=0.5)
plt.legend()
plt.savefig("KPI_vs_beta.eps", format="eps", bbox_inches='tight')
plt.show()

#%% Aproximation

DP_idx = (DP_cost>0.75)*(DP_cost<0.9)
DP_loss_apx = DP_loss[DP_idx]
DP_cost_apx = DP_cost[DP_idx] - 1
DP_m = np.dot(DP_cost_apx, DP_loss_apx)/np.dot(DP_cost_apx, DP_cost_apx)

RL_idx = RL_cost>0.75
RL_loss_apx = RL_loss[RL_idx]
RL_cost_apx = RL_cost[RL_idx] - 1
RL_m = np.dot(RL_cost_apx, RL_loss_apx)/np.dot(RL_cost_apx, RL_cost_apx)

H_idx = (H_cost>0.75)*(H_cost<0.9)
H_loss_apx = H_loss[H_idx]
H_cost_apx = H_cost[H_idx] - 1
H_m = np.dot(H_cost_apx, H_loss_apx)/np.dot(H_cost_apx, H_cost_apx)

plt.plot(RL_loss, (RL_loss/RL_m)+1,  '--', label= r"RL $\alpha $@0.9")
#plt.plot(RL2_loss, RL2_cost, label= "RL DISC@0.7")
plt.plot(DP_loss, (DP_loss/DP_m)+1,  '--', label= r"DP $\alpha $@0.9")
#plt.plot(DP2_loss, DP2_cost, label= "DP DISC@0.7")
plt.plot(H_loss, (H_loss/H_m)+1, '--', label="Heuristics")
plt.plot(AON_loss, AON_cost, 'o', label="Always ON")
plt.xlabel("Normalized mean losses")
plt.ylabel("Normalized mean grid cost")
plt.xlim([0, 0.15])
plt.ylim([0.7, 1])
plt.grid(linestyle='--', linewidth=0.5)
plt.legend()
plt.plot(H_loss, H_cost, '*', label="Heuristics", color="green")
plt.plot(RL_loss, RL_cost,  '*', label= r"RL $\alpha $@0.9", color="royalblue")
plt.plot(DP_loss, DP_cost,  '*', label= r"DP $\alpha $@0.9", color="orange")
plt.savefig("comp_aprox_plot.eps", format="eps", bbox_inches='tight')
plt.show()