import logo from '../assets/logo_meta.png'

const Navbar = ({ web3Handler, account }) => {
    return (
        <nav className="flex-between">
            <a
                className='flex'
                href="https://www.linkedin.com/in/carmelo-proetto-265549232/"
                target="_blank"
                rel="noopener noreferrer"
            >
                <img src={logo} className="App-logo" alt="logo" />
                Metaverse Map
            </a>

            {account ? (
                //se siamo loggati comparirà il nostro indirzzio
                <a
                    href="https://www.linkedin.com/in/carmelo-proetto-265549232/"
                    target="_blank"
                    rel="noopener noreferrer"
                    className="button">
                    {account.slice(0, 5) + '...' + account.slice(38, 42)}
                </a>
            ) : (
                //se non siamo loggati comparirà un pulsante per l'accesso
                //ogni volta che clicchiamo sul pulsante viene chaiamta la funzione web3Handler
                <button onClick={web3Handler} className="button">Connect Wallet</button>
            )}
        </nav>
    )
}

export default Navbar;