import { useHelper } from '@react-three/drei';
import { useFrame } from '@react-three/fiber';
import { useEffect, useRef } from "react";
import { BoxHelper } from 'three';

type Props = {
    isTesting: boolean;
}

const AnimatedBox = ({isTesting}) => {

    const meshRef = useRef(null);
    
    useHelper(meshRef, BoxHelper, "blue");
    
   
    //questo ciclo viene eseguito ogni framez
    useFrame(() => {
        console.log("hi");
        if(meshRef.current){
            meshRef.current.rotation.x += 0.01;
        }
    });

    return(
        <mesh ref={meshRef} scale={[0.5, 0.5, 0.5]}>
            <boxGeometry />
            <meshStandardMaterial />
        </mesh>
    );
};

export default AnimatedBox;