#!/usr/bin/env python3
import subprocess
import rclpy
from rclpy.node import Node

from example_interfaces.msg import Int64
from geometry_msgs.msg import PoseStamped
import matplotlib.pyplot as plt
from mpl_toolkits import mplot3d

from sensor_msgs.msg import PointCloud2
from sensor_msgs.msg import Imu
from std_msgs.msg import Float64MultiArray
import queue
import sys

def get_topic_point():
    if(not len(sys.argv) == 2):
        #dir=input("Give me bag dataset folder path: ")
        dir = "/home/frsagco/dataset/campus_small_dataset/campus_small_dataset/campus_small_dataset.db3"
       # dir = "/home/frsagco/dataset/hdl_filtered/hdl_501_filtered/hdl_501_filtered.db3"
       # dir = "/home/frsagco/dataset/hdl/hdl_501_ros1/hdl_501_ros1.db3"
    else:
        dir = sys.argv[1]

    info=subprocess.run(['ros2', 'bag', 'info', dir], stdout=subprocess.PIPE).stdout.decode('utf-8')
    topic = []
    if len(info.splitlines()) > 8:
        print(info.splitlines()[9].split(" ")[20])
        print(info.splitlines()[10].split(" ")[20])
        
        topic.append(info.splitlines()[9].split(" ")[20])
        topic.append(info.splitlines()[10].split(" ")[20])

        print("Topics: " + topic[0] + " " + topic[1])
    else:
        print("Give me a valid path. Abort.")
        return

    return topic

class TestOdometry(Node):
    def __init__(self):
        super().__init__("test_odometry")
        self.get_logger().info("Test odometry running")

        
        self.name_robot = "/robot1"
        self.imu_is_present = False
        #self.topic_point_ = ["/imu_raw", "/points_raw"] # kitti
        #self.topic_point_ = ["/imu/data", "/velodyne_points"] # loam
        #self.topic_point_ = ["/imu_correct", "/points_raw"] # campus_small_dataset
        self.topic_point_ = [" ", "/velodyne_points"]
        

        self.x = []
        self.y = []
        self.z = []
        self.point_cloud = queue.Queue()
        self.imu = queue.Queue()

        self.topic_name = self.name_robot +"/current_pose"
        self.imuTopic = "/ld_slam/imu_raw"
        self.pointCloudTopic = "/ld_slam/point_cloud_raw"

        #self.odometry_subscriber = self.create_subscription(PoseStamped, "/curr_pos", self.callback_odometry, 100)
        self.point_cloud_subscriber = self.create_subscription(PointCloud2, self.topic_point_[1], self.callback_point_cloud, 300)
        
        if self.imu_is_present is True:
            self.imu_subscriber_ = self.create_subscription(Imu, self.topic_point_[0], self.callback_imu, 300)

        #self.prova_subscriber_ = self.create_subscription(Float64MultiArray, "/prova_matrix", self.callback_prova, 1)

        self.point_cloud_publisher_ = self.create_publisher(PointCloud2, self.pointCloudTopic, 100)
        self.imu_publisher_ = self.create_publisher(Imu, self.imuTopic, 100)

        self.count_point = 0
        self.count = 0
        self.count_pub_point = 0
        self.count_imu = 0
        #self.odometry_timer_ = self.create_timer(60, self.odometry_result)
        self.point_cloud_timer_ = self.create_timer(0.1, self.publish_point_cloud)
        self.imu_timer_ = self.create_timer(0.09, self.publish_imu)

    def callback_prova(self, msg):
        print("Msg: ")
        print(msg.data)

    def callback_odometry(self, msg):
        # ros2 run teleop_twist_keyboard teleop_twist_keyboard --ros-args --remap cmd_vel:=/robot1/cmd_vel
        print("[" + str(self.count) +"]: [" + str(self.count_point) +"]:" + "[" + str(self.count_pub_point) + "]:" + " Current pose of [" + self.name_robot + "]: x=" + str(msg.pose.position.x) + " y=" + str(msg.pose.position.y) + " z=" + str(msg.pose.position.z))
        self.x.append(msg.pose.position.x)
        self.y.append(msg.pose.position.y)
        self.z.append(msg.pose.position.z)
        
        self.count = self.count + 1
        
    def callback_point_cloud(self, msg):
        self.count_point = self.count_point + 1
        #msg.header.stamp = self.get_clock().now().to_msg()
        self.point_cloud.put(msg)

    def callback_imu(self, msg):
        self.count_imu = self.count_imu + 1
        self.imu.put(msg)
    

    def odometry_result(self):
        fig = plt.figure()
        ax = plt.axes(projection='3d')
        ax.plot3D(self.x, self.y, self.z, 'gray')
        plt.show()
            
    def publish_point_cloud(self):
        if((self.point_cloud.empty() is False)):
            msg_cloud = self.point_cloud.get()
            msg_cloud.header.stamp = self.get_clock().now().to_msg()
            #msg_imu = self.imu.get()
            #msg_imu.header.stamp = self.get_clock().now().to_msg()
            
            self.count_pub_point = self.count_pub_point + 1
            #self.imu_publisher_.publish(msg_imu)
            self.point_cloud_publisher_.publish(msg_cloud)

    def publish_imu(self):
        if((self.imu.empty() is False)):
            msg_imu = self.imu.get()
            msg_imu.header.stamp = self.get_clock().now().to_msg()
            
            self.count_pub_point = self.count_pub_point + 1
            self.imu_publisher_.publish(msg_imu)

def main(args = None):
    rclpy.init(args=args)
    node = TestOdometry()
    rclpy.spin(node)
    rclpy.shutdown()

if __name__ == "__main__":
    main()
