#ifndef LOOPCLOSUREDETECTION_HPP_
#define LOOPCLOSUREDETECTION_HPP_

#include "visibility.h"
#include <rclcpp/rclcpp.hpp>

#include <tf2_ros/buffer.h>
#include <tf2_ros/transform_listener.h>
#include <tf2_ros/transform_broadcaster.h>
#include <tf2_sensor_msgs/tf2_sensor_msgs.h>
#include <tf2_geometry_msgs/tf2_geometry_msgs.h>
#include <tf2_eigen/tf2_eigen.h>
#include <sensor_msgs/msg/point_cloud2.hpp>
#include <sensor_msgs/msg/laser_scan.hpp>
#include <geometry_msgs/msg/pose_stamped.hpp>
#include <geometry_msgs/msg/transform.hpp>
#include <geometry_msgs/msg/transform_stamped.hpp>
#include <nav_msgs/msg/odometry.hpp>
#include <mutex>
#include <thread>
#include <future>
#include <cstdlib>

#include <pclomp/ndt_omp.h>
#include <pclomp/ndt_omp_impl.hpp>
#include <pclomp/voxel_grid_covariance_omp.h>
#include <pclomp/voxel_grid_covariance_omp_impl.hpp>
#include <pclomp/gicp_omp.h>
#include <pclomp/gicp_omp_impl.hpp>


#include <pcl_conversions/pcl_conversions.h>
#include "Scancontext.h"
#include "utility.hpp"

#include <std_msgs/msg/float64_multi_array.hpp>
#include <std_msgs/msg/int32_multi_array.hpp>
#include <std_msgs/msg/multi_array_dimension.hpp>
#include <Eigen/Dense>

#include "ld_slam_msg/srv/give_point_cloud.hpp"


typedef pcl::PointXYZI PointType;

namespace ldslam
{
  class LoopClosure: public rclcpp::Node
  {
  public:
      COMPOSITION_PUBLIC
      explicit LoopClosure(const rclcpp::NodeOptions & options);

  private:
      std::string robot_name_;

      std::mutex mtx_clouds_;
      std::mutex mtx_rendezvous_;

      rclcpp::TimerBase::SharedPtr timer_loop_;
      rclcpp::TimerBase::SharedPtr timer_rendezvous_;
      rclcpp::TimerBase::SharedPtr timer_debug_;
      rclcpp::TimerBase::SharedPtr timer_inter_loop_;
      rclcpp::TimerBase::SharedPtr timer_perform_loop_;
      // cloud dataset
      std::vector<pcl::PointCloud<PointType>> raw_clouds_;
      std::vector<pcl::PointCloud<PointType>> corner_clouds_;
      std::vector<pcl::PointCloud<PointType>> surface_clouds_;

      std::vector<PointTypePose> poses_;
      
      // debug
      std::vector<pcl::PointCloud<PointType>> other_raw_clouds_;

      rclcpp::Subscription<sensor_msgs::msg::PointCloud2>::SharedPtr cloud_raw_sub_;
      rclcpp::Subscription<sensor_msgs::msg::PointCloud2>::SharedPtr cloud_surface_sub_;
      rclcpp::Subscription<sensor_msgs::msg::PointCloud2>::SharedPtr cloud_corner_sub_;
      rclcpp::Subscription<geometry_msgs::msg::PoseStamped>::SharedPtr odom_sub_;
      rclcpp::Subscription<std_msgs::msg::Float64MultiArray>::SharedPtr sc_context_sub_;
      rclcpp::Subscription<std_msgs::msg::Int32MultiArray>::SharedPtr loop_id_sub_;
      rclcpp::Subscription<sensor_msgs::msg::PointCloud2>::SharedPtr loop_cloud_sub_;

      rclcpp::Publisher<std_msgs::msg::Float64MultiArray>::SharedPtr sc_context_pub_;
      rclcpp::Publisher<std_msgs::msg::Int32MultiArray>::SharedPtr loop_id_pub_;
      rclcpp::Publisher<sensor_msgs::msg::PointCloud2>::SharedPtr loop_cloud_pub_;

      // debug
      rclcpp::Subscription<sensor_msgs::msg::PointCloud2>::SharedPtr debug_pointCloud_sub_;

      /* Loop Closure detection Parameters */
      SCManager scManager;

      // intra-robot loop closure detection
      pcl::PointCloud<PointType>::Ptr SClatestSurfKeyFrameCloud;
      pcl::PointCloud<PointType>::Ptr SCnearHistorySurfKeyFrameCloud;
      pcl::PointCloud<PointType>::Ptr SCnearHistorySurfKeyFrameCloudDS;
      pcl::VoxelGrid<PointType> downSizeFilterHistoryKeyFrames; // for histor key frames of loop closure

      // inter-robot loop closure detection
      std::vector<pcl::PointCloud<PointType>> SCinterSourceCloud;
      std::vector<pcl::PointCloud<PointType>> SCinterTargetCloud;
      pcl::PointCloud<PointType>::Ptr SCinterTargetCloudDS;
      std::vector<Indexes> resInterLoop;



      bool loopClosureEnableFlag;
      float loopClosureFrequency;
      bool potentialLoopFlag;
      double timeSaveFirstCurrentScanForLoopClosure;
      int SCclosestHistoryFrameID; // giseop 
      int latestFrameIDLoopCloure;
      float yawDiffRad;
      int historyKeyframeSearchNum;
      float historyKeyframeFitnessScore;
      int latestPointCloud;

      // inter-robot loop closure detection
      bool interClosureEnableFlag;
      bool potentialInterLoopFlag;
      bool interLoop;
      bool activePerformLoop;
      double timeSaveFirstCurrentScanForInterLoopClosure;
      double timeLaserInterOdometry;
      int loop;

      // intra loop closure
      void performLoopClosure();
      bool detectLoopClosure();

      // inter loop closure
      void publishScanContext();
      void performInterLoopClosure();
      void performInterLoopClosure_callback();
        

      pcl::PointCloud<PointType>::Ptr transformPointCloud(pcl::PointCloud<PointType>::Ptr cloudIn, PointTypePose* transformIn);
      void setParams();
      void initializePubSub();
      void allocateMemory();

      
      void sc_context_callback(const std_msgs::msg::Float64MultiArray::SharedPtr msg);
      void cloud_surface_callback(const sensor_msgs::msg::PointCloud2::SharedPtr msg);
      void cloud_corner_callback(const sensor_msgs::msg::PointCloud2::SharedPtr msg);
      void cloud_raw_callback(const sensor_msgs::msg::PointCloud2::SharedPtr msg);
      void odometry_callback(const geometry_msgs::msg::PoseStamped::SharedPtr msg);
      void inter_loop_id_callback(const std_msgs::msg::Int32MultiArray::SharedPtr msg);
      void store_targetCloud_callback(const sensor_msgs::msg::PointCloud2::SharedPtr msg);


      // debug
      void debug_pointCloud_callback(const sensor_msgs::msg::PointCloud2::SharedPtr msg);
      void debugPerform(); 

      // odom
      double timeLaserOdometry;

      // debug
      int count;
      int count1;
      int count2;
      int count3;
      int count4;
  };
}

#endif  // LOOPCLOSUREDETECTION_HPP_
