function [gammaR] = sp_att_rain(f,teta,tau,R001)
% Apecific attenuation model for rain (ITU-R P.838)

% k and alfa are calculated using regression coefficients (for horizontal and 
% vertical polarization) kH, kV, alfaH and alfa V at the frequency of interest


% kH calculation for linear or circular polarization

a = [-5.3398 -0.35351 -0.23789 -0.94158];
b = [-0.10008 1.2697 0.86036 0.64552];
c = [1.13098 0.454 0.15354 0.16817];
mk = -0.18961;
ck = 0.71147;

d = zeros(1,4);
for j=1:4
    d(j) = a(j).* exp(-(((log10(f)-b(j)) ./c(j)).^2));
end

kH = 10.^ (sum(d) + mk.*log10(f) + ck);


% kV calculation for linear or circular polarization

a = [-3.80595 -3.44965 -0.39902 0.50167];
b = [0.56934 -0.22911 0.73042 1.07319];
c = [0.81061 0.51059 0.11899 0.27195];
mk = -0.16398;
ck = 0.63297;

d = zeros(1,4);
for j=1:4
    d(j) = a(j).* exp(-(((log10(f)-b(j)) ./c(j)).^2));
end

kV = 10.^ (sum(d) + mk.*log10(f) + ck);


% alfaH calculation for linear or circular polarization

a = [-0.14318 0.29591 0.32177 -5.37610 16.1721];
b = [1.82442 0.77564 0.63773 -0.9623 -3.2998];
c = [-0.55187 0.19822 0.13164 1.47828 3.43990];
ma = 0.67849;
ca = -1.95537;

d = zeros(1,5);
for j=1:5
    d(j) = a(j).* exp(-(((log10(f)-b(j)) ./c(j) ).^2));
end

alfaH = sum(d) + ma.*log10(f) + ca;


% alfaV calculation for linear or circular polarization

a = [-0.07771 0.56727 -0.20238 -48.2991 48.5833];
b = [2.33840 0.95545 1.14520 0.791669 0.791459];
c = [-0.76284 0.54039 0.26809 0.116226 0.116479];
ma = -0.053739;
ca = 0.83433;

d = zeros(1,5);
for j=1:5
    d(j) = a(j).* exp(-(((log10(f)-b(j)) ./c(j) ).^2));
end

alfaV = sum(d) + ma.*log10(f) + ca;


% k and alfa are dependent variables of frequency f, elevation angle teta
% and polarization tilt angle tau

k = (kH + kV + (kH-kV) .* cosd(teta).^2 .* cosd(2*tau)) /2;

alfa = (kH.*alfaH + kV.*alfaV + (kH.*alfaH - kV.*alfaV) .* ...
    cosd(teta).^2 .* cosd(2*tau)) ./ (2*k);


% Specific attenuation
gammaR = k.*R001.^alfa;

end