function [S] = slantrange_LEO(hS,eps)
% Slant Range computation in case of LEO/MEO satellite (spherical Earth)

h = hS*ones(1,3);
R = 6378.16;            % Earth radius [km]

S = sqrt((R+h).^2 - R.^2 .* cosd(eps).^2) - R.*sind(eps);

end

