function [S,eps] = slantrange_GEO(posG,posS)
% Slant Range computation in case of GEO satellite (elliptical Earth)
% S has only a NOM valor

tetaG = posG(1);               % GS Latitude [deg] (Geodetic)
phiG = posG(2);                % GS Longitude [deg]
hG = posG(3);                  % GS Height [km] (Geodetic)
psiS = posS(1);                % SC Latitude [deg] (Geocentric)
phiS = posS(2);                % SC Longitude [deg]
hS = posS(3);                  % SC Height [km] (Geodetic)

Rq = 6378.16;                   % Earth equatorial radius [km]
Rp = 6356.778;                  % Earth polar radius [km]
e = sqrt(Rq^2 - Rp^2)/Rq;       % Earth eccentricity [adim.]

% Geocentric coordinates computation
% - GS Geocentric Longitude
psiG = atand((Rq*(1-e^2) + hG.*sqrt(1-(e*sind(tetaG)).^2)) .* tand(tetaG)...
    ./ (Rq + hG.*sqrt(1-(e*sind(tetaG)).^2)));
% - GS height from the center of the Earth
RG = sqrt((hG.^2 + 2*Rq*hG* sqrt(1 - (e*sind(tetaG)).^2))...
    + (Rq^2 * (1 - e^2 * (2-e^2) * sind(tetaG).^2) ./ (1 - (e*sind(tetaG)).^2)));
% - SC height from the center of the Earth
RS = sqrt((hS.^2 + 2*Rq*hS* sqrt(1 - (e*sind(psiS)).^2))...
    + (Rq^2 * (1 - e^2 * (2-e^2) * sind(psiS).^2) ./ (1 - (e*sind(psiS)).^2)));

% Slant Range [km] computation
Gamma = cosd(psiG).*cosd(psiS).*cosd(phiS-phiG) + sind(psiG).*sind(psiS);
S = ones(1,3) .* sqrt(RG.^2 + RS.^2 - 2*RG.*RS.*Gamma);

% GS Antenna Elevation angle [deg] computation
Omega = RS.*(cosd(psiS).*cosd(tetaG).*cosd(phiS-phiG) + sind(psiS).*sind(tetaG))...
    - RG.*cosd(psiG-tetaG);
eps = ones(1,3) .* asind(abs(Omega)./S);

end

