function [LH] = polarizloss(XG,XS)
% Polarization mismatch Loss computation

rG = 10.^(XG/20);
rS = 10.^(XS/20);
LH(1) = 10*log10(4*(1+rS(1).^2).*(1+rG(1).^2) ./ ((1+rS(1)).*(1+rG(1))).^2);
LH(2) = 10*log10( (1+rS(2).^2).*(1+rG(2).^2) ./ (rS(2)+rG(2)).^2 );
LH(3) = 10*log10( (1+rS(3).^2).*(1+rG(3).^2) ./ (rS(3).*rG(3)+1).^2 );

end

