function [L] = pointloss(f,D,teta,hpbw)
% Pointing loss computation

if teta(2)>0
    if D(2)>0
        u = (pi.*D.*f.*sind(teta))/300;
        L = -20*log10(2*besselj(1,u)./u);
    elseif D(2)==0 
        L = 12*(teta./hpbw).^2;
    end
elseif teta(2)==0
    L = zeros(1,3);
end

end