function STD = importstatdw(workbookFile, sheetName, dataLines)
%IMPORTFILE1 Import data from a spreadsheet
%  LINKBUDGETV5S4 = IMPORTFILE1(FILE) reads data from the first
%  worksheet in the Microsoft Excel spreadsheet file named FILE.
%  Returns the numeric data.
%
%  LINKBUDGETV5S4 = IMPORTFILE1(FILE, SHEET) reads from the specified
%  worksheet.
%
%  LINKBUDGETV5S4 = IMPORTFILE1(FILE, SHEET, DATALINES) reads from the
%  specified worksheet for the specified row interval(s). Specify
%  DATALINES as a positive scalar integer or a N-by-2 array of positive
%  scalar integers for dis-contiguous row intervals.
%
%  Example:
%  LinkBudgetv5S4 = importfile1("C:\Users\hp\Desktop\LINK_BUDGET_v5\Link_Budget_v5.xlsx", "Output Dw", [4, 123]);
%
%  See also READTABLE.
%
% Auto-generated by MATLAB on 22-Sep-2022 12:12:19

%% Input handling

% If no sheet is specified, read first sheet
if nargin == 1 || isempty(sheetName)
    sheetName = 1;
end

% If row start and end points are not specified, define defaults
if nargin <= 2
    dataLines = [4, 123];
end

%% Set up the Import Options and import the data
opts = spreadsheetImportOptions("NumVariables", 1);

% Specify sheet and range
opts.Sheet = sheetName;
opts.DataRange = "P" + dataLines(1, 1) + ":P" + dataLines(1, 2);

% Specify column names and types
opts.VariableNames = "VarName16";
opts.VariableTypes = "double";

% Import the data
STD = readtable(workbookFile, opts, "UseExcel", false);

for idx = 2:size(dataLines, 1)
    opts.DataRange = "P" + dataLines(idx, 1) + ":P" + dataLines(idx, 2);
    tb = readtable(workbookFile, opts, "UseExcel", false);
    STD = [STD; tb]; %#ok<AGROW>
end

%% Convert to output type
STD = table2array(STD);
end