function IN = importfile(workbookFile,sheetName,dataLines)
%IMPORTFILE1 Import data from a spreadsheet
%  LINKBUDGETV5S2 = IMPORTFILE1(FILE) reads data from the first
%  worksheet in the Microsoft Excel spreadsheet file named FILE.
%  Returns the numeric data.
%
%  LINKBUDGETV5S2 = IMPORTFILE1(FILE, SHEET) reads from the specified
%  worksheet.
%
%  LINKBUDGETV5S2 = IMPORTFILE1(FILE, SHEET, DATALINES) reads from the
%  specified worksheet for the specified row interval(s). Specify
%  DATALINES as a positive scalar integer or a N-by-2 array of positive
%  scalar integers for dis-contiguous row intervals.
%
%  Example:
%  LinkBudgetv5S2 = importfile1("C:\Users\hp\Desktop\LINK_BUDGET_v5\Link_Budget_v5.xlsx", "Input", [3, 134]);
%
%  See also READTABLE.
%
% Auto-generated by MATLAB on 03-Oct-2022 16:23:30

%% Input handling

% If no sheet is specified, read first sheet
if nargin == 1 || isempty(sheetName)
    sheetName = 1;
end

% If row start and end points are not specified, define defaults
if nargin <= 2
    dataLines = [3, 134];
end

%% Set up the Import Options and import the data
opts = spreadsheetImportOptions("NumVariables", 11);

% Specify sheet and range
opts.Sheet = sheetName;
opts.DataRange = "A" + dataLines(1, 1) + ":K" + dataLines(1, 2);

% Specify column names and types
opts.VariableNames = ["Flag", "Var2", "Var3", "Var4", "Var5", "Var6", "Var7", "mu", "VarName9", "VarName10", "VarName11"];
opts.SelectedVariableNames = ["Flag", "mu", "VarName9", "VarName10", "VarName11"];
opts.VariableTypes = ["double", "char", "char", "char", "char", "char", "char", "double", "double", "double", "double"];

% Specify variable properties
opts = setvaropts(opts, ["Var2", "Var3", "Var4", "Var5", "Var6", "Var7"], "WhitespaceRule", "preserve");
opts = setvaropts(opts, ["Var2", "Var3", "Var4", "Var5", "Var6", "Var7"], "EmptyFieldRule", "auto");

% Import the data
IN = readtable(workbookFile, opts, "UseExcel", false);

for idx = 2:size(dataLines, 1)
    opts.DataRange = "A" + dataLines(idx, 1) + ":K" + dataLines(idx, 2);
    tb = readtable(workbookFile, opts, "UseExcel", false);
    IN = [IN; tb]; %#ok<AGROW>
end

%% Convert to output type
IN = table2array(IN);
end