function [EbN0_req] = dvbs2(i)
% Required Eb/N0 calculation from BER, according to ETSI DVB-S2 standard

% Spectral efficiency [bits/symbol]
eta = [NaN
       0.490243
       0.656448
       0.789412
       0.988858
       1.188304
       1.322253
       1.487473
       1.587196
       1.654663
       1.766451
       1.788612
       1.779991
       1.980636
       2.228124
       2.478562
       2.646012
       2.679207
       2.637201
       2.966728
       3.165623
       3.300184
       3.523143
       3.567342
       3.703295
       3.951571
       4.119540
       4.397854
       4.453027];

% Ideal Es/N0 [dB] (for FECFRAME length = 64800)
EsN0 = [NaN
        -2.35
        -1.24
        -0.30
        1.00
        2.23
        3.10
        4.03
        4.68
        5.18
        6.20
        6.42
        5.50
        6.62
        7.91
        9.35
        10.69
        10.98
        8.97
        10.21
        11.03
        11.61
        12.89
        13.13
        12.73
        13.64
        14.28
        15.69
        16.05];

EbN0_r = EsN0(i) - 10*log10(eta(i));      % [dB]

EbN0_req = ones(1,3).*EbN0_r;


end