function [EbN0_req] = coding(i,COD,MOD)
% Required Eb/N0 calculation from BER, depending on the type of coding
% applicated to TM (No Code for TC), according to CCSDS standard

% i is the index of our BER value (from 1 to 7)

BER = [1E-2
       1E-3
       1E-4
       1E-5
       1E-6
       1E-7
       1E-8];

if MOD<=5 || MOD==11       % BPSK / QPSK / OQPSK

VT12 = [1.32349
        2.45439
        3.32895
        4.11806
        4.72623
        5.20875
        5.62263];

VT23 = [2.40407
        3.228198
        3.9098842
        4.571221
        5.2325576
        5.7921515
        6.3229166];

VT34 = [2.9331393
        3.7674413
        4.4796511
        5.1511631
        5.771802
        6.392442
        7.0046019];

VT56 = [3.645349
        4.4491275
        5.17151143
        5.82267396
        6.4331398
        6.9927326
        7.57267257];

VT78 = [4.2049418
        5.04941804
        5.84302342
        6.555232087
        7.257267704
        7.87790661
        8.457850926];

VT = [NaN(7,1) VT12 VT23 VT34 VT56 VT78];

RS223 = [4.78152
         5.61587
         5.97776
         6.28938
         6.50048
         6.64624
         6.76687];

VT12RS223 = [1.81103
             2.22449
             2.36894
             2.49460
             2.57502
             2.64074
             2.71204];

VT23RS223 = [2.622465
             2.803432
             2.922
             3.034322
             3.127925
             3.218327
             3.30828];

VT34RS223 = [3.15289
             3.340094
             3.47114
             3.5897032
             3.6770673
             3.7659756
             3.854443];

VT56RS223 = [3.870515
             4.070203
             4.219969
             4.3322932
             4.4572101
             4.5811995
             4.7051888];

VT78RS223 = [4.382216
             4.606865
             4.769111
             4.900156
             5.014346
             5.129396
             5.2444463];

VTRS223 = [RS223 VT12RS223 VT23RS223 VT34RS223 VT56RS223 VT78RS223];

RS239 = [4.61063
         6.023
         6.50048
         6.81714
         7.07347
         7.3097
         7.54091];

VT12RS239 = [1.59491
             2.23324
             2.48957
             2.64036
             2.7258
             2.81497
             2.90417];

VT23RS239 = [2.542373
             2.822034
             2.983051
             3.12712
             3.25424
             3.364407
             3.4725351];

VT34RS239 = [3.0678
             3.339
             3.517
             3.661017
             3.79661
             3.92759
             4.05857];

VT56RS239 = [3.78814
             4.0763
             4.279661
             4.42373
             4.5678
             4.710531
             4.853265];

VT78RS239 = [4.339
             4.6356
             4.83051
             5.00848
             5.158596
             5.2881365
             5.417677];

VTRS239 = [RS239 VT12RS239 VT23RS239 VT34RS239 VT56RS239 VT78RS239];


if COD(1)==1 && COD(2)==1       % No Code
    EbN0_r_lin = erfcinv(2*BER(i)).^2;
    EbN0_r = 10*log10(EbN0_r_lin);

elseif COD(2)==1 && COD(1)>=2       % Viterbi (Convolutional)
    % Rate: 1/2 - 2/3 - 3/4 - 5/6 - 7/8
    EbN0_r = VT(i,COD(1));

elseif COD(2)==2        % Reed-Solomon(255,223)
    % No Viterbi - VT+RS (Concatenated)
    EbN0_r = VTRS223(i,COD(1));

elseif COD(2)==3        % Reed-Solomon(255,239)
    % No Viterbi - VT+RS (Concatenated)
    EbN0_r = VTRS239(i,COD(1));
end

elseif MOD==6       % GMSK - No code
    alfa = 0.68;
    EbN0_r_lin = erfcinv(2*BER(i)).^2 ./alfa;
    EbN0_r = 10*log10(EbN0_r_lin);

elseif MOD==7       % 8PSK - No code
    M=8;
    m=log2(M);
    EbN0_r_lin = (erfcinv(m*BER(i)) ./ sin(pi./M)).^2 ./m;
    EbN0_r = 10*log10(EbN0_r_lin);

elseif MOD==10       % FSK - No code
    EbN0_r_lin = 2*erfcinv(2*BER(i)).^2;
    EbN0_r = 10*log10(EbN0_r_lin);
end



EbN0_req = ones(1,3).*EbN0_r;


end


