function [TR] = RXnoiseT_SC(TR_S_data,TR_S_flag)
% SC Rx Noise Temperature computation

if TR_S_flag(1)==1
    L1 = TR_S_data(1,:);          % SC Rx Cable Attenuation [dB]
elseif TR_S_flag(1)==0
    L1 = zeros(1,3);
end

if TR_S_flag(2)==1
    T1 = TR_S_data(2,:);          % SC Cable assembly physical Temperature [K]
elseif TR_S_flag(2)==0
    T1 = zeros(1,3);
end

if TR_S_flag(3)==1
    L2 = TR_S_data(3,:);          % SC DX Attenuation [dB]
elseif TR_S_flag(3)==0
    L2 = zeros(1,3);
end

if TR_S_flag(4)==1
    T2 = TR_S_data(4,:);          % SC DX physical Temperature [K]
elseif TR_S_flag(4)==0
    T2 = zeros(1,3);
end

F = TR_S_data(5,:);           % SC Rx Noise Figure [dB]

T0 = 290;       % [K]

TR = T1.*(10.^(L1/10)-1) + T2.*(10.^(L2/10)-1) .* 10.^(L1/10)...
    +T0.*(10.^(F/10)-1) .* 10.^(L1/10) .* 10.^(L2/10);

end

