function [SN_acc,XRG_acc,CN0_req_acc,M_accR] = RGmeas_acc(meas_acc,BWdw_RG,XMjTdw, ...
    TdwL_RG,SN0_G)
% Ranging Measurement Accuracy budget calculation

teta_m = meas_acc(1,:);
sigma_R = meas_acc(2,:);
f_MT = meas_acc(5,:);

% RG Measurement Accuracy S/N treshold [dB]
SN_acc = -10*log10(2) + 20*log10(75000./(pi*f_MT.*sigma_R));

% BWdw_RG = RG Dw effective loop BW (2BL) [Hz] (Ranging noise bandwidth)
% -> to be converted to [dBHz]
BWdw_RG_dB = 10*log10(BWdw_RG);

% RG Code modulation loss [dB]
XRG_acc = -20*log10(cos(teta_m));

% Required C/N0 at GS for TM Acquisition
CN0_req_acc = SN_acc + BWdw_RG_dB + XRG_acc + XMjTdw + TdwL_RG;

% Margin for RG Measurement Accuracy (> 3 dB)
M_accR = SN0_G - CN0_req_acc;


end