function [ML1,ML2,ML3,ML4,ML5] = PSK(alfa,PCM)
% PSK direct Modulation for uplink/downlink
% There is no budget for Up Carrier Acquisition, because the carrier is suppressed.
% PSK Modulation is allowed for TC/TM ONLY
% Only MLup2 calculation is implemented

ML1 = zeros(1,3);
ML3 = zeros(1,3);
ML4 = zeros(1,3);
ML5 = zeros(1,3);

% alfa = Roll-off Factor, it determines the limitation of the signal 
% band compared to the theoric band (which is unlimited).

z = [pi*(1+alfa);2*pi*(1+alfa)];

% sinint(z) is set to its asymptotic value pi/2 when z >= 16

Si_z = zeros(2,3);

for i=1:2
    if z(i,:) < 16
        Si_z(i,:) = sinint(z(i,:));
    else
        Si_z(i,:) = pi/2;
    end
end

A = (2/pi)*(Si_z(1,:) - sin(z(1,:)/2).^2 ./ (z(1,:)/2));
B = (2/pi)*(Si_z(2,:) - sin(z(2,:)/2).^2 ./ (z(2,:)/2));

if PCM==1               % PCM signal - type NRZ-L
    ML2 = -10*log10(A);
elseif PCM==2           % PCM signal - type SP-L
    ML2 = -10*log10(2*A - B);
end

end