function [MLup1,MLup2,MLup3,MLup4,MLup5,parz1,parz2,parz4] = PMsc_up(mod_ind,MODU,MOD3)
% PM Modulation with subcarriers in uplink

mTC = mod_ind(1,:);             % TC Carrier Modulation Index [rad]

if MODU(2)==1 || MODU(3)==1
    Mup = mod_ind(2,:);         % RG Major Tone Modulation Index (up) [rad]
else
    Mup = zeros(1,3);
end

if MOD3==2
    mup = mod_ind(3,:);         % RG Minor Tone Modulation Index (up) [rad]
else
    mup = zeros(1,3);
end

% [NOM , WORST = + , BEST = -]

% MLup1 (TC Up Carrier Mod Loss) calculation:
% ADV = [+ + +]     FAV = [- - -]
MLup1_TC = (MODU(1)==1) .* (-10*log10(besselj(0,mTC).^2));
MLup1_Mj = (MODU(3)==1) .* (-10*log10(besselj(0,Mup).^2));
MLup1_Mn = (MODU(3)==1) .* (-10*log10(besselj(0,mup).^2));
MLup1 = MLup1_TC + MLup1_Mj + MLup1_Mn;

% Total Carrier Suppression parzialization: 
% Contributes due to: TC - RG
parz1 = [MLup1_TC;MLup1_Mj];

% MLup2 (TC Mod Loss) calculation:
% ADV = [- + +]     FAV = [+ - -]
mTC2([1,2,3]) = mTC([1,3,2]);
MLup2_TC = MODU(1) .* (-10*log10(2*besselj(1,mTC2).^2));
MLup2_Mj = (MODU(3)==1) .* (-10*log10(besselj(0,Mup).^2));
MLup2_Mn = (MODU(3)==1) .* (-10*log10(besselj(0,mup).^2));
MLup2 = MLup2_TC + MLup2_Mj + MLup2_Mn;

% Total Telecommand Losses parzialization: 
% Contributes due to: Carrier - RG
parz2 = [MLup2_TC;MLup2_Mj];

% MLup3 (RG Up Carrier Mod Loss) calculation:
% ADV = [0 + +]     FAV = [0 - -]
MLup3_Mj = (MODU(2)==1) .* (-10*log10(besselj(0,Mup).^2));
MLup3_Mn = (MODU(2)==1) .* (-10*log10(besselj(0,mup).^2));
MLup3 = MLup3_Mj + MLup3_Mn;

% MLup4 (RG Major Tone Mod loss (up)) calculation:
% ADV = [+ - +]     FAV = [- + -]
if MODU(2)==1 || MODU(3)==1
    Mup2([1,2,3]) = Mup([1,3,2]);
    MLup4_TC = (MODU(3)==1) .* (-10*log10(besselj(0,mTC).^2));
    MLup4_Mj = -10*log10(2*besselj(1,Mup2).^2);
    MLup4_Mn = -10*log10(besselj(0,mup).^2);
else
    MLup4_TC = zeros(1,3);
    MLup4_Mj = zeros(1,3);
    MLup4_Mn = zeros(1,3);
end
MLup4 = MLup4_TC + MLup4_Mj + MLup4_Mn;

% Total Ranging Losses parzialization: 
% Contributes due to: Carrier - TM
parz4 = [MLup4_Mj;MLup4_TC];

% MLup5 (RG Minor Tone Mod loss (up)) calculation:
% ADV = [+ + -]     FAV = [- - +]
if MOD3==2 && (MODU(2)==1 || MODU(3)==1)
    mup2([1,2,3]) = mup([1,3,2]);
    MLup5_TC = (MODU(3)==1) .* (-10*log10(besselj(0,mTC).^2));
    MLup5_Mj = -10*log10(besselj(0,Mup).^2);
    MLup5_Mn = -10*log10(2*besselj(1,mup2).^2);
else
    MLup5_TC = zeros(1,3);
    MLup5_Mj = zeros(1,3);
    MLup5_Mn = zeros(1,3);
end
MLup5 = MLup5_TC + MLup5_Mj + MLup5_Mn;

end