function [MLdw1,MLdw2,MLdw3,MLdw4,parz1,parz2,parz3,mi_eff] = PMdir_dw(mod_ind,SN_MT_dB,SN_mt_dB, ...
            SN_TC_dB,SN_tot_lin,MODD,MOD3)
% PM direct Modulation in downlink

mTM = mod_ind(1,:);             % TM Carrier Modulation Index [rad]

if MODD(2)==1
    mdw = mod_ind(2,:);         % RG Tones Modulation Index (dw) [rad]
else
    mdw = zeros(1,3);
end

% Nominal Prefixed dw m/i (mdw) is modified (by the effect of noise
% accumulated in uplink -> Effective dw m/i must be calculated

% m/i ADV (+) -> mdw ADV (+), S/N FAV (+)

% S/N Ratios for recovered signals of TC, RG Major Tone, RG Minor Tone and Global S/N
% -> To be converted from [dB] to [linear]
SN_MT_lin = (MODD(2)==1) .* 10.^(SN_MT_dB/10);
SN_mt_lin = (MOD3==2) .* 10.^(SN_mt_dB/10);
SN_TC_lin = (MODD(3)==1) .* 10.^(SN_TC_dB/10);

SN_MT([1,2,3]) = SN_MT_lin([1,3,2]);
SN_mt([1,2,3]) = SN_mt_lin([1,3,2]);
SN_TC([1,2,3]) = SN_TC_lin([1,3,2]);
SN_tot([1,2,3]) = SN_tot_lin([1,3,2]);

mu_MT = mdw.*sqrt(SN_MT./SN_tot);           % Effective RG Major Tone m/i [rad pk]
mu_mt = mdw.*sqrt(SN_mt./SN_tot);           % Effective RG Minor Tone m/i [rad pk]
mu_TC = mdw.*sqrt(SN_TC./SN_tot);           % Effective Back TC m/i [rad pk]
mu_N = mdw./sqrt(2*SN_tot);                 % Effective Noise m/i [rad pk]

mi_eff = [mu_MT;mu_mt;mu_TC;mu_N];

% [NOM , WORST = + , BEST = -]
% NB: Per mu_N però vale [NOM , WORST = - , BEST = +]

% MLdw1 (Dw Carrier Mod Loss) calculation:
% ADV = [+ + + + -]     FAV = [- - - - +]
MLdw1_TM = -10*log10(cos(mTM).^2);
MLdw1_RG = -10*log10(besselj(0,mu_MT).^2);
MLdw1_TC = -10*log10(besselj(0,mu_TC).^2);
MLdw1_N = -10*log10(exp(-(mu_N).^2));
MLdw1_Mn = -10*log10(besselj(0,mu_mt).^2);
MLdw1 = MLdw1_TM + MLdw1_RG + MLdw1_TC + MLdw1_N + MLdw1_Mn;

% Total Carrier Suppression parzialization: 
% Contributes due to: TM - RG - TC echo - Noise
parz1 = [MLdw1_TM;MLdw1_RG;MLdw1_TC;MLdw1_N];

% MLdw2 (TM Mod Loss) calculation:
% ADV = [- + + + -]     FAV = [+ - - - +]
mTM2([1,2,3]) = mTM([1,3,2]);
MLdw2_TM = -10*log10(sin(mTM2).^2);
MLdw2_RG = -10*log10(besselj(0,mu_MT).^2);
MLdw2_TC = -10*log10(besselj(0,mu_TC).^2);
MLdw2_N = -10*log10(exp(-(mu_N).^2));
MLdw2_Mn = -10*log10(besselj(0,mu_mt).^2);
MLdw2 = MLdw2_TM + MLdw2_RG + MLdw2_TC + MLdw2_N + MLdw2_Mn;

% Total Telemetry Losses parzialization: 
% Contributes due to: Carrier - RG - TC echo - Noise
parz2 = [MLdw2_TM;MLdw2_RG;MLdw2_TC;MLdw2_N];

% MLdw3 (RG Major Tone Mod loss (dw)) calculation:
% ADV = [+ - - - +]     FAV = [- + + + -]
if MODD(2)==1
    mu_MT3([1,2,3]) = mu_MT([1,3,2]);
    mu_mt3([1,2,3]) = mu_mt([1,3,2]);
    mu_TC3([1,2,3]) = mu_TC([1,3,2]);
    mu_N3([1,2,3]) = mu_N([1,3,2]);
    MLdw3_TM = -10*log10(cos(mTM).^2);
    MLdw3_RG = -10*log10(2*besselj(1,mu_MT3).^2);
    MLdw3_TC = -10*log10(besselj(0,mu_TC3).^2);
    MLdw3_N = -10*log10(exp(-(mu_N3).^2));
    MLdw3_Mn = -10*log10(besselj(0,mu_mt3).^2);
else
    MLdw3_TM = zeros(1,3);
    MLdw3_RG = zeros(1,3);
    MLdw3_TC = zeros(1,3);
    MLdw3_N = zeros(1,3);
    MLdw3_Mn = zeros(1,3);
end
MLdw3 = MLdw3_TM + MLdw3_RG + MLdw3_TC + MLdw3_N + MLdw3_Mn;

% Total Ranging Losses parzialization: 
% Contributes due to: Carrier - TM - TC echo - Noise
parz3 = [MLdw3_RG;MLdw3_TM;MLdw3_TC;MLdw3_N];

% MLdw4 (RG Minor Tone Mod loss (dw)) calculation:
% ADV = [+ - - - +]     FAV = [- + + + -]
if MOD3==2 && MODD(2)==1
    MLdw4_TM = -10*log10(cos(mTM).^2);
    MLdw4_RG = -10*log10(besselj(0,mu_MT3).^2);
    MLdw4_TC = -10*log10(besselj(0,mu_TC3).^2);
    MLdw4_N = -10*log10(exp(-(mu_N3).^2));
    MLdw4_Mn = -10*log10(2*besselj(1,mu_mt3).^2);
else
    MLdw4_TM = zeros(1,3);
    MLdw4_RG = zeros(1,3);
    MLdw4_TC = zeros(1,3);
    MLdw4_N = zeros(1,3);
    MLdw4_Mn = zeros(1,3);
end
MLdw4 = MLdw4_TM + MLdw4_RG + MLdw4_TC + MLdw4_N + MLdw4_Mn;

end