function [ML1,ML2,ML3,ML4,ML5] = FSK(Delta_f,Rb,PCM)
% FSK direct Modulation in downlink
% There is no budget for Up Carrier Acquisition, because the carrier is suppressed.
% PSK Modulation is allowed for TC/TM ONLY
% Only MLup2 calculation is implemented

ML1 = zeros(1,3);
ML3 = zeros(1,3);
ML4 = zeros(1,3);
ML5 = zeros(1,3);

% Delta_f = frequency Deviation [kHz] (Downlink)

% The frequency of the wave is fm = Rb [Hz] (information Bit Rate, R_TM)

% beta = Equivalent Modulation Index, it determines the number of spectral
% components which are included in the Band of Carson (98% of Power)
beta = Delta_f*1000./(Rb.*PCM);

% NB: Rb is doubled in case of PCM signal type SP-L

z = [2*pi*(1+beta);4*pi*(1+beta)];

% sinint(z) is set to its asymptotic value pi/2 when z >= 16

Si_z = zeros(2,3);

for i=1:2
    if z(i,:) < 16
        Si_z(i,:) = sinint(z(i,:));
    else
        Si_z(i,:) = pi/2;
    end
end

A = (2/pi)*(Si_z(1,:) - sin(z(1,:)/2).^2 ./ (z(1,:)/2));
B = (2/pi)*(Si_z(2,:) - sin(z(2,:)/2).^2 ./ (z(2,:)/2));

if PCM==1               % PCM signal - type NRZ-L
    ML2 = -10*log10(A);
elseif PCM==2           % PCM signal - type SP-L
    ML2 = -10*log10(2*A - B);
end

end