function [MLup1,MLup2,MLup3,MLup4,MLup5] = FM(FM_freq,RG_freq,MODU,MOD3)
% FM Modulation
% As for PSK Modulation, it is considered the case of Green Carrier, so
% there is no budget for Up/RG Carrier Acquisition.

MLup1 = zeros(1,3);
MLup3 = zeros(1,3);

Delta_f = FM_freq(1,:);         % frequency Deviation [kHz] (Uplink)
f_TC = FM_freq(2,:);            % TC Subcarrier Frequency [kHz]

% beta2 (TC Mod) calculation:
beta(1,:) = Delta_f ./ f_TC;

% beta4 (RG Major Tone Mod) calculation:
if MODU(2)==1 || MODU(3)==1
    f_MT = RG_freq(1,:);            % RG Major Tone Frequency [kHz]
    beta(2,:) = Delta_f ./ f_MT;
    
    % beta5 (RG Minor Tone Mod) calculation:
    if MOD3 == 2
        f_mt = RG_freq(2,:);            % RG minor Tone Frequency [kHz]
        beta(3,:) = Delta_f ./ f_mt;
    else
        beta(3,:) = zeros(1,3);
    end

else
    beta(2,:) = zeros(1,3);
    beta(3,:) = zeros(1,3);
end


% MLup2/3/4 calculation:
MLup = zeros(3,3);
for i = 1:3
    if beta(i,1)+1 < 2
        MLup(i,:) = -10*log10(besselj(0,beta(i,:)).^2 + 2*besselj(1,beta(i,:)).^2);
    elseif beta(i,1)+1 >= 2 && beta(i,1)+1 < 3
        MLup(i,:) = -10*log10(besselj(0,beta(i,:)).^2 + 2*besselj(1,beta(i,:)).^2 ...
            + 2*besselj(2,beta(i,:)).^2);
    elseif beta(i,1)+1 >= 3 && beta(i,1)+1 < 4
        MLup(i,:) = -10*log10(besselj(0,beta(i,:)).^2 + 2*besselj(1,beta(i,:)).^2 ...
            + 2*besselj(2,beta(i,:)).^2 + 2*besselj(3,beta(i,:)).^2);
    elseif beta(i,1)+1 >= 4
        MLup(i,:) = -10*log10(besselj(0,beta(i,:)).^2 + 2*besselj(1,beta(i,:)).^2 ...
            + 2*besselj(2,beta(i,:)).^2 + 2*besselj(3,beta(i,:)).^2 ...
            + 2*besselj(4,beta(i,:)).^2);
    end
end

MLup2 = MLup(1,:);
MLup4 = MLup(2,:);
MLup5 = MLup(3,:);

end