const fs = require("fs");

const READ_DELAY = Math.floor(0.8 * 48000);

const results = [];

const array = [];

// checks if [lower1, upper1] Intersects [lower2, upper2]
const intersects = (lower1, upper1, lower2, upper2) => {
  if (lower1 > upper2 || lower2 > upper1) return false;
  return true;
};

const includes = (target, lower, upper) => {
  if (target >= lower && target <= upper) return true;
  return false;
};

for (let i = array.length - 1; i > 0; i--) {
  let foundMatch = false;
  const lower1 = array[i].client_read_clock - READ_DELAY;
  const upper1 = array[i].client_read_clock - READ_DELAY + array[i].n_samples;

  for (let j = i - 1; j >= 0; j--) {
    const lower2 = array[j].client_write_clock;
    const upper2 = array[j].client_write_clock + array[j].n_samples;
    // if (intersects(lower1, upper1, lower2, upper2)) {
    if (includes(lower1, lower2, upper2)) {
      results.push(array[i].received_timestamp - array[j].sent_timestamp);
      foundMatch = true;
      break;
    }
  }
  if (!foundMatch) console.log("no match found for index", i);
}
console.log(JSON.stringify(results));

fs.writeFile(
  "test_results/http3_three_users_in_call_sound_delay.txt",
  JSON.stringify(results),
  (err) => {
    if (err) {
      console.error(err);
    }
    // file written successfully
  }
);
