
import os
import numpy as np
import nibabel as nib
import monai.transforms as transforms

from glob import glob


def prepare_preditions(example):
    """
    Convert back to original BraTS orientation and save as NIfTI.
    :param example: example file
    :return: post-processed NIfTI file
    """
    fname = example[0].split("/")[-1].split(".")[0]
    prediction = np.load(example[0])
    prediction = np.transpose(prediction, (2, 1, 0))
    prediction[prediction < 0.0005] = 0.
    # Gaussian sharpen
    prediction = transforms.GaussianSharpen(sigma1=0.5, sigma2=0.5, alpha=10)(prediction)
    prediction[prediction < prediction[0, 0, 0] + 1e-6] = 0.
    # save as NIfTI
    img = nib.load(f"./data/BraTS2021_val/availables/{fname}.nii.gz")
    nib.save(
        nib.Nifti1Image(prediction.numpy(), img.affine, header=img.header),
        os.path.join("./results/final_preds", fname + ".nii.gz"),
    )


if __name__ == "__main__":
    os.makedirs("./results/final_preds")
    preds = sorted(glob(f"./results/predictions*"))
    examples = list(zip(*[sorted(glob(f"{p}/*.npy")) for p in preds]))
    print("Preparing final predictions")
    for example in examples:
        prepare_preditions(example)
    print("Finished!")
