# U-Net for Cross-Sequence Brain Magnetic Resonance Image (MRI) Translation

This repository provides an extended PyTorch implementation of the U-Net CNN proposed in ["Deep learning-based convolutional neural network for intramodality brain MRI synthesis"](https://pubmed.ncbi.nlm.nih.gov/35044073/). Please refer also to the [authors' original implementation on GitHub](https://github.com/afiosman/UNet-for-MR-to-MR-image-translation) for further details.

## Table of contents

- [Theoretical Background](#theoretical-background)
    * [BraTS 2021](#brats-2021)
- [Quick Start Guide](#quick-start-guide)

## Theoretical Background
Deep Learning (DL) has achieved state-of-the-art results in the medical field, with particular focus on radiology-related tasks. Still, it is a well-known fact that, in order to achieve such performances, DL algorithms require a huge amount of data for training. Unfortunately, the medical field often presents the data scarcity problem, with few scans available for analysis mainly due to the cost of expert-annotation. In the case of brain cancer patients, for example, the availability of multicontrast magnetic resonance (MR) images leads to an increase in the accessible information for the network and, consequently, in performance. This project tries to address the MR missing problem by implementing an U-Net architecture whose goal is to learn the non-linear translation across brain MRI contrasts. It also extends the [original implementation](https://github.com/afiosman/UNet-for-MR-to-MR-image-translation) by allowing multiple modalities input in order to exploit further contextual information.

### BraTS 2021
The RSNA ASNR MICCAI Brain Tumor Segmentation (BraTS) challenge  is a project started in 2012 in conjunction with the MICCAI conference with the goal of becoming the de facto benchmark for addressing the automated tumor sub-region segmentation from pre-operative multi-parametric Magnetic Resonance Imaging (mpMRI) scans. The BraTS 2021 dataset presents a collection of 1251 patients, each one presenting four scan modalities (FLAIR, T1, T1ce and T2), acquired with different apparati and protocols from several different institutions, thus presenting a highly heterogeneous image quality (please refer to ["The RSNA-ASNR-MICCAI BraTS 2021 Benchmark on Brain Tumor Segmentation and Radiogenomic Classification"](https://arxiv.org/abs/2107.02314) for further details). The proposed U-Net architecture will be trained on patients coming from such dataset with the goal of learning how to digitally reconstruct the missing sequences starting from the available ones. Here are presented the four standard modalities for two different patients from the BraTS 2021 dataset.

<img src="images/modalities_examples.png" width="1200"/>

## Quick Start Guide
To download the training and validation dataset, you need to have an account on https://www.synapse.org and be registered for the BraTS 2021 challenge. It is assumed as starting point that both .zip files for training and validation data are unzipped in the `/data` folder in the following way:
```
 /data
  │
  ├────BraTS2021_train
  │      ├──BraTS2021_00000
  │      │      └──BraTS2021_00000_flair.nii.gz
  │      │      └──BraTS2021_00000_t1.nii.gz
  │      │      └──BraTS2021_00000_t1ce.nii.gz
  │      │      └──BraTS2021_00000_t2.nii.gz
  │      ├──BraTS2021_00002
  │      │      └──BraTS2021_00002_flair.nii.gz
  │      ...    └──...
  │
  └────BraTS2021_val
         ├──BraTS2021_00001
         │      └──BraTS2021_00001_flair.nii.gz
         │      └──BraTS2021_00001_t1.nii.gz
         │      └──BraTS2021_00001_t1ce.nii.gz
         │      └──BraTS2021_00001_t2.nii.gz
         ├──BraTS2021_00002
         │      └──BraTS2021_00002_flair.nii.gz
         ...    └──...
```
As a first step, all available modalities are stacked in such a way that each input patient consists in a single tensor of shape (C, 240, 240, 155), where C is the number of modalities decided to take into account. Specifically, by calling
```
 python prepare.py [--available] {flair, t1, t1ce, t2} [--target] {flair, t1, t1ce, t2}
```
all specified available modalities will be prepared as described above, together with the designated target modality. The next step consists in preprocessing all patients by cropping the volume, normalizing the intensity, scaling the normalized intensities into the (0, 1) range and saving each £D scan as Numpy array by calling
```
 python preprocess.py --task train --exec_mode training
 python preprocess.py --task val --exec_mode test
```
At this point, calling `ls /data` should include the following four directories
```
 BraTS2021_train   BraTS2021_val   train_3d   val_3d
```
If that is the case, it is possible to procede with the actual training. By calling
```
 python ./main.py --dim 3 --depth 4 --filters 64 128 256 512 1024 64 --learning_rate 0.0003 --seed 42 --save_ckpt --epochs 100 --fold 0 --amp --gpus 1 --task train --tb_logs --scheduler
```
the 2D U-Net generator will start training for 150 epochs on the data contained in `/data/train_3d`, using mixed precision if `[--amp]` is included as argument. Once training is ended, it is possible to perform inference on the unseen patients contained in `/data/val_3d` by calling
```
 python ./main.py --dim 3 --depth 4 --filters 64 128 256 512 1024 64 --gpus 1 --fold 0 --amp --exec_mode predict --data ./data/val_3d/test --save_preds --ckpt_path ./results/checkpoints/foldA/epoch=BB-ssim=C.DD.ckpt
```
Inference is performed individually for each 3D scan. Inference prediction will be saved if `[--save_preds]` is present. Please substitute the checkpoint path with your own (by default, .ckpt files are saved in `./results/checkpoints/foldA`). Once the process is ended, by calling
```
 python ./postprocess.py
```
each synthesized precision will be re-oriented to match BraTS guidelines and, after some Gaussian sharpening, saved as final NIfTI file (by default, output files are saved in `./results/final_preds`). When performing modality transfer on custom private data, please rename each file as BraTS2021_*_{modality}.nii.gz, where * is an ID of your choice for identification.
