(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    603072,      13610]
NotebookOptionsPosition[    581363,      13251]
NotebookOutlinePosition[    581871,      13270]
CellTagsIndexPosition[    581828,      13267]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["COLLAGE solution +  ParB +SYMMETTRIC", "Title",
 CellChangeTimes->{{3.856942919201233*^9, 3.85694298216225*^9}, {
  3.856952720464478*^9, 3.856952726811193*^9}, {3.8637730475660257`*^9, 
  3.863773071751679*^9}, {3.8641893784760437`*^9, 3.864189382445861*^9}, {
  3.8667793215925093`*^9, 3.866779322114891*^9}, {3.8701734590314417`*^9, 
  3.870173461122712*^9}, {3.8732837100447493`*^9, 3.873283723036909*^9}, {
  3.874315288648995*^9, 
  3.874315295185431*^9}},ExpressionUUID->"5e68a840-5695-4b20-ab27-\
615771320821"],

Cell[CellGroupData[{

Cell["NOTBOOK CREATED JUST TO PRODUCE PLOTS!!", "Chapter",
 CellChangeTimes->{{3.874315299628475*^9, 
  3.874315314511209*^9}},ExpressionUUID->"f0f49cad-f21c-4e29-94be-\
1d0619cf1257"],

Cell[TextData[{
 "Merging this new solving scheme with the limited conservation of ParB is \
different now: when we solved with the \[Delta](x) the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["w", "on"], "would"}], TraditionalForm]],ExpressionUUID->
  "f91fa1dc-7ca5-4fbe-8141-b2ebe33fffd1"],
 " just disappear from the equations.\nIn this model we have a system 2*L \
long, and a ParS domain long 2*di. \nIn this model instead of having ParS in \
the origin we put the origin \[OpenCurlyDoubleQuote]between one ParS and the \
other one\[CloseCurlyDoubleQuote]."
}], "Text",
 CellChangeTimes->{{3.8711017397577257`*^9, 3.8711018110087967`*^9}, {
  3.8732843783402643`*^9, 3.8732844040752172`*^9}, {3.873284484697947*^9, 
  3.8732846325008307`*^9}, {3.8735046533275623`*^9, 
  3.873504655319363*^9}},ExpressionUUID->"ec134919-5e8f-40e1-b829-\
d32523a3f103"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.873438095338348*^9, 3.8734380953395653`*^9}, {
   3.8734381331256247`*^9, 3.8734381500811453`*^9}, 3.873504646395485*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"ab62c68a-7687-4d90-8910-f65c8ec5063a"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Rho]", "\[Infinity]"], TraditionalForm]],ExpressionUUID->
  "3a333bc0-a1c5-436d-b7a3-a5b9dc39fd61"],
 " distribution"
}], "Section",
 CellChangeTimes->{{3.871055721382749*^9, 3.8710557304794827`*^9}, {
  3.8710557648240423`*^9, 
  3.871055773748958*^9}},ExpressionUUID->"57593b15-bd54-4f15-b54e-\
28927b414cc1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Ws", "=", 
   RowBox[{"-", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["k", "off"]}], " ", "-", 
         RowBox[{
          SubscriptBox["\[Gamma]", "oc"], 
          SubscriptBox["k", 
           RowBox[{"oc", " "}]]}]}], ",", " ", 
        RowBox[{
         RowBox[{"+", 
          SubscriptBox["\[Gamma]", "co"]}], 
         SubscriptBox["k", "co"]}]}], " ", "}"}], ",", "\[IndentingNewLine]", 
      "                     ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[Gamma]", "oc"], 
         SubscriptBox["k", "oc"]}], " ", ",", " ", 
        RowBox[{
         RowBox[{"-", " ", 
          SubscriptBox["\[Gamma]", "co"]}], 
         SubscriptBox["k", "co"]}]}], " ", "}"}]}], "}"}]}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.8569430553440437`*^9, 3.8569431069174843`*^9}, 
   3.856943333672545*^9, {3.8569434046108027`*^9, 3.856943422673024*^9}, {
   3.85763623653333*^9, 3.857636245285993*^9}, {3.8611028611807623`*^9, 
   3.861102862629772*^9}, {3.861872792054578*^9, 3.8618728120927277`*^9}, {
   3.861872930627611*^9, 3.861873011798237*^9}, {3.870173466425888*^9, 
   3.870173564183374*^9}, {3.870173663171897*^9, 3.870173680151472*^9}, {
   3.870319377814283*^9, 3.8703193837142553`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"5abff06d-aac8-4af6-a09b-8adecbf3271d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"W", "  ", "=", 
   RowBox[{"-", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SubscriptBox["k", "off"]}], " ", "-", " ", 
         SubscriptBox["k", 
          RowBox[{"oc", " "}]]}], ",", " ", 
        RowBox[{"+", 
         SubscriptBox["k", "co"]}]}], " ", "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["k", "oc"], " ", ",", " ", 
        RowBox[{"-", " ", 
         SubscriptBox["k", "co"]}]}], " ", "}"}]}], "}"}]}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.856943003968009*^9, 3.8569430370628357`*^9}, {
  3.856943344858469*^9, 3.8569433559214582`*^9}, {3.8576361957548103`*^9, 
  3.857636206317915*^9}, {3.8576362650557623`*^9, 3.857636266949959*^9}, {
  3.864209513443884*^9, 3.864209514037374*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"63de950c-ff95-4ae7-bee2-1f4e3b8a7103"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["D", "o"], " ", ",", " ", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", " ", ",", " ", 
        SubscriptBox["D", "c"]}], "}"}]}], "}"}]}], ";"}], " "}]], "Input",
 CellChangeTimes->{{3.856943118804317*^9, 3.8569431350842247`*^9}, 
   3.857636274009564*^9, {3.864210340144663*^9, 3.864210379604312*^9}, {
   3.870173567788436*^9, 3.870173569579303*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"3705c23f-518d-4d92-9cf6-e5128b9191c4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"cc", "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["w", "on"], ",", "0"}], " ", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.856943160280342*^9, 3.8569431748869047`*^9}, {
   3.857636372545953*^9, 3.857636372799261*^9}, 3.8641170861664047`*^9, {
   3.873799574007967*^9, 3.87379958795649*^9}, {3.873799711473896*^9, 
   3.8737997119644833`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"69ce6edc-cf12-4847-b384-63ea52f98507"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"z", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", "W", "]"}], ".", "cc"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"zs", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Inverse", "[", "Ws", "]"}], ".", "cc"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.863771818536887*^9, 3.86377182360987*^9}, {
   3.863771875759652*^9, 3.863771887688586*^9}, 3.864117079325006*^9, 
   3.865306444056988*^9, 3.865307705693894*^9, 3.865310954092185*^9, 
   3.865504182183757*^9, 3.8655046948770437`*^9, {3.870173722957818*^9, 
   3.870173742618903*^9}, {3.87017382041512*^9, 3.870173857543082*^9}, 
   3.870335359353829*^9, 3.87379958182495*^9, 3.873799702531816*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"8221fea6-8128-4dca-9276-fc1808364d09"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SubscriptBox["w", "on"], 
    SubscriptBox["k", "off"]], ",", 
   FractionBox[
    RowBox[{
     SubscriptBox["k", "oc"], " ", 
     SubscriptBox["w", "on"]}], 
    RowBox[{
     SubscriptBox["k", "co"], " ", 
     SubscriptBox["k", "off"]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.870173822719369*^9, {3.870173858548643*^9, 3.870173885094544*^9}, 
   3.870176945118678*^9, 3.870176990674341*^9, 3.8701771120315657`*^9, 
   3.870232133278675*^9, 3.870232338050756*^9, 3.870256412753853*^9, 
   3.8703169915204153`*^9, 3.870317862282497*^9, 3.870319164644059*^9, 
   3.870320897837184*^9, 3.8703211991629477`*^9, 3.870326278518116*^9, 
   3.870330025431603*^9, 3.870335359600107*^9, 3.870348420891384*^9, 
   3.870348491603867*^9, 3.870858047141548*^9, 3.870863871295278*^9, 
   3.870929851858962*^9, 3.87094016711451*^9, 3.8710258165431833`*^9, 
   3.871055865662258*^9, 3.871099897715138*^9, 3.8711010143729153`*^9, {
   3.8711015123414288`*^9, 3.871101539806198*^9}, {3.8711019435433292`*^9, 
   3.871101965270208*^9}, 3.871102294965541*^9, 3.871103057858189*^9, 
   3.871103500206682*^9, 3.873284300413348*^9, 3.873368524362854*^9, 
   3.8734366725218163`*^9, {3.873439142508606*^9, 3.8734391593683233`*^9}, 
   3.8734419049466553`*^9, 3.873456242195323*^9, 3.873699674393271*^9, 
   3.8737861017974653`*^9, 3.873799182869375*^9, {3.8737996178523617`*^9, 
   3.873799631569777*^9}, 3.873800089400592*^9, 3.874231940848319*^9, 
   3.874315711691432*^9, 3.8743181037242393`*^9, 3.874324074357109*^9, 
   3.8743845525524387`*^9, 3.874388676805399*^9, 3.874389652802854*^9, 
   3.874476374947187*^9, 3.874491261586755*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"5da22d1c-60a0-4152-a47e-ee2e4606bac5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SubscriptBox["w", "on"], 
    SubscriptBox["k", "off"]], ",", 
   FractionBox[
    RowBox[{
     SubscriptBox["k", "oc"], " ", 
     SubscriptBox["w", "on"], " ", 
     SubscriptBox["\[Gamma]", "oc"]}], 
    RowBox[{
     SubscriptBox["k", "co"], " ", 
     SubscriptBox["k", "off"], " ", 
     SubscriptBox["\[Gamma]", "co"]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.870173822719369*^9, {3.870173858548643*^9, 3.870173885094544*^9}, 
   3.870176945118678*^9, 3.870176990674341*^9, 3.8701771120315657`*^9, 
   3.870232133278675*^9, 3.870232338050756*^9, 3.870256412753853*^9, 
   3.8703169915204153`*^9, 3.870317862282497*^9, 3.870319164644059*^9, 
   3.870320897837184*^9, 3.8703211991629477`*^9, 3.870326278518116*^9, 
   3.870330025431603*^9, 3.870335359600107*^9, 3.870348420891384*^9, 
   3.870348491603867*^9, 3.870858047141548*^9, 3.870863871295278*^9, 
   3.870929851858962*^9, 3.87094016711451*^9, 3.8710258165431833`*^9, 
   3.871055865662258*^9, 3.871099897715138*^9, 3.8711010143729153`*^9, {
   3.8711015123414288`*^9, 3.871101539806198*^9}, {3.8711019435433292`*^9, 
   3.871101965270208*^9}, 3.871102294965541*^9, 3.871103057858189*^9, 
   3.871103500206682*^9, 3.873284300413348*^9, 3.873368524362854*^9, 
   3.8734366725218163`*^9, {3.873439142508606*^9, 3.8734391593683233`*^9}, 
   3.8734419049466553`*^9, 3.873456242195323*^9, 3.873699674393271*^9, 
   3.8737861017974653`*^9, 3.873799182869375*^9, {3.8737996178523617`*^9, 
   3.873799631569777*^9}, 3.873800089400592*^9, 3.874231940848319*^9, 
   3.874315711691432*^9, 3.8743181037242393`*^9, 3.874324074357109*^9, 
   3.8743845525524387`*^9, 3.874388676805399*^9, 3.874389652802854*^9, 
   3.874476374947187*^9, 3.874491261591117*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"4b766eb1-1aed-4ab9-821b-6446d009ffe7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eq", "=", 
  RowBox[{"R", "==", 
   RowBox[{"Simplify", "[", " ", 
    RowBox[{
     RowBox[{"Total", "[", "z", "]"}], " ", "/.", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "\[Rule]", " ", 
      RowBox[{
       SubscriptBox["k", "on"], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["N", "tot"], "-", "\[Delta]N", "-", 
          RowBox[{"R", "*", "2", "L"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "L"}], ")"}]}]}]}]}], " ", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.87105584939095*^9, 3.871055873837062*^9}, {
  3.8710559683518333`*^9, 3.8710560182367*^9}, {3.871101489959835*^9, 
  3.871101524445828*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"60e2b40a-6321-4d29-8a33-2620d25f5597"],

Cell[BoxData[
 RowBox[{"R", "\[Equal]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["k", "co"], "+", 
       SubscriptBox["k", "oc"]}], ")"}], " ", 
     SubscriptBox["k", "on"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "L", " ", "R"}], "+", "\[Delta]N", "-", 
       SubscriptBox["N", "tot"]}], ")"}]}], 
    RowBox[{"2", " ", "L", " ", 
     SubscriptBox["k", "co"], " ", 
     SubscriptBox["k", "off"]}]]}]}]], "Output",
 CellChangeTimes->{{3.871055860243046*^9, 3.8710558745698*^9}, {
   3.871055971782454*^9, 3.871056018820939*^9}, 3.8710998996699543`*^9, 
   3.8711010163770447`*^9, {3.871101515517373*^9, 3.871101542873639*^9}, 
   3.8711019653407993`*^9, 3.871102295028294*^9, 3.8711030579187183`*^9, 
   3.871103500301792*^9, 3.87328430047823*^9, 3.873368524414132*^9, 
   3.873436672556765*^9, 3.8734391594207706`*^9, 3.873441904987178*^9, 
   3.873456242246601*^9, 3.8736996744442663`*^9, 3.873786101836012*^9, 
   3.8737991829347267`*^9, 3.873799631624284*^9, 3.873800089460609*^9, 
   3.874231940907819*^9, 3.874315711749827*^9, 3.874318103789546*^9, 
   3.8743240743848457`*^9, 3.8743845525946198`*^9, 3.874388676855364*^9, 
   3.874389652847597*^9, 3.874476374986207*^9, 3.874491261627358*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"2de70589-4b80-4e86-83f4-6aabecc91e0f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sub", "=", "  ", 
   RowBox[{"Simplify", "[", " ", 
    RowBox[{"Solve", "[", 
     RowBox[{"eq", ",", "R"}], "]"}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["R", "sum"], "=", " ", 
  RowBox[{"R", " ", "/.", " ", 
   RowBox[{"sub", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]}], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"f0c3e516-3b8d-454f-8ae2-25e2e7a3ab3d"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["k", "co"], "+", 
      SubscriptBox["k", "oc"]}], ")"}], " ", 
    SubscriptBox["k", "on"], " ", 
    RowBox[{"(", 
     RowBox[{"\[Delta]N", "-", 
      SubscriptBox["N", "tot"]}], ")"}]}], 
   RowBox[{"2", " ", "L", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["k", "oc"], " ", 
       SubscriptBox["k", "on"]}], "+", 
      RowBox[{
       SubscriptBox["k", "co"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["k", "off"], "+", 
         SubscriptBox["k", "on"]}], ")"}]}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{
  3.871056031963723*^9, 3.8710998997649527`*^9, 3.871101016422081*^9, {
   3.871101515570553*^9, 3.87110154292871*^9}, 3.871101965425198*^9, 
   3.871102295090457*^9, 3.871103057978904*^9, 3.871103500376357*^9, 
   3.8732843005441933`*^9, 3.8733685244638453`*^9, 3.873436672593072*^9, 
   3.873439159473477*^9, 3.8734419050312357`*^9, 3.873456242294195*^9, 
   3.873699674500443*^9, 3.873786101872055*^9, 3.873799182995346*^9, 
   3.873799631677479*^9, 3.873800089522777*^9, 3.874231940964344*^9, 
   3.874315711800687*^9, 3.874318103854755*^9, 3.8743240744134293`*^9, 
   3.8743845526406918`*^9, 3.874388676897767*^9, 3.874389652889923*^9, 
   3.874476375023266*^9, 3.874491261660164*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"56925133-f85c-4148-9f8b-8d460cb7ec5f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   SubscriptBox["w", "on"], "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "on"], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["N", "tot"], "-", "\[Delta]N", "-", 
         RowBox[{"R", "*", "2", "*", "L"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "L"}], ")"}]}]}], " ", "/.", " ", 
     RowBox[{"R", " ", "\[Rule]", " ", 
      SubscriptBox["R", "sum"]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.871102075658369*^9, 3.871102149759274*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"c8560aa8-b81c-498d-ab17-ccdd766a0192"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SubscriptBox["k", "co"], " ", 
    SubscriptBox["k", "off"], " ", 
    SubscriptBox["k", "on"], " ", 
    RowBox[{"(", 
     RowBox[{"\[Delta]N", "-", 
      SubscriptBox["N", "tot"]}], ")"}]}], 
   RowBox[{"2", " ", "L", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["k", "oc"], " ", 
       SubscriptBox["k", "on"]}], "+", 
      RowBox[{
       SubscriptBox["k", "co"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["k", "off"], "+", 
         SubscriptBox["k", "on"]}], ")"}]}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.8711021283586903`*^9, 3.871102150033555*^9}, 
   3.871102295151916*^9, 3.8711030580376043`*^9, 3.8711035004462433`*^9, 
   3.873284300600037*^9, 3.873368524513143*^9, 3.873436672622047*^9, 
   3.873439159520009*^9, 3.873441905065838*^9, 3.873456242336266*^9, 
   3.873699674546301*^9, 3.8737861019070063`*^9, 3.873799183055665*^9, 
   3.873799631727447*^9, 3.873800089580656*^9, 3.874231941021377*^9, 
   3.874315711854951*^9, 3.8743181039189777`*^9, 3.874324074436849*^9, 
   3.8743845526850224`*^9, 3.874388676938211*^9, 3.87438965293044*^9, 
   3.874476375057529*^9, 3.874491261692545*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"94022bbf-fb00-41bf-b207-4cf56ac88a9a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Rho]", "inf"], "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox[
        SubscriptBox["R", "sum"], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["k", "co"], "+", 
          SubscriptBox["k", "oc"]}], ")"}]], "*", 
       SubscriptBox["k", "co"]}], ",", 
      RowBox[{
       FractionBox[
        SubscriptBox["R", "sum"], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["k", "co"], "+", 
          SubscriptBox["k", "oc"]}], ")"}]], "*", 
       SubscriptBox["k", "oc"]}]}], "}"}]}], ";"}], "*)"}]], "Input",
 CellChangeTimes->{{3.871102044329105*^9, 3.871102050065613*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"e3ca6e70-ed35-45ab-9fbf-2109a6055134"],

Cell[TextData[{
 "Now that the expression of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["w", 
    RowBox[{"on", " "}]], TraditionalForm]],ExpressionUUID->
  "0b3b3040-bc0b-4be5-b30d-d4014e0dad18"],
 "has been updated, the \[Delta]N (number of dimers in the space dependent \
solution) is present in the 2 flat concentration z and zs"
}], "Text",
 CellChangeTimes->{{3.871102195476699*^9, 3.8711022833938427`*^9}, {
  3.873283969076892*^9, 
  3.873283969221025*^9}},ExpressionUUID->"6596a6d5-9b51-4e79-b00a-\
9c9798d9304b"],

Cell["This expressio", "Text",
 CellChangeTimes->{{3.873369677715534*^9, 
  3.873369680478911*^9}},ExpressionUUID->"c2322349-cec7-4569-97dc-\
a15c9354deef"],

Cell[CellGroupData[{

Cell[BoxData["z"], "Input",
 CellChangeTimes->{3.8711021595951633`*^9},
 CellLabel->"In[13]:=",ExpressionUUID->"8bd3a987-a9d3-4aa7-a6dd-fea427c07af8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SubscriptBox["k", "co"], " ", 
      SubscriptBox["k", "on"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Delta]N", "-", 
        SubscriptBox["N", "tot"]}], ")"}]}], 
     RowBox[{"2", " ", "L", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["k", "oc"], " ", 
         SubscriptBox["k", "on"]}], "+", 
        RowBox[{
         SubscriptBox["k", "co"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["k", "off"], "+", 
           SubscriptBox["k", "on"]}], ")"}]}]}], ")"}]}]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SubscriptBox["k", "oc"], " ", 
      SubscriptBox["k", "on"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Delta]N", "-", 
        SubscriptBox["N", "tot"]}], ")"}]}], 
     RowBox[{"2", " ", "L", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["k", "oc"], " ", 
         SubscriptBox["k", "on"]}], "+", 
        RowBox[{
         SubscriptBox["k", "co"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["k", "off"], "+", 
           SubscriptBox["k", "on"]}], ")"}]}]}], ")"}]}]]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.871102170110855*^9, 3.8711022952517147`*^9, 
  3.871103058103045*^9, 3.8711035005222197`*^9, 3.873284300671997*^9, 
  3.873368524572341*^9, 3.8734366726583567`*^9, 3.873439160723737*^9, 
  3.8734419051074*^9, 3.87345624238628*^9, 3.8736996746077023`*^9, 
  3.873786101949625*^9, 3.873799183184019*^9, 3.873799631798069*^9, 
  3.873800089645195*^9, 3.8742319410830393`*^9, 3.8743157119175777`*^9, 
  3.874318103992057*^9, 3.87432407447234*^9, 3.874384552745434*^9, 
  3.8743886769875402`*^9, 3.874389652980472*^9, 3.874476375099846*^9, 
  3.8744912617272797`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"b526bb9d-c4ef-45af-9abe-b732389c8e8f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["zs"], "Input",
 CellChangeTimes->{{3.871102166037283*^9, 3.87110216627208*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"d07dd06b-3b45-447f-b034-43c90f7ab1cd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SubscriptBox["k", "co"], " ", 
      SubscriptBox["k", "on"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Delta]N", "-", 
        SubscriptBox["N", "tot"]}], ")"}]}], 
     RowBox[{"2", " ", "L", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["k", "oc"], " ", 
         SubscriptBox["k", "on"]}], "+", 
        RowBox[{
         SubscriptBox["k", "co"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["k", "off"], "+", 
           SubscriptBox["k", "on"]}], ")"}]}]}], ")"}]}]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SubscriptBox["k", "oc"], " ", 
      SubscriptBox["k", "on"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Delta]N", "-", 
        SubscriptBox["N", "tot"]}], ")"}], " ", 
      SubscriptBox["\[Gamma]", "oc"]}], 
     RowBox[{"2", " ", "L", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["k", "oc"], " ", 
         SubscriptBox["k", "on"]}], "+", 
        RowBox[{
         SubscriptBox["k", "co"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["k", "off"], "+", 
           SubscriptBox["k", "on"]}], ")"}]}]}], ")"}], " ", 
      SubscriptBox["\[Gamma]", "co"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8711021601246767`*^9, 3.871102166564064*^9}, 
   3.871102295318152*^9, 3.871103058155879*^9, 3.8711035005854063`*^9, 
   3.873284300766433*^9, 3.8733685246231413`*^9, 3.8734366726863003`*^9, 
   3.873439161819178*^9, 3.873441905137594*^9, 3.87345624243815*^9, 
   3.873699674649987*^9, 3.8737861019901752`*^9, 3.873799183271935*^9, 
   3.8737996318626747`*^9, 3.8738000897032967`*^9, 3.874231941135553*^9, 
   3.874315711972238*^9, 3.874318104056916*^9, 3.8743240744976053`*^9, 
   3.8743845527952414`*^9, 3.874388677027132*^9, 3.8743896530232*^9, 
   3.874476375133217*^9, 3.874491261752263*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"5180799f-dc09-42be-a235-99cda2b2e732"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Solving the system", "Section"]], "Subsection",
 CellChangeTimes->{{3.8641018598062687`*^9, 
  3.8641018741358547`*^9}},ExpressionUUID->"9d26a5f2-0957-4c2b-a045-\
ccdb8f9b0c4d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "d", "]"}], ".", "W"}]}], ";"}]], "Input",
 CellChangeTimes->{3.864117088646833*^9},
 CellLabel->"In[15]:=",ExpressionUUID->"98193d95-5b3b-4497-9009-8c64c293de88"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eig", "=", 
  RowBox[{"Simplify", "[", " ", 
   RowBox[{"Eigenvalues", "[", "B", "]"}], " ", "]"}]}]], "Input",
 CellChangeTimes->{
  3.865307689947167*^9, 3.865310979722124*^9, 3.865311559323195*^9, {
   3.865504188492649*^9, 3.865504193109667*^9}, 3.865504706354671*^9, {
   3.866779612883171*^9, 3.8667796164027853`*^9}, 3.8701735877816563`*^9},
 CellLabel->"In[16]:=",ExpressionUUID->"efccc9ec-c5d8-4b63-bcd6-1e0cd81ae83c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      SubscriptBox["D", "o"], " ", 
      SubscriptBox["k", "co"]}], "+", 
     RowBox[{
      SubscriptBox["D", "c"], " ", 
      SubscriptBox["k", "oc"]}], "+", 
     RowBox[{
      SubscriptBox["D", "c"], " ", 
      SubscriptBox["k", "off"]}], "-", 
     SqrtBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SubscriptBox["D", "c"], " ", 
        SubscriptBox["D", "o"], " ", 
        SubscriptBox["k", "co"], " ", 
        SubscriptBox["k", "off"]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["D", "o"], " ", 
           SubscriptBox["k", "co"]}], "+", 
          RowBox[{
           SubscriptBox["D", "c"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["k", "oc"], "+", 
             SubscriptBox["k", "off"]}], ")"}]}]}], ")"}], "2"]}]]}], 
    RowBox[{"2", " ", 
     SubscriptBox["D", "c"], " ", 
     SubscriptBox["D", "o"]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      SubscriptBox["D", "o"], " ", 
      SubscriptBox["k", "co"]}], "+", 
     RowBox[{
      SubscriptBox["D", "c"], " ", 
      SubscriptBox["k", "oc"]}], "+", 
     RowBox[{
      SubscriptBox["D", "c"], " ", 
      SubscriptBox["k", "off"]}], "+", 
     SqrtBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SubscriptBox["D", "c"], " ", 
        SubscriptBox["D", "o"], " ", 
        SubscriptBox["k", "co"], " ", 
        SubscriptBox["k", "off"]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["D", "o"], " ", 
           SubscriptBox["k", "co"]}], "+", 
          RowBox[{
           SubscriptBox["D", "c"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["k", "oc"], "+", 
             SubscriptBox["k", "off"]}], ")"}]}]}], ")"}], "2"]}]]}], 
    RowBox[{"2", " ", 
     SubscriptBox["D", "c"], " ", 
     SubscriptBox["D", "o"]}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.870173588002548*^9, 3.87017388492253*^9, 3.8701769448775587`*^9, 
   3.870176990459854*^9, 3.870177111831716*^9, 3.870232133064822*^9, 
   3.8702564125048*^9, 3.870316991342815*^9, 3.870317862114483*^9, 
   3.870319164472865*^9, 3.870320897633988*^9, 3.8703211989340773`*^9, 
   3.8703262782085543`*^9, 3.8703300251994123`*^9, 3.870348420648628*^9, 
   3.870348491500889*^9, 3.8708580469176064`*^9, 3.8708638710888166`*^9, 
   3.870929851691416*^9, 3.870940166871992*^9, 3.871025816315794*^9, 
   3.8710558654539843`*^9, 3.8710998974899797`*^9, 3.8711010141637163`*^9, {
   3.871101512147801*^9, 3.871101539612741*^9}, 3.871101965751786*^9, 
   3.871102295520104*^9, 3.8711030583439093`*^9, 3.8711035007841263`*^9, 
   3.873284300965213*^9, 3.873368524790043*^9, 3.8734366728514767`*^9, 
   3.873439162045362*^9, 3.8734419053020153`*^9, 3.873456242609673*^9, 
   3.8736996749876966`*^9, 3.873786102146172*^9, 3.873799183484427*^9, 
   3.8737996330392227`*^9, 3.873800089895009*^9, 3.874231941319539*^9, 
   3.874315718887933*^9, 3.874318105202104*^9, 3.874324074654714*^9, 
   3.8743845529716673`*^9, 3.874388677175335*^9, 3.8743896532017612`*^9, 
   3.874476375298917*^9, 3.874491261891128*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"2e25ebbb-e210-48ac-9393-c927539c2785"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Bs", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", "d", "]"}], ".", "Ws"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"eigs", "=", 
  RowBox[{"Simplify", "[", " ", 
   RowBox[{"Eigenvalues", "[", "Bs", "]"}], " ", "]"}]}]}], "Input",
 CellChangeTimes->{{3.8701736174381313`*^9, 3.87017365510198*^9}, {
  3.870173688775218*^9, 3.870173703988287*^9}, {3.870256475076434*^9, 
  3.8702564766323137`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"29726819-8374-4bb3-999d-50fcb837e098"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      SubscriptBox["D", "c"], " ", 
      SubscriptBox["k", "off"]}], "+", 
     RowBox[{
      SubscriptBox["D", "o"], " ", 
      SubscriptBox["k", "co"], " ", 
      SubscriptBox["\[Gamma]", "co"]}], "+", 
     RowBox[{
      SubscriptBox["D", "c"], " ", 
      SubscriptBox["k", "oc"], " ", 
      SubscriptBox["\[Gamma]", "oc"]}], "-", 
     SqrtBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SubscriptBox["D", "c"], " ", 
        SubscriptBox["D", "o"], " ", 
        SubscriptBox["k", "co"], " ", 
        SubscriptBox["k", "off"], " ", 
        SubscriptBox["\[Gamma]", "co"]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["D", "o"], " ", 
           SubscriptBox["k", "co"], " ", 
           SubscriptBox["\[Gamma]", "co"]}], "+", 
          RowBox[{
           SubscriptBox["D", "c"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["k", "off"], "+", 
             RowBox[{
              SubscriptBox["k", "oc"], " ", 
              SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}]}], ")"}], "2"]}]]}], 
    RowBox[{"2", " ", 
     SubscriptBox["D", "c"], " ", 
     SubscriptBox["D", "o"]}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      SubscriptBox["D", "c"], " ", 
      SubscriptBox["k", "off"]}], "+", 
     RowBox[{
      SubscriptBox["D", "o"], " ", 
      SubscriptBox["k", "co"], " ", 
      SubscriptBox["\[Gamma]", "co"]}], "+", 
     RowBox[{
      SubscriptBox["D", "c"], " ", 
      SubscriptBox["k", "oc"], " ", 
      SubscriptBox["\[Gamma]", "oc"]}], "+", 
     SqrtBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SubscriptBox["D", "c"], " ", 
        SubscriptBox["D", "o"], " ", 
        SubscriptBox["k", "co"], " ", 
        SubscriptBox["k", "off"], " ", 
        SubscriptBox["\[Gamma]", "co"]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["D", "o"], " ", 
           SubscriptBox["k", "co"], " ", 
           SubscriptBox["\[Gamma]", "co"]}], "+", 
          RowBox[{
           SubscriptBox["D", "c"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["k", "off"], "+", 
             RowBox[{
              SubscriptBox["k", "oc"], " ", 
              SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}]}], ")"}], "2"]}]]}], 
    RowBox[{"2", " ", 
     SubscriptBox["D", "c"], " ", 
     SubscriptBox["D", "o"]}]]}], "}"}]], "Output",
 CellChangeTimes->{{3.870173642050311*^9, 3.8701736552968693`*^9}, {
   3.8701736902812223`*^9, 3.8701737047742643`*^9}, 3.870173885025681*^9, 
   3.870176945073846*^9, 3.870176990637651*^9, 3.8701771119749537`*^9, 
   3.870232133220312*^9, 3.870256412694936*^9, 3.870256478634966*^9, 
   3.870316991456759*^9, 3.870317862215233*^9, 3.870319164599278*^9, 
   3.870320897762294*^9, 3.870321199094803*^9, 3.870326278446814*^9, 
   3.8703300253503523`*^9, 3.8703484207946444`*^9, 3.870348491550127*^9, 
   3.870858047066934*^9, 3.870863871239194*^9, 3.870929851799469*^9, 
   3.870940167029543*^9, 3.8710258164705563`*^9, 3.871055865610125*^9, 
   3.871099897637685*^9, 3.871101014314124*^9, {3.8711015122938843`*^9, 
   3.87110153975739*^9}, 3.871101965896665*^9, 3.871102295718264*^9, 
   3.8711030584861927`*^9, 3.871103500949374*^9, 3.873284301118024*^9, 
   3.8733685249372883`*^9, 3.873436679731325*^9, 3.873439162212667*^9, 
   3.873441905412437*^9, 3.873456242730632*^9, 3.873699675188778*^9, 
   3.873786102252288*^9, 3.873799183632452*^9, 3.87379963429627*^9, 
   3.873800090041284*^9, 3.874231941465877*^9, 3.874315719442533*^9, 
   3.874318106540757*^9, 3.8743240748049088`*^9, 3.874384553077108*^9, 
   3.874388677320641*^9, 3.874389653343953*^9, 3.874476375443713*^9, 
   3.8744912620259743`*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"c235c802-0dd4-4f57-af42-2c5125740b7e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Id", "=", 
   RowBox[{"IdentityMatrix", "[", "2", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.85694325274536*^9, 3.856943255884211*^9}, 
   3.856943287296959*^9, {3.856943488230226*^9, 3.8569435049642076`*^9}, {
   3.856961559526307*^9, 3.8569615636998034`*^9}, 3.864117074739027*^9},
 CellLabel->"In[19]:=",ExpressionUUID->"cc22fc24-0c11-4cb0-9337-b22687db6f2e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"U", "=", 
   RowBox[{"FullSimplify", "[", "  ", 
    RowBox[{"Transpose", "[", " ", 
     RowBox[{"Eigenvectors", "[", "B", "]"}], "    ", "]"}], "]"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Us", "=", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"Transpose", "[", " ", 
     RowBox[{"Eigenvectors", "[", "Bs", "]"}], " ", "]"}], "]"}]}], " ", 
  ";"}]}], "Input",
 CellChangeTimes->{
  3.864117062650276*^9, {3.8701737865740223`*^9, 3.87017380143622*^9}, 
   3.87017389064284*^9, {3.870339644735305*^9, 3.870339664386449*^9}, {
   3.871055696247015*^9, 3.871055699831359*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"29049ddc-b7ae-4181-bff0-d5e2b54618e3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"B", ".", "U"}], ";"}]], "Input",
 CellChangeTimes->{{3.870335797737315*^9, 3.8703358338488398`*^9}, 
   3.8710557042654657`*^9},
 CellLabel->"In[22]:=",ExpressionUUID->"cd3ec990-8a3d-4569-9869-0817b33e0adf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Ui", "  ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Inverse", "[", "U", "]"}], "   ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Uis", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Inverse", "[", "Us", "]"}], " ", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.85694429053265*^9, 3.856944304953683*^9}, 
   3.864117060835668*^9, {3.866779744475854*^9, 3.866779746822467*^9}, {
   3.870173905450976*^9, 3.870173915739662*^9}, {3.8703168103777647`*^9, 
   3.8703168242131968`*^9}, 3.870317049020993*^9},
 CellLabel->"In[23]:=",ExpressionUUID->"1cdb2e63-604e-4565-be6d-b03c6f45feb3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["The two solutions", "Section",
 CellChangeTimes->{{3.870174014329442*^9, 3.870174036759753*^9}, {
  3.8701745957509212`*^9, 
  3.870174599396968*^9}},ExpressionUUID->"100e28e0-fb31-40db-9388-\
e5aa00f624c0"],

Cell[CellGroupData[{

Cell["Non Special DNA", "Subsubsection",
 CellChangeTimes->{{3.870174603122951*^9, 3.870174605469286*^9}, {
  3.8701746870818768`*^9, 
  3.870174690003088*^9}},ExpressionUUID->"cc390b4b-4211-41cb-9b2b-\
ff4f77653b26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["c", "1"], 
     RowBox[{"Cosh", "[", 
      RowBox[{
       SqrtBox[
        SubscriptBox["\[Lambda]", "-"]], 
       RowBox[{"(", 
        RowBox[{"L", "-", "x"}], ")"}]}], "]"}]}], ",", 
    RowBox[{
     SubscriptBox["c", "2"], 
     RowBox[{"Cosh", "[", 
      RowBox[{
       SqrtBox[
        SubscriptBox["\[Lambda]", "+"]], 
       RowBox[{"(", 
        RowBox[{"L", "-", "x"}], ")"}]}], "]"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.870174302979908*^9, 3.8701743277095547`*^9}, {
  3.8701743744597187`*^9, 3.870174514344157*^9}, {3.87017519584622*^9, 
  3.870175230414592*^9}, {3.8701752729946203`*^9, 3.870175273693253*^9}, {
  3.870317799446309*^9, 3.870317803877277*^9}, {3.870321186598884*^9, 
  3.870321189465967*^9}, {3.87423176052099*^9, 3.874231762179483*^9}, {
  3.8742318070019207`*^9, 3.874231809905553*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"823cb917-10a1-4ece-ace8-752b6bdec2f0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Cosh", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"L", "-", "x"}], ")"}], " ", 
      SqrtBox[
       SubscriptBox["\[Lambda]", "-"]]}], "]"}], " ", 
    SubscriptBox["c", "1"]}], ",", 
   RowBox[{
    RowBox[{"Cosh", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"L", "-", "x"}], ")"}], " ", 
      SqrtBox[
       SubscriptBox["\[Lambda]", "+"]]}], "]"}], " ", 
    SubscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.870174515029772*^9, 3.8701752343546677`*^9, 3.870175274647772*^9, 
   3.87017695033811*^9, 3.870176995573614*^9, 3.8701771152670507`*^9, 
   3.870232135471109*^9, 3.870256414875412*^9, 3.8703169929665117`*^9, {
   3.8703178443543158`*^9, 3.87031786678927*^9}, 3.870319166745212*^9, 
   3.870320901186659*^9, 3.870321202031556*^9, 3.870326282860021*^9, 
   3.870330031110497*^9, 3.870348424191029*^9, 3.870348492108343*^9, 
   3.870858050429118*^9, 3.870863874267247*^9, 3.870929853972982*^9, 
   3.8709401702186728`*^9, 3.871025822064021*^9, 3.871099899859198*^9, 
   3.871101016506405*^9, {3.871101515675117*^9, 3.87110154304773*^9}, 
   3.8711022989130297`*^9, 3.871103061557479*^9, 3.871103503110682*^9, 
   3.87328513733243*^9, 3.87336852692036*^9, 3.8734366826857147`*^9, 
   3.873439164523651*^9, 3.873441906862064*^9, 3.873456244224373*^9, 
   3.873699677575091*^9, 3.873786103668984*^9, 3.873799185675035*^9, 
   3.873799636939601*^9, 3.873800093144948*^9, 3.874231943443165*^9, 
   3.87431572163129*^9, 3.874318108908379*^9, 3.874324076760207*^9, 
   3.874384555464089*^9, 3.8743886842618103`*^9, 3.874389659656547*^9, 
   3.874476378622266*^9, 3.874491263803834*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"344a562e-2ef1-4420-b5c4-4d48689ba114"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalPi]", "[", "x_", "]"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"U", ".", "h"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8701740113461533`*^9, 3.870174011347412*^9}, {
   3.870174530486924*^9, 3.870174572062036*^9}, {3.870176783295322*^9, 
   3.870176798535326*^9}, 3.87017687961043*^9},
 CellLabel->"In[26]:=",ExpressionUUID->"b93da27d-8f89-4a5c-bf73-3c8cfc5bab5a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SubscriptBox["D", "o"], " ", 
      SubscriptBox["k", "oc"]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"L", "-", "x"}], ")"}], " ", 
         SqrtBox[
          SubscriptBox["\[Lambda]", "-"]]}], "]"}], " ", 
       SubscriptBox["c", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["D", "o"], " ", 
          SubscriptBox["k", "co"]}], "-", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          SubscriptBox["k", "oc"]}], "-", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          SubscriptBox["k", "off"]}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{
            SubsuperscriptBox["D", "o", "2"], " ", 
            SubsuperscriptBox["k", "co", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["D", "c"], " ", 
            SubscriptBox["D", "o"], " ", 
            SubscriptBox["k", "co"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["k", "oc"], "-", 
              SubscriptBox["k", "off"]}], ")"}]}], "+", 
           RowBox[{
            SubsuperscriptBox["D", "c", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["k", "oc"], "+", 
               SubscriptBox["k", "off"]}], ")"}], "2"]}]}]]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"L", "-", "x"}], ")"}], " ", 
         SqrtBox[
          SubscriptBox["\[Lambda]", "+"]]}], "]"}], " ", 
       SubscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["D", "o"]}], " ", 
          SubscriptBox["k", "co"]}], "+", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          SubscriptBox["k", "oc"]}], "+", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          SubscriptBox["k", "off"]}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{
            SubsuperscriptBox["D", "o", "2"], " ", 
            SubsuperscriptBox["k", "co", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["D", "c"], " ", 
            SubscriptBox["D", "o"], " ", 
            SubscriptBox["k", "co"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["k", "oc"], "-", 
              SubscriptBox["k", "off"]}], ")"}]}], "+", 
           RowBox[{
            SubsuperscriptBox["D", "c", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["k", "oc"], "+", 
               SubscriptBox["k", "off"]}], ")"}], "2"]}]}]]}], ")"}]}]}], 
     ")"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"L", "-", "x"}], ")"}], " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]", "-"]]}], "]"}], " ", 
     SubscriptBox["c", "1"]}], "+", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"L", "-", "x"}], ")"}], " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]", "+"]]}], "]"}], " ", 
     SubscriptBox["c", "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.870174534185116*^9, 3.87017454344302*^9}, 
   3.870174574042983*^9, 3.870175280559063*^9, {3.870176788066626*^9, 
   3.8701767987918043`*^9}, 3.870176950726055*^9, 3.870176995838203*^9, 
   3.8701770572372103`*^9, 3.8701771155674877`*^9, 3.870177218668766*^9, 
   3.870232135733766*^9, 3.87025641511594*^9, 3.870316993133924*^9, 
   3.870317866992279*^9, 3.870319166942638*^9, 3.870320901482911*^9, 
   3.8703212022879753`*^9, 3.870326283102161*^9, 3.870330031367642*^9, 
   3.870348424426543*^9, 3.8703484921628857`*^9, 3.870858050693419*^9, 
   3.870863874539672*^9, 3.870929854169351*^9, 3.8709401704727182`*^9, 
   3.871025822361766*^9, 3.87109990017171*^9, 3.871101016805809*^9, {
   3.871101516110228*^9, 3.87110154357414*^9}, 3.8711022991619663`*^9, 
   3.871103061809617*^9, 3.871103503352439*^9, 3.873285137755414*^9, 
   3.873368527167761*^9, 3.8734366829238577`*^9, 3.873439164760166*^9, 
   3.873441907028327*^9, 3.873456244390909*^9, 3.873699677826086*^9, 
   3.873786103841547*^9, 3.87379918591339*^9, 3.873799637179002*^9, 
   3.873800093573205*^9, 3.874231943720262*^9, 3.8743157219106903`*^9, 
   3.8743181092059603`*^9, 3.874324077039089*^9, 3.8743845556977577`*^9, 
   3.874388684846526*^9, 3.874389660207202*^9, 3.874476378931501*^9, 
   3.8744912640146847`*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"db9494a1-5533-4124-9de6-061ea95044d0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalPi]left", "[", "x_", "]"}], "=", " ", 
  RowBox[{
   RowBox[{"\[CapitalPi]", "[", "x", "]"}], " ", "/.", " ", 
   RowBox[{"L", "\[Rule]", " ", 
    RowBox[{"-", "L"}]}]}]}]], "Input",
 CellChangeTimes->{{3.874227254822289*^9, 3.874227298156001*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"e66c6d45-5910-4019-94b1-e90ce22446cd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SubscriptBox["D", "o"], " ", 
      SubscriptBox["k", "oc"]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "L"}], "-", "x"}], ")"}], " ", 
         SqrtBox[
          SubscriptBox["\[Lambda]", "-"]]}], "]"}], " ", 
       SubscriptBox["c", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["D", "o"], " ", 
          SubscriptBox["k", "co"]}], "-", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          SubscriptBox["k", "oc"]}], "-", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          SubscriptBox["k", "off"]}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{
            SubsuperscriptBox["D", "o", "2"], " ", 
            SubsuperscriptBox["k", "co", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["D", "c"], " ", 
            SubscriptBox["D", "o"], " ", 
            SubscriptBox["k", "co"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["k", "oc"], "-", 
              SubscriptBox["k", "off"]}], ")"}]}], "+", 
           RowBox[{
            SubsuperscriptBox["D", "c", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["k", "oc"], "+", 
               SubscriptBox["k", "off"]}], ")"}], "2"]}]}]]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "L"}], "-", "x"}], ")"}], " ", 
         SqrtBox[
          SubscriptBox["\[Lambda]", "+"]]}], "]"}], " ", 
       SubscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["D", "o"]}], " ", 
          SubscriptBox["k", "co"]}], "+", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          SubscriptBox["k", "oc"]}], "+", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          SubscriptBox["k", "off"]}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{
            SubsuperscriptBox["D", "o", "2"], " ", 
            SubsuperscriptBox["k", "co", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["D", "c"], " ", 
            SubscriptBox["D", "o"], " ", 
            SubscriptBox["k", "co"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["k", "oc"], "-", 
              SubscriptBox["k", "off"]}], ")"}]}], "+", 
           RowBox[{
            SubsuperscriptBox["D", "c", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["k", "oc"], "+", 
               SubscriptBox["k", "off"]}], ")"}], "2"]}]}]]}], ")"}]}]}], 
     ")"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "L"}], "-", "x"}], ")"}], " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]", "-"]]}], "]"}], " ", 
     SubscriptBox["c", "1"]}], "+", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "L"}], "-", "x"}], ")"}], " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]", "+"]]}], "]"}], " ", 
     SubscriptBox["c", "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.874231943795021*^9, 3.874315721990027*^9, 
  3.874318109295875*^9, 3.874324077110827*^9, 3.874384555776593*^9, 
  3.874388684898334*^9, 3.874389660261047*^9, 3.874476378976169*^9, 
  3.874491264058832*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"d72da9e5-98aa-4bb4-aa72-31fe4b3eee2f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D\[CapitalPi]", "[", "x_", "]"}], "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"\[CapitalPi]", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8702321436789618`*^9, 3.870232157829669*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"f958b27d-b350-4851-bbfa-c7d7093d8690"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SubscriptBox["D", "o"], " ", 
      SubscriptBox["k", "oc"]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Sinh", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"L", "-", "x"}], ")"}], " ", 
          SqrtBox[
           SubscriptBox["\[Lambda]", "-"]]}], "]"}]}], " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]", "-"]], " ", 
       SubscriptBox["c", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["D", "o"], " ", 
          SubscriptBox["k", "co"]}], "-", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          SubscriptBox["k", "oc"]}], "-", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          SubscriptBox["k", "off"]}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{
            SubsuperscriptBox["D", "o", "2"], " ", 
            SubsuperscriptBox["k", "co", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["D", "c"], " ", 
            SubscriptBox["D", "o"], " ", 
            SubscriptBox["k", "co"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["k", "oc"], "-", 
              SubscriptBox["k", "off"]}], ")"}]}], "+", 
           RowBox[{
            SubsuperscriptBox["D", "c", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["k", "oc"], "+", 
               SubscriptBox["k", "off"]}], ")"}], "2"]}]}]]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"L", "-", "x"}], ")"}], " ", 
         SqrtBox[
          SubscriptBox["\[Lambda]", "+"]]}], "]"}], " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]", "+"]], " ", 
       SubscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["D", "o"]}], " ", 
          SubscriptBox["k", "co"]}], "+", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          SubscriptBox["k", "oc"]}], "+", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          SubscriptBox["k", "off"]}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{
            SubsuperscriptBox["D", "o", "2"], " ", 
            SubsuperscriptBox["k", "co", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["D", "c"], " ", 
            SubscriptBox["D", "o"], " ", 
            SubscriptBox["k", "co"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["k", "oc"], "-", 
              SubscriptBox["k", "off"]}], ")"}]}], "+", 
           RowBox[{
            SubsuperscriptBox["D", "c", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["k", "oc"], "+", 
               SubscriptBox["k", "off"]}], ")"}], "2"]}]}]]}], ")"}]}]}], 
     ")"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sinh", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"L", "-", "x"}], ")"}], " ", 
        SqrtBox[
         SubscriptBox["\[Lambda]", "-"]]}], "]"}]}], " ", 
     SqrtBox[
      SubscriptBox["\[Lambda]", "-"]], " ", 
     SubscriptBox["c", "1"]}], "-", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"L", "-", "x"}], ")"}], " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]", "+"]]}], "]"}], " ", 
     SqrtBox[
      SubscriptBox["\[Lambda]", "+"]], " ", 
     SubscriptBox["c", "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.870232158182235*^9, 3.8702564151950293`*^9, 3.8703169932211647`*^9, 
   3.870317867056703*^9, 3.87031916702479*^9, 3.870320901615193*^9, 
   3.870321202351506*^9, 3.8703262831630497`*^9, 3.870330031442528*^9, 
   3.8703484245290318`*^9, 3.870348492217662*^9, 3.870858050750725*^9, 
   3.8708638746121807`*^9, 3.870929854247672*^9, 3.870940170539084*^9, 
   3.871025822423429*^9, 3.871099900243906*^9, 3.8711010168597727`*^9, {
   3.871101516166226*^9, 3.8711015436989603`*^9}, 3.8711022992205973`*^9, 
   3.8711030619022083`*^9, 3.8711035034446573`*^9, 3.873285137820166*^9, 
   3.873368527236719*^9, 3.87343668297407*^9, 3.873439164815771*^9, 
   3.873441907081567*^9, 3.873456244444536*^9, 3.8736996778891172`*^9, 
   3.87378610389203*^9, 3.87379918598864*^9, 3.87379963725511*^9, 
   3.873800093647519*^9, 3.874231943864156*^9, 3.874315722055428*^9, 
   3.874318109374332*^9, 3.8743240771631927`*^9, 3.874384555844688*^9, 
   3.8743886849504147`*^9, 3.874389660305667*^9, 3.874476379030572*^9, 
   3.874491264101921*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"f1566a7e-ded2-4eaf-9fce-5c468c767f72"]
}, Open  ]],

Cell["check that it is for real the solution", "Text",
 CellChangeTimes->{{3.8703310521792583`*^9, 
  3.870331059694223*^9}},ExpressionUUID->"c542aa86-285c-4531-ad19-\
0cf61c3d1b0b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"d", ".", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"D\[CapitalPi]", "[", "x", "]"}], ",", "x"}], "]"}]}], "-", 
    RowBox[{"W", ".", 
     RowBox[{"\[CapitalPi]", "[", "x", "]"}]}]}], " ", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", 
      RowBox[{"eig", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], " ", ",", " ", 
     RowBox[{
      SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", 
      RowBox[{"eig", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], " ", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8703310872420673`*^9, 3.870331170682501*^9}, {
  3.870331216779129*^9, 3.87033121738194*^9}, {3.870331250296476*^9, 
  3.870331308590551*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"e9b92cc8-a535-42e8-b549-0503bbb46770"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.870331114061195*^9, {3.8703311580966177`*^9, 3.870331173671823*^9}, 
   3.8703312302134647`*^9, {3.870331288678615*^9, 3.870331308989254*^9}, 
   3.870348424607053*^9, 3.870348492233685*^9, 3.870858050827916*^9, 
   3.8708638746775*^9, 3.870929854294229*^9, 3.870940170616869*^9, 
   3.871025822482946*^9, 3.871099900311611*^9, 3.8711010169086018`*^9, {
   3.871101516296918*^9, 3.87110154377577*^9}, 3.8711022992790833`*^9, 
   3.8711030619707403`*^9, 3.8711035035097446`*^9, 3.873285137889873*^9, 
   3.873368527294383*^9, 3.873436683021196*^9, 3.87343916486112*^9, 
   3.873441907131496*^9, 3.8734562444984694`*^9, 3.873699677948907*^9, 
   3.873786103952758*^9, 3.8737991860495253`*^9, 3.8737996373230124`*^9, 
   3.87380009372443*^9, 3.8742319439276133`*^9, 3.874315722115465*^9, 
   3.874318109439723*^9, 3.8743240772125473`*^9, 3.8743845559076633`*^9, 
   3.874388684992385*^9, 3.874389660351128*^9, 3.8744763790787373`*^9, 
   3.874491264143989*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"f1d00de5-9bff-4b3a-b300-153e99fdaa6e"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Special DNA", "Subsection",
 CellChangeTimes->{{3.870174609976053*^9, 3.870174614605351*^9}, {
  3.870174691651156*^9, 3.870174696881085*^9}, {3.8732851574663486`*^9, 
  3.873285157723691*^9}},ExpressionUUID->"48f017ca-83d7-4ba3-9b8c-\
6436db2f1ac7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hs", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["cs", "1"], 
     RowBox[{"Cosh", "[", 
      RowBox[{
       SqrtBox[
        SubscriptBox["\[Lambda]s", "-"]], 
       RowBox[{"(", "x", ")"}]}], "]"}]}], ",", 
    RowBox[{
     SubscriptBox["cs", "2"], 
     RowBox[{"Cosh", "[", 
      RowBox[{
       SqrtBox[
        SubscriptBox["\[Lambda]s", "+"]], 
       RowBox[{"(", "x", ")"}]}], "]"}]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8701746259406843`*^9, 3.8701746693162537`*^9}, {
   3.87017529677567*^9, 3.870175309112082*^9}, {3.870317812850423*^9, 
   3.870317816251026*^9}, {3.870321174027804*^9, 3.870321177539487*^9}, {
   3.8703364486225567`*^9, 3.8703364654883633`*^9}, 3.8742318381901207`*^9},
 CellLabel->"In[30]:=",ExpressionUUID->"6394876f-f8a4-4b63-9cfb-33b25becc1a7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Cosh", "[", 
     RowBox[{"x", " ", 
      SqrtBox[
       SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
    SubscriptBox["cs", "1"]}], ",", 
   RowBox[{
    RowBox[{"Cosh", "[", 
     RowBox[{"x", " ", 
      SqrtBox[
       SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", 
    SubscriptBox["cs", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.870174655810289*^9, 3.8701746699303217`*^9}, 
   3.870175309859782*^9, 3.8701769507617483`*^9, 3.870176995905466*^9, 
   3.870177115635417*^9, 3.8702321357888203`*^9, 3.870256415256214*^9, 
   3.8703169932717543`*^9, 3.870317867115752*^9, 3.8703191670934877`*^9, 
   3.870320901685184*^9, 3.870321202413711*^9, 3.870326283222657*^9, 
   3.870330031505962*^9, 3.870336482962555*^9, 3.870348424678824*^9, 
   3.870348492283358*^9, 3.870858050882663*^9, 3.870863874693985*^9, 
   3.870929854325493*^9, 3.8709401706811666`*^9, 3.871025822540123*^9, 
   3.8710999003737497`*^9, 3.871101017729844*^9, {3.8711015172131033`*^9, 
   3.871101544657401*^9}, 3.8711023001312637`*^9, 3.871103062763505*^9, 
   3.871103504382131*^9, 3.873285138710267*^9, 3.873368528037582*^9, 
   3.873436683747447*^9, 3.873439165623313*^9, 3.87344190765303*^9, 
   3.873456245088365*^9, 3.873699678786425*^9, 3.8737861045156307`*^9, 
   3.873799186897607*^9, 3.873799638128147*^9, 3.873800094560256*^9, 
   3.874231944100992*^9, 3.8743157228820744`*^9, 3.874318110249776*^9, 
   3.874324077985443*^9, 3.8743845568543463`*^9, 3.8743886850357122`*^9, 
   3.874389660396111*^9, 3.874476379133286*^9, 3.874491264174082*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"beeb622d-02e8-4843-ba38-fff30b8f8c90"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalPi]s", "[", "x_", "]"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"Us", ".", "hs"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.870174673865378*^9, 3.8701746765355*^9}, {
  3.8701769681041727`*^9, 3.8701769698789186`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"91326ac0-d6f2-44d2-b92f-ebb5698be9a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SubscriptBox["D", "o"], " ", 
      SubscriptBox["k", "oc"], " ", 
      SubscriptBox["\[Gamma]", "oc"]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"x", " ", 
         SqrtBox[
          SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
       SubscriptBox["cs", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["D", "o"], " ", 
          SubscriptBox["k", "co"], " ", 
          SubscriptBox["\[Gamma]", "co"]}], "-", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["k", "off"], "+", 
            RowBox[{
             SubscriptBox["k", "oc"], " ", 
             SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{
            SubsuperscriptBox["D", "o", "2"], " ", 
            SubsuperscriptBox["k", "co", "2"], " ", 
            SubsuperscriptBox["\[Gamma]", "co", "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["D", "c"], " ", 
            SubscriptBox["D", "o"], " ", 
            SubscriptBox["k", "co"], " ", 
            SubscriptBox["\[Gamma]", "co"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["k", "off"], "-", 
              RowBox[{
               SubscriptBox["k", "oc"], " ", 
               SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
           RowBox[{
            SubsuperscriptBox["D", "c", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["k", "off"], "+", 
               RowBox[{
                SubscriptBox["k", "oc"], " ", 
                SubscriptBox["\[Gamma]", "oc"]}]}], ")"}], "2"]}]}]]}], 
        ")"}]}], "-", 
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"x", " ", 
         SqrtBox[
          SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", 
       SubscriptBox["cs", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["D", "o"]}], " ", 
          SubscriptBox["k", "co"], " ", 
          SubscriptBox["\[Gamma]", "co"]}], "+", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["k", "off"], "+", 
            RowBox[{
             SubscriptBox["k", "oc"], " ", 
             SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{
            SubsuperscriptBox["D", "o", "2"], " ", 
            SubsuperscriptBox["k", "co", "2"], " ", 
            SubsuperscriptBox["\[Gamma]", "co", "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["D", "c"], " ", 
            SubscriptBox["D", "o"], " ", 
            SubscriptBox["k", "co"], " ", 
            SubscriptBox["\[Gamma]", "co"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["k", "off"], "-", 
              RowBox[{
               SubscriptBox["k", "oc"], " ", 
               SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
           RowBox[{
            SubsuperscriptBox["D", "c", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["k", "off"], "+", 
               RowBox[{
                SubscriptBox["k", "oc"], " ", 
                SubscriptBox["\[Gamma]", "oc"]}]}], ")"}], "2"]}]}]]}], 
        ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"x", " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
     SubscriptBox["cs", "1"]}], "+", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"x", " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", 
     SubscriptBox["cs", "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.870256415713677*^9, 3.870316993586535*^9, 3.87031786742852*^9, 
   3.870319167381336*^9, 3.870320902110673*^9, 3.870321202834016*^9, 
   3.8703262836251793`*^9, 3.870330031930409*^9, 3.870336487493327*^9, 
   3.870348425136116*^9, 3.870348492298476*^9, 3.870858051414469*^9, 
   3.870863875224194*^9, 3.8709298546661997`*^9, 3.870940171156378*^9, 
   3.871025823030744*^9, 3.8710999009384403`*^9, 3.871101018279482*^9, {
   3.871101517895413*^9, 3.871101545233472*^9}, 3.8711023006073837`*^9, 
   3.8711030632376213`*^9, 3.871103504869141*^9, 3.87328513918758*^9, 
   3.873368528491735*^9, 3.8734366842281637`*^9, 3.873439166010483*^9, 
   3.873441907939687*^9, 3.873456245379572*^9, 3.8736996792857523`*^9, 
   3.873786104874527*^9, 3.873799187386833*^9, 3.873799638607712*^9, 
   3.8738000950471153`*^9, 3.874231944526444*^9, 3.87431572330099*^9, 
   3.874318110680657*^9, 3.874324078407785*^9, 3.874384557235094*^9, 
   3.874388685467223*^9, 3.874389660874166*^9, 3.8744763795887012`*^9, 
   3.874491264483102*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"31e13113-d0d5-4a30-bf6e-7295fd2bb561"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D\[CapitalPi]s", "[", "x_", "]"}], "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"\[CapitalPi]s", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8702321770818663`*^9, 3.870232179570569*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"23258ae0-64e3-41e6-8e53-2633666415fe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SubscriptBox["D", "o"], " ", 
      SubscriptBox["k", "oc"], " ", 
      SubscriptBox["\[Gamma]", "oc"]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"x", " ", 
         SqrtBox[
          SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]s", "-"]], " ", 
       SubscriptBox["cs", "1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["D", "o"], " ", 
          SubscriptBox["k", "co"], " ", 
          SubscriptBox["\[Gamma]", "co"]}], "-", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["k", "off"], "+", 
            RowBox[{
             SubscriptBox["k", "oc"], " ", 
             SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{
            SubsuperscriptBox["D", "o", "2"], " ", 
            SubsuperscriptBox["k", "co", "2"], " ", 
            SubsuperscriptBox["\[Gamma]", "co", "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["D", "c"], " ", 
            SubscriptBox["D", "o"], " ", 
            SubscriptBox["k", "co"], " ", 
            SubscriptBox["\[Gamma]", "co"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["k", "off"], "-", 
              RowBox[{
               SubscriptBox["k", "oc"], " ", 
               SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
           RowBox[{
            SubsuperscriptBox["D", "c", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["k", "off"], "+", 
               RowBox[{
                SubscriptBox["k", "oc"], " ", 
                SubscriptBox["\[Gamma]", "oc"]}]}], ")"}], "2"]}]}]]}], 
        ")"}]}], "-", 
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"x", " ", 
         SqrtBox[
          SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]s", "+"]], " ", 
       SubscriptBox["cs", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["D", "o"]}], " ", 
          SubscriptBox["k", "co"], " ", 
          SubscriptBox["\[Gamma]", "co"]}], "+", 
         RowBox[{
          SubscriptBox["D", "c"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["k", "off"], "+", 
            RowBox[{
             SubscriptBox["k", "oc"], " ", 
             SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
         SqrtBox[
          RowBox[{
           RowBox[{
            SubsuperscriptBox["D", "o", "2"], " ", 
            SubsuperscriptBox["k", "co", "2"], " ", 
            SubsuperscriptBox["\[Gamma]", "co", "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["D", "c"], " ", 
            SubscriptBox["D", "o"], " ", 
            SubscriptBox["k", "co"], " ", 
            SubscriptBox["\[Gamma]", "co"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubscriptBox["k", "off"], "-", 
              RowBox[{
               SubscriptBox["k", "oc"], " ", 
               SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
           RowBox[{
            SubsuperscriptBox["D", "c", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["k", "off"], "+", 
               RowBox[{
                SubscriptBox["k", "oc"], " ", 
                SubscriptBox["\[Gamma]", "oc"]}]}], ")"}], "2"]}]}]]}], 
        ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"x", " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
     SqrtBox[
      SubscriptBox["\[Lambda]s", "-"]], " ", 
     SubscriptBox["cs", "1"]}], "+", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"x", " ", 
       SqrtBox[
        SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", 
     SqrtBox[
      SubscriptBox["\[Lambda]s", "+"]], " ", 
     SubscriptBox["cs", "2"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.870232182062436*^9, 3.870256415859971*^9, 3.870316993679804*^9, 
   3.870317867535359*^9, 3.87031916744709*^9, 3.870320902164343*^9, 
   3.870321202897675*^9, 3.870326283710478*^9, 3.870330032008724*^9, 
   3.8703364931811247`*^9, 3.870348425295795*^9, 3.8703484923543873`*^9, 
   3.870858051506246*^9, 3.870863875300394*^9, 3.8709298547304907`*^9, 
   3.8709401712615833`*^9, 3.871025823149398*^9, 3.8710999011139727`*^9, 
   3.871101018347537*^9, {3.871101517972579*^9, 3.871101545293853*^9}, 
   3.871102300666471*^9, 3.871103063307126*^9, 3.871103504962317*^9, 
   3.873285139261609*^9, 3.873368528554285*^9, 3.873436684276827*^9, 
   3.873439166061349*^9, 3.873441908005591*^9, 3.873456245431437*^9, 
   3.8736996793431*^9, 3.873786104932363*^9, 3.87379918747534*^9, 
   3.8737996386935263`*^9, 3.873800095862113*^9, 3.874231944657961*^9, 
   3.874315723383006*^9, 3.874318110771234*^9, 3.874324078481214*^9, 
   3.874384557289783*^9, 3.874388685557082*^9, 3.874389660947672*^9, 
   3.8744763797517567`*^9, 3.874491264538374*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"2fc10c55-6d40-4819-a447-8c318765a2ff"]
}, Open  ]],

Cell["Check", "Text",
 CellChangeTimes->{{3.870331358520487*^9, 3.870331361915818*^9}, {
  3.870331400247168*^9, 
  3.8703314007347193`*^9}},ExpressionUUID->"9507ae1d-23ea-4b0a-90ea-\
08a52ba81d1b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"d", ".", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"D\[CapitalPi]s", "[", "x", "]"}], ",", "x"}], "]"}]}], "-", 
    RowBox[{"Ws", ".", 
     RowBox[{"\[CapitalPi]s", "[", "x", "]"}]}]}], " ", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", 
      RowBox[{"eigs", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], " ", ",", " ", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "+"], "\[Rule]", " ", 
      RowBox[{"eigs", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], " ", "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.870331371319873*^9, 3.8703313963873177`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"cdf35b9e-fd2d-4d43-82b6-4dd5fbb6f985"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.870331384101873*^9, 3.8703313969552307`*^9}, 
   3.870336510545868*^9, 3.870348425394176*^9, 3.8703484924071503`*^9, 
   3.870858051575794*^9, 3.870863875353459*^9, 3.870929854786059*^9, 
   3.870940171329571*^9, 3.8710258232177267`*^9, 3.871099901182673*^9, 
   3.8711010184059277`*^9, {3.871101518035242*^9, 3.8711015453397083`*^9}, 
   3.8711023007318687`*^9, 3.8711030633643913`*^9, 3.8711035050277042`*^9, 
   3.873285139322433*^9, 3.87336852861335*^9, 3.873436684324143*^9, 
   3.873439166110643*^9, 3.87344190805539*^9, 3.873456245478224*^9, 
   3.873699679398655*^9, 3.873786105006649*^9, 3.873799187537979*^9, 
   3.873799638767823*^9, 3.873800096143852*^9, 3.874231944713097*^9, 
   3.874315723445155*^9, 3.8743181108433437`*^9, 3.874324078540741*^9, 
   3.8743845573496532`*^9, 3.874388685605114*^9, 3.874389660993514*^9, 
   3.8744763797866364`*^9, 3.874491264590149*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"185846f0-120e-4594-83a7-175a2e3f0278"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Integral of \[CapitalPi](x)", "Section",
 CellChangeTimes->{{3.871100017345767*^9, 3.871100027828823*^9}, {
  3.874387916875163*^9, 
  3.8743879263596783`*^9}},ExpressionUUID->"81f83d68-cdc8-4da0-b761-\
4cef7c51dd29"],

Cell[CellGroupData[{

Cell["Integ", "Subsection",
 CellChangeTimes->{{3.874389675997286*^9, 
  3.874389679298933*^9}},ExpressionUUID->"4312356b-87c6-4c6d-a1c8-\
f9ff9100efc9"],

Cell[TextData[{
 "What is \[CapitalPi](x)? It is the space dependent part and in particular \
\[CapitalPi](x)=\[Rho](x)-z  so it is the difference between the total \
distribution AND z (not zs!).\nThe integral is symmetric (we will integrate \
from 0 to L, and multiply by 2), and is broken in 2 domains: the Special and \
NonSpecial DNA.\n\[Delta]N=2",
 Cell[BoxData[
  RowBox[{"\[Integral]", 
   RowBox[{
    SubscriptBox["\[CapitalPi]", "s"], 
    RowBox[{"(", "x", ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]],ExpressionUUID->
  "bf7e2c50-7445-4123-a573-85438925ebc1"],
 " (fro 0 to di) + 2",
 Cell[BoxData[
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"zs", "-", "z"}], ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]],ExpressionUUID->
  "a62eae1e-98d4-48a0-85af-9d83aa0c52e1"],
 " (fro 0 to di) + 2",
 Cell[BoxData[
  RowBox[{"\[Integral]", 
   RowBox[{
    SubscriptBox["\[CapitalPi]", "NS"], 
    RowBox[{"(", "x", ")"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]],ExpressionUUID->
  "e58e70d8-fa9b-4429-9516-352c96004c5c"],
 " (from di to L)"
}], "Text",
 CellChangeTimes->{{3.874387951585444*^9, 
  3.8743882908826733`*^9}},ExpressionUUID->"15b95e90-b047-4360-9621-\
b853767f7b16"],

Cell["\<\
The integrals should be the same regardless where they are centered\
\>", "Text",
 CellChangeTimes->{{3.874315616965296*^9, 
  3.8743156299906397`*^9}},ExpressionUUID->"06d5a56f-7c88-4f48-9229-\
4eb3e1d98ebb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"\[CapitalPi]", "[", "x", "]"}], " ", "/.", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Cosh", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"L", "-", "x"}], ")"}], " ", 
          SqrtBox[
           SubscriptBox["\[Lambda]", "-"]]}], "]"}], " ", "\[Rule]", " ", 
        RowBox[{
         FractionBox["2", 
          SqrtBox[
           SubscriptBox["\[Lambda]", "-"]]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sinh", "[", 
            RowBox[{
             SqrtBox[
              SubscriptBox["\[Lambda]", "-"]], "L"}], "]"}], "-", 
           RowBox[{"Sinh", "[", 
            RowBox[{
             SqrtBox[
              SubscriptBox["\[Lambda]", "-"]], "di"}], "]"}]}], ")"}]}]}], 
       ",", 
       RowBox[{
        RowBox[{"Cosh", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"L", "-", "x"}], ")"}], " ", 
          SqrtBox[
           SubscriptBox["\[Lambda]", "+"]]}], "]"}], " ", "\[Rule]", " ", 
        RowBox[{
         FractionBox["2", 
          SqrtBox[
           SubscriptBox["\[Lambda]", "+"]]], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sinh", "[", 
            RowBox[{
             SqrtBox[
              SubscriptBox["\[Lambda]", "+"]], "L"}], "]"}], "-", 
           RowBox[{"Sinh", "[", 
            RowBox[{
             SqrtBox[
              SubscriptBox["\[Lambda]", "+"]], "di"}], "]"}]}], ")"}]}]}]}], 
      "}"}]}], " ", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.87110006185179*^9, 3.871100241332638*^9}, {
  3.8711003190709867`*^9, 3.8711003714897413`*^9}, {3.8743155580892057`*^9, 
  3.8743155923857203`*^9}, {3.874388353427704*^9, 3.8743884418620996`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"11c52818-a561-48a6-bc01-271128d163b8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"\[CapitalPi]s", "[", "x", "]"}], " ", "/.", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Cosh", "[", 
         RowBox[{"x", " ", 
          SqrtBox[
           SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", "\[Rule]", " ", 
        RowBox[{
         FractionBox["2", 
          SqrtBox[
           SubscriptBox["\[Lambda]s", "-"]]], 
         RowBox[{"Sinh", "[", 
          RowBox[{
           SqrtBox[
            SubscriptBox["\[Lambda]s", "-"]], "di"}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"Cosh", "[", 
         RowBox[{"x", " ", 
          SqrtBox[
           SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", "\[Rule]", " ", 
        RowBox[{
         FractionBox["2", 
          SqrtBox[
           SubscriptBox["\[Lambda]s", "+"]]], 
         RowBox[{"Sinh", "[", 
          RowBox[{
           SqrtBox[
            SubscriptBox["\[Lambda]s", "+"]], "di"}], "]"}]}]}]}], "}"}]}], 
    " ", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"2", "*", "di", "*", 
    RowBox[{"(", 
     RowBox[{"zs", "-", "z"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"dNnew", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"p1", "+", "p2", "+", "p3"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.87438843303566*^9, 3.8743885095095882`*^9}, {
   3.8743885690670853`*^9, 3.874388636849534*^9}, {3.874388750307282*^9, 
   3.874388825448214*^9}, {3.874388865255199*^9, 3.8743888746505327`*^9}, 
   3.8743891600376167`*^9, {3.874389279609831*^9, 3.874389280788968*^9}, 
   3.874389691196885*^9, {3.874390093404345*^9, 3.874390158659985*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"1f6f1d75-4d42-4209-87ba-17fa7e869fa7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      SubscriptBox["D", "o"], " ", 
      SubscriptBox["k", "oc"]}]], 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sinh", "[", 
            RowBox[{"di", " ", 
             SqrtBox[
              SubscriptBox["\[Lambda]", "-"]]}], "]"}]}], "+", 
          RowBox[{"Sinh", "[", 
           RowBox[{"L", " ", 
            SqrtBox[
             SubscriptBox["\[Lambda]", "-"]]}], "]"}]}], ")"}], " ", 
        SubscriptBox["c", "1"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["D", "o"], " ", 
           SubscriptBox["k", "co"]}], "-", 
          RowBox[{
           SubscriptBox["D", "c"], " ", 
           SubscriptBox["k", "oc"]}], "-", 
          RowBox[{
           SubscriptBox["D", "c"], " ", 
           SubscriptBox["k", "off"]}], "+", 
          SqrtBox[
           RowBox[{
            RowBox[{
             SubsuperscriptBox["D", "o", "2"], " ", 
             SubsuperscriptBox["k", "co", "2"]}], "+", 
            RowBox[{"2", " ", 
             SubscriptBox["D", "c"], " ", 
             SubscriptBox["D", "o"], " ", 
             SubscriptBox["k", "co"], " ", 
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["k", "oc"], "-", 
               SubscriptBox["k", "off"]}], ")"}]}], "+", 
            RowBox[{
             SubsuperscriptBox["D", "c", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SubscriptBox["k", "oc"], "+", 
                SubscriptBox["k", "off"]}], ")"}], "2"]}]}]]}], ")"}]}], 
       SqrtBox[
        SubscriptBox["\[Lambda]", "-"]]], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"di", " ", 
            SqrtBox[
             SubscriptBox["\[Lambda]", "+"]]}], "]"}], "-", 
          RowBox[{"Sinh", "[", 
           RowBox[{"L", " ", 
            SqrtBox[
             SubscriptBox["\[Lambda]", "+"]]}], "]"}]}], ")"}], " ", 
        SubscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["D", "o"]}], " ", 
           SubscriptBox["k", "co"]}], "+", 
          RowBox[{
           SubscriptBox["D", "c"], " ", 
           SubscriptBox["k", "oc"]}], "+", 
          RowBox[{
           SubscriptBox["D", "c"], " ", 
           SubscriptBox["k", "off"]}], "+", 
          SqrtBox[
           RowBox[{
            RowBox[{
             SubsuperscriptBox["D", "o", "2"], " ", 
             SubsuperscriptBox["k", "co", "2"]}], "+", 
            RowBox[{"2", " ", 
             SubscriptBox["D", "c"], " ", 
             SubscriptBox["D", "o"], " ", 
             SubscriptBox["k", "co"], " ", 
             RowBox[{"(", 
              RowBox[{
               SubscriptBox["k", "oc"], "-", 
               SubscriptBox["k", "off"]}], ")"}]}], "+", 
            RowBox[{
             SubsuperscriptBox["D", "c", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                SubscriptBox["k", "oc"], "+", 
                SubscriptBox["k", "off"]}], ")"}], "2"]}]}]]}], ")"}]}], 
       SqrtBox[
        SubscriptBox["\[Lambda]", "+"]]], "+", 
      RowBox[{
       FractionBox["1", 
        SubscriptBox["\[Gamma]", "oc"]], 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"di", " ", 
             SqrtBox[
              SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
           SubscriptBox["cs", "1"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["D", "o"], " ", 
              SubscriptBox["k", "co"], " ", 
              SubscriptBox["\[Gamma]", "co"]}], "-", 
             RowBox[{
              SubscriptBox["D", "c"], " ", 
              RowBox[{"(", 
               RowBox[{
                SubscriptBox["k", "off"], "+", 
                RowBox[{
                 SubscriptBox["k", "oc"], " ", 
                 SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
             SqrtBox[
              RowBox[{
               RowBox[{
                SubsuperscriptBox["D", "o", "2"], " ", 
                SubsuperscriptBox["k", "co", "2"], " ", 
                SubsuperscriptBox["\[Gamma]", "co", "2"]}], "-", 
               RowBox[{"2", " ", 
                SubscriptBox["D", "c"], " ", 
                SubscriptBox["D", "o"], " ", 
                SubscriptBox["k", "co"], " ", 
                SubscriptBox["\[Gamma]", "co"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SubscriptBox["k", "off"], "-", 
                  RowBox[{
                   SubscriptBox["k", "oc"], " ", 
                   SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
               RowBox[{
                SubsuperscriptBox["D", "c", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   SubscriptBox["k", "off"], "+", 
                   RowBox[{
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["\[Gamma]", "oc"]}]}], ")"}], "2"]}]}]]}], 
            ")"}]}], 
          SqrtBox[
           SubscriptBox["\[Lambda]s", "-"]]], "-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"di", " ", 
             SqrtBox[
              SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", 
           SubscriptBox["cs", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SubscriptBox["D", "o"]}], " ", 
              SubscriptBox["k", "co"], " ", 
              SubscriptBox["\[Gamma]", "co"]}], "+", 
             RowBox[{
              SubscriptBox["D", "c"], " ", 
              RowBox[{"(", 
               RowBox[{
                SubscriptBox["k", "off"], "+", 
                RowBox[{
                 SubscriptBox["k", "oc"], " ", 
                 SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
             SqrtBox[
              RowBox[{
               RowBox[{
                SubsuperscriptBox["D", "o", "2"], " ", 
                SubsuperscriptBox["k", "co", "2"], " ", 
                SubsuperscriptBox["\[Gamma]", "co", "2"]}], "-", 
               RowBox[{"2", " ", 
                SubscriptBox["D", "c"], " ", 
                SubscriptBox["D", "o"], " ", 
                SubscriptBox["k", "co"], " ", 
                SubscriptBox["\[Gamma]", "co"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  SubscriptBox["k", "off"], "-", 
                  RowBox[{
                   SubscriptBox["k", "oc"], " ", 
                   SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
               RowBox[{
                SubsuperscriptBox["D", "c", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   SubscriptBox["k", "off"], "+", 
                   RowBox[{
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["\[Gamma]", "oc"]}]}], ")"}], "2"]}]}]]}], 
            ")"}]}], 
          SqrtBox[
           SubscriptBox["\[Lambda]s", "+"]]]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Sinh", "[", 
          RowBox[{"di", " ", 
           SqrtBox[
            SubscriptBox["\[Lambda]", "-"]]}], "]"}]}], "+", 
        RowBox[{"Sinh", "[", 
         RowBox[{"L", " ", 
          SqrtBox[
           SubscriptBox["\[Lambda]", "-"]]}], "]"}]}], ")"}], " ", 
      SubscriptBox["c", "1"]}], 
     SqrtBox[
      SubscriptBox["\[Lambda]", "-"]]], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Sinh", "[", 
          RowBox[{"di", " ", 
           SqrtBox[
            SubscriptBox["\[Lambda]", "+"]]}], "]"}]}], "+", 
        RowBox[{"Sinh", "[", 
         RowBox[{"L", " ", 
          SqrtBox[
           SubscriptBox["\[Lambda]", "+"]]}], "]"}]}], ")"}], " ", 
      SubscriptBox["c", "2"]}], 
     SqrtBox[
      SubscriptBox["\[Lambda]", "+"]]], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"di", " ", 
        SqrtBox[
         SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
      SubscriptBox["cs", "1"]}], 
     SqrtBox[
      SubscriptBox["\[Lambda]s", "-"]]], "+", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"di", " ", 
        SqrtBox[
         SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", 
      SubscriptBox["cs", "2"]}], 
     SqrtBox[
      SubscriptBox["\[Lambda]s", "+"]]], "+", 
    FractionBox[
     RowBox[{"di", " ", 
      SubscriptBox["k", "oc"], " ", 
      SubscriptBox["k", "on"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Delta]N", "-", 
        SubscriptBox["N", "tot"]}], ")"}]}], 
     RowBox[{"L", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["k", "oc"], " ", 
         SubscriptBox["k", "on"]}], "+", 
        RowBox[{
         SubscriptBox["k", "co"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["k", "off"], "+", 
           SubscriptBox["k", "on"]}], ")"}]}]}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{"di", " ", 
      SubscriptBox["k", "oc"], " ", 
      SubscriptBox["k", "on"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Delta]N", "-", 
        SubscriptBox["N", "tot"]}], ")"}], " ", 
      SubscriptBox["\[Gamma]", "oc"]}], 
     RowBox[{"L", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SubscriptBox["k", "oc"], " ", 
         SubscriptBox["k", "on"]}], "+", 
        RowBox[{
         SubscriptBox["k", "co"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["k", "off"], "+", 
           SubscriptBox["k", "on"]}], ")"}]}]}], ")"}], " ", 
      SubscriptBox["\[Gamma]", "co"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.87438887649903*^9, 3.874389161904068*^9, 3.874389283301424*^9, {
   3.874389688892468*^9, 3.8743896929927273`*^9}, {3.874390173527676*^9, 
   3.874390173656371*^9}, 3.874476385337701*^9, 3.874491267746234*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"4a92748d-2d37-4641-95dc-ade347433cd5"]
}, Open  ]],

Cell["\<\
I already know that the first integral is zero so from now on I will just use \
the integral of the closed distribution\
\>", "Text",
 CellChangeTimes->{{3.871100827753976*^9, 
  3.871100865791397*^9}},ExpressionUUID->"9b07dcf9-4442-49ee-a3e9-\
f73f1c60e44d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Attaching  the solutions together (finding the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "i"], TraditionalForm]],ExpressionUUID->
  "ef6c9ee9-20f9-446c-9296-ffd55365ae29"],
 ")"
}], "Subsection",
 CellChangeTimes->{{3.866779400441866*^9, 3.8667794049013357`*^9}, {
  3.870175414868321*^9, 3.870175420051662*^9}, {3.87025937041166*^9, 
  3.870259373598802*^9}, {3.870316461939548*^9, 3.87031646724051*^9}, {
  3.871100891757515*^9, 3.8711009069613123`*^9}, {3.871101085358448*^9, 
  3.871101087554151*^9}},ExpressionUUID->"f6992107-ad34-4713-a047-\
3741eadb70eb"],

Cell["Open, flat solutions are equal", "Text",
 CellChangeTimes->{{3.870175459398885*^9, 
  3.870175473826899*^9}},ExpressionUUID->"6e61e6a2-ed9a-4c6b-8a68-\
9a40fa8986a5"],

Cell["\<\
We have 4 equations, 2 coming from the continuity of the function (both open \
and closed) and 2 coming from the continuity of the derivative.\
\>", "Text",
 CellChangeTimes->{{3.870259382924673*^9, 
  3.8702594729115562`*^9}},ExpressionUUID->"a788cea3-1d27-4e18-90ff-\
6d17519102f7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soll", "=", 
  RowBox[{"Solve", "[", "\[IndentingNewLine]", "     ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"\[CapitalPi]", "[", "di", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "  ", 
      RowBox[{
       RowBox[{"\[CapitalPi]s", "[", "di", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], " ", "&&", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"D\[CapitalPi]", "[", "di", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], " ", "\[Equal]", " ", 
      RowBox[{
       RowBox[{"D\[CapitalPi]s", "[", "di", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "&&", "\[IndentingNewLine]", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\[CapitalPi]", "[", "di", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], "+", 
       RowBox[{"z", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "\[Equal]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[CapitalPi]s", "[", "di", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], "+", 
       RowBox[{"zs", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}]}], " ", "&&", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{
       RowBox[{"D\[CapitalPi]", "[", "di", "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", " ", 
      RowBox[{
       RowBox[{"D\[CapitalPi]s", "[", "di", "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["c", "1"], ",", 
      SubscriptBox["c", "2"], ",", 
      SubscriptBox["cs", "1"], ",", 
      SubscriptBox["cs", "2"]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8642820603255453`*^9, 3.864282062189694*^9}, {
   3.864906991940485*^9, 3.8649069939139223`*^9}, {3.865306280157008*^9, 
   3.8653062835220413`*^9}, {3.8653066128263607`*^9, 3.865306618925583*^9}, 
   3.87017542261451*^9, {3.870175485476207*^9, 3.8701755004162416`*^9}, {
   3.870177035657576*^9, 3.87017710654531*^9}, {3.87017717641251*^9, 
   3.8701772102253304`*^9}, {3.870232190219013*^9, 3.870232313361161*^9}, {
   3.870232353298967*^9, 3.870232390139262*^9}, {3.870318317627923*^9, 
   3.870318324426734*^9}, 3.8703183791025047`*^9, {3.870321003450673*^9, 
   3.870321003873994*^9}, 3.874231866699888*^9},
 CellLabel->"In[38]:=",ExpressionUUID->"220b45b8-2b0b-4ea3-9d37-a8ee6934a32c"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             SubscriptBox["c", "1"], "\[Rule]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                RowBox[{
                 RowBox[{"Sinh", "[", 
                  RowBox[{"di", " ", 
                   SqrtBox[
                    SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", 
                 TemplateBox[{"3"},
                  "OutputSizeLimit`Skeleton"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Cosh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "+"]]}], "]"}]}], " ", 
                    RowBox[{"Sinh", "[", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "]"}], " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]", "+"]]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "+", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], "-", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]}], 
               TemplateBox[{"1"},
                "OutputSizeLimit`Skeleton"]]}]}], ",", 
            RowBox[{
             SubscriptBox["c", "2"], "\[Rule]", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], " ", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"]}], "+", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"]}]]}], "+", 
              FractionBox[
               TemplateBox[{"1"},
                "OutputSizeLimit`Skeleton"], 
               TemplateBox[{"1"},
                "OutputSizeLimit`Skeleton"]]}]}], ",", 
            RowBox[{
             SubscriptBox["cs", "1"], "\[Rule]", 
             TemplateBox[{"1"},
              "OutputSizeLimit`Skeleton"]}], ",", 
            RowBox[{
             SubscriptBox["cs", "2"], "\[Rule]", 
             TemplateBox[{"1"},
              "OutputSizeLimit`Skeleton"]}]}], "}"}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{49.65234375, {3., 7.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{42.94921875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 38, 24408456342082606278, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{49.7578125, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 38, 24408456342082606278, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{36.87890625, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 38, 24408456342082606278, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{63.8671875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[24408456342082606278 === $SessionID, 
   Out[38], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.871103077002678*^9, 3.871103518827231*^9, 
  3.873285199294169*^9, 3.8733685423374023`*^9, 3.87343669824706*^9, 
  3.87343917973332*^9, 3.873441920291512*^9, 3.873456257757509*^9, 
  3.873699693189308*^9, 3.873786117218371*^9, 3.873799201391272*^9, 
  3.873799652383128*^9, 3.8738001099498873`*^9, 3.8742319583703327`*^9, 
  3.874315737273991*^9, 3.874318124522484*^9, 3.874324092211289*^9, 
  3.8743845695172663`*^9, 3.874389060504199*^9, 3.874389715102888*^9, 
  3.874476398727099*^9, 3.874491280039641*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"fe016348-38dc-43ba-a49b-66a03402163c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vv", "=", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["c", "1"], ",", 
     SubscriptBox["c", "2"], ",", 
     SubscriptBox["cs", "1"], ",", 
     SubscriptBox["cs", "2"]}], "}"}], " ", "/.", " ", 
   RowBox[{"soll", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 NotebookAutoSave->True,
 CellChangeTimes->{{3.87023329064993*^9, 3.870233312293399*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"38192a75-e18e-4796-aa62-b18ef844e88b"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"Sinh", "[", 
                  RowBox[{"di", " ", 
                   SqrtBox[
                    SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", 
                 SqrtBox[
                  SubscriptBox["\[Lambda]s", "+"]], " ", 
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}], " ", 
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Cosh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "+"]]}], "]"}]}], " ", 
                    RowBox[{"Sinh", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "di"}], "+", "L"}], ")"}], " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]", "+"]]}], "]"}], " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]", "+"]]}], "-", 
                    RowBox[{
                    RowBox[{"Cosh", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "di"}], "+", "L"}], ")"}], " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]", "+"]]}], "]"}], " ", 
                    RowBox[{"Sinh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "+"]]}]}], ")"}]}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{
                    RowBox[{"Cosh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SubscriptBox["D", "o"], " ", 
                    SubscriptBox["k", "co"], " ", 
                    SubscriptBox["\[Gamma]", "co"]}], "-", 
                    RowBox[{
                    SubscriptBox["D", "c"], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], "+", 
                    SqrtBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]]}], ")"}]}], 
                    RowBox[{"2", " ", 
                    SubscriptBox["D", "o"], " ", 
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["\[Gamma]", "oc"]}]], "+", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    RowBox[{"2", " ", 
                    SubscriptBox["D", "o"], " ", 
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["\[Gamma]", "oc"]}]]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Cosh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "+"]]}], "]"}]}], " ", 
                    RowBox[{"Sinh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}]}], ")"}]}], "-", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Cosh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "+"]]}], "]"}]}], " ", 
                    RowBox[{"Sinh", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "di"}], "+", "L"}], ")"}], " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]", "+"]]}], "]"}], " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]", "+"]]}], "-", 
                    RowBox[{
                    RowBox[{"Cosh", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "di"}], "+", "L"}], ")"}], " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]", "+"]]}], "]"}], " ", 
                    RowBox[{"Sinh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "+"]]}]}], ")"}]}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{
                    RowBox[{"Cosh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
                    TemplateBox[{"2"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SubscriptBox["D", "o"], " ", 
                    SubscriptBox["k", "co"], " ", 
                    SubscriptBox["\[Gamma]", "co"]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{
                    SubsuperscriptBox["D", "o", "2"], " ", 
                    SubsuperscriptBox["k", "co", "2"], " ", 
                    SubsuperscriptBox["\[Gamma]", "co", "2"]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]]}], ")"}]}], 
                    RowBox[{"2", " ", 
                    SubscriptBox["D", "o"], " ", 
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["\[Gamma]", "oc"]}]], "+", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    RowBox[{"2", " ", 
                    SubscriptBox["D", "o"], " ", 
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["\[Gamma]", "oc"]}]]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"Cosh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "+"]]}], "]"}]}], " ", 
                    RowBox[{"Sinh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], "-", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]}], ")"}]}], ")"}]}], ",", 
           TemplateBox[{"2"},
            "OutputSizeLimit`Skeleton"], ",", 
           TemplateBox[{"1"},
            "OutputSizeLimit`Skeleton"]}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{49.65234375, {3., 7.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{42.94921875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 39, 24408456342082606278, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{49.7578125, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 39, 24408456342082606278, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{36.87890625, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 39, 24408456342082606278, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{63.8671875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[24408456342082606278 === $SessionID, 
   Out[39], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGDQBuL9fEYxj66+cbQ5tGbpWyD9ZMMeS+5rbxxPTP21DER/
ME/05AHSz5i9lXhB/He/3UG02Cntw/xAeoHl1umCQHqR//vTIkD6wtbHk6SA
dFlf8iwQ/WSqVpbw9TeOYbPEncSAdHptfKUZkH71XKHZGkinJs0PTQXSTE2J
jZ1AOuc5C28XkK4xv+8Hojf6hawF0Z/1lvJ0A2mhjQ+cQbTCRs3uLbffOE45
cMH6LpCWfOzX/A9Il2XW7/wPpOfV8wkw3nnjuG+xjQAHkLY7v+ZtHZBe4rhG
YSWQZtlh1LIeSN9un7QHRO+rOfwVRHMJXrrUdBfIbzbcvRpIB2lMe7oGSNsd
7D6/HkjPijEPPwukd4mfnXseRH9+cwtEs6Td1/0FpCX2sxUx3nvjCAB9DMNF

  "],
 CellLabel->"Out[39]=",ExpressionUUID->"d1affc75-5f27-4e2d-baa6-5b8186dd6eb5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"shortVV", "=", 
    RowBox[{
    "Import", "[", 
     "\"\</home/salats/Documenti/PCS/tesi/mathematica/COLLAGE/coeff.mx\>\"", 
     "]"}]}], ";"}], "*)"}]], "Input",
 CellChangeTimes->{{3.873285466672057*^9, 3.873285468585001*^9}, 
   3.873285556889763*^9},
 CellLabel->"In[40]:=",ExpressionUUID->"623ba4ba-533b-45d0-88ee-55a584af48fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finding \[Delta]N and plugging it in all the other expressions!", \
"Subsection",
 CellChangeTimes->{{3.87110113987357*^9, 3.8711011848337097`*^9}, {
  3.871102837723907*^9, 
  3.87110287281938*^9}},ExpressionUUID->"fe86524f-3ab8-4c5f-90c2-\
628287b1b5ab"],

Cell["Now DdNnew is a vector, i expect the first entry to be zero.", "Text",
 CellChangeTimes->{{3.874389754374879*^9, 
  3.874389774027708*^9}},ExpressionUUID->"cbe2530b-c1fc-4332-874f-\
0dab9566262d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dNnew", "=", 
   RowBox[{"dNnew", " ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["c", "1"], "\[Rule]", " ", 
       RowBox[{"vv", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", 
      RowBox[{
       SubscriptBox["c", "2"], "\[Rule]", " ", 
       RowBox[{"vv", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ",", 
      RowBox[{
       SubscriptBox["cs", "1"], "\[Rule]", " ", 
       RowBox[{"vv", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], ",", 
      RowBox[{
       SubscriptBox["cs", "2"], "\[Rule]", " ", 
       RowBox[{"vv", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8711011592538*^9, 3.871101160058566*^9}, {
   3.871101197419573*^9, 3.8711013215839787`*^9}, {3.8711014694114943`*^9, 
   3.871101473734481*^9}, 3.8732855737330914`*^9, 3.873285621860928*^9, {
   3.8743891761547823`*^9, 3.874389197566729*^9}, {3.874389293105414*^9, 
   3.874389328439069*^9}, {3.87438951490407*^9, 3.874389549245738*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"4c51031a-8672-4629-b263-093e428abae2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"dNneww", "=", 
   RowBox[{"dNnew", " ", "/.", " ", 
    RowBox[{"\[Delta]N", " ", "\[Rule]", " ", 
     RowBox[{"dNo", "+", "dNc"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.87438955419086*^9, 3.8743895613043633`*^9}, {
  3.874389595117124*^9, 3.874389609127289*^9}, {3.874389742522497*^9, 
  3.874389747686708*^9}, {3.874389785293879*^9, 3.874389801272915*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"94f0b82b-ac73-4e09-bbd7-d94e901cb57f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"subbbb", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"dNneww", "\[Equal]", 
     RowBox[{"{", 
      RowBox[{"dNo", ",", "dNc"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"dNo", ",", "dNc"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8711025443731947`*^9, 3.871102580458378*^9}, {
  3.871102700010643*^9, 3.871102701672083*^9}, {3.8743898164436073`*^9, 
  3.874389853850728*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"465cab5d-0014-48cd-9640-de9bca842f69"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"dNo", "\[Rule]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"di", " ", 
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["k", "on"], " ", 
                    SubscriptBox["N", "tot"]}], 
                    RowBox[{"L", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["k", "on"]}], "+", 
                    RowBox[{
                    SubscriptBox["k", "co"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SubscriptBox["k", "off"], "+", 
                    SubscriptBox["k", "on"]}], ")"}]}]}], ")"}]}]]}], "+", 
                    TemplateBox[{"36"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"Sinh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
                    TemplateBox[{"8"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]], "-", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]]}], ")"}]}], 
                    RowBox[{"L", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}], " ", 
                    SubscriptBox["\[Gamma]", "co"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}]]}], ")"}]}], " ", 
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}]}], "+", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]}], 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   TemplateBox[{"36"},
                    "OutputSizeLimit`Skeleton"], "+", 
                   FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    RowBox[{"L", " ", 
                    TemplateBox[{"2"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}]], "-", 
                   FractionBox[
                    RowBox[{
                    RowBox[{"Sinh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
                    RowBox[{"Sinh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "+"]]}], "]"}], " ", 
                    TemplateBox[{"5"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]], "-", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]]}], ")"}]}], 
                    RowBox[{"L", " ", 
                    TemplateBox[{"4"},
                    "OutputSizeLimit`Skeleton"]}]]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   TemplateBox[{"34"},
                    "OutputSizeLimit`Skeleton"], "+", 
                   FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}], " ", 
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}]}]}]]}]}], ",", 
            RowBox[{"dNc", "\[Rule]", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]]}], "+", 
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"]}]}]}], "}"}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{49.65234375, {3., 7.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{42.94921875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 43, 24408456342082606278, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{49.7578125, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 43, 24408456342082606278, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{36.87890625, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 43, 24408456342082606278, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{63.8671875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[24408456342082606278 === $SessionID, 
   Out[43], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.871103081176346*^9, 3.87110352300145*^9, 
  3.873285784904688*^9, 3.87336854657734*^9, 3.873436702553398*^9, 
  3.87343918416609*^9, 3.8734419242694273`*^9, 3.873456261773633*^9, 
  3.873699697472068*^9, 3.8737861211231203`*^9, 3.873799205648611*^9, 
  3.873799656655398*^9, 3.8738001142022743`*^9, 3.8742319623479958`*^9, 
  3.874315741642165*^9, 3.874318128520056*^9, 3.874324096116358*^9, 
  3.8743845735479937`*^9, 3.8743898844118347`*^9, 3.874390246276258*^9, 
  3.874476428342202*^9, 3.874491306964533*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"8ee1d980-2757-4af5-8c54-d0da2c7ad737"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"prova", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dNo", ",", "dNc"}], "}"}], " ", "/.", " ", 
   RowBox[{"subbbb", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.871102803055485*^9, 3.8711028219415627`*^9}, 
   3.871102997460438*^9, {3.871103032099298*^9, 3.871103033376256*^9}, {
   3.874389941261519*^9, 3.874389973584483*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"ce248066-0f38-4c62-85cb-7328ed4c7cc9"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   FractionBox[
                    RowBox[{"di", " ", 
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["k", "on"], " ", 
                    SubscriptBox["N", "tot"]}], 
                    RowBox[{"L", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["k", "on"]}], "+", 
                    RowBox[{
                    SubscriptBox["k", "co"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    SubscriptBox["k", "off"], "+", 
                    SubscriptBox["k", "on"]}], ")"}]}]}], ")"}]}]]}], "+", 
                  TemplateBox[{"36"},
                   "OutputSizeLimit`Skeleton"], "+", 
                  FractionBox[
                   RowBox[{
                    RowBox[{"Sinh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
                    TemplateBox[{"8"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]], "-", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]]}], ")"}]}], 
                   RowBox[{"L", " ", 
                    TemplateBox[{"3"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}]]}], ")"}]}], " ", 
               RowBox[{"(", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], ")"}]}], "+", 
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"]}], 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 TemplateBox[{"39"},
                  "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 FractionBox[
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"]], "+", 
                 TemplateBox[{"33"},
                  "OutputSizeLimit`Skeleton"], "+", 
                 FractionBox[
                  RowBox[{
                   RowBox[{"Sinh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
                   TemplateBox[{"6"},
                    "OutputSizeLimit`Skeleton"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]], "-", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]]}], ")"}]}], 
                  RowBox[{"2", " ", "L", " ", 
                   TemplateBox[{"3"},
                    "OutputSizeLimit`Skeleton"], " ", 
                   SubscriptBox["\[Gamma]", "oc"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}]]}], ")"}]}], "-", 
              RowBox[{
               RowBox[{"(", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], ")"}], " ", 
               TemplateBox[{"1"},
                "OutputSizeLimit`Skeleton"]}]}]]}], ",", 
           RowBox[{
            RowBox[{"-", 
             FractionBox[
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"], 
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"]]}], "+", 
            TemplateBox[{"1"},
             "OutputSizeLimit`Skeleton"]}]}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{49.65234375, {3., 7.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{42.94921875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 44, 24408456342082606278, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{49.7578125, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 44, 24408456342082606278, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{36.87890625, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 44, 24408456342082606278, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{63.8671875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[24408456342082606278 === $SessionID, 
   Out[44], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{
  3.8733685467391577`*^9, 3.8734367026718683`*^9, 3.8734391844737377`*^9, 
   3.873441924485359*^9, 3.8734562619826*^9, 3.8736996976777678`*^9, 
   3.8737861212653522`*^9, 3.8737992058490067`*^9, 3.873799656848227*^9, 
   3.873800114438155*^9, 3.874231962523632*^9, 3.8743157418589*^9, 
   3.874318128670844*^9, 3.874324096247891*^9, 3.874384573740592*^9, {
   3.874389969155219*^9, 3.874389976917103*^9}, 3.874390257513473*^9, 
   3.874476429978421*^9, 3.874491308093759*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"00bb811d-8384-47bf-983d-5e2e03986015"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"simpp", "=", 
   RowBox[{"Simplify", "[", "\[Delta]N", "]"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8733448058015833`*^9, 3.873344820691077*^9}, 
   3.873368518485981*^9},
 CellLabel->"In[45]:=",ExpressionUUID->"fee4a4a3-28f4-4dc9-9de8-97f691940960"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]N", "=", 
  RowBox[{"Total", "[", "prova", "]"}]}]], "Input",
 CellChangeTimes->{{3.874390403332878*^9, 3.874390421693687*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"380cc118-316f-40fe-8853-55305544b0e6"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{
          RowBox[{"-", 
           FractionBox[
            RowBox[{
             RowBox[{"-", 
              FractionBox[
               RowBox[{"di", " ", 
                SubscriptBox["k", "oc"], " ", 
                SubscriptBox["k", "on"], " ", 
                SubscriptBox["N", "tot"]}], 
               RowBox[{"L", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   SubscriptBox["k", "oc"], " ", 
                   SubscriptBox["k", "on"]}], "+", 
                  RowBox[{
                   SubscriptBox["k", "co"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    SubscriptBox["k", "off"], "+", 
                    SubscriptBox["k", "on"]}], ")"}]}]}], ")"}]}]]}], "+", 
             TemplateBox[{"36"},
              "OutputSizeLimit`Skeleton"], "+", 
             FractionBox[
              RowBox[{
               RowBox[{"Sinh", "[", 
                RowBox[{"di", " ", 
                 SqrtBox[
                  SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
               TemplateBox[{"8"},
                "OutputSizeLimit`Skeleton"], " ", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox[
                  RowBox[{
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], 
                  RowBox[{
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}]], "-", 
                 FractionBox[
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"]]}], ")"}]}], 
              RowBox[{"L", " ", 
               SqrtBox[
                SubscriptBox["\[Lambda]s", "-"]], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SubscriptBox["k", "oc"], " ", 
                  SubscriptBox["k", "on"]}], "+", 
                 RowBox[{
                  SubscriptBox["k", "co"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SubscriptBox["k", "off"], "+", 
                    SubscriptBox["k", "on"]}], ")"}]}]}], ")"}], " ", 
               SubscriptBox["\[Gamma]", "co"], " ", 
               RowBox[{"(", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], ")"}]}]]}], 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             TemplateBox[{"39"},
              "OutputSizeLimit`Skeleton"]}]]}], "-", 
          FractionBox[
           RowBox[{
            TemplateBox[{"1"},
             "OutputSizeLimit`Skeleton"], "+", 
            TemplateBox[{"1"},
             "OutputSizeLimit`Skeleton"]}], 
           RowBox[{
            TemplateBox[{"1"},
             "OutputSizeLimit`Skeleton"], "-", 
            TemplateBox[{"1"},
             "OutputSizeLimit`Skeleton"]}]], "+", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             TemplateBox[{"1"},
              "OutputSizeLimit`Skeleton"], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   FractionBox[
                    RowBox[{"di", " ", 
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["k", "on"], " ", 
                    SubscriptBox["N", "tot"]}], 
                    RowBox[{"L", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["k", "on"]}], "+", 
                    RowBox[{
                    SubscriptBox["k", "co"], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}]}], ")"}]}]]}], "+", 
                  TemplateBox[{"36"},
                   "OutputSizeLimit`Skeleton"], "+", 
                  FractionBox[
                   RowBox[{
                    RowBox[{"Sinh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
                    TemplateBox[{"8"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], 
                   RowBox[{"L", " ", 
                    TemplateBox[{"3"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}]]}], ")"}]}], " ", 
               RowBox[{"(", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], ")"}]}], "+", 
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"]}], ")"}]}], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              TemplateBox[{"39"},
               "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 TemplateBox[{"36"},
                  "OutputSizeLimit`Skeleton"], "+", 
                 FractionBox[
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"]], "-", 
                 FractionBox[
                  RowBox[{
                   RowBox[{"Sinh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
                   TemplateBox[{"7"},
                    "OutputSizeLimit`Skeleton"], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], 
                  RowBox[{"L", " ", 
                   TemplateBox[{"4"},
                    "OutputSizeLimit`Skeleton"]}]]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", 
                 TemplateBox[{"34"},
                  "OutputSizeLimit`Skeleton"], "+", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"]}], ")"}]}], "-", 
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"]}], ")"}]}]]}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{49.65234375, {3., 7.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{42.94921875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 46, 24408456342082606278, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{49.7578125, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 46, 24408456342082606278, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{36.87890625, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 46, 24408456342082606278, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{63.8671875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[24408456342082606278 === $SessionID, 
   Out[46], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.874390430813024*^9, 3.874476431617229*^9, 
  3.874491309331696*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"26460445-7a2f-4ad7-a2d7-6985e84a9c1b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["zs"], "Input",
 CellChangeTimes->{{3.871103003298069*^9, 3.871103005608036*^9}, 
   3.871108681688264*^9},
 CellLabel->"In[47]:=",ExpressionUUID->"967a2b16-3ba1-4036-9c83-f73b1081483d"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              SubscriptBox["k", "co"], " ", 
              SubscriptBox["k", "on"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 SubscriptBox["N", "tot"]}], "-", 
                FractionBox[
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"], 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"]], "-", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], "+", 
                FractionBox[
                 RowBox[{
                  RowBox[{"(", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"di", " ", 
                    SubscriptBox["k", "oc"], " ", 
                    SubscriptBox["k", "on"], " ", 
                    SubscriptBox["N", "tot"]}], 
                    RowBox[{"L", " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}]]}], "+", 
                    TemplateBox[{"36"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]]}], ")"}]}], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    TemplateBox[{"36"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"Sinh", "[", 
                    RowBox[{"di", " ", 
                    SqrtBox[
                    SubscriptBox["\[Lambda]s", "-"]]}], "]"}], " ", 
                    TemplateBox[{"7"},
                    "OutputSizeLimit`Skeleton"], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], 
                    RowBox[{"L", " ", 
                    TemplateBox[{"4"},
                    "OutputSizeLimit`Skeleton"]}]]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}]]}], ")"}]}], 
             RowBox[{"2", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubscriptBox["k", "oc"], " ", 
                 SubscriptBox["k", "on"]}], "+", 
                RowBox[{
                 SubscriptBox["k", "co"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SubscriptBox["k", "off"], "+", 
                   SubscriptBox["k", "on"]}], ")"}]}]}], ")"}]}]]}], ",", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{
              SubscriptBox["k", "oc"], " ", 
              SubscriptBox["k", "on"], " ", 
              SubscriptBox["\[Gamma]", "oc"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 SubscriptBox["N", "tot"]}], "-", 
                FractionBox[
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"], 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"]], "-", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], "+", 
                FractionBox[
                 RowBox[{
                  RowBox[{"(", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    TemplateBox[{"39"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "-", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}]]}], ")"}]}], 
             RowBox[{"2", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubscriptBox["k", "oc"], " ", 
                 SubscriptBox["k", "on"]}], "+", 
                RowBox[{
                 SubscriptBox["k", "co"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SubscriptBox["k", "off"], "+", 
                   SubscriptBox["k", "on"]}], ")"}]}]}], ")"}], " ", 
              SubscriptBox["\[Gamma]", "co"]}]]}]}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{49.65234375, {3., 7.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{42.94921875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 47, 24408456342082606278, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{49.7578125, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 47, 24408456342082606278, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{36.87890625, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 47, 24408456342082606278, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{63.8671875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[24408456342082606278 === $SessionID, 
   Out[47], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.871103006123497*^9, 3.871103042832239*^9, 
  3.871103081569043*^9, 3.871103523352269*^9, 3.871108682193668*^9, 
  3.873285785239787*^9, 3.873368546961109*^9, 3.873436702887957*^9, 
  3.873439185000966*^9, 3.873441924853436*^9, 3.8734562623601627`*^9, 
  3.8736996979288607`*^9, 3.873786121471261*^9, 3.873799206109771*^9, 
  3.873799657063238*^9, 3.873800114692254*^9, 3.874231962743471*^9, 
  3.874315742087572*^9, 3.874318128863923*^9, 3.874324096439533*^9, 
  3.874384573974732*^9, 3.8743903963453207`*^9, 3.8743904399395113`*^9, 
  3.874476434852413*^9, 3.8744913115092583`*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"93d531fb-740f-410e-8095-d44ddc72fa3d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Simplification and study of the analytical form of the coefficients\
\>", "Subsection",
 CellChangeTimes->{{3.870345140377315*^9, 
  3.870345174164043*^9}},ExpressionUUID->"5fcd1d6b-14f0-4e0f-9891-\
c7d2142cc0b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     SubscriptBox["D", "c"], " ", 
     SubscriptBox["D", "o"], " ", 
     SubscriptBox["k", "co"], " ", 
     SubscriptBox["k", "off"]}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["D", "o"], " ", 
        SubscriptBox["k", "co"]}], "+", 
       RowBox[{
        SubscriptBox["D", "c"], " ", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["k", "oc"], "+", 
          SubscriptBox["k", "off"]}], ")"}]}]}], ")"}], "2"]}], "==", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["D", "o", "2"], " ", 
     SubsuperscriptBox["k", "co", "2"]}], "+", 
    RowBox[{"2", " ", 
     SubscriptBox["D", "c"], " ", 
     SubscriptBox["D", "o"], " ", 
     SubscriptBox["k", "co"], " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["k", "oc"], "-", 
       SubscriptBox["k", "off"]}], ")"}]}], "+", 
    RowBox[{
     SubsuperscriptBox["D", "c", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["k", "oc"], "+", 
        SubscriptBox["k", "off"]}], ")"}], "2"]}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.870345105423295*^9, 3.870345127949182*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"a3d92836-eab4-45f5-bfdd-723d815b29af"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.870345117212427*^9, 3.870345128240094*^9}, 
   3.8703484392845783`*^9, 3.870348499240797*^9, 3.870858065501377*^9, 
   3.870863888861157*^9, 3.8709298670763273`*^9, 3.870940185189034*^9, 
   3.871025837079768*^9, 3.871099915199353*^9, 3.871101032257032*^9, 
   3.871101559063448*^9, 3.871102314712785*^9, 3.87110308165281*^9, 
   3.8711035234428864`*^9, 3.873343874478956*^9, 3.8733685470226297`*^9, 
   3.8734367029331207`*^9, 3.873439185063572*^9, 3.8734419248873158`*^9, 
   3.873456262406022*^9, 3.873699698015579*^9, 3.873786121531123*^9, 
   3.873799206204772*^9, 3.87379965714711*^9, 3.873800114773678*^9, 
   3.8742319628158693`*^9, 3.874315742179687*^9, 3.874318128952572*^9, 
   3.874324096514077*^9, 3.874384574051265*^9, 3.874476435033621*^9, 
   3.8744913116362247`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"4080f8fd-0d85-44f0-9577-f5c6c1c3b477"]
}, Open  ]],

Cell["\<\
In the coefficients appears very often the same square root that appears in \
the eigenvalues,
In order to make the expression shorter, I introduced the following \
substitution:\
\>", "Text",
 CellChangeTimes->{{3.870345132874812*^9, 3.8703451334516687`*^9}, {
  3.87034522289808*^9, 3.8703452502937317`*^9}, {3.870860532345798*^9, 
  3.870860560375987*^9}},ExpressionUUID->"683e555f-49cf-4091-8704-\
304d01475451"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"shortVV", "=", 
  RowBox[{"vv", " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{
         SubsuperscriptBox["D", "o", "2"], " ", 
         SubsuperscriptBox["k", "co", "2"]}], "+", 
        RowBox[{"2", " ", 
         SubscriptBox["D", "c"], " ", 
         SubscriptBox["D", "o"], " ", 
         SubscriptBox["k", "co"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["k", "oc"], "-", 
           SubscriptBox["k", "off"]}], ")"}]}], "+", 
        RowBox[{
         SubsuperscriptBox["D", "c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["k", "oc"], "+", 
            SubscriptBox["k", "off"]}], ")"}], "2"]}]}]], " ", "\[Rule]", 
      "A"}], ",", " ", 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{
         SubsuperscriptBox["D", "o", "2"], " ", 
         SubsuperscriptBox["k", "co", "2"], " ", 
         SubsuperscriptBox["\[Gamma]", "co", "2"]}], "-", 
        RowBox[{"2", " ", 
         SubscriptBox["D", "c"], " ", 
         SubscriptBox["D", "o"], " ", 
         SubscriptBox["k", "co"], " ", 
         SubscriptBox["\[Gamma]", "co"], " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["k", "off"], "-", 
           RowBox[{
            SubscriptBox["k", "oc"], " ", 
            SubscriptBox["\[Gamma]", "oc"]}]}], ")"}]}], "+", 
        RowBox[{
         SubsuperscriptBox["D", "c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["k", "off"], "+", 
            RowBox[{
             SubscriptBox["k", "oc"], " ", 
             SubscriptBox["\[Gamma]", "oc"]}]}], ")"}], "2"]}]}]], "\[Rule]", 
      " ", "As"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{
  3.870348614116046*^9, {3.870858311555709*^9, 3.870858348605898*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"4630bc56-60bf-4e22-9204-6d3c67059c31"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          TemplateBox[{"1"},
           "OutputSizeLimit`Skeleton"], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{49.65234375, {3., 7.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{42.94921875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 49, 24408456342082606278, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{49.7578125, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 49, 24408456342082606278, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{36.87890625, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 49, 24408456342082606278, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{63.8671875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[24408456342082606278 === $SessionID, 
   Out[49], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.870863888925888*^9, 3.870929867115075*^9, 
  3.870940185263874*^9, 3.871025837137019*^9, 3.871099915274119*^9, 
  3.871101032325014*^9, 3.871101559115234*^9, 3.8711023147733183`*^9, 
  3.871103083109166*^9, 3.871103524898967*^9, 3.873343876032342*^9, 
  3.873368548555311*^9, 3.873436704384623*^9, 3.873439190691181*^9, 
  3.873441928620984*^9, 3.873456266241735*^9, 3.873699699498013*^9, 
  3.8737861225495462`*^9, 3.8737992076790257`*^9, 3.873799658621019*^9, 
  3.873800116258073*^9, 3.874231964005199*^9, 3.8743157436890574`*^9, 
  3.8743181302280617`*^9, 3.874324097687498*^9, 3.874384575117325*^9, 
  3.874476464034081*^9, 3.874491335072584*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"d6f44326-a91f-4f7f-a948-d076bf95ba77"]
}, Open  ]],

Cell["\<\
This simplification takes around 10 min to compute, I exported it in an \
external file, so \
\>", "Text",
 CellChangeTimes->{{3.8708605751633368`*^9, 3.870860605502571*^9}, {
  3.87086068179639*^9, 
  3.8708606856198673`*^9}},ExpressionUUID->"d4d4237e-a947-4d62-b311-\
10d8c03fd13a"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"shortVV", "=", 
    RowBox[{"Simplify", "[", " ", "shortVV", " ", "]"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
    "\"\</home/salats/Documenti/PCS/tesi/mathematica/PBC/coeff.mx\>\"", ",", 
     "shortVV"}], "]"}], ";"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.870858369057259*^9, 3.87085841732198*^9}, {
  3.870858505475849*^9, 3.8708585114957867`*^9}, {3.870860494195038*^9, 
  3.8708605031210938`*^9}, {3.870860618805613*^9, 3.870860632766151*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"8fb1b804-8410-4f69-b5d7-9dc473c6e346"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"shortVV", "=", 
   RowBox[{
   "Import", "[", 
    "\"\</home/salats/Documenti/PCS/tesi/mathematica/PBC/coeff.mx\>\"", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.870859608602227*^9, 3.870859642034128*^9}, {
  3.870859966404601*^9, 3.870859966668531*^9}, {3.870860070028891*^9, 
  3.8708600859716597`*^9}, {3.870860123557218*^9, 3.87086013706103*^9}, {
  3.870860622861977*^9, 3.870860677376814*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"9d01fa14-2399-4ab6-b003-8b02279f9288"],

Cell[BoxData[
 TemplateBox[{
  "Import", "nffil", 
   "\"File \\!\\(\\*RowBox[{\\\"\\\\\\\"/home/salats/Documenti/PCS/tesi/\
mathematica/PBC/coeff.mx\\\\\\\"\\\"}]\\) not found during \
\\!\\(\\*RowBox[{\\\"Import\\\"}]\\).\"", 2, 51, 1, 24408456342082606278, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8733438762135687`*^9, 3.873368548682255*^9, 
  3.873436704528125*^9, 3.8734391909540977`*^9, 3.873441928784403*^9, 
  3.873456266348733*^9, 3.873699699663259*^9, 3.8737861226415167`*^9, 
  3.873799207819201*^9, 3.873799658738187*^9, 3.873800116412562*^9, 
  3.8742319641420097`*^9, 3.8743157438885803`*^9, 3.8743181304157057`*^9, 
  3.874324097816983*^9, 3.8743845752686253`*^9, 3.8744764650790453`*^9, 
  3.8744913359375134`*^9},
 CellLabel->
  "During evaluation of \
In[51]:=",ExpressionUUID->"c41deeb6-deef-4571-9082-fc1aba9f360e"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Numerical values and plots! (after a first evaluation, just run this last \
section)\
\>", "Section",
 CellChangeTimes->{{3.865412780915193*^9, 3.865412784523015*^9}, {
  3.8654199741031103`*^9, 3.865419976832881*^9}, {3.8654217233897038`*^9, 
  3.865421751572958*^9}, {3.865587042927815*^9, 
  3.865587068498247*^9}},ExpressionUUID->"4f5228d8-f075-433d-bc45-\
6672eb886da4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Nv", "tot"], "=", "75"}], ";", " ", 
  RowBox[{
   SubscriptBox["kv", "on"], "=", "0.03"}], ";", " ", 
  RowBox[{
   SubscriptBox["kv", "off"], " ", "=", " ", "0.1"}], ";"}]], "Input",
 CellChangeTimes->{{3.871103096004587*^9, 3.8711031388601837`*^9}, 
   3.871103388778982*^9, {3.871104217097993*^9, 3.871104218460998*^9}, {
   3.8733438277069187`*^9, 3.873343827888165*^9}, 3.8733443860257874`*^9, {
   3.8733686073270893`*^9, 3.8733686412289953`*^9}, {3.8737992334144983`*^9, 
   3.873799235922804*^9}, 3.873799294235693*^9, {3.873800081700686*^9, 
   3.8738000819303703`*^9}, 3.8743152695498734`*^9},
 CellLabel->"In[97]:=",ExpressionUUID->"85f3d4dc-2e9e-4418-8025-dfc53ba66b87"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["kv", "oc"], "=", "0.02"}], ";", " ", 
   RowBox[{
    SubscriptBox["kv", "co"], " ", "=", " ", "0.01"}], ";", " ", 
   RowBox[{
    SubscriptBox["\[Gamma]v", "oc"], " ", "=", " ", "1000"}], ";", " ", 
   RowBox[{
    SubscriptBox["\[Gamma]v", "co"], "=", " ", "2"}], ";", " ", 
   RowBox[{
    SubscriptBox["Dv", "o"], "=", "0.07"}], ";", " ", 
   RowBox[{
    SubscriptBox["Dv", "c"], " ", "=", " ", "0.007"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"Lv", "=", "50"}], ";", " ", 
   RowBox[{"div", "=", "1"}], ";"}]}]}], "Input",
 CellChangeTimes->{
  3.865421491926985*^9, {3.8654215360997753`*^9, 3.86542162569445*^9}, {
   3.865421660484646*^9, 3.8654216609691133`*^9}, {3.8654217937939034`*^9, 
   3.8654218420630836`*^9}, {3.865421938840406*^9, 3.865421939021715*^9}, {
   3.865421970304166*^9, 3.865421970452509*^9}, {3.865422528021867*^9, 
   3.865422580689043*^9}, {3.865486586327509*^9, 3.865486611619156*^9}, {
   3.86548691334085*^9, 3.865486913502491*^9}, {3.865504507516572*^9, 
   3.86550453134693*^9}, {3.865504788248146*^9, 3.865504795162526*^9}, {
   3.865505026301528*^9, 3.865505027864496*^9}, {3.865505558733165*^9, 
   3.865505562239355*^9}, {3.865505601569529*^9, 3.865505625569497*^9}, {
   3.8655058785167017`*^9, 3.865505880284679*^9}, {3.865507153360779*^9, 
   3.865507224988649*^9}, {3.865507283316478*^9, 3.865507309859313*^9}, {
   3.870256822216276*^9, 3.87025686780984*^9}, {3.870257758454008*^9, 
   3.870257774107897*^9}, {3.870318907831604*^9, 3.870318911219906*^9}, {
   3.8703190995530787`*^9, 3.8703191017257557`*^9}, {3.870319148698189*^9, 
   3.870319153507276*^9}, 3.870321195219058*^9, {3.870321363099268*^9, 
   3.870321371445813*^9}, {3.870326250381961*^9, 3.870326254014143*^9}, {
   3.8703308646183662`*^9, 3.87033086481269*^9}, {3.870331493633507*^9, 
   3.870331496533298*^9}, {3.870337075630456*^9, 3.870337086929069*^9}, {
   3.870344119397439*^9, 3.870344119754333*^9}, {3.87034416977596*^9, 
   3.870344181701236*^9}, 3.8708637610912037`*^9, {3.870863853337619*^9, 
   3.8708638592005777`*^9}, {3.8709199592451773`*^9, 3.870919959657611*^9}, {
   3.8709200036492233`*^9, 3.870920006527851*^9}, {3.8709200445978947`*^9, 
   3.870920049767152*^9}, {3.8709302185071487`*^9, 3.8709302786127367`*^9}, {
   3.870930441610517*^9, 3.8709304430043373`*^9}, 3.8709309846068583`*^9, 
   3.870940571520636*^9, {3.870941925678217*^9, 3.870941925848555*^9}, 
   3.871103130733562*^9, {3.871103937523967*^9, 3.871103943579111*^9}, 
   3.871104190523036*^9, {3.871104246644372*^9, 3.8711042867268*^9}, 
   3.873300210905106*^9, {3.873300250912704*^9, 3.873300251115209*^9}, {
   3.8733003804838743`*^9, 3.873300407272195*^9}, {3.873300874516304*^9, 
   3.873300876392758*^9}, {3.873301165521859*^9, 3.873301167186648*^9}, {
   3.873343813712912*^9, 3.873343820064604*^9}, {3.8733439569877243`*^9, 
   3.8733439588455753`*^9}, {3.8733443830486717`*^9, 3.873344405444186*^9}, {
   3.873368568782593*^9, 3.87336860541579*^9}, 3.873436933231024*^9, {
   3.8734429728364477`*^9, 3.873442974790818*^9}, 3.874315277510223*^9, 
   3.87432411968013*^9, {3.874324298018394*^9, 3.874324298589548*^9}, 
   3.874324361046876*^9, {3.8743844316699944`*^9, 3.874384435841498*^9}, {
   3.874384485207897*^9, 3.874384485521257*^9}, {3.874390993290921*^9, 
   3.874390995661112*^9}, 3.874491506947332*^9},
 CellLabel->"In[98]:=",ExpressionUUID->"e07b083e-eb46-489e-a0a2-6786a4b5a649"],

Cell[CellGroupData[{

Cell["Interesting ratios of the system parameters:", "Subsubsection",
 CellChangeTimes->{{3.8709308658650303`*^9, 
  3.870930878857284*^9}},ExpressionUUID->"cae7e8c3-2ba1-45cc-b69d-\
e368966c29f4"],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox["div", "Lv"]], "Input",
 CellChangeTimes->{{3.870930902194665*^9, 3.870930903610169*^9}},
 CellLabel->
  "In[100]:=",ExpressionUUID->"d0fba3f0-0d95-486c-87c4-e463c00566b1"],

Cell[BoxData[
 FractionBox["1", "50"]], "Output",
 CellChangeTimes->{
  3.8709309046318007`*^9, 3.8709309889556026`*^9, 3.870940185459627*^9, 
   3.870940582372826*^9, 3.870941932078925*^9, 3.8710258373008966`*^9, 
   3.871099915457296*^9, 3.8711010324984303`*^9, 3.871101559314076*^9, 
   3.871102314977955*^9, 3.8711030833406878`*^9, 3.8711035251003942`*^9, 
   3.871103948542016*^9, {3.871104197716207*^9, 3.871104251966791*^9}, 
   3.8711042915994673`*^9, 3.87328644743828*^9, 3.873300216454392*^9, 
   3.8733002580415173`*^9, 3.873300426532786*^9, 3.8733008812577763`*^9, 
   3.8733011740273*^9, 3.873343918488619*^9, 3.873343963619574*^9, 
   3.873344417793623*^9, 3.873368548750917*^9, 3.873368588111051*^9, {
   3.873368618887534*^9, 3.873368645591399*^9}, 3.873436704580922*^9, 
   3.873436942309841*^9, 3.873439191075591*^9, 3.8734419288587646`*^9, 
   3.8734429854024982`*^9, 3.873456266395612*^9, 3.873699699762685*^9, 
   3.873786122700808*^9, 3.873799207927449*^9, 3.873799250259655*^9, 
   3.873799297746294*^9, 3.873799658834477*^9, 3.873800116505456*^9, 
   3.874231964228231*^9, 3.874315743985999*^9, 3.874318130514817*^9, {
   3.8743240978829327`*^9, 3.874324123537941*^9}, 3.874324304779471*^9, 
   3.87432437285384*^9, 3.8743844468768387`*^9, 3.874384494249833*^9, 
   3.8743845753619347`*^9, 3.8743904569262733`*^9, 3.874391038216617*^9, 
   3.874476465188236*^9, 3.874491336070958*^9, 3.874491520478057*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"7863016f-68d5-417b-88a4-e7a118281cb7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  SubscriptBox["kv", "oc"], 
  SubscriptBox["kv", "co"]]], "Input",
 CellChangeTimes->{{3.8709309226725388`*^9, 3.870930926769203*^9}},
 CellLabel->
  "In[101]:=",ExpressionUUID->"117361dc-a2ff-4d2e-a90d-fcd2c9b2847a"],

Cell[BoxData["2.`"], "Output",
 CellChangeTimes->{
  3.8709309283019943`*^9, 3.870930988998082*^9, 3.870940185542307*^9, 
   3.870940582424287*^9, 3.870941932134705*^9, 3.8710258373642797`*^9, 
   3.871099915541834*^9, 3.8711010325454483`*^9, 3.8711015593787127`*^9, 
   3.871102315050602*^9, 3.871103083414112*^9, 3.8711035251735573`*^9, 
   3.87110394859101*^9, {3.87110419776539*^9, 3.871104252028639*^9}, 
   3.8711042916507177`*^9, 3.873286447477626*^9, 3.873300216492917*^9, 
   3.873300258089682*^9, 3.873300426576009*^9, 3.873300881304439*^9, 
   3.873301174075595*^9, 3.8733439185476294`*^9, 3.8733439636790857`*^9, 
   3.873344417837967*^9, 3.873368548805193*^9, 3.873368588170164*^9, {
   3.8733686189382763`*^9, 3.873368645638032*^9}, 3.8734367046071053`*^9, 
   3.873436942369895*^9, 3.8734391911113253`*^9, 3.873441928895047*^9, 
   3.8734429854476767`*^9, 3.873456266418298*^9, 3.873699699811455*^9, 
   3.873786122730942*^9, 3.873799207986445*^9, 3.873799250331398*^9, 
   3.8737992978005342`*^9, 3.873799658880908*^9, 3.873800116564851*^9, 
   3.874231964274681*^9, 3.874315744035027*^9, 3.874318130577283*^9, {
   3.87432409791719*^9, 3.874324123591757*^9}, 3.874324304832559*^9, 
   3.874324372907399*^9, 3.874384446911705*^9, 3.8743844942860947`*^9, 
   3.8743845754075108`*^9, 3.874390456982355*^9, 3.87439103827649*^9, 
   3.874476465256442*^9, 3.8744913361177073`*^9, 3.8744915205283127`*^9},
 CellLabel->
  "Out[101]=",ExpressionUUID->"f1fb0f0e-da17-4a1f-9d2b-760337eb0888"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  SubscriptBox["Dv", "c"], 
  SubscriptBox["Dv", "o"]]], "Input",
 CellChangeTimes->{{3.870930952372108*^9, 3.8709309556350327`*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"d9d4ed82-e5cf-49ea-9ee2-b419279d604d"],

Cell[BoxData["0.09999999999999999`"], "Output",
 CellChangeTimes->{
  3.8709309570001917`*^9, 3.870930989045322*^9, 3.870940185607193*^9, 
   3.870940582476918*^9, 3.8709419321838818`*^9, 3.871025837412819*^9, 
   3.8710999156090612`*^9, 3.8711010325916767`*^9, 3.871101559434935*^9, 
   3.871102315096429*^9, 3.8711030834692163`*^9, 3.8711035252315273`*^9, 
   3.871103948639496*^9, {3.8711041978114147`*^9, 3.871104252076254*^9}, 
   3.87110429169767*^9, 3.873286447519938*^9, 3.873300216545474*^9, 
   3.87330025812728*^9, 3.873300426586133*^9, 3.87330088135282*^9, 
   3.873301174120182*^9, 3.873343918602263*^9, 3.873343963726243*^9, 
   3.873344417884078*^9, 3.87336854885998*^9, 3.873368588219953*^9, {
   3.8733686189857607`*^9, 3.8733686456821127`*^9}, 3.873436704634198*^9, 
   3.8734369424260674`*^9, 3.87343919115077*^9, 3.873441928932027*^9, 
   3.873442985461215*^9, 3.8734562664419003`*^9, 3.873699699861828*^9, 
   3.873786122760079*^9, 3.873799207996664*^9, 3.873799250395216*^9, 
   3.8737992978583803`*^9, 3.873799658928523*^9, 3.873800116629087*^9, 
   3.874231964283222*^9, 3.8743157440841103`*^9, 3.8743181305887423`*^9, {
   3.874324097952425*^9, 3.874324123648964*^9}, 3.87432430488341*^9, 
   3.874324372981583*^9, 3.8743844469617968`*^9, 3.874384494329108*^9, 
   3.8743845754595213`*^9, 3.874390457042375*^9, 3.874391038332984*^9, 
   3.874476465325203*^9, 3.874491336166706*^9, 3.874491520538769*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"39bf5f8d-f322-44cc-8334-ed9c92b81997"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
I create this variables with an extra v that stays for the \
\[OpenCurlyDoubleQuote]numerical value\[CloseCurlyDoubleQuote]\
\>", "Subsection",
 CellChangeTimes->{{3.865420665531465*^9, 
  3.865420699096757*^9}},ExpressionUUID->"239260a6-05e5-4a9f-a352-\
07c1971d347b"],

Cell["\<\
Now I will try to assign values to new variable in order to not lose the \
symbolic expressions\
\>", "Text",
 CellChangeTimes->{{3.865419980049313*^9, 3.865420033166861*^9}, {
  3.870257080713496*^9, 
  3.870257081637199*^9}},ExpressionUUID->"30a34616-13db-414b-bad9-\
04fdd8f47ad6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"eig1", "=", 
  RowBox[{
   RowBox[{"eig", "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}]}], "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"eig2", "=", 
  RowBox[{
   RowBox[{"eig", "[", 
    RowBox[{"[", "2", "]"}], "]"}], " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}]}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.865412661396297*^9, 3.865412662022331*^9}, 
   3.8654141706818657`*^9, 3.865414409061586*^9, {3.865417720736855*^9, 
   3.86541772642699*^9}, 3.865417996883071*^9, {3.865418335163484*^9, 
   3.8654184746728373`*^9}, {3.865419652121319*^9, 3.865419738875984*^9}, {
   3.865420435351364*^9, 3.865420538996101*^9}, {3.8654206091518*^9, 
   3.865420611661619*^9}, {3.865504815848984*^9, 3.865504836174698*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"852bffad-239f-4324-81d1-c75c4ad1022d"],

Cell[BoxData["0.9167749007205945`"], "Output",
 CellChangeTimes->{{3.865420512819396*^9, 3.865420530961288*^9}, {
   3.8654206095537863`*^9, 3.865420624616878*^9}, 3.8654207778866787`*^9, 
   3.865421249612369*^9, 3.865421282610798*^9, 3.865421496193419*^9, {
   3.865421550331126*^9, 3.865421563719777*^9}, {3.865421602142627*^9, 
   3.865421630598187*^9}, 3.865421666169106*^9, {3.8654218057478447`*^9, 
   3.865421848708818*^9}, {3.865421946540574*^9, 3.865421974960353*^9}, 
   3.865422399600421*^9, {3.865422533444193*^9, 3.865422563174479*^9}, 
   3.865481761641789*^9, 3.865481798913907*^9, 3.865482086167695*^9, 
   3.865486624588476*^9, 3.865486926868348*^9, 3.865504559140421*^9, 
   3.865504731218238*^9, 3.865504847441288*^9, 3.865505033417192*^9, 
   3.865505567517523*^9, 3.865505609929891*^9, 3.865505946776132*^9, 
   3.865587715862473*^9, 3.870173891505063*^9, 3.870177116517373*^9, 
   3.87023213653027*^9, 3.870256429657587*^9, 3.8702577793622913`*^9, 
   3.8703170059455147`*^9, 3.870317879893662*^9, 3.870318917099272*^9, 
   3.87031910556285*^9, 3.870319179117826*^9, 3.8703209143998003`*^9, 
   3.870321215956691*^9, 3.870321382673806*^9, 3.8703262671587133`*^9, 
   3.870326297449554*^9, 3.870330045719274*^9, 3.870330868114333*^9, 
   3.870331506909477*^9, 3.870336611488351*^9, {3.8703371188647423`*^9, 
   3.870337148090145*^9}, 3.870344129017099*^9, 3.870344186480977*^9, 
   3.870348555975176*^9, 3.870858120418035*^9, 3.870860979207156*^9, 
   3.8708637668990307`*^9, 3.870863889056872*^9, 3.870918437090892*^9, 
   3.870919964185011*^9, 3.8709200096398897`*^9, 3.870920053508944*^9, 
   3.870929867250689*^9, 3.870930224188003*^9, 3.870930282610536*^9, 
   3.8709304474108887`*^9, 3.87093098908906*^9, 3.8709401856753883`*^9, 
   3.870940582534391*^9, 3.87094193219427*^9, 3.8710258374659557`*^9, 
   3.871099915678355*^9, 3.871101032641633*^9, 3.8711015594858217`*^9, 
   3.871102315153363*^9, 3.871103083530559*^9, 3.871103525286903*^9, 
   3.871103948697276*^9, {3.871104197857608*^9, 3.8711042521235237`*^9}, 
   3.871104291742333*^9, 3.87328644756355*^9, 3.873300216583297*^9, 
   3.8733002581615*^9, 3.873300426627654*^9, 3.8733008813957453`*^9, 
   3.873301174155354*^9, 3.873343918647052*^9, 3.87334396377044*^9, 
   3.873344417925592*^9, 3.873368548927066*^9, 3.873368588269754*^9, {
   3.873368619031994*^9, 3.873368645722456*^9}, 3.87343670466319*^9, 
   3.873436942478628*^9, 3.873439191194952*^9, 3.87344192896854*^9, 
   3.873442985497168*^9, 3.873456266473085*^9, 3.873699699911005*^9, 
   3.8737861227895527`*^9, 3.873799208072649*^9, 3.873799250450486*^9, 
   3.873799297915781*^9, 3.873799658978764*^9, 3.873800116690737*^9, 
   3.874231964340171*^9, 3.874315744140081*^9, 3.8743181306567097`*^9, {
   3.874324097992551*^9, 3.8743241237041283`*^9}, 3.874324304941042*^9, 
   3.874324373037753*^9, 3.874384447002513*^9, 3.874384494376349*^9, 
   3.874384575511835*^9, 3.8743900024215803`*^9, 3.874390457180077*^9, 
   3.874391038511694*^9, 3.8744764654438343`*^9, 3.8744913362651577`*^9, 
   3.874491520734572*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"a6c60a27-0d69-4f83-b695-604d4d410199"],

Cell[BoxData["2.2260822421365485`"], "Output",
 CellChangeTimes->{{3.865420512819396*^9, 3.865420530961288*^9}, {
   3.8654206095537863`*^9, 3.865420624616878*^9}, 3.8654207778866787`*^9, 
   3.865421249612369*^9, 3.865421282610798*^9, 3.865421496193419*^9, {
   3.865421550331126*^9, 3.865421563719777*^9}, {3.865421602142627*^9, 
   3.865421630598187*^9}, 3.865421666169106*^9, {3.8654218057478447`*^9, 
   3.865421848708818*^9}, {3.865421946540574*^9, 3.865421974960353*^9}, 
   3.865422399600421*^9, {3.865422533444193*^9, 3.865422563174479*^9}, 
   3.865481761641789*^9, 3.865481798913907*^9, 3.865482086167695*^9, 
   3.865486624588476*^9, 3.865486926868348*^9, 3.865504559140421*^9, 
   3.865504731218238*^9, 3.865504847441288*^9, 3.865505033417192*^9, 
   3.865505567517523*^9, 3.865505609929891*^9, 3.865505946776132*^9, 
   3.865587715862473*^9, 3.870173891505063*^9, 3.870177116517373*^9, 
   3.87023213653027*^9, 3.870256429657587*^9, 3.8702577793622913`*^9, 
   3.8703170059455147`*^9, 3.870317879893662*^9, 3.870318917099272*^9, 
   3.87031910556285*^9, 3.870319179117826*^9, 3.8703209143998003`*^9, 
   3.870321215956691*^9, 3.870321382673806*^9, 3.8703262671587133`*^9, 
   3.870326297449554*^9, 3.870330045719274*^9, 3.870330868114333*^9, 
   3.870331506909477*^9, 3.870336611488351*^9, {3.8703371188647423`*^9, 
   3.870337148090145*^9}, 3.870344129017099*^9, 3.870344186480977*^9, 
   3.870348555975176*^9, 3.870858120418035*^9, 3.870860979207156*^9, 
   3.8708637668990307`*^9, 3.870863889056872*^9, 3.870918437090892*^9, 
   3.870919964185011*^9, 3.8709200096398897`*^9, 3.870920053508944*^9, 
   3.870929867250689*^9, 3.870930224188003*^9, 3.870930282610536*^9, 
   3.8709304474108887`*^9, 3.87093098908906*^9, 3.8709401856753883`*^9, 
   3.870940582534391*^9, 3.87094193219427*^9, 3.8710258374659557`*^9, 
   3.871099915678355*^9, 3.871101032641633*^9, 3.8711015594858217`*^9, 
   3.871102315153363*^9, 3.871103083530559*^9, 3.871103525286903*^9, 
   3.871103948697276*^9, {3.871104197857608*^9, 3.8711042521235237`*^9}, 
   3.871104291742333*^9, 3.87328644756355*^9, 3.873300216583297*^9, 
   3.8733002581615*^9, 3.873300426627654*^9, 3.8733008813957453`*^9, 
   3.873301174155354*^9, 3.873343918647052*^9, 3.87334396377044*^9, 
   3.873344417925592*^9, 3.873368548927066*^9, 3.873368588269754*^9, {
   3.873368619031994*^9, 3.873368645722456*^9}, 3.87343670466319*^9, 
   3.873436942478628*^9, 3.873439191194952*^9, 3.87344192896854*^9, 
   3.873442985497168*^9, 3.873456266473085*^9, 3.873699699911005*^9, 
   3.8737861227895527`*^9, 3.873799208072649*^9, 3.873799250450486*^9, 
   3.873799297915781*^9, 3.873799658978764*^9, 3.873800116690737*^9, 
   3.874231964340171*^9, 3.874315744140081*^9, 3.8743181306567097`*^9, {
   3.874324097992551*^9, 3.8743241237041283`*^9}, 3.874324304941042*^9, 
   3.874324373037753*^9, 3.874384447002513*^9, 3.874384494376349*^9, 
   3.874384575511835*^9, 3.8743900024215803`*^9, 3.874390457180077*^9, 
   3.874391038511694*^9, 3.8744764654438343`*^9, 3.8744913362651577`*^9, 
   3.874491520775674*^9},
 CellLabel->
  "Out[104]=",ExpressionUUID->"e785ba93-0fab-4d4c-9f49-6c13becd7666"]
}, Open  ]],

Cell["Now the \"special\" eigenvalues", "Text",
 CellChangeTimes->{{3.8702574004487534`*^9, 
  3.870257415384037*^9}},ExpressionUUID->"92e342be-dcee-4597-94d4-\
c2a706a0cc9c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"eigs1", "=", 
  RowBox[{
   RowBox[{"eigs", "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}]}], "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"eigs2", "=", 
  RowBox[{
   RowBox[{"eigs", "[", 
    RowBox[{"[", "2", "]"}], "]"}], " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}]}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.870256506918454*^9, 3.8702565460145683`*^9}},
 CellLabel->
  "In[105]:=",ExpressionUUID->"a4fdd237-d391-471a-8e64-4995504fed33"],

Cell[BoxData["0.014075278505259225`"], "Output",
 CellChangeTimes->{{3.870256532536278*^9, 3.8702565465832644`*^9}, 
   3.8702577794174356`*^9, 3.870317005987903*^9, 3.870317879940916*^9, 
   3.870318917136964*^9, 3.870319105605163*^9, 3.8703191791637363`*^9, 
   3.8703209144395933`*^9, 3.870321216007218*^9, 3.8703213827223377`*^9, 
   3.870326267230157*^9, 3.8703262975162163`*^9, 3.8703300457661657`*^9, 
   3.870330868165063*^9, 3.8703315069588337`*^9, 3.870336611538293*^9, {
   3.8703371189172583`*^9, 3.870337148146899*^9}, 3.8703441290488167`*^9, 
   3.87034418652717*^9, 3.870348556014422*^9, 3.8708581204836397`*^9, 
   3.8708609792565317`*^9, 3.870863766951158*^9, 3.870863889108617*^9, 
   3.8709184371454983`*^9, 3.870919964228973*^9, 3.870920009685458*^9, 
   3.8709200535569057`*^9, 3.870929867281506*^9, 3.870930224221465*^9, 
   3.870930282647778*^9, 3.870930447446375*^9, 3.87093098913547*^9, 
   3.870940185742687*^9, 3.870940582594149*^9, 3.870941932246813*^9, 
   3.8710258375202017`*^9, 3.871099915752632*^9, 3.871101032690248*^9, 
   3.871101559539289*^9, 3.871102315211904*^9, 3.871103083587173*^9, 
   3.871103525347289*^9, 3.871103948757422*^9, {3.871104197901819*^9, 
   3.871104252171883*^9}, 3.871104291790111*^9, 3.873286447606142*^9, 
   3.873300216630835*^9, 3.873300258214354*^9, 3.87330042671117*^9, 
   3.8733008814382477`*^9, 3.873301174197955*^9, 3.873343918703644*^9, 
   3.8733439638190203`*^9, 3.8733444179668922`*^9, 3.873368548992391*^9, 
   3.873368588318338*^9, {3.8733686190825777`*^9, 3.873368645764699*^9}, 
   3.873436704694199*^9, 3.873436942530034*^9, 3.8734391912338753`*^9, 
   3.873441929005142*^9, 3.873442985538232*^9, 3.873456266502014*^9, 
   3.873699699968563*^9, 3.873786122823378*^9, 3.873799208134959*^9, 
   3.8737992505082006`*^9, 3.8737992979767036`*^9, 3.8737996590349197`*^9, 
   3.873800116755883*^9, 3.874231964449193*^9, 3.874315744199052*^9, 
   3.874318130782819*^9, {3.874324098034786*^9, 3.874324123760928*^9}, 
   3.874324304996662*^9, 3.874324373089932*^9, 3.874384447042934*^9, 
   3.874384494425762*^9, 3.874384575564262*^9, 3.874390004995657*^9, 
   3.874390457436721*^9, 3.874391038693529*^9, 3.8744764656260023`*^9, 
   3.87449133644871*^9, 3.874491520867695*^9},
 CellLabel->
  "Out[105]=",ExpressionUUID->"ebbfa17f-3822-4a45-b470-104f1b7887b7"],

Cell[BoxData["289.9859247214947`"], "Output",
 CellChangeTimes->{{3.870256532536278*^9, 3.8702565465832644`*^9}, 
   3.8702577794174356`*^9, 3.870317005987903*^9, 3.870317879940916*^9, 
   3.870318917136964*^9, 3.870319105605163*^9, 3.8703191791637363`*^9, 
   3.8703209144395933`*^9, 3.870321216007218*^9, 3.8703213827223377`*^9, 
   3.870326267230157*^9, 3.8703262975162163`*^9, 3.8703300457661657`*^9, 
   3.870330868165063*^9, 3.8703315069588337`*^9, 3.870336611538293*^9, {
   3.8703371189172583`*^9, 3.870337148146899*^9}, 3.8703441290488167`*^9, 
   3.87034418652717*^9, 3.870348556014422*^9, 3.8708581204836397`*^9, 
   3.8708609792565317`*^9, 3.870863766951158*^9, 3.870863889108617*^9, 
   3.8709184371454983`*^9, 3.870919964228973*^9, 3.870920009685458*^9, 
   3.8709200535569057`*^9, 3.870929867281506*^9, 3.870930224221465*^9, 
   3.870930282647778*^9, 3.870930447446375*^9, 3.87093098913547*^9, 
   3.870940185742687*^9, 3.870940582594149*^9, 3.870941932246813*^9, 
   3.8710258375202017`*^9, 3.871099915752632*^9, 3.871101032690248*^9, 
   3.871101559539289*^9, 3.871102315211904*^9, 3.871103083587173*^9, 
   3.871103525347289*^9, 3.871103948757422*^9, {3.871104197901819*^9, 
   3.871104252171883*^9}, 3.871104291790111*^9, 3.873286447606142*^9, 
   3.873300216630835*^9, 3.873300258214354*^9, 3.87330042671117*^9, 
   3.8733008814382477`*^9, 3.873301174197955*^9, 3.873343918703644*^9, 
   3.8733439638190203`*^9, 3.8733444179668922`*^9, 3.873368548992391*^9, 
   3.873368588318338*^9, {3.8733686190825777`*^9, 3.873368645764699*^9}, 
   3.873436704694199*^9, 3.873436942530034*^9, 3.8734391912338753`*^9, 
   3.873441929005142*^9, 3.873442985538232*^9, 3.873456266502014*^9, 
   3.873699699968563*^9, 3.873786122823378*^9, 3.873799208134959*^9, 
   3.8737992505082006`*^9, 3.8737992979767036`*^9, 3.8737996590349197`*^9, 
   3.873800116755883*^9, 3.874231964449193*^9, 3.874315744199052*^9, 
   3.874318130782819*^9, {3.874324098034786*^9, 3.874324123760928*^9}, 
   3.874324304996662*^9, 3.874324373089932*^9, 3.874384447042934*^9, 
   3.874384494425762*^9, 3.874384575564262*^9, 3.874390004995657*^9, 
   3.874390457436721*^9, 3.874391038693529*^9, 3.8744764656260023`*^9, 
   3.87449133644871*^9, 3.8744915209507236`*^9},
 CellLabel->
  "Out[106]=",ExpressionUUID->"35436768-9ebb-4cb6-9cea-b9cb6ee2971b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"provaV", "=", 
  RowBox[{"prova", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
     RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
     RowBox[{"di", "\[Rule]", "div"}], ",", 
     RowBox[{
      SubscriptBox["k", "on"], "\[Rule]", " ", 
      SubscriptBox["kv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["N", "tot"], "\[Rule]", " ", 
      SubscriptBox["Nv", "tot"]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.874390008090102*^9, 3.874390051950177*^9}, 
   3.874390271309519*^9},
 CellLabel->
  "In[107]:=",ExpressionUUID->"7a2dc5b5-13ee-4e85-930b-603a16ed9205"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.6798032701542829`"}], ",", "24.636492776985538`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8743902733569508`*^9, 3.874390458565111*^9, 
  3.87439103983597*^9, 3.874476466841498*^9, 3.874491337243051*^9, 
  3.874491521646524*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"14f98659-5820-4151-8c4c-c641dec3818c"]
}, Open  ]],

Cell["\<\
The long expressions for the 4 coefficients
The first 2 coefficients (NS) are very small, this makes sense if the system \
is pretty big (for example L=50) because they will multiply cosh(50)\
\>", "Text",
 CellChangeTimes->{{3.870257418900783*^9, 3.870257431275692*^9}, {
  3.870861797173497*^9, 
  3.870861849237338*^9}},ExpressionUUID->"cb71b93f-8887-4d00-8548-\
e98bb1d3d478"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  SubscriptBox["cv", "1"], "=", 
  RowBox[{
   RowBox[{"vv", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "   ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
     RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
     RowBox[{"di", "\[Rule]", "div"}], ",", 
     RowBox[{
      SubscriptBox["k", "on"], "\[Rule]", " ", 
      SubscriptBox["kv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["N", "tot"], "\[Rule]", " ", 
      SubscriptBox["Nv", "tot"]}]}], "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["cv", "2"], "=", 
  RowBox[{
   RowBox[{"vv", "[", 
    RowBox[{"[", "2", "]"}], "]"}], "   ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
     RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
     RowBox[{"di", "\[Rule]", "div"}], ",", 
     RowBox[{
      SubscriptBox["k", "on"], "\[Rule]", " ", 
      SubscriptBox["kv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["N", "tot"], "\[Rule]", " ", 
      SubscriptBox["Nv", "tot"]}]}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.870256630118353*^9, 3.870256800310176*^9}, {
   3.870256835094067*^9, 3.8702568386740017`*^9}, {3.870256873486698*^9, 
   3.8702569204000893`*^9}, {3.8702569881917458`*^9, 3.8702569916477137`*^9}, 
   3.870861790327551*^9, {3.8711031716722937`*^9, 3.871103184356236*^9}, 
   3.871103217424933*^9, 3.871103301991201*^9, {3.871103401374488*^9, 
   3.871103439941135*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"6a09e365-51ab-4c28-9d29-8a54d389121f"],

Cell[BoxData["1.4678320224579875`*^-20"], "Output",
 CellChangeTimes->{
  3.8708637670063133`*^9, 3.8708638891626377`*^9, 3.870918437201495*^9, 
   3.870919964275021*^9, 3.8709200097355213`*^9, 3.8709200536151457`*^9, 
   3.870929867312298*^9, 3.8709302242555304`*^9, 3.8709302826833487`*^9, 
   3.870930447487216*^9, 3.8709309891824913`*^9, 3.870940185808201*^9, 
   3.870940582656633*^9, 3.870941932296898*^9, 3.871025837574142*^9, 
   3.871099915828588*^9, 3.871101032739862*^9, 3.871101559590931*^9, 
   3.871102315269704*^9, 3.8711030837743883`*^9, 3.8711035255551043`*^9, 
   3.871103948984223*^9, {3.8711041980770493`*^9, 3.871104252363925*^9}, 
   3.871104292004999*^9, 3.8732864477586613`*^9, 3.873300216780788*^9, 
   3.873300258380135*^9, 3.8733004268633127`*^9, 3.87330088162457*^9, 
   3.873301174346027*^9, 3.873343918904489*^9, 3.873343964044445*^9, 
   3.8733444181533527`*^9, 3.873368549187958*^9, 3.873368588514962*^9, {
   3.8733686192631063`*^9, 3.873368645960177*^9}, 3.87343670488837*^9, 
   3.8734369427247887`*^9, 3.8734391914777927`*^9, 3.873441929171144*^9, 
   3.87344298570197*^9, 3.873456266666791*^9, 3.873699700164384*^9, 
   3.873786122976836*^9, 3.873799208331669*^9, 3.873799250701002*^9, 
   3.873799298199294*^9, 3.873799659230678*^9, 3.873800116956769*^9, 
   3.8742319646513433`*^9, 3.874315744408449*^9, 3.8743181309811153`*^9, {
   3.874324098231757*^9, 3.8743241239640293`*^9}, 3.874324305189783*^9, 
   3.874324373327615*^9, 3.874384447195396*^9, 3.8743844946112137`*^9, 
   3.874384575716441*^9, 3.874390462316605*^9, 3.874391043571759*^9, 
   3.874476470723608*^9, 3.87449133988111*^9, 3.874491524362774*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"c0a2811e-bba8-4d3f-802c-4231c8f9e018"],

Cell[BoxData["4.756899222421976`*^-32"], "Output",
 CellChangeTimes->{
  3.8708637670063133`*^9, 3.8708638891626377`*^9, 3.870918437201495*^9, 
   3.870919964275021*^9, 3.8709200097355213`*^9, 3.8709200536151457`*^9, 
   3.870929867312298*^9, 3.8709302242555304`*^9, 3.8709302826833487`*^9, 
   3.870930447487216*^9, 3.8709309891824913`*^9, 3.870940185808201*^9, 
   3.870940582656633*^9, 3.870941932296898*^9, 3.871025837574142*^9, 
   3.871099915828588*^9, 3.871101032739862*^9, 3.871101559590931*^9, 
   3.871102315269704*^9, 3.8711030837743883`*^9, 3.8711035255551043`*^9, 
   3.871103948984223*^9, {3.8711041980770493`*^9, 3.871104252363925*^9}, 
   3.871104292004999*^9, 3.8732864477586613`*^9, 3.873300216780788*^9, 
   3.873300258380135*^9, 3.8733004268633127`*^9, 3.87330088162457*^9, 
   3.873301174346027*^9, 3.873343918904489*^9, 3.873343964044445*^9, 
   3.8733444181533527`*^9, 3.873368549187958*^9, 3.873368588514962*^9, {
   3.8733686192631063`*^9, 3.873368645960177*^9}, 3.87343670488837*^9, 
   3.8734369427247887`*^9, 3.8734391914777927`*^9, 3.873441929171144*^9, 
   3.87344298570197*^9, 3.873456266666791*^9, 3.873699700164384*^9, 
   3.873786122976836*^9, 3.873799208331669*^9, 3.873799250701002*^9, 
   3.873799298199294*^9, 3.873799659230678*^9, 3.873800116956769*^9, 
   3.8742319646513433`*^9, 3.874315744408449*^9, 3.8743181309811153`*^9, {
   3.874324098231757*^9, 3.8743241239640293`*^9}, 3.874324305189783*^9, 
   3.874324373327615*^9, 3.874384447195396*^9, 3.8743844946112137`*^9, 
   3.874384575716441*^9, 3.874390462316605*^9, 3.874391043571759*^9, 
   3.874476470723608*^9, 3.87449133988111*^9, 3.874491528079259*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"85418f9d-fecb-4050-a4e9-377af336c3da"]
}, Open  ]],

Cell["They need to be negative since", "Text",
 CellChangeTimes->{{3.870861871182971*^9, 
  3.870861885998233*^9}},ExpressionUUID->"71d23e3f-c697-4873-b3c5-\
9279f3144a19"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  SubscriptBox["csv", "1"], "=", 
  RowBox[{
   RowBox[{"vv", "[", 
    RowBox[{"[", "3", "]"}], "]"}], "   ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
     RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
     RowBox[{"di", "\[Rule]", "div"}], ",", 
     RowBox[{
      SubscriptBox["k", "on"], "\[Rule]", " ", 
      SubscriptBox["kv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["N", "tot"], "\[Rule]", " ", 
      SubscriptBox["Nv", "tot"]}]}], "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["csv", "2"], "=", 
  RowBox[{
   RowBox[{"vv", "[", 
    RowBox[{"[", "4", "]"}], "]"}], "   ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
     RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
     RowBox[{"di", "\[Rule]", "div"}], " ", ",", 
     RowBox[{
      SubscriptBox["k", "on"], "\[Rule]", " ", 
      SubscriptBox["kv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["N", "tot"], "\[Rule]", " ", 
      SubscriptBox["Nv", "tot"]}]}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.870256630118353*^9, 3.870256800310176*^9}, {
   3.870256835094067*^9, 3.8702568386740017`*^9}, {3.870256873486698*^9, 
   3.8702569204000893`*^9}, {3.8702569881917458`*^9, 3.8702569916477137`*^9}, 
   3.870861790327551*^9, {3.8711034583728456`*^9, 3.8711034756640167`*^9}},
 CellLabel->
  "In[110]:=",ExpressionUUID->"16c83424-1cda-4bd7-a7d6-50c7b55a8219"],

Cell[BoxData[
 RowBox[{"-", "76.65936830344083`"}]], "Output",
 CellChangeTimes->{{3.870256652325099*^9, 3.870256691472266*^9}, 
   3.870256806322137*^9, {3.870256839463675*^9, 3.870256921077775*^9}, 
   3.87025702346659*^9, 3.870257779470777*^9, 3.870317006030128*^9, 
   3.8703178799839*^9, 3.8703189171701927`*^9, 3.870319105650943*^9, 
   3.870319179214672*^9, 3.870320914481235*^9, 3.870321216059173*^9, 
   3.8703213827877827`*^9, 3.870326267302293*^9, 3.8703262975726833`*^9, 
   3.870330045816392*^9, 3.870330868220373*^9, 3.870331507010902*^9, 
   3.870336611589467*^9, {3.8703371189737062`*^9, 3.8703371482051983`*^9}, 
   3.8703441290845327`*^9, 3.870344186567594*^9, 3.870348556059731*^9, 
   3.870858120549155*^9, 3.870860979310464*^9, 3.870863767059556*^9, 
   3.8708638892170563`*^9, 3.870918437255404*^9, 3.870919964319683*^9, 
   3.870920009780875*^9, 3.870920053662064*^9, 3.870929867348081*^9, 
   3.870930224288274*^9, 3.870930282712841*^9, 3.870930447526613*^9, 
   3.870930989232255*^9, 3.870940185872836*^9, 3.870940582716502*^9, 
   3.870941932349834*^9, 3.87102583762852*^9, 3.8710999159503717`*^9, 
   3.8711010327928333`*^9, 3.8711015596410103`*^9, 3.871102315329063*^9, 
   3.871103084266609*^9, 3.871103526087405*^9, 3.871103949533512*^9, {
   3.871104198649084*^9, 3.8711042529592237`*^9}, 3.871104292498382*^9, 
   3.873286448162324*^9, 3.8733002171528053`*^9, 3.873300258746244*^9, 
   3.873300427248774*^9, 3.8733008820185223`*^9, 3.8733011746993*^9, 
   3.873343919414365*^9, 3.873343964542704*^9, 3.873344418686987*^9, 
   3.8733685497360983`*^9, 3.873368589105781*^9, {3.873368619789357*^9, 
   3.87336864654837*^9}, 3.873436705408358*^9, 3.873436943233653*^9, 
   3.8734391920293293`*^9, 3.8734419295669947`*^9, 3.8734429861040993`*^9, 
   3.87345626705311*^9, 3.873699700686088*^9, 3.87378612332913*^9, 
   3.8737992088504047`*^9, 3.873799251207131*^9, 3.873799298704445*^9, 
   3.873799659755187*^9, 3.8738001175016117`*^9, 3.8742319651729517`*^9, 
   3.874315744927888*^9, 3.87431813151511*^9, {3.874324098779263*^9, 
   3.8743241244900208`*^9}, 3.874324305727152*^9, 3.874324373911265*^9, 
   3.8743844475431633`*^9, 3.874384494977015*^9, 3.8743845760931807`*^9, 
   3.874390472818734*^9, 3.874391055437748*^9, 3.874476480018125*^9, 
   3.874491348040968*^9, 3.8744915327440453`*^9},
 CellLabel->
  "Out[110]=",ExpressionUUID->"be3bfb3c-c01f-4d2e-a976-7913d5f791be"],

Cell[BoxData[
 RowBox[{"-", "1.2211842197949634`*^-8"}]], "Output",
 CellChangeTimes->{{3.870256652325099*^9, 3.870256691472266*^9}, 
   3.870256806322137*^9, {3.870256839463675*^9, 3.870256921077775*^9}, 
   3.87025702346659*^9, 3.870257779470777*^9, 3.870317006030128*^9, 
   3.8703178799839*^9, 3.8703189171701927`*^9, 3.870319105650943*^9, 
   3.870319179214672*^9, 3.870320914481235*^9, 3.870321216059173*^9, 
   3.8703213827877827`*^9, 3.870326267302293*^9, 3.8703262975726833`*^9, 
   3.870330045816392*^9, 3.870330868220373*^9, 3.870331507010902*^9, 
   3.870336611589467*^9, {3.8703371189737062`*^9, 3.8703371482051983`*^9}, 
   3.8703441290845327`*^9, 3.870344186567594*^9, 3.870348556059731*^9, 
   3.870858120549155*^9, 3.870860979310464*^9, 3.870863767059556*^9, 
   3.8708638892170563`*^9, 3.870918437255404*^9, 3.870919964319683*^9, 
   3.870920009780875*^9, 3.870920053662064*^9, 3.870929867348081*^9, 
   3.870930224288274*^9, 3.870930282712841*^9, 3.870930447526613*^9, 
   3.870930989232255*^9, 3.870940185872836*^9, 3.870940582716502*^9, 
   3.870941932349834*^9, 3.87102583762852*^9, 3.8710999159503717`*^9, 
   3.8711010327928333`*^9, 3.8711015596410103`*^9, 3.871102315329063*^9, 
   3.871103084266609*^9, 3.871103526087405*^9, 3.871103949533512*^9, {
   3.871104198649084*^9, 3.8711042529592237`*^9}, 3.871104292498382*^9, 
   3.873286448162324*^9, 3.8733002171528053`*^9, 3.873300258746244*^9, 
   3.873300427248774*^9, 3.8733008820185223`*^9, 3.8733011746993*^9, 
   3.873343919414365*^9, 3.873343964542704*^9, 3.873344418686987*^9, 
   3.8733685497360983`*^9, 3.873368589105781*^9, {3.873368619789357*^9, 
   3.87336864654837*^9}, 3.873436705408358*^9, 3.873436943233653*^9, 
   3.8734391920293293`*^9, 3.8734419295669947`*^9, 3.8734429861040993`*^9, 
   3.87345626705311*^9, 3.873699700686088*^9, 3.87378612332913*^9, 
   3.8737992088504047`*^9, 3.873799251207131*^9, 3.873799298704445*^9, 
   3.873799659755187*^9, 3.8738001175016117`*^9, 3.8742319651729517`*^9, 
   3.874315744927888*^9, 3.87431813151511*^9, {3.874324098779263*^9, 
   3.8743241244900208`*^9}, 3.874324305727152*^9, 3.874324373911265*^9, 
   3.8743844475431633`*^9, 3.874384494977015*^9, 3.8743845760931807`*^9, 
   3.874390472818734*^9, 3.874391055437748*^9, 3.874476480018125*^9, 
   3.874491348040968*^9, 3.8744915371430264`*^9},
 CellLabel->
  "Out[111]=",ExpressionUUID->"fb23129b-093b-4917-b905-6bc5db984c53"]
}, Open  ]],

Cell["The constant solutions", "Text",
 CellChangeTimes->{{3.870257500544608*^9, 
  3.870257503755027*^9}},ExpressionUUID->"3428c1b6-27bd-4787-a506-\
eda4e44bcf4a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"zv", "=", 
  RowBox[{"z", " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
     RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
     RowBox[{"di", "\[Rule]", "div"}], ",", 
     RowBox[{
      SubscriptBox["c", "1"], "\[Rule]", " ", 
      SubscriptBox["cv", "1"]}], ",", 
     RowBox[{
      SubscriptBox["c", "2"], "\[Rule]", " ", 
      SubscriptBox["cv", "2"]}], ",", 
     RowBox[{
      SubscriptBox["cs", "1"], "\[Rule]", " ", 
      SubscriptBox["csv", "1"]}], ",", 
     RowBox[{
      SubscriptBox["cs", "2"], "\[Rule]", " ", 
      SubscriptBox["csv", "2"]}], ",", 
     RowBox[{
      SubscriptBox["k", "on"], "\[Rule]", " ", 
      SubscriptBox["kv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["N", "tot"], "\[Rule]", " ", 
      SubscriptBox["Nv", "tot"]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.870257506394071*^9, 3.870257530779681*^9}, 
   3.871103486519415*^9},
 CellLabel->
  "In[112]:=",ExpressionUUID->"cee6ee6e-c813-45f6-822c-50f91a21f148"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.08059470077868748`", ",", "0.16118940155737496`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.870257507112276*^9, 3.870257531622909*^9}, 
   3.8702577795353947`*^9, 3.870317006073257*^9, 3.8703178800746393`*^9, 
   3.870318917205042*^9, 3.8703191057647867`*^9, 3.8703191792668467`*^9, 
   3.870320914567713*^9, 3.870321216116493*^9, 3.870321382856494*^9, 
   3.870326267380653*^9, 3.870326297647409*^9, 3.8703300458793173`*^9, 
   3.870330868274536*^9, 3.870331507067045*^9, 3.870336611644342*^9, {
   3.870337119034437*^9, 3.87033714826357*^9}, 3.870344129118246*^9, 
   3.8703441866089153`*^9, 3.870348556110807*^9, 3.870858120620167*^9, 
   3.870860979362692*^9, 3.870863767122471*^9, 3.8708638892709618`*^9, 
   3.87091843730888*^9, 3.870919964367201*^9, 3.870920009826635*^9, 
   3.870920053708325*^9, 3.870929867360026*^9, 3.870930224318356*^9, 
   3.870930282743907*^9, 3.87093044757025*^9, 3.87093098928004*^9, 
   3.870940185934416*^9, 3.870940582775762*^9, 3.870941932409629*^9, 
   3.871025837644373*^9, 3.871099916025206*^9, 3.87110103283991*^9, 
   3.871101559689608*^9, 3.87110231538545*^9, 3.871103084769301*^9, 
   3.8711035266102133`*^9, 3.871103949948721*^9, {3.8711041990698977`*^9, 
   3.871104253363289*^9}, 3.87110429298324*^9, 3.87328644844051*^9, 
   3.873300217433185*^9, 3.8733002590710583`*^9, 3.8733004276026487`*^9, 
   3.873300882280046*^9, 3.873301174947813*^9, 3.8733439198396053`*^9, 
   3.873343964979062*^9, 3.873344419122859*^9, 3.8733685502041483`*^9, 
   3.873368589531268*^9, {3.873368620207604*^9, 3.873368646964089*^9}, 
   3.873436705835917*^9, 3.873436943702784*^9, 3.8734391925500517`*^9, 
   3.873441929984048*^9, 3.873442986388884*^9, 3.873456267345223*^9, 
   3.873699701210143*^9, 3.873786123586664*^9, 3.873799209383197*^9, 
   3.873799251733041*^9, 3.8737992991819553`*^9, 3.8737996603332167`*^9, 
   3.873800118009717*^9, 3.8742319656942663`*^9, 3.8743157454877777`*^9, 
   3.874318132132658*^9, {3.874324099211186*^9, 3.8743241249683237`*^9}, 
   3.874324306264512*^9, 3.874324374383547*^9, 3.874384447790883*^9, 
   3.874384495336204*^9, 3.8743845765269403`*^9, 3.8743904802687263`*^9, 
   3.874391062329121*^9, 3.874476488864111*^9, 3.874491353954473*^9, 
   3.874491538683926*^9},
 CellLabel->
  "Out[112]=",ExpressionUUID->"99e1536e-c9b3-4500-bf8d-eefc0b74419d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"zsv", "=", 
  RowBox[{"zs", " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
     RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
     RowBox[{"di", "\[Rule]", "div"}], ",", 
     RowBox[{
      SubscriptBox["c", "1"], "\[Rule]", " ", 
      SubscriptBox["cv", "1"]}], ",", 
     RowBox[{
      SubscriptBox["c", "2"], "\[Rule]", " ", 
      SubscriptBox["cv", "2"]}], ",", 
     RowBox[{
      SubscriptBox["cs", "1"], "\[Rule]", " ", 
      SubscriptBox["csv", "1"]}], ",", 
     RowBox[{
      SubscriptBox["cs", "2"], "\[Rule]", " ", 
      SubscriptBox["csv", "2"]}], ",", 
     RowBox[{
      SubscriptBox["k", "on"], "\[Rule]", " ", 
      SubscriptBox["kv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["N", "tot"], "\[Rule]", " ", 
      SubscriptBox["Nv", "tot"]}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.8702575519298353`*^9, 3.870257552892694*^9}, 
   3.8711034887515707`*^9},
 CellLabel->
  "In[113]:=",ExpressionUUID->"bed96359-1dd5-455c-aab8-43252e4c9942"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.08059470077868748`", ",", "80.59470077868748`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.8702575534390182`*^9, 3.870257779590413*^9, 3.870317006111639*^9, 
   3.87031788011959*^9, 3.8703189172353973`*^9, 3.870319105801202*^9, 
   3.87031917930052*^9, 3.87032091460686*^9, 3.870321216166768*^9, 
   3.8703213829169617`*^9, 3.870326267394864*^9, 3.870326297702512*^9, 
   3.8703300459236393`*^9, 3.870330868322262*^9, 3.870331507124125*^9, 
   3.870336611657527*^9, {3.8703371190866213`*^9, 3.870337148314645*^9}, 
   3.870344129148849*^9, 3.870344186642743*^9, 3.8703485561591454`*^9, 
   3.8708581206830053`*^9, 3.870860979408568*^9, 3.870863767183387*^9, 
   3.870863889322607*^9, 3.87091843735769*^9, 3.870919964410254*^9, 
   3.8709200098715487`*^9, 3.870920053751807*^9, 3.8709298673914957`*^9, 
   3.870930224349017*^9, 3.870930282773864*^9, 3.87093044760798*^9, 
   3.87093098932446*^9, 3.8709401860562468`*^9, 3.8709405828343477`*^9, 
   3.87094193246977*^9, 3.871025837694055*^9, 3.871099916093463*^9, 
   3.871101032886475*^9, 3.871101559736044*^9, 3.871102315439766*^9, 
   3.8711030848857393`*^9, 3.871103526710662*^9, 3.871103950048586*^9, {
   3.871104199164279*^9, 3.871104253461606*^9}, 3.871104293097756*^9, 
   3.873286448603942*^9, 3.8733002176402807`*^9, 3.873300259268322*^9, 
   3.873300427683769*^9, 3.873300882531947*^9, 3.8733011750343018`*^9, 
   3.873343919941856*^9, 3.873343965076333*^9, 3.873344419221594*^9, 
   3.873368550302413*^9, 3.87336858962825*^9, {3.873368620302721*^9, 
   3.87336864706917*^9}, 3.8734367059333763`*^9, 3.873436943819387*^9, 
   3.873439192655443*^9, 3.873441930065322*^9, 3.873442986575*^9, 
   3.873456267472783*^9, 3.873699701313653*^9, 3.873786123757484*^9, 
   3.873799209481011*^9, 3.87379925185719*^9, 3.873799299320677*^9, 
   3.8737996604371567`*^9, 3.873800118142312*^9, 3.874231965796081*^9, 
   3.874315745591093*^9, 3.874318132234499*^9, {3.8743240993092318`*^9, 
   3.874324125089764*^9}, 3.8743243063904333`*^9, 3.874324374482168*^9, 
   3.874384447866846*^9, 3.8743844954154043`*^9, 3.8743845766058807`*^9, 
   3.874390482670047*^9, 3.8743910638667173`*^9, 3.874476491088426*^9, 
   3.8744913555576344`*^9, 3.8744915402947607`*^9},
 CellLabel->
  "Out[113]=",ExpressionUUID->"b3c2b5f5-acd1-4842-9a1a-7e9891671a08"]
}, Open  ]],

Cell["The space dependent parts", "Text",
 CellChangeTimes->{{3.870257490176898*^9, 
  3.870257497486197*^9}},ExpressionUUID->"7c55b855-6f5e-4f25-9c6b-\
9310d5fd1045"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalPi]v", "[", "x_", "]"}], "=", 
   RowBox[{
    RowBox[{"\[CapitalPi]", "[", "x", "]"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["k", "oc"], "->", 
       SubscriptBox["kv", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "co"], " ", "->", " ", 
       SubscriptBox["kv", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
       SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "co"], " ", "->", 
       SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "o"], " ", "->", 
       SubscriptBox["Dv", "o"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "c"], " ", "->", 
       SubscriptBox["Dv", "c"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "off"], " ", "->", 
       SubscriptBox["kv", "off"]}], ",", " ", 
      RowBox[{
       SubscriptBox["w", "on"], "->", 
       SubscriptBox["wv", "on"]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
      RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
      RowBox[{"di", "\[Rule]", "div"}], ",", 
      RowBox[{
       SubscriptBox["c", "1"], "\[Rule]", " ", 
       SubscriptBox["cv", "1"]}], ",", 
      RowBox[{
       SubscriptBox["c", "2"], "\[Rule]", " ", 
       SubscriptBox["cv", "2"]}], ",", 
      RowBox[{
       SubscriptBox["cs", "1"], "\[Rule]", " ", 
       SubscriptBox["csv", "1"]}], ",", 
      RowBox[{
       SubscriptBox["cs", "2"], "\[Rule]", " ", 
       SubscriptBox["csv", "2"]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.870257126958235*^9, 3.870257226406303*^9}, {
   3.870257302934639*^9, 3.870257310619856*^9}, 3.870342224145321*^9},
 CellLabel->
  "In[114]:=",ExpressionUUID->"a303cef5-047d-4401-8b2f-445baf523eb5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalPi]sv", "[", "x_", "]"}], "=", 
   RowBox[{
    RowBox[{"\[CapitalPi]s", "[", "x", "]"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["k", "oc"], "->", 
       SubscriptBox["kv", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "co"], " ", "->", " ", 
       SubscriptBox["kv", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
       SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "co"], " ", "->", 
       SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "o"], " ", "->", 
       SubscriptBox["Dv", "o"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "c"], " ", "->", 
       SubscriptBox["Dv", "c"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "off"], " ", "->", 
       SubscriptBox["kv", "off"]}], ",", " ", 
      RowBox[{
       SubscriptBox["w", "on"], "->", 
       SubscriptBox["wv", "on"]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
      RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
      RowBox[{"di", "\[Rule]", "div"}], ",", 
      RowBox[{
       SubscriptBox["c", "1"], "\[Rule]", " ", 
       SubscriptBox["cv", "1"]}], ",", 
      RowBox[{
       SubscriptBox["c", "2"], "\[Rule]", " ", 
       SubscriptBox["cv", "2"]}], ",", 
      RowBox[{
       SubscriptBox["cs", "1"], "\[Rule]", " ", 
       SubscriptBox["csv", "1"]}], ",", 
      RowBox[{
       SubscriptBox["cs", "2"], "\[Rule]", " ", 
       SubscriptBox["csv", "2"]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.870257473282257*^9, 3.870257476448707*^9}, 
   3.870342226455339*^9},
 CellLabel->
  "In[115]:=",ExpressionUUID->"593c6d77-8117-49df-a5d9-b143554c52af"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalPi]leftv", "[", "X_", "]"}], "=", " ", 
   RowBox[{
    RowBox[{"\[CapitalPi]left", "[", "x", "]"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["k", "oc"], "->", 
       SubscriptBox["kv", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "co"], " ", "->", " ", 
       SubscriptBox["kv", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
       SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "co"], " ", "->", 
       SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "o"], " ", "->", 
       SubscriptBox["Dv", "o"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "c"], " ", "->", 
       SubscriptBox["Dv", "c"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "off"], " ", "->", 
       SubscriptBox["kv", "off"]}], ",", " ", 
      RowBox[{
       SubscriptBox["w", "on"], "->", 
       SubscriptBox["wv", "on"]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
      RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
      RowBox[{"di", "\[Rule]", "div"}], ",", 
      RowBox[{
       SubscriptBox["c", "1"], "\[Rule]", " ", 
       SubscriptBox["cv", "1"]}], ",", 
      RowBox[{
       SubscriptBox["c", "2"], "\[Rule]", " ", 
       SubscriptBox["cv", "2"]}], ",", 
      RowBox[{
       SubscriptBox["cs", "1"], "\[Rule]", " ", 
       SubscriptBox["csv", "1"]}], ",", 
      RowBox[{
       SubscriptBox["cs", "2"], "\[Rule]", " ", 
       SubscriptBox["csv", "2"]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.874227340910326*^9, 3.874227388346376*^9}, 
   3.874231923289613*^9},
 CellLabel->
  "In[116]:=",ExpressionUUID->"377ba47d-4a57-4e93-a206-4eafa31da1b9"],

Cell["Check that the special parts are flat in ParS", "Text",
 CellChangeTimes->{{3.870342104237167*^9, 3.870342133247766*^9}, {
  3.870342217668507*^9, 
  3.870342218539163*^9}},ExpressionUUID->"56fed37e-3974-4deb-a136-\
bbcbd9bd322b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"D\[CapitalPi]sv", "[", "x_", "]"}], "=", 
   RowBox[{
    RowBox[{"D\[CapitalPi]s", "[", "x", "]"}], " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["k", "oc"], "->", 
       SubscriptBox["kv", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "co"], " ", "->", " ", 
       SubscriptBox["kv", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
       SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "co"], " ", "->", 
       SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "o"], " ", "->", 
       SubscriptBox["Dv", "o"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "c"], " ", "->", 
       SubscriptBox["Dv", "c"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "off"], " ", "->", 
       SubscriptBox["kv", "off"]}], ",", " ", 
      RowBox[{
       SubscriptBox["w", "on"], "->", 
       SubscriptBox["wv", "on"]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
      RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
      RowBox[{"di", "\[Rule]", "div"}], ",", 
      RowBox[{
       SubscriptBox["c", "1"], "\[Rule]", " ", 
       SubscriptBox["cv", "1"]}], ",", 
      RowBox[{
       SubscriptBox["c", "2"], "\[Rule]", " ", 
       SubscriptBox["cv", "2"]}], ",", 
      RowBox[{
       SubscriptBox["cs", "1"], "\[Rule]", " ", 
       SubscriptBox["csv", "1"]}], ",", 
      RowBox[{
       SubscriptBox["cs", "2"], "\[Rule]", " ", 
       SubscriptBox["csv", "2"]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"D\[CapitalPi]sv", "[", "0", "]"}]}], "Input",
 CellChangeTimes->{{3.870342157104795*^9, 3.870342210043236*^9}, 
   3.8742319947147913`*^9},
 CellLabel->
  "In[117]:=",ExpressionUUID->"92e50df9-2c99-4745-9db7-1a9934f6a3f2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{{3.870342166456905*^9, 3.870342210339513*^9}, 
   3.870344129191681*^9, 3.8703441867029743`*^9, 3.870348556228615*^9, 
   3.870858120767803*^9, 3.87086097952214*^9, 3.870863767327949*^9, 
   3.8708638893906603`*^9, 3.870918437463523*^9, 3.870919964488092*^9, 
   3.870920009973381*^9, 3.87092005383178*^9, 3.870929867435416*^9, 
   3.870930224408915*^9, 3.870930282816969*^9, 3.8709304476789913`*^9, 
   3.870930989404687*^9, 3.870940186135983*^9, 3.870940582926237*^9, 
   3.87094193256544*^9, 3.8710258377677507`*^9, 3.8710999161775637`*^9, 
   3.871101032957963*^9, 3.8711015598018837`*^9, 3.871102315569116*^9, 
   3.871103085031747*^9, 3.8711035268466682`*^9, 3.8711039502572308`*^9, {
   3.871104199267434*^9, 3.87110425355571*^9}, 3.8711042931823063`*^9, 
   3.873286448735755*^9, 3.87330021773425*^9, 3.873300259372224*^9, 
   3.873300427751423*^9, 3.873300882611051*^9, 3.8733011751404057`*^9, 
   3.873343920038611*^9, 3.8733439651716757`*^9, 3.873344419309475*^9, 
   3.873368550403738*^9, 3.873368589710568*^9, {3.873368620383436*^9, 
   3.87336864717934*^9}, 3.873436705996863*^9, 3.8734369439302483`*^9, 
   3.873439192743842*^9, 3.873441930130447*^9, 3.8734429866695337`*^9, 
   3.873456267552154*^9, 3.873699701422893*^9, 3.873786123840248*^9, 
   3.873799209587879*^9, 3.873799251926177*^9, 3.87379929944593*^9, 
   3.873799660603243*^9, 3.873800118231614*^9, {3.87423196593215*^9, 
   3.8742319950298023`*^9}, 3.8743157457010317`*^9, 3.874318132378345*^9, {
   3.8743240994219112`*^9, 3.8743241252136927`*^9}, 3.874324306578141*^9, 
   3.874324374601626*^9, 3.874384447971093*^9, 3.874384495518568*^9, 
   3.874384576698094*^9, 3.874390483292427*^9, 3.8743910642567177`*^9, 
   3.87447649165055*^9, 3.874491356050908*^9, 3.874491540704376*^9},
 CellLabel->
  "Out[118]=",ExpressionUUID->"fa6771ad-e588-45b6-bf9d-315ba9deedf7"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]Nv", "=", " ", 
   RowBox[{"\[Delta]N", " ", "/.", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["k", "oc"], "->", 
       SubscriptBox["kv", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "co"], " ", "->", " ", 
       SubscriptBox["kv", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
       SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "co"], " ", "->", 
       SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "o"], " ", "->", 
       SubscriptBox["Dv", "o"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "c"], " ", "->", 
       SubscriptBox["Dv", "c"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "off"], " ", "->", 
       SubscriptBox["kv", "off"]}], ",", " ", 
      RowBox[{
       SubscriptBox["w", "on"], "->", 
       SubscriptBox["wv", "on"]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
      RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
      RowBox[{"di", "\[Rule]", "div"}], ",", 
      RowBox[{
       SubscriptBox["c", "1"], "\[Rule]", " ", 
       SubscriptBox["cv", "1"]}], ",", 
      RowBox[{
       SubscriptBox["c", "2"], "\[Rule]", " ", 
       SubscriptBox["cv", "2"]}], ",", 
      RowBox[{
       SubscriptBox["cs", "1"], "\[Rule]", " ", 
       SubscriptBox["csv", "1"]}], ",", 
      RowBox[{
       SubscriptBox["cs", "2"], "\[Rule]", " ", 
       SubscriptBox["csv", "2"]}], ",", 
      RowBox[{
       SubscriptBox["k", "on"], "\[Rule]", " ", 
       SubscriptBox["kv", "on"]}], ",", 
      RowBox[{
       SubscriptBox["N", "tot"], "\[Rule]", " ", 
       SubscriptBox["Nv", "tot"]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8711037442878513`*^9, 3.871103764553897*^9}, {
  3.871103794873685*^9, 3.871103795119956*^9}, {3.873299820291428*^9, 
  3.873299828285441*^9}, {3.8733000914338493`*^9, 3.87330014846525*^9}, {
  3.87330069535345*^9, 3.8733006992069674`*^9}, {3.874318603101921*^9, 
  3.874318606152149*^9}, {3.874318643348168*^9, 3.874318675179061*^9}, {
  3.8743187155953083`*^9, 3.874318787990039*^9}},
 CellLabel->
  "In[119]:=",ExpressionUUID->"d91d1fc3-f569-4123-b114-4440dfdc89a2"],

Cell[CellGroupData[{

Cell["Equilibrium flat solution", "Subsubsection",
 CellChangeTimes->{{3.8743840452031717`*^9, 
  3.874384057396089*^9}},ExpressionUUID->"173fb62c-4ad9-4118-8677-\
cb7723b21540"],

Cell[TextData[{
 "The flat solution WITHOUT PARS, here differs from the one WITH PARS, \
because the  spike depletes the solution, therefore making ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["w", "on"], " "}], TraditionalForm]],
  FormatType->"TraditionalForm",ExpressionUUID->
  "f6e20acb-757c-4d93-9d5b-9d9fe1a9b707"],
 "weaker, therefore making the constant solution smaller "
}], "Text",
 CellChangeTimes->{{3.874384076244729*^9, 3.874384136843852*^9}, {
  3.874384241944435*^9, 3.874384268372217*^9}, {3.87438430679005*^9, 
  3.8743843411230993`*^9}},ExpressionUUID->"8c885f36-6934-4d45-a960-\
641bc0e83b66"],

Cell["\<\
Here i am taking the expressions, substituting the expressions of the \
eigenvalues, so the coefficient expression depend just on the foundamental \
parameters, and than I set \[Gamma] = 1 , so in the system there is no ParS\
\>", "Text",
 CellChangeTimes->{{3.874384069852462*^9, 
  3.874384072294548*^9}},ExpressionUUID->"a63e02f2-1aff-487b-a53d-\
1acbd023a17f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"zeqv", "=", 
   RowBox[{"z", " ", "/.", 
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", 
       RowBox[{"eig", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", 
       RowBox[{"eig", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", 
       RowBox[{"eigs", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "+"], "\[Rule]", 
       RowBox[{"eigs", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"zeqv", "=", 
  RowBox[{"zeqv", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", "1"}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "\[Rule]", "1"}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}], ",", 
     RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
     RowBox[{"di", "\[Rule]", "div"}], ",", 
     RowBox[{
      SubscriptBox["k", "on"], "\[Rule]", " ", 
      SubscriptBox["kv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["N", "tot"], "\[Rule]", " ", 
      SubscriptBox["Nv", "tot"]}]}], "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zeqSv", "=", 
   RowBox[{"zs", " ", "/.", 
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", 
       RowBox[{"eig", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", 
       RowBox[{"eig", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", 
       RowBox[{"eigs", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "+"], "\[Rule]", 
       RowBox[{"eigs", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"zeqSv", "=", 
  RowBox[{"zeqSv", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", "1"}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "\[Rule]", "1"}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "->", 
      SubscriptBox["Dv", "c"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", " ", 
     RowBox[{
      SubscriptBox["w", "on"], "->", 
      SubscriptBox["wv", "on"]}], ",", 
     RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
     RowBox[{"di", "\[Rule]", "div"}], ",", 
     RowBox[{
      SubscriptBox["k", "on"], "\[Rule]", " ", 
      SubscriptBox["kv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["N", "tot"], "\[Rule]", " ", 
      SubscriptBox["Nv", "tot"]}]}], "}"}]}]}]}], "Input",
 CellLabel->
  "In[120]:=",ExpressionUUID->"96d709c6-721d-46a3-a0b4-c34f25ea528f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.11842105263157894`", ",", "0.23684210526315788`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.874384448470985*^9, 3.8743844959759817`*^9, 
  3.874384577139091*^9, 3.874390495617179*^9, 3.8743910738621473`*^9, 
  3.874476505801614*^9, 3.874491367380187*^9, 3.8744915504908543`*^9},
 CellLabel->
  "Out[121]=",ExpressionUUID->"ea3c2d57-14e9-4930-be73-9972f4a0b1bb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.11842105263157894`", ",", "0.23684210526315785`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.874384448470985*^9, 3.8743844959759817`*^9, 
  3.874384577139091*^9, 3.874390495617179*^9, 3.8743910738621473`*^9, 
  3.874476505801614*^9, 3.874491367380187*^9, 3.874491559345392*^9},
 CellLabel->
  "Out[123]=",ExpressionUUID->"f4bad230-0872-45e5-9f18-cd448a173e0a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Check", " ", "that", " ", "with", " ", "\[Gamma]"}], "=", 
  RowBox[{"1", " ", "there", " ", "is", " ", "no", " "}]}]], "Input",
 CellChangeTimes->{{3.874385196934288*^9, 3.8743852118091707`*^9}},
 CellLabel->
  "In[124]:=",ExpressionUUID->"fb2b2c4a-e0ea-42b2-9031-492e1e4dfcc1"],

Cell[BoxData[
 TemplateBox[{
  "Set", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"Times\\\"}]\\) in \\!\\(\\*RowBox[{\\\"Check\\\
\", \\\" \\\", \\\"that\\\", \\\" \\\", \\\"with\\\", \\\" \\\", \\\"\[Gamma]\
\\\"}]\\) is Protected.\"", 2, 124, 3, 24408456342082606278, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.874390504532015*^9, 3.87439108286832*^9, 
  3.8744765147351837`*^9, 3.8744913773345757`*^9, 3.8744915594714937`*^9},
 CellLabel->
  "During evaluation of \
In[124]:=",ExpressionUUID->"dfef64b7-37e0-4e0f-904b-d8ef665dba10"],

Cell[BoxData[
 RowBox[{"is", " ", "no", " ", "there"}]], "Output",
 CellChangeTimes->{3.8743905045445967`*^9, 3.874391082878461*^9, 
  3.874476514744158*^9, 3.8744913773420763`*^9, 3.874491559472579*^9},
 CellLabel->
  "Out[124]=",ExpressionUUID->"6e18387b-4413-408c-8676-46d825bec60b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]Nlong", "=", 
   RowBox[{"\[Delta]N", " ", "/.", 
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", 
       RowBox[{"eig", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", 
       RowBox[{"eig", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", 
       RowBox[{"eigs", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "+"], "\[Rule]", 
       RowBox[{"eigs", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}]}], ";"}]], "Input",
 CellLabel->
  "In[125]:=",ExpressionUUID->"0337135a-2c16-4c70-9a3e-140ef2a4b9ba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]Nlong", " ", "/.", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["k", "oc"], "->", 
     SubscriptBox["kv", "oc"]}], ",", " ", 
    RowBox[{
     SubscriptBox["k", "co"], " ", "->", " ", 
     SubscriptBox["kv", "co"]}], ",", " ", 
    RowBox[{
     SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", "1"}], ",", " ", 
    RowBox[{
     SubscriptBox["\[Gamma]", "co"], " ", "\[Rule]", "1"}], ",", " ", 
    RowBox[{
     SubscriptBox["D", "o"], " ", "->", 
     SubscriptBox["Dv", "o"]}], ",", " ", 
    RowBox[{
     SubscriptBox["D", "c"], " ", "->", 
     SubscriptBox["Dv", "c"]}], ",", " ", 
    RowBox[{
     SubscriptBox["k", "off"], " ", "->", 
     SubscriptBox["kv", "off"]}], ",", " ", 
    RowBox[{
     SubscriptBox["w", "on"], "->", 
     SubscriptBox["wv", "on"]}], ",", 
    RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
    RowBox[{"di", "\[Rule]", "div"}], ",", 
    RowBox[{
     SubscriptBox["k", "on"], "\[Rule]", " ", 
     SubscriptBox["kv", "on"]}], ",", 
    RowBox[{
     SubscriptBox["N", "tot"], "\[Rule]", " ", 
     SubscriptBox["Nv", "tot"]}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.874385186180647*^9, 3.8743851866977673`*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"184888b8-0df0-4395-ac60-0a6dd26c9e21"],

Cell[BoxData["3.5388358909926865`*^-16"], "Output",
 CellChangeTimes->{3.874385189005351*^9, 3.874390509140563*^9, 
  3.874391089562936*^9, 3.8744765193258257`*^9, 3.874491381978437*^9, 
  3.874491564166828*^9},
 CellLabel->
  "Out[126]=",ExpressionUUID->"00ab079b-afa8-4e8e-8048-103b6515e043"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["PLOTS ", "Subsection",
 CellChangeTimes->{{3.8654136077889233`*^9, 3.865413612807293*^9}, 
   3.865414384102647*^9, {3.865414415603209*^9, 3.8654144326408567`*^9}, 
   3.865421083524755*^9},ExpressionUUID->"02b41595-27bb-4502-9e42-\
f0189b36b45b"],

Cell["Percentuage of dimers in the spike solution", "Text",
 CellChangeTimes->{{3.874318794384344*^9, 3.874318807250758*^9}, 
   3.874384348189169*^9},ExpressionUUID->"f54e7d09-2e22-4a73-9ae7-\
0fb3848395f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]Nv", "/", 
  SubscriptBox["Nv", "tot"]}]], "Input",
 CellChangeTimes->{{3.874318655154481*^9, 3.874318657989893*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"3954073a-2c35-4fde-990f-2c2910abe976"],

Cell[BoxData["0.31942252675775007`"], "Output",
 CellChangeTimes->{
  3.874318667744008*^9, {3.874324099504387*^9, 3.874324125321331*^9}, 
   3.874324306655941*^9, 3.8743243747069273`*^9, 3.8743844488356667`*^9, 
   3.874384496524954*^9, 3.874384577698924*^9, 3.874390509256545*^9, 
   3.874391089697866*^9, 3.874476519438349*^9, 3.8744913820866117`*^9, 
   3.874491564271202*^9},
 CellLabel->
  "Out[127]=",ExpressionUUID->"192f0f20-7e13-4cd9-b5f0-a172d5c040b0"]
}, Open  ]],

Cell["Number of dimers in the constant solution", "Text",
 CellChangeTimes->{{3.873300643252923*^9, 3.873300656771494*^9}, 
   3.873436860632712*^9},ExpressionUUID->"9b9af6db-bc66-4280-83d6-\
ab28e5f04c19"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Total", "[", "zv", "]"}], "*", "Lv", "*", 
  RowBox[{"2", "/", 
   SubscriptBox["Nv", "tot"]}]}]], "Input",
 CellChangeTimes->{{3.873300591234827*^9, 3.8733006246926727`*^9}, {
  3.87330066897869*^9, 3.873300675143272*^9}, {3.8733007222405148`*^9, 
  3.873300798510745*^9}, {3.873343847326645*^9, 3.873343849069714*^9}, {
  3.8743188129750757`*^9, 3.874318822654015*^9}, {3.874324173503048*^9, 
  3.874324184051241*^9}, {3.874384637081791*^9, 3.874384641424912*^9}},
 CellLabel->
  "In[128]:=",ExpressionUUID->"176edcd4-50fb-42d1-a2fb-a8ae55ea4275"],

Cell[BoxData["0.32237880311475`"], "Output",
 CellChangeTimes->{{3.873300594300926*^9, 3.8733006254067097`*^9}, {
   3.8733007124264183`*^9, 3.8733007630906363`*^9}, 3.873300798797886*^9, 
   3.873300883164054*^9, 3.873301175583844*^9, 3.873343920677206*^9, 
   3.873343965799667*^9, 3.873344419925099*^9, 3.873368551020039*^9, 
   3.873368590326564*^9, {3.8733686209349613`*^9, 3.873368648021575*^9}, 
   3.873436706369975*^9, 3.873436944578196*^9, 3.8734391932864323`*^9, 
   3.8734419306189957`*^9, 3.873442987054006*^9, 3.873456267936261*^9, 
   3.873699701572484*^9, 3.873786123964813*^9, 3.873799209725278*^9, 
   3.873799252055435*^9, 3.873799299591271*^9, 3.8737996608232813`*^9, 
   3.87380011838063*^9, 3.8742319660688047`*^9, 3.874315745835992*^9, 
   3.8743181325439157`*^9, 3.874318823237615*^9, {3.874324099569928*^9, 
   3.874324125416994*^9}, {3.8743241738045597`*^9, 3.874324184323496*^9}, 
   3.874324306710416*^9, 3.874324374790742*^9, 3.874384448873481*^9, 
   3.874384496580295*^9, 3.8743845777435007`*^9, 3.874384641979827*^9, 
   3.874390509344427*^9, 3.874391089765099*^9, 3.874476519495862*^9, 
   3.874491382154234*^9, 3.874491564335052*^9},
 CellLabel->
  "Out[128]=",ExpressionUUID->"931e8a2f-7e29-4a0f-8581-048dd82d0558"]
}, Open  ]],

Cell["How much is the spike taller than the baseline?", "Text",
 CellChangeTimes->{{3.87431883785028*^9, 
  3.874318850649457*^9}},ExpressionUUID->"a2490635-7113-41b1-907d-\
8071963ce698"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalPi]sv", "[", "0", "]"}], "[", 
     RowBox[{"[", "2", "]"}], "]"}], "+", 
    RowBox[{"zsv", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"\[CapitalPi]sv", "[", "0", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "+", 
    RowBox[{"zsv", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", 
  RowBox[{"Total", "[", "zv", "]"}]}]], "Input",
 CellChangeTimes->{{3.8743178689041643`*^9, 3.874317895207509*^9}, {
  3.8743179448735943`*^9, 3.874317947981564*^9}, {3.874318005810153*^9, 
  3.874318029816847*^9}, {3.8743180906621437`*^9, 3.874318096873766*^9}, {
  3.874318324405368*^9, 3.874318324518078*^9}, {3.874318369507678*^9, 
  3.874318372570353*^9}, {3.8743184081897383`*^9, 3.874318496345147*^9}, {
  3.874318531337221*^9, 3.874318586270605*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"d26a0a4e-ad98-4b11-b77b-df56a0d6968f"],

Cell[BoxData["16.294063213250816`"], "Output",
 CellChangeTimes->{{3.874317863863659*^9, 3.874317895745221*^9}, 
   3.874317948524729*^9, {3.8743180074234324`*^9, 3.874318030435711*^9}, 
   3.874318132618622*^9, 3.874318325322624*^9, {3.874318369883812*^9, 
   3.8743183733386717`*^9}, {3.8743184089478617`*^9, 3.874318496880913*^9}, {
   3.874318554991838*^9, 3.874318586597435*^9}, {3.874324099658711*^9, 
   3.874324125586133*^9}, 3.874324306827437*^9, 3.874324374925267*^9, 
   3.874384448962591*^9, 3.874384496708562*^9, 3.8743845778348*^9, 
   3.874390509433578*^9, 3.8743910898342524`*^9, 3.87447651956413*^9, 
   3.8744913822140017`*^9, 3.8744915643898687`*^9},
 CellLabel->
  "Out[129]=",ExpressionUUID->"c0ee5d9a-b889-4a39-b92a-9336b92e050d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Total", "[", "zeqv", "]"}], "*", "Lv", "*", 
  RowBox[{"2", "/", 
   SubscriptBox["Nv", "tot"]}]}]], "Input",
 CellChangeTimes->{{3.8743910219746923`*^9, 3.87439102220868*^9}},
 CellLabel->
  "In[130]:=",ExpressionUUID->"804caa2b-b326-463d-85e1-cf62748f38a8"],

Cell[BoxData["0.4736842105263158`"], "Output",
 CellChangeTimes->{3.874391023559059*^9, 3.874391089902132*^9, 
  3.874476519578196*^9, 3.874491382264803*^9, 3.874491564443952*^9},
 CellLabel->
  "Out[130]=",ExpressionUUID->"96760fce-4baf-49c7-8650-a4e51a06ad5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Open distribution", "Subsubsection",
 CellChangeTimes->{{3.8702576703217707`*^9, 3.8702576736532516`*^9}, {
  3.87025804697097*^9, 3.870258051530252*^9}, {3.8702580816700583`*^9, 
  3.870258099695695*^9}, {3.870340369075769*^9, 
  3.870340370269837*^9}},ExpressionUUID->"8e91f318-8bfb-46d9-9402-\
728f48263f3a"],

Cell["\<\
Using the Piecewise function , and plotting just half of the even function\
\>", "Text",
 CellChangeTimes->{{3.870259179389535*^9, 
  3.870259216154544*^9}},ExpressionUUID->"1e80cb5f-f892-4c52-a3b8-\
82f27ccfacd5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Piecewise", "[", 
      RowBox[{"{", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalPi]v", "[", "x", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{"zv", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
          RowBox[{"x", ">", "div"}]}], "}"}], " ", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalPi]sv", "[", "x", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{"zsv", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "div"}], "<", "x", "<", "div"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalPi]leftv", "[", "x", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{"zv", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"x", "<", 
           RowBox[{"-", "div"}]}]}], "}"}]}], " ", "}"}], "]"}], ",", 
     RowBox[{"zeqv", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Lv"}], ",", "Lv"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", " ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Distribution\>\"", ",", "\"\<Equilibrium solution\>\""}], 
     "}"}]}], ",", " ", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "div"}], ",", "div"}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}]}], ",", 
   RowBox[{"Exclusions", "\[Rule]", "None"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<\[Rho](x)\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.870258738745694*^9, 3.870258787561223*^9}, {
  3.870258868828355*^9, 3.8702589406588697`*^9}, {3.870317931900642*^9, 
  3.870317932206595*^9}, {3.870318685798162*^9, 3.870318690592079*^9}, {
  3.870340139727*^9, 3.870340181577323*^9}, {3.870861119187931*^9, 
  3.8708611530108852`*^9}, {3.871103978176425*^9, 3.871103984225871*^9}, {
  3.8743157904406548`*^9, 3.8743157916367197`*^9}, {3.874316180716852*^9, 
  3.874316181252054*^9}, {3.874316451546883*^9, 3.87431645199574*^9}, {
  3.874324223422724*^9, 3.874324227730942*^9}, {3.87432428585466*^9, 
  3.8743242883012857`*^9}, {3.874384788305778*^9, 3.874384788433036*^9}, {
  3.874476585738387*^9, 3.874476607991601*^9}, {3.874476808369863*^9, 
  3.874476817479944*^9}, {3.874491461390156*^9, 3.874491464113144*^9}},
 CellLabel->
  "In[131]:=",ExpressionUUID->"6b2e4326-21d6-41da-bda6-78ffa617dce1"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJxF23k8VN//B3A7oZJ9N/adGfuWcxAiIoQiJHslS4RK0qaESCVKJFuEasY+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          "]]}, Annotation[#, "Charting`Private`Tag$10076#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQHZP48N3//x4HeJ+aTrkesM9+50SLuIQmBF/sUP/Z
AywIvrvdzbr4L25wvqTfd3bub65wvkZJ457Nf1zg/HVblzlbvXOG8692LVh0
9qMTnF9cbXrF7oEjnO/XZGa49rIDnD/FUuJMwCZ7OL9y6c9bTJNt4fwFFi0z
z023hvOdfjxbN2WZJZx/6V19pli3OZy/hOfQ5Y2TTeH85ESrxxxFxnD+3Edd
nlFRhnC+sRjn/q6zenA+x9UM0xsTteD8hEdS3JHz1BDujbXUDgxTgvNrkgU+
VbvIwPnXVgT57MkRgfPPTb5ddu06O5z/2T7Hk/3O+/0w/gf7CbkMGe/sYfy2
isL7KrUcDjB+02Up4X3yInA+B/8Sxd8rZeD8QJ+0LPU2JTh/ttOKJ7L5anA+
5+lakblrtOD8LyyMT18s1IPzv356ybzA0RBhn47sh/4YYzj/nN1ynbRgUzhf
R+r34YYSczjf49zS1Y2FlnD+y9AKm44Uazh/zjIRjcuNtnA+3wX2FJZqe4T+
xKS/Nucd4HyfIyFzf912hPPXTy5KXX3NCeE/969Rdc+c4fxn6YsrXJ64IPxX
+DSL964rnN+d0NP145UbnN+4O+7StWfucH4e34KE7GIPOB+aX+B8AJD2k5U=

          "]]}, Annotation[#, "Charting`Private`Tag$10076#2"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0.004125595199768198}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{-1, 1}, {}}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox["\"x\"", TraditionalForm], 
       FormBox["\"\[Rho](x)\"", TraditionalForm]}, 
     AxesOrigin -> {0, 0.004125595199768198}, DisplayFunction :> Identity, 
     Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{-1, 1}, {}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-50, 50}, {0.004125595199768198, 0.11842105263157894`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Distribution\"", "\"Equilibrium solution\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.870342053852455*^9, 3.870342059384646*^9}, 
   3.870344129817219*^9, 3.870344187231996*^9, 3.870348556967771*^9, 
   3.8708581219042463`*^9, 3.870860980458478*^9, {3.870861130475349*^9, 
   3.870861153600246*^9}, 3.870863768321859*^9, 3.870863890038947*^9, 
   3.870918438258356*^9, 3.8709199651544943`*^9, 3.8709200107585583`*^9, 
   3.870920054715781*^9, 3.8709298681172333`*^9, 3.8709302250932407`*^9, 
   3.870930283352517*^9, 3.870930448191024*^9, 3.8709309901666*^9, 
   3.8709401872035027`*^9, 3.870940583911697*^9, 3.87094193349273*^9, 
   3.871025838879095*^9, 3.8710999175220623`*^9, 3.871101034079574*^9, 
   3.87110156089951*^9, 3.871102316885482*^9, 3.871103086357765*^9, 
   3.8711035282729883`*^9, {3.871103951883422*^9, 3.871103984494049*^9}, {
   3.871104200430685*^9, 3.871104254747108*^9}, 3.871104294274475*^9, 
   3.873286450181469*^9, 3.873300218631899*^9, 3.8733002604358063`*^9, 
   3.873300428681673*^9, 3.8733008835639753`*^9, 3.873301175864275*^9, 
   3.8733439210680923`*^9, 3.8733439661970787`*^9, 3.873344420301929*^9, 
   3.873368551673573*^9, 3.873368590659349*^9, {3.873368621305606*^9, 
   3.873368648435046*^9}, 3.873436707078272*^9, 3.873436945073875*^9, 
   3.873439193871187*^9, 3.873441931254389*^9, 3.873442987313157*^9, 
   3.873456268313339*^9, 3.87369970229805*^9, 3.8737861244080477`*^9, 
   3.873799210709371*^9, 3.873799252462816*^9, 3.873799300143241*^9, 
   3.873799661859599*^9, 3.8738001193809433`*^9, 3.874231966885113*^9, 
   3.87431574725952*^9, 3.8743157937315207`*^9, 3.8743161819405823`*^9, 
   3.874316453054717*^9, 3.874318133386051*^9, {3.874324100504727*^9, 
   3.8743241262332363`*^9}, 3.8743242282235727`*^9, {3.87432428878645*^9, 
   3.8743243074642344`*^9}, 3.8743243755196457`*^9, 3.874384449066584*^9, 
   3.874384496860959*^9, 3.8743845780651913`*^9, 3.874384789535688*^9, 
   3.874390509744066*^9, 3.874391090069858*^9, 3.8744765198719797`*^9, 
   3.874476809256412*^9, 3.874491382487686*^9, 3.8744915645895443`*^9},
 CellLabel->
  "Out[131]=",ExpressionUUID->"1478ea33-d48c-40d3-84d9-e0f6f8c722c3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Closed distribution", "Subsubsection",
 CellChangeTimes->{{3.8702582823876457`*^9, 3.8702582971038427`*^9}, {
  3.87034228237665*^9, 
  3.870342282979254*^9}},ExpressionUUID->"57dc040b-d7b3-438f-9a80-\
335d91737f9e"],

Cell["ParS is included here, the difference is small", "Text",
 CellChangeTimes->{{3.870929970528983*^9, 
  3.870929983974517*^9}},ExpressionUUID->"a93a6e85-519e-4d19-82a0-\
a6ae248bce2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Piecewise", "[", 
      RowBox[{"{", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalPi]v", "[", "x", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{"zv", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
          RowBox[{"x", ">", "div"}]}], "}"}], " ", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalPi]sv", "[", "x", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{"zsv", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "div"}], "<", "x", "<", "div"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalPi]leftv", "[", "x", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{"zv", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"x", "<", 
           RowBox[{"-", "div"}]}]}], "}"}]}], " ", "}"}], "]"}], ",", 
     RowBox[{"zeqv", "[", 
      RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Lv"}], ",", "Lv"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", " ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Distribution\>\"", ",", "\"\<Equilibrium solution\>\""}], 
     "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "div"}], ",", "div"}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}]}], ",", 
   RowBox[{"Exclusions", "\[Rule]", "None"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<\[Rho](x)\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.870259560900365*^9, 3.8702595702813177`*^9}, {
   3.870259607443694*^9, 3.870259612440889*^9}, {3.870343309657527*^9, 
   3.87034335900368*^9}, {3.870343399342345*^9, 3.8703434106871233`*^9}, 
   3.870343478307878*^9, 3.874316017012506*^9, {3.8743161363225*^9, 
   3.874316165080048*^9}, {3.8743164644648867`*^9, 3.874316464959059*^9}, {
   3.8743846853040733`*^9, 3.874384737198783*^9}, {3.874476739063531*^9, 
   3.8744767868936462`*^9}},
 CellLabel->
  "In[132]:=",ExpressionUUID->"3f8e59e8-453d-4cb0-bcaa-940ad3f31948"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJxF23k4lN//P3D7vmXf932fQdacQyiKFJVkSwihJFIKSZRCIYkUFVmyJCrC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          "]]}, 
        Annotation[#, "Charting`Private`Tag$10155#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQHZP48N3//x4HeJ+aTrkecM5+50SLuIQmBF/sUP/Z
AywIvrvdzbr4L25wvqTfd3bub65wvkZJ457Nf1zg/HVblzlbvXOG8692LVh0
9qMTnF9cbXrF7oEjnO/XZGa49rIDnD/FUuJMwCZ7OL9y6c9bTJNt4fwFFi0z
z023hvOdfjxbN2WZJZx/6V19pli3OZy/hOfQ5Y2TTeH85ESrxxxFxnD+3Edd
nlFRhnC+sRjn/q6zenA+x9UM0xsTteD8hEdS3JHz1BDujbXUDgxTgvNrkgU+
VbvIwPnXVgT57MkRgfPPTb5ddu06O5z/2T7Hk/3O+/0w/gf7CbkMGe/sYfy2
isL7KrUcDjB+02Up4X3yInA+B/8Sxd8rZeD8QJ+0LPU2JTh/ttOKJ7L5anA+
5+lakblrtOD8LyyMT18s1IPzv356ybzA0RBhn47sh/4YYzj/nN1ynbRgUzhf
R+r34YYSczjf49zS1Y2FlnD+y9AKm44Uazh/zjIRjcuNtnA+3wX2FJZqe4T+
xKS/Nucd4HyfIyFzf912hPPXTy5KXX3NCeE/969Rdc+c4fxn6YsrXJ64IPxX
+DSL964rnN+d0NP145UbnN+4O+7StWfucH4e34KE7GIPOB+aX+B8AMXBltU=

          "]]}, Annotation[#, "Charting`Private`Tag$10155#2"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJxF1GtIEwAQAOBpljOtxIa5pcSsTExFs+nma25ON2tJWgmJmu+macMHZvhK
GSJTUJlYYYtV84VlL0QkUZvSH90Up6vU8pGTLJhrac6mWYHeHRzH9+O4uz9H
TRZGp5kTCIQL//J/jUua121v8wYIOzFLiTPYbaKTJzRrJ41oAXdk87wenefR
vf/eHFq8UePi9RbdU09PSKxA2ytqlQMWaG7wx9Jrq+FgcuS6pfWvMLBrfnnv
600OuLOrJdRfFwqeFMseK3+wcZ8i2kTwHAscWeHr/UwdAm5gOIxcfMUE327e
mDKXBIFldNF91d0AMNu41NnQwgCP68oy7Kv9wHIbhfqlhAZOSfL/Qsz1AUsX
xBGxsd5gH3urfrHSE0ycFNA+1LuBExco1lcfuuC+8YzTUTHO4OIUW0MRxxGs
aYvm92aRwCrJdIHmvSX4JzMrwnJmpX/XemZdNkGgY+66sjBn9kQJMWTXFWrK
4b5jJDDxkJxqancER/HTM09VOoOb2G2LTkIXsNVwCUn61A28amGm/frIE7xm
WN4jY3njPHcnfW2cD1gV3OqefokGdqeYBu/k+4F5quaO8hwGePlKYWBVagD4
QQvJVV0eBD44ZplqUcTE/qTkrcDREDB/6LL09zQL/FySm9ahYeN93LXY0qVQ
8NL1J4WcRQ7el6PNPPApDFydWCM2fgsHl79JGNcsccEO78YKAr6jX4yxj8pW
0J+1LqkZRnSg7cqayYoHNqaWkake6JsHZYk38tD7yHZ7x26hpcdF7WeL0SN0
gWFLhHZL8RLVNaK13QOtXT3oYsUZPqUPTVLK9aUKNHuhisEbRstsooanZtD0
I4NC5jx6lEojybXoP77k+GwdupFVbTZuQHvwt5p919FDMcJzTSb0zv8C/wV/
4ij1
          "]]}, 
        Annotation[#, "Charting`Private`Tag$10155#3"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{-1, 1}, {}}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox["\"x\"", TraditionalForm], 
       FormBox["\"\[Rho](x)\"", TraditionalForm]}, AxesOrigin -> {0, 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{-1, 1}, {}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-50, 50}, {0., 3.935300505142351}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Distribution\"", "\"Equilibrium solution\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8743161458119383`*^9, 3.874316166278637*^9}, 
   3.874316466613143*^9, 3.874318133817293*^9, {3.874324100980551*^9, 
   3.874324126681003*^9}, 3.874324307856202*^9, 3.874324376010325*^9, 
   3.87438444940774*^9, 3.874384497358029*^9, 3.8743845782599993`*^9, {
   3.874384713177779*^9, 3.874384741164371*^9}, 3.874390509959342*^9, 
   3.874391090281954*^9, 3.8744765200764503`*^9, 3.8744767937258368`*^9, 
   3.8744913826919813`*^9, 3.874491564777299*^9},
 CellLabel->
  "Out[132]=",ExpressionUUID->"88294490-23da-4de7-bf0b-d01d2aec7730"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sum of the 2", "Subsubsection",
 CellChangeTimes->{{3.8703369483460817`*^9, 3.8703369489668903`*^9}, {
  3.870342296475984*^9, 
  3.870342304861987*^9}},ExpressionUUID->"1bc336bc-ee5f-477b-928d-\
a98fc6079376"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Piecewise", "[", 
      RowBox[{"{", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalPi]v", "[", "x", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{"zv", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"\[CapitalPi]v", "[", "x", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{"zv", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
          RowBox[{"x", ">", "div"}]}], "}"}], " ", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalPi]sv", "[", "x", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{"zsv", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"\[CapitalPi]sv", "[", "x", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{"zsv", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"-", "div"}], "<", "x", "<", "div"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalPi]leftv", "[", "x", "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{"zv", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"\[CapitalPi]leftv", "[", "x", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{"zv", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", 
          RowBox[{"x", "<", 
           RowBox[{"-", "div"}]}]}], "}"}]}], " ", "}"}], "]"}], ",", 
     RowBox[{
      RowBox[{"zeqv", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "+", 
      RowBox[{"zeqv", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Lv"}], ",", "Lv"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", " ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Distribution\>\"", ",", "\"\<Equilibrium solution\>\""}], 
     "}"}]}], ",", " ", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "div"}], ",", "div"}], "}"}], ",", " ", 
      RowBox[{"{", "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"Exclusions", "\[Rule]", "None"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<\[Rho](x)\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.870336876547709*^9, 3.870336939095727*^9}, {
   3.870342771180444*^9, 3.8703427864892673`*^9}, 3.870343518779553*^9, {
   3.8703435529094343`*^9, 3.870343576416739*^9}, 3.8743159246922398`*^9, 
   3.874316042472485*^9, {3.874316096461424*^9, 3.87431610764452*^9}, {
   3.87431647330742*^9, 3.87431647393493*^9}, {3.8743847748652143`*^9, 
   3.874384776542643*^9}, {3.8744768010330544`*^9, 3.8744768013559933`*^9}, {
   3.874491481561191*^9, 3.8744914838487062`*^9}},
 CellLabel->
  "In[133]:=",ExpressionUUID->"79fdc70b-798b-40b4-b734-17618a1faadd"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJxF23k0Vd3/B3DzPM/zPI/3XmPI3iRTkZBUElKGUKmQEkmSQqQyJRWSUElK
yd1JynivMYQkQyjzlPF3Ts/ze75/Wa/lrrvP5+x9915nnfdH1uu44xE6Ghoa
K3oaGvyvm+f3yc1Na8Q0I8H1ebYZVCQbuntE/89C1UlNiOF/tjLtvnBo3vI/
i9ovMbMvbv/PKqcvVr5Ys/jPJS/ztxlNbkNs/9o8R36O/sQ2xPevO+JzHjTN
mCOVf61Af8yYyc8cef/rU+f02k0HzBDH7D8e2HhJt7jPDLXO/WP7aH1icRtE
Bcv/+Pqu+w3+LhBFM0j+deoWkUaHUoBq5P5x7FRc2+MHpigg/B+fzfvTQ3dz
K0oMkPprjinTN763TNBkjcxf5xjGpDffMUb0bUp/fTJNL5d4zwh5rOn9U8/y
SElq/hbk6Ov21/GndK53pBmiOJqGv26djPQTumaARHavcON+u54j5Z2kj06U
D/HhzuWobnt+Uw9JybmL4TYRfv7y/C499Kn5tyTudtmcO1bsemjCP1YOd4BG
0lm+T7rIff60Cm4GgwsH+qJ1UeNnCQJuh8ozjdUeumhkvFIXd5ZZ4NYCU120
U2ljC+6ftd4lCRK6qPPIIsCtu9NN+tSKDipLqrLE3cPV9eXImA4KsT9rizuq
xemGa5cOcv4dbI9bKZViveOTDtp746kj7kaXHbSm5TrI5b7OXtzBop8qCHk6
6EY7vRtukV7zYPlUHZSmqeiJ+7Cn0Q+WYB0UxX4y4G89wwFBOzx10KTz1WDc
IX73/iQ46CCz40xn/47/uyWGCnSQZP9k5N/7e5KBh19bB/24YXMFd9KLu3vK
lHRQBafCtb/zvaCfuUdKBz0fk0zCnX3WTymNUwd9qDl1B3fpxWYTyV8kpMFY
+xj3qw8+0VU/SKh+W0UJ7kpG2s+HvpKQOaX9Be7aqzpOD+pJ6ObS1SrcDQ2N
aduqSQhYKNXgpnIe7R+qICEx0+k63N3JaX7Kj0koV4C/E3d/G/Hp5xwS+rUW
1It7ULBh3i+NhPYUbgzi/pW+Hll0hYS6lsjTuGkeeN0mHiWhT19XueowMw6t
fm09SEKv+ZWFcbMp3ZI9vQe73sZUadwChZ+Kyi1IyMIGEnGL/vKY3WtCQh/P
RRvhltJaMfijQ0LPuHgscCuXanwwliehxU0hV9wa8x9Z+sRIqMf7lhdugv4h
+wt8JBRi6BeI2+hNcjeiJSEVGYkY3PbVi1PbB4goLJumHLcTww290S9EVH/r
3Afcrpaq5+IoRJS907sFt1f9AaaGKiJyZk+YxO3DsbAjoJyIfL3b13EH2Ccm
c5YQkalsGmc9Pv+tSMLhLhG5VORq4T4nsN9rJpWIyr8tANxRLnOPUq4TkRZd
+27c8T2KOh3niMh2l00o7ruD8Tb79xORfHt2HW7TusGFa45ENLDTtR/3wFOj
B+9sich7sWQOt0LE+IqMMRFZ5ljKNODzfdj8kaMOZrdkA9y+thlOMepEdKL6
+i7cRcK2RaPiRMSdV3gRt/3GfVdRASLq5e3KxD099IdhBwcRDbE3luPWLX18
sGSNgM67SU/hrtzJyn2mj4Dqjsv7N2J21/F8m99BQG9kda/hphGr8OlqIqDy
e6AYt8WoLzKuIqD8Ge953CNNKCCwnIAU7BJFmzDHlYmI3ishIKkrLQB348XP
J+nuEZCh6ack3EG+MlK6dwjotPa1Ctw8u8LqjyQRkP7EtSHczhIq8nWRBBR9
y8+0GfPX8ivtSR4EdPRKCR0F8/m736LeuxJQZ8NxA9xSMQaacw4E5GzwPhC3
1+7Ryy5mBMSyw+IbbgZDQIrbQkA33iSKUTHnS93pryASkO5wxl7c4xOWBpJy
BMQgrfUF9/XW7B/2YgQUx9wi2oJZq2IxKYqPgKYOB7rjDo7N//mDjoC425p/
454349Dd80kbCeXMK7VhNuSuvP76lTZ64yRzDvf53mPD4gXaqOZCfQtuhtCG
24Nx2sgwbCS2HbO1xbmp7We10T5q5DDu67zq1o/9tNHk2xHLDvz3VBT/57it
NtqxHszXia/ns0aObUbaSPJDzXncWZbjhfrq2kiDaes4boXvNm7r7NrI2pGW
8gWzjhArOb5JC92ly63uxuu5NTifWamFgoTPOfdgVhOoVCt+ooVkb9BP4Jbh
O36bclUL/U6pUerFLJFs3TgQpoVy9e0bcQvzyNHN+mgh+1j10D7MXFwdgQKW
WkhPOqWvHzNrQslDRT0txB0amv4Nr5cjrltfQQuhp74HBjCvshpv30enhRge
GMx+x/d/xvsS2VWaiM7N6+Qw5qGYcMenxZpIXCT08Ajmb/TOcShLEwkruRwc
xdxJyzw/GK6JFlhC/MYwt0QNqM77aaLli1vPj+PrbbPiEOM+TVT9qvfOBOYP
6wENygaaaEX+8/hvzFXnLWm3KGkiJUKx3BTmN6vSBraCmmioIdN7GvOzP60P
AuY0UL32D+Y5fL9eMAx//lQDlYm0dSxjTj/N96w6WwO1lz3xWcH397mJ4bYE
DbQsfIppDfO1mezdi8c0UPnEuYBN/Hw/EXaF+YAGohnL0qWdawbRU7vfidhq
IBJNADs95rDfDKrGKhqIyWZthAnz6YB+953CGmin6dtfLJiPT7xKPcikgfiE
FOjZMR8d86eJGlJH1SqS3tyYnYapX2py1FEnmcokitneu5CzM0kdPe8evi+O
2fbHpW2jF9SRctopRynM8Lv+U9aD6qg7uXpRHrOJB8+w2E515EW/NKGE2eDb
mJiGsToqHo7/o4pZqy8r1l4U+376VQ8CZlW3kMpDLOqIKf98pQ5mha+7Zk8s
qSHZ2QIdA8zi3XTuNzvU0IZAepgpZpYOX72uZDWsnrxQe8ymd8mGbNFqaKzL
MMoR86kjQiYmwWpIMrX+kQvm/oUP5jmOakgurGDvIcz8VWKWreZqiK965Pth
zNaxJ20YdNRQQT9zki/mF0LSDr78aijWSt0lGPPP/jNOGfRqiMHRPTgUs9Sj
RpfGOVUUrtr58jzmOIPwg4R2VZTa4vzqCmZ31w7/5VRVtBbe9+ke5lQZjSC1
y6rIYcbWLB9z3c/ok25nVNEMe/ivIsy6ZwlhaI8q4hqR63+D2c/syrnZ7arI
N61SuRpzNmv/BQV9VXQtzvVxHWbWjGuX44RUkfUb9wPdeP1eg3FvmFSRS5xd
0nd8vtW2XP+1qIJSQq3pxvH634ykOHxRQQMZDMWrmMu+muWIpKmgTLjTXm4e
268epj20jVNBLYOzpRqYpQOm8s+HqSD/bxE+Bpjj17KKB1xVEGHn7zo7zOSa
uWd8NiqI/Wnn+X2Y56/blllsUUHtwU+vHsF8SHL5TYGoCrKW4K+8gDl12L6q
h1UFgXyL0WuY64vz3nOsKKOT0mWh6Zh1TZ0+n+hRRizkpPaXmNkOlXQYZioj
i4093XOYoTJjt/81ZbRZ9yeOYaEZnJk60Jt1Thn9jph4LYh5IJL1B42bMvKN
3/Z4C2ZBa48R0k5llHX5zcmdmG15Xo15myijr5EP6g9hfpnjPf1ZQhldCNoO
4jCP+76dW+FQRpBN0PsuZhki35LGuhKyoLmo/gJz/Hvy+o0+JWRiMfhyALPH
oBj7vmwlxChksMNisRnYuWVOGCYoIWpXr5snZqNO8UaR80poIFzcMxIzf71E
Qtc+JaQ0ssuzCjONxd3A19ZKaKn0R+A3zL/eSdqnGSghN4pDIu0Sdj4/l+J2
FVRCubGM2jaYX6jfmzJgwK4H6FQHYc7Jk6YKzykigTj2pFuYw9Nlkr9QFVFG
F9PmCGbNi3L8e68roptOtwMylpuB2OqDOf1ziohwyHWzHjPTGfl2IX9FhKZe
KK9jHvBVuNVppYgazz8MOvqnGTQN5p4p11dEvZFMj+9ifuOm6HJbURHJRRQ8
68Sc6qAk7EKviM4+CPS2X2kGF+vzl/RmFVDUZxIhAXOQhXKX4HcFhJwusTRj
tjJUSe+oUkD1z0bkXVabwYq0mviecAXkWirAFr3WDEbTC1d1/RSQx9sJozbM
7fzqvQKuCoiwbMSnvN4Mipk17rbrKaCVIxWcXzBnXCyKKFNQQMXfz3nobGD7
4aqGeyq/AprMGitPwewxpSntPCOPZIKT2/dvYvPjV7KpMyCPpt/VUT9gNvqh
NcBPkUf9314ZEWgoQOCL9v22Inlk6xjXwE9LAZ+qiPJOvvLo+cEd5qz0FFBm
WEqvs1ce/UnyZE7GnFNKGuKzlEda7xVNJBkoIDxfJ69VXh4dC3kZv42RAnxk
yi6X8skjsS1ps32YnTN0j6bQyqMTEQFHI5goQCtRT9nxmxzauS9bopGZAsRZ
yplJzXLIiLXv1TkWCmCJ1v/J+04OuR8e5SGyUsD3MwaPWzIwRxRVFbNRQOrB
Leq7XeQQ1/5vZfOcFDCUdqI/arsc6k87WtTGRQF67Y+Sn+lidh5srOCmgE5b
oWVufjn0fL4mJIuXApRj7Z4AOjnEosh6Pp2PAsLex7gfn5FFFlSJB9n8FCBq
OFfTTJFFHmZih6oFKcD/lFrYRpUsyh17Ff1diALelHiqa5XIIp4XzwdYRSjA
TZGanHBdFjGwjV8IFaOAbL5i9502sqh+6uEWijQFTNkN8Z43lEWVRAtBM1kK
gFfFPz5RlkU3sq93Vslh9W1eVWdnkkWXGJ/d/qZIASTj9/1GCzJIqXzq8CVl
CogOWU72H5JBpjFfXuiqUoDC76PLddUyiM/rQPZ7DQo4rZL95M9zGXThcbx8
thYFfDzc4a56XwY1PqyliSdQwNGebR/jImVQ4VLFh2RdCnj8SSbFykQGlRq4
HDyxlQJW6Fy3h6rLoGJi7dlOQAG2pknL+WIyKKb2lJeDOQV88Vt9xzErjUQC
GrWirbD7NeCnEECVRrIXtY8Z21KA2N6u+IYSaTQTlqXIbofdD4uXe+OPSaOH
T8iMM44UsPFGvmrMRho7H2JesLhQwD1iioKNijRipPk6tWUfBQxKHZ9hHpZC
NZmzAb8OYevnj8q1y+5SSL/5dVhhELYeTtyZGTKRQpORJYGPgimgcITR1UJc
Cq2dEDryMYQCfrUNKtB3SSLJ+hPPfCMpINF29zWvcklUbTG8ffoSBWi/J8+8
T5VE+TDQ824cBQSXZFVF7ZZEhae3iwamUAC/IrvigLYkynuyZplyB1vvmWev
AS5JFCFoIzWYRQFLcS6uG/US6E+jmA9zAQWcP8wze85CAk2l2OxLQRSQEnB2
TkJRAjk8pH9VXUsBj84Mzr9jlED8yfc35ZoooPVK2dJmrTiS2OjVO9tDAaM3
JP/kPBJH2T9/koK/U8BaeuyKWZw4qu0NNrr/E1ufRa7rl2zEkWX1B56CJQow
efl+Q0FNHOUzJDlf2qQAxyo1mlo2cfSNrre2iZ4KzlPX6FgaxdCIRzppOwcV
tM7nsFy3F0MS1262NkpRwc91VjZNbTH0VeqdcL08FawznWJv5hZD4Q186pMq
VKAiup2Lp0UUVa8Q45/qUIGpXAn38+eiKCefa8+uLVTgpC7M65giil78/vpL
DFDBha1j/KlOouhBou2s0Q4qSLV0FNTTFUU3H9WQUnZTweNdb4U6BUTRzGrq
iJgrFbR7JoiKdIogVzjXVHuEClRjidJZriIo3tPbt/wSNl5ShszWLSKIeiMI
1V6jAuc0erl+URHky/JdQygVG6+wQ0HmqzBKWMiSD8/DxnthqvT+rTDyVzSq
TSnBxqt8pOyVJYyOacyWzL7Cxms+q5Z7UBh5Ko+YJjdQwfiXQfXtpsLI6/Dr
q+0dVLA5sENzREoYIW76w74DVKA2J0lQGRBCQvLH+q4tUkGUcLVekZcQsrvs
4cKp3AJuy6gb2G0TQju1+ualdVvAE9VUw0l5IRQW1ZWabtYCOo2PGhOGBdGJ
P8+7mw+2gAkLiknLR0HkHE4xSw5oATT2hqbB+YJI41upzudzLUDdg82szAcz
eeTMg8wWAP1Ome+xFkSv/TVO2RW1AJfg3m2LKoJI4qSmy/l3LSAqpsTScFwA
+abOJIR8x8YrcNxZGSCAEqkrlH2EVrBfkJulwlYAxYEfAcFWraD/YsOHlyoC
iI9e0s/xUCsY3W9h/HSIH73XdtaJSW4FAZ9olp5U86P7/AZnh560gmmdd6UF
OfzIXniQT/VTK1jm0Fd74MaPeh6uikfStIHzZ2eHs434kVreNu37Um2AZqTk
fqYIPzrqF/Lj89Y2wEpWFr3Vzof6XrV32EW2AbGToixxO/lQqGejuxlPO8ju
6/gQo8aH4j6W9t03aAdytimRF1n4kAaNQ9h+j3agLs++FF7Di37u8sxnKG8H
z5I+lYY+4EW2SdEF3D/age7apaDTUbxIhdalKI+3A5h0rA0HmvAi66s+nYWn
OgAyq7jvL8aLlCyxR9ZHHcCi5MxBn2Ue1BwvnHS1twPYXZls9yjjQQOf39Og
nZ3AfcvABycNHnTtUFe22/YvYDAvK9KBjQf1bFFcW4n7ApoUSkMyqNzImCXU
bqb5C+jvfHgkwZob/QxfOGzi1QVGnkr0xTJwo72rd89VPe0CU3G3nKMQF+JL
umQyt9kFaIyvbDtlyIUMqZxrXQXdgEWA5m3APCcK3HogrIq2B/D+DiMdfcaJ
Um0disgHe4DcPX/ZfSqc6FRuYeBV6a9gO739pqkIBxKwebCc39QL7HtrQwzb
2ZGe+NVBinkfcHkJJok32FEwU1mReGUf8PUh9imwsKMf1qZnXr/tBydgobNU
DRuq2ZEdfcD8GzgrKt8oHMWG5GYjij82fQPxDQJv2ZZZ0YTocFnr2QGQkptA
YihjRVt4M/S3fhoAmRFMhevHWZELbUSDv/B3UKS9nDY9yoLUZGIUzqLvoPnm
15DOL8yoxfxo/SXDH4CcbKPglMaM9Os0afTTfmDz96qF4sqMdt76lSCz+gMk
X7upUdfNhEylxQP5G4ZA9FXanu0ZTMhovy7V1XAYBF85fqV6PxMyj5CucXg8
DJwv7Rh8+5URJZxcdfx2ewRsv1iRZJjFiCZejCdU8o8C/UjlrS/dGFFVxURp
d+ooED5Hn1bSx4AylCfHj+f+BD3Bb+3uf6NHXxgaEvPWx0HDCdVVyRx6lOYr
uYfv/gSoDLpTkOFBj87Xl+yWsf0F7vqfok/9TofQcmjjTPFvkOj7/RnPAzp0
szjVWN5vElw4uss9wYsOdRl+nmhRmwIeXuoVsT9oUd3ybnc7z2mw2yP9KH0u
LWqeCLHKaJwG5u7MAlHetCji2lJGnvEMkN//I+jsMA3KfXJG+rLiLGh4qG/T
1bxJLnvrkH9LYx4U3ePLbdm1STa9orFztWIeJGZObtRTN8hP+enGPHYuAIeb
+WXvWtfJrz3kNyeiFgEpKZr7ldM6+RFLuXqI/BLgv+bu/6x9jRwslNxX17AE
OqOFZB52rpJjruc9Ldb6A15fmA3P2rtKTmS5Z/Ni7A9ID2/uuNW1Qq6x8rwW
+GQFuAXHXovr+UPuEZH0YrRYA4Oei4uB/UtkgvVgbETLJqg52Lrb59AS+ZWM
VuaYNw3M21dS5DGwSO6puZqZNkwDfXcf9XIaXCDf8d/xSW+BFtramb/beXiB
fPz+KOViDB1Ut5ESsRyaJw/r3RnkFKWHk7CzyXBkjpyybeTEK0cGSDUpVSH5
zJHb7w0Pmy8zwOeGiZfUf86S05UYYscfMsLTBMstUuMzZBOFi08ucTFDFw25
VOFjM+QJ9xGNxSZmaKCyMcnza5pcGRHAciWVBYoo9NiwBU6Tj61PXYrwYoVz
IMCGuXeK3JXFmWNpwAbn7W6oLQ1OkjUOHZ40HcR8oIx9dOw3+chXsFnjwQ7n
/bp+dU7/Ij8kePuvfMAcutZUuzRBLiehKAEhDjh/WeZp+cY4+V6KwxWVgxxw
4abFjXzGcfJB28sXOrM44OJ935O3OcbInJKSJ6y+YH563TGW/yd5z/yOpRpO
Trj47plOiNgoWfQuusZvxgmXGtoFjsqOkG2KVHYVnOSEy6MSX7ZrD5G3vJi7
f68B8wJ8raf/g2wWuPbBYoET/qE/kq64dZCsPVzq/UmCC65IFx9g3DFArjRg
BpePcMGFAw/Ojj/sJ5NoYnjrYrngYui4cf3zXjL/l2f963lccOkmaeMxuYes
sVreq/CBCy4/DUdXm7rIgdk+Tab9XPBPQ3W039dO8hT9dY2dS9j3j7Jttxlr
J+8yvLDDjosbrtI7MasutZLbXmd4mstzwzXpzDoWxhZyRx/HbXV9brgSWivc
othMHrmSx8hqhf3/qUvWDbN68nLlntqePdxwY3RExuFgLdl3h9lYjhc33JQO
zeM+W03mH1g5dyCQG9I943LOVn1HjtCBV9lCuCGjjPZBSc+X5N4eP9GS89yQ
V+ZeoyHxCTnAs5hkeZEbEmjQu0B4h0zfsK279RI3ZNhcDnGNjQSQMZLbOYYb
doPstcaLD0G8ZntHXTQ3HHuqdcbn6nPwMbRPTTeSGw4DroCfuytA71Zn9ptn
ueHMaMhz3QQEom7TBo+c5IZTT0c0zpysAe+33N+r5csNf4e6FLzc8xk0vC0p
9XfjhhOgVn5xSyN4ocsdmmnPDRfoM3eJc1OBRmHkLWTKDedHHROMaVvBo/05
K90a3HCuga3hwFwbuNexL2FUhBvOPq1mOT/cATQt1TXG6LDxb4ZbZn35AuLH
cwv6x7ngdCgpprKuG7w62UL+ROWCk+DB5lpxH7CSqF0Mvs0Ff8vv3yqZ8w2s
+R+K1QnB5pv+6jupugHATTYlDDlhHoWrpm8HwfuJfC42VszdEmK7yn6AavZY
5dMDnHChYdnwUPEQkA/yUH35khPOP30WEnlvBLiEWhV77sN8//qtpLRRMHZS
ripEmRPO3fQtu5f8E3yKPrMle5YDzl62aHsaPwau+M1MgjeYQ2VmyZfGgWkY
f4pbBGa/NR7q+QlQrNfZaGXEAWcOdGkPnPkFJOZ3DZMm2eG0XZn9dNBvcDll
pMEnFTO4EUjjOwlMzjPf2VBgh2FCLRWkkCkgcCHJmSuGDUYtslwimU+DI9fe
jRU9ZoWsTTYUb4cZsCjuf09kiRnaG/ovRHyZAVM9rm1Kasww5WG8+B33WVDk
pCVGc4QJioU3+NQFzIEX+t80uqcZoPvwRMLg3Bygqdz2fpsZA3zowFG2Gj4P
ghd/PbdPo4caynY0WlcXQMfmMJfJPjq4tb05LSVvCVzupPWplaaB0WCq6onG
MrAi5BO/m2yC2kLu4ZoXy+Cxn1Vy27YNYH/Rgbj0/g/4wFV1XShwDaT8OrGX
x2YF0H9LHytNXAVf9iZHqFJXgAgjOBnzegV4aLXWHehfBZbnBTwuy/8Buemz
U6ePrIEsX3cOCe9l8JOBXyjx1xroiONRKX+yBE5+dfJCK+tA4ZXsxA/7RWBW
4x+Rwk4Dxb/Rblj0z4GhP+E80rto4IuAc7m0DnMgVvvawycpNPCnvibLYO0s
qM94UlcjSguTq6pkbD7MgADqW7fdB2khb3nylmDrGcDF1DjVl0ML388WltC3
TgPHk78El5TpYO49a8UTP6bAfP5awaVjdJDY1npLiHsK3O7lMOF5SgfJHnP3
7M0nwVcrTS9VfXp4hPcMZU/VL+AtFVRywIIBZtx6tHmFcRwwOV8w+3mFAban
j58JPDoGCq4mtp9uYIBl+xM0fzX+BL/mS1YSHBlhNo+h0PDjUZCoRk4Qu80I
KW+fi65JjwKCB0XmUTcjLCI86xnOGAFnGqYskQcTJKxd8YnMHgYitDQ9O3OZ
4GK+uXOP0jB4o88T2D3KBK8OTkq6vxgCG/cJN2eDmGGXX3OxVdcPEBt28ptC
BAuspJot1tgNYs/r1020KlmgIEr5FvDnO1hJf5RusMoCH5057VT/6DsIetvn
ZHuWFdoWfFKx5fgOVBqXnzm9ZoUeL9SKYfUAGOzl5zq4xAo1WLbOpYYPAJcN
m8/Hz7BBxl5/R66hb4CH+4ji2TI26HORiX7D8xuol46Kjp5jgyOnXMg8Q/3A
1Kzc5NZJdthQd2FTYL4PKMbIPX8TyAFluiW/8cBe0J+6laumiAPWeEoYx339
CtLyXI81TXBAgwcWn9XCvwKOT4mKA36ccOfumaI41ANqvzyOHivghMmx7B28
vj0g6mfNt9lR7FwajCZ78vWAedbVdMajXJCmnhC/EtQNSsSElriwc+NqneAT
Ydlu4KtOdBYZ4oKo8w9tbkcX6N3pw6WO7eNHLesL32zvAoOf/MxUtHlgYO/Q
s07wBQCHpakiex6YseZidYj+C8jqiskmBvHArRI5658+dwKXsXurRsU8cME0
lXndtRO8OKlZSG7kgf5XqFuK5DsBz8obV4tfPDAnbiukne4A9WydL+3UeWGU
klCBT0IHUL552LvVlhfyXU5PPOTeAWLEZ/j2+vNCOYPRHfWEDmCqwXHC4zEv
vOPn3FDX3Q5K7czVTinzwfrhXRLQuB1wd1K6liz54L0eIalMoXYQ4H7wyvmj
fFCo08xIENunlY6HDV3O44MOvEI82562gUtLjDfZPvJBro3YguHENjAQedMs
aYgPls7QCFw+3gYybpRkp8nzQ5vQY4KZOm1gScTETnIbP1y6Y55LJ9wGnO/X
rd734odVL4rmrFdbAVfpkOuT+/xw78OGfS61rSC6TYy/SloA2h0TmiAfaQUn
lp2ZR80EoFKox3qSXStwl0xa5fYWgL3vb02p6bcCIx/6Ic8CARhn/PJmPmsr
ULm+tSu+XgDKu271DZ9vAULPQxtf/BKAJWGfDm5+awFzKxNljERBeFo+0Jax
ogUMSis91nIShD2/a7jP5bcAqoXH3b1nBKGRGFPStdQWUJTYfvlxhSDUuZnq
4RvcArzl3rnYmQvBIcsk8+vY87Cj1ZJtiLcQdJnni9ithD3PBhDBvVgh6H6x
b/q6SAuQKM9TnqkXggLun7j3blAB29dv4mK/heCJQ+FO/TNUsLwpyrONWxg+
+rN7s3EYe363SVxOdRKGhuy1Am3NVFAd9PnXuzPC8JsyLevQByp4dpPu+8gd
YVjNkxu2q4IKrveF1Bn2CsNZsM6klkcF208eyuj1FoGca0UjOVFUoHs7PZHx
ighcvPdr0yCMCuTetkVrPRaBCcw6pwROUMEGg/WxqN8ikHfh6PFUDyr4pRp9
6DG3KMyfPPdEZx8V9NhXOrUSRWGkdnY+tyMVlKcRTBRCRCHhgCp9iAUV5L7z
J9ilicIHEd4P1rZSQcpgrkLIG1FYE6977rUBFQRpiHJ+3hCFSrFLG5/VqUAJ
0fYfuyIGoxmc/GWEqEBg2Lg19bEYDHhLd1melwro2EJq3zWIwfaazphdHFTQ
7zRews0jDi+t8y1I0FNBY5jCQ0OSOLTw7qkOXaeAN3fd73g6i8MyYzXn9XkK
uDPaGvkiTRx2H6852TlEAbEcnKd734jDuJ8BtxX7KOA00cqXsU8cBu5Uefii
gwIczr112CsrAd1Uvf1jPlEAC3eu7OpjCRjAHL76oZgCtJ6fOBHTIAH9G7eG
TT+igD1OW8mcvyWg84GbBTseUMCDO51uMgRJ2MJ6a0fcHQr4vOXhk8e7JWE+
eDd1NIUCJr8eXyGdkoQX9j55HJRAAcYyrGnbyyWh0oixyfwlCvCq7hhp/iIJ
3bbevHs8kgLivB/ouf6RhHX1QYrc5yigvcC4zd9ECvpqhiiWB1NAEDGI60a1
FGSWOr899jAFpLYZHRQdkoIim+wLDB4U8PYMc9EDRmkodoA1754bVs+bHJuX
1tIwYzPhqqILVo9bYJqpvzT032vNy+1EAc4bW0Y/XZOG5Z6HAa8DBdw3b4vp
aZaGJUolEW62WD1D99oOT0vD63k1ArlWFBC6TT95kUUGmr/OPUS7nQLuDtMN
RKrJQPff29xXAAWMq2ZFpATKwJm+PVbt+hSwHk6nuPeCDNSvcMl6pUsBPI2+
jeJJMnBIN+TjExIFGATpiec9k4E7rDMiarQowJacWe33XgYuiXWz/9SgAHce
On+tVhkoSPQJEFOngJjS5tev5mRgUa1Y82NlbL7p9TzOM8jCyQTL34xKFFDo
nMlsJigL3+eniB1XoICWRR+Xen1ZaJp+k9ZHlgKkjGnne8/KwqQMQc9BcQog
XvfJvB8vC7Pkug2zxCjAoq/J/GimLGS5sp/kIUoBxyIzkqcqZaHaaLUNozAF
XKDSbClrkoXW/FFNw4IUkCLrMxDWLwv9DCNNKQIU8PqDjjYdjRwM+FHT9JaP
AhoEMjpreeTglqYd3lW8FNB/hObCNVk5WCgS3PWZhwIYWJoaBbbJQaEbXzzm
uShg986j/sqxclDKbTXxHjsFqDnvsmi4JQdN7AWejrJhn3czlDqeJwc9j5+U
08NcfoyttbxGDt43aDjyjYUCxK6VbLGkl4dbCyN3BzJRwFzKHf5xPnn4S/vV
wldGCmjMiPqdICcP/e4yUOwxRxY63u8wk4cK3s25kIEChuoWWY5EycPZDZ7C
3XQU8K7l2yDLDXn49KjOu35aCrjd/bmy6J48fCt2Xv44ZuuxjBPzVfLQ4eqV
K+k0FFDMArourctDfblKJb7NZhDLo1KqzKkA+5xWLF/h72dEeK83SCjAIf5Z
5kOY+VR+AH4TBVjjViRVvt4MQqyuPHoQrgCflfrkRK01g127Tly0jFeAqkuH
PhhiVtm778B4ugJUEZZdmV1tBj1H1blJFQrwfPrXI4GYQSwl5P2SAjzKmPgg
bKUZiCS+djjCrAh/M/Q1Asyzt+6rsQorQqO+9EwWzLl5p/od9BVh1BGuxew/
zYDlo7DlwGlFKHd94lDfcjP43kgjExOjCOnthQOeYX7TPvZHOVURPnR/XhOD
OXDobfHxF4pQKIdOj4i5ld5DcHNGETbq0AilLTWDJ+w2Uw9olWBqcMiV05hj
+El1lrxK0PBB0+ZuzPryDBGJBCX4gmNmhBtzpnnBkORxJSjEXfPp9mIzqEzz
+c4fpQQ9CnsdwjD3Tyr1syYrwR9MPU37Mctl5n1ZKFWCamP6l+UwW8x4t098
UIIuGczPmTEfsVJo+d6uBAfSM1/8XmgGBXMP6psWleDkqodcJeZ6G69PH5iV
IUn3/cVczL/uydZUiCjDLbwgOwGz9s6cd3lGyvDCfeElT8zluXefRVxQhkdZ
RxP4MHetuBWfSlKGaQmRRjSYVxwkCv1ylKGzKfns5Hwz2Lqe8XBPtTI87bh5
txGzu9P+nB1tytBdEIZXYo56LHrXbEgZ3riQ/6UIc82etNuaTCpw2qWXMQnz
yJO9N+WFVWDW26XmKMwsdMI3RFVU4PLzZtZTmHeU3LrKaKsCewqTa10xtzLd
PN+XoAKFmB5tquDvp90cz7Zlq8D2aaY/kpiFXvCG1D1VgSssWbb8mPcdunH8
ZYsKFKw4NbEx1wzCX+4KeDKoAn92ntJbwJzFzu13f04FsrTINU1gHniV4JUg
qArzh8a+4u/f6bjsDl1SUoUB1h72LXh+wZvD7ayBKmQYh4z4+3ofnmt7juxT
hQSmGoMKzJO+cdZb76rCFBbWsCzMPGSr7TolqtC75WrHLcwkQWZzVbIqfBYl
7puE+cz7y8aC31VhYkiv4iXMt4W3G7LPqkKWpe92EZhfBzLo0dKrQWea3Fw8
n7Ameknrt4IaJBYldwXgeYUT5uo/9NRgrfp8qQ9mUEur0m2pBlv0osq98PxI
cJTsR181yLLxR2cfni9oiBC4W4R9vmZkxArz9BfytuBKNVgg8lrdAnPXEO0p
q0Y12LX12HWIuWDjcsvMhBqk8TXO3oLZkpSYaKmuDkn2mpMaeN4DUN+JG6vD
Eqv4NTz/IbST7/e0rTp8kz4io4x5+MjtHZn+6jAriOexLOaY9GyW6cfqcFzE
OV8Yc0D+gMHHCnXYk/XCSRDPp7yQ88moU4ciXEF8/JjlmvI/Woypw7zn0++5
ML+neRqdrqIBvSjDX/H8SwHnzPMgQw0YcLuCiRHzDTGd79usNWBJlSnA8zIe
uq/ApI8GjB6s/YLnazZ8yGvmjzTg/lrnrD94Hu00rYbIKw3Y3C6vhud1mi9u
O/C7VgNez0LVi3geL/NTxZ0RDbijTo5/Hs+3UighvxQ14eTgdhU8D6TQy5v/
Xk8Tns7WZJjEzD7m1HF7uyZMis38+QvPo9J16Zgd0YSh8xz1eN7orP7A9K1c
TcjP8/4nnlfy2CYnc6xME5ZutaLDbe3gvQvWaEJn4hU5PN8k4v+zePyHJlT5
HhDyA3P53Wl/IK8FpfwKj+L5qOxCUoaAjhYMWWp+huenYl+drhsz14IBHOY0
uPe0LCunemlBrwMhJXj+ap6BdvjnfS14JJTF4ivmMIfrZkHPtaBQuuMrPM+1
limcPYe0YHrwQy3cDDpaeze+acFc1SEVPA/G73mgjl9KG+bkfLXG82K3i0YU
0zW1oRzY1Y3nycSWT0ZLbdWGJnNzAbjlkuKMVd204Ro6dRfPp5HevSw2zdCG
b91HZfD8WjmLGVvNY21Io3T2M553M3JuPGpToQ19HqcE4zabGJR27tKG7db8
za2YCzhY6nTZCdDmsncOnqfzL7ULXeIjwOF+m/24NVxvKr4RI8CklwQh3M8e
SkUDNQJUjPp8E8/rvTbSM7a1IcDCxexcPO8XPhA+xrGbAAfi2f/mAU1i0R2K
KwEGE7j/5gVRy455Z18CnA4spuD5wk++XsWHrhBgPKsAH+44roIDckkE6MLG
OILnEW3LfrMO3ybAaLLhW9zNm2FH/fMJMD1zmx/uzttJ0mc+EuBQw3wrnodM
M+loMmgiQKom8zPc+wfFzq+0E+Cew6KJuPs187sihwhwv4GM3d/8ZE1lcjw9
EZYGLHXgecwCfzpox06EcnWWb3D781hPcvMTIXne4x7uyQNttrfkiJCupP8Y
7oXZMfocMyK84+nDibuXnPGB3ZYIpxezFvA8afX1HZdCHYkwzDvpb940UamY
btdhInSNv1mK+/Tcweo3x4gwXSjjLu79iCta6TQR0shYXcWttP8E7UYMEf7W
iPLCzaEs+94vgQhnXegccM/OtUR13CLCe9bCprjJCTo0xflEmBI8Ko7b9f3i
xoHPRJgrXNiH52tNEx9VfaISoVChLQW3wgHXCzrdROjvePA97pn5inW2cSIM
6anPx9313v9dyCwRuq1IZeCuShSPGFwhQmrJlwTc8SoRaxXsJHj7tH8I7hML
mpWKAiSYm2J6DLdLdf+5ZAkS1Dl4zAO3vBtc9dUkQVWumh24K5PoV4R3keBn
CTUl3A/cyiou7SXB80bnJHHHqR45O3WIBN0teAVx7/lQu1x7ggR33adnxG1y
I/Q16SwJJg0cWMfz0nIHVcKyL5Kg64/pBdyTi1eXzqSQILGibvRvfv6D0avv
GSTIMM/6HfebGxMhdg9JcAVF9vztB1CzW1QoI8Gss4zNuKXdeRbaOkgwit3+
FW4m9fdloB+rV5y79G9ee+nk6ScjJKhC+VOE+3Vy21z0Egmu0lg9/Js3d495
MblJgnksj7Jxx6jrndrPogPXPqpn/M3nf7w9SxTVgTp92cm4JQ4tn2RV04E7
b9+5intsed/MgJEOrPrMGY07WkNyOslNB+4KdD6NWyCC9oFlgA4Mb7kQhPtR
07DT+jkdWByy4fs3jx9U8so/UwcSnMfdcbuTU/xkn+hAkwd2+3FPc4eKd73R
gYPO83twCz4Hkdt7dKDkuzU73EaOLD9K/+hAdZfRv/0A7nNUSxlRXbifLRPi
vpSaXphgqAuVrtMa4y7Q8+Ja3asLITOzPu7Z0LmOjtu68IJroSZu4zcxd591
6MJuOS7lv/djTfDINQE9WHqyXRZ3s+kjjaNOejB8s/Rvv0OExu6wucP60Duz
kh+3htjqh6jTBjDFW4Hn7/WdphrQnjKE9GeG//ZXWDfnPbl4cgv8udf/r0X4
uOcZjhnBCU/jvx7bE2YS520Me8ZU/unXuGBZqnnKBNbYyv51Vr6AStvFrRBd
/qf/Y48xV+2xC6bwUOI//SFcVGZvhnMAkrT+cYHCizuHLCHcZPrH1p5e6yYU
CMf/7T+pTznQlLnHDI7925+ys8b57spXMyjwb//KxpPDtE77zOGJf/tbnt4M
PvKk0xxq/+u83zoDqe7boOC/zrRa2H9hZBvk+NcSNAGnzoxvg//fT5P9evBa
wOT/nKNKrdy/+D/nsj+RMmCy+M8lFI/BKUULyPqv0d5GP88jFpDlX4/4PAyz
GLKA/9+/M39y2J+zb/t/vuZxPX553PI/X3zr3to5YvWfg7hyPI6dsv7P//YX
/ef/A/HxFM4=
          "]]}, Annotation[#, "Charting`Private`Tag$10235#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQHZP48N3//x4HTmVrrF+455r9zokWcQlNCL7Yof6z
B1gQfHe7m3XxX9zgfEm/7+zc31zhfI2Sxj2b/7jA+eu2LnO2eucM51/tWrDo
7EcnOL+42vSK3QNHON+vycxw7WUHOH+KpcSZgE32cH7l0p+3mCbbwvkLLFpm
nptuDec7/Xi2bsoySzj/0rv6TLFuczh/Cc+hyxsnm8L5yYlWjzmKjOH8uY+6
PKOiDOF8YzHO/V1n9eB8jqsZpjcmasH5CY+kuCPnqSHcG2upHRimBOfXJAt8
qnaRgfOvrQjy2ZMjAuefm3y77Np1djj/s32OJ/ud9/th/A/2E3IZMt7Zw/ht
FYX3VWo5HGD8pstSwvvkReB8Dv4lir9XysD5gT5pWeptSnD+bKcVT2Tz1eB8
ztO1InPXaMH5X1gYn75YqAfnf/30knmBoyHCPh3ZD/0xxnD+ObvlOmnBpnC+
jtTvww0l5nC+x7mlqxsLLeH8l6EVNh0p1nD+nGUiGpcbbeF8vgvsKSzV9gj9
iUl/bc47wPk+R0Lm/rrtCOevn1yUuvqaE8J/7l+j6p45w/nP0hdXuDxxQfiv
8GkW711XOL87oafrxys3OL9xd9yla8/c4fw8vgUJ2cUecD40v8D5AL4Os+E=

          "]]}, Annotation[#, "Charting`Private`Tag$10235#2"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJxF1GtIEwAQAOBpljOtxIa5pcSsTExFs+nma25ON2tJWgmJmu+macMHZvhK
GSJTUJlYYYtV84VlL0QkUZvSH90Up6vU8pGTLJhrac6mWYHeHRzH9+O4uz9H
TRZGp5kTCIQL//J/jUua121v8wYIOzFLiTPYbaKTJzRrJ41oAXdk87wenefR
vf/eHFq8UePi9RbdU09PSKxA2ytqlQMWaG7wx9Jrq+FgcuS6pfWvMLBrfnnv
600OuLOrJdRfFwqeFMseK3+wcZ8i2kTwHAscWeHr/UwdAm5gOIxcfMUE327e
mDKXBIFldNF91d0AMNu41NnQwgCP68oy7Kv9wHIbhfqlhAZOSfL/Qsz1AUsX
xBGxsd5gH3urfrHSE0ycFNA+1LuBExco1lcfuuC+8YzTUTHO4OIUW0MRxxGs
aYvm92aRwCrJdIHmvSX4JzMrwnJmpX/XemZdNkGgY+66sjBn9kQJMWTXFWrK
4b5jJDDxkJxqancER/HTM09VOoOb2G2LTkIXsNVwCUn61A28amGm/frIE7xm
WN4jY3njPHcnfW2cD1gV3OqefokGdqeYBu/k+4F5quaO8hwGePlKYWBVagD4
QQvJVV0eBD44ZplqUcTE/qTkrcDREDB/6LL09zQL/FySm9ahYeN93LXY0qVQ
8NL1J4WcRQ7el6PNPPApDFydWCM2fgsHl79JGNcsccEO78YKAr6jX4yxj8pW
0J+1LqkZRnSg7cqayYoHNqaWkake6JsHZYk38tD7yHZ7x26hpcdF7WeL0SN0
gWFLhHZL8RLVNaK13QOtXT3oYsUZPqUPTVLK9aUKNHuhisEbRstsooanZtD0
I4NC5jx6lEojybXoP77k+GwdupFVbTZuQHvwt5p919FDMcJzTSb0zv8C/wV/
4ij1
          "]]}, 
        Annotation[#, "Charting`Private`Tag$10235#3"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{-1, 1}, {}}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox["\"x\"", TraditionalForm], 
       FormBox["\"\[Rho](x)\"", TraditionalForm]}, AxesOrigin -> {0, 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {{-1, 1}, {}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-50, 50}, {0., 3.9396134577406485`}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Distribution\"", "\"Equilibrium solution\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8703369398444967`*^9, {3.870337120187818*^9, 3.87033714939504*^9}, 
   3.870342788438745*^9, 3.870343519379406*^9, {3.8703435608314037`*^9, 
   3.870343578029258*^9}, 3.870344130534731*^9, 3.8703441880038443`*^9, 
   3.870348557658633*^9, 3.870858122543284*^9, 3.870860981129115*^9, 
   3.8708637691776857`*^9, 3.8708638905741167`*^9, 3.870918438853664*^9, 
   3.870919965719623*^9, 3.870920011440733*^9, 3.87092005554736*^9, 
   3.8709298688034887`*^9, 3.870930225857904*^9, 3.870930284224012*^9, 
   3.870930448826985*^9, 3.8709309910126457`*^9, 3.870940187899568*^9, 
   3.8709405847444143`*^9, 3.870941934712084*^9, 3.871025839827353*^9, 
   3.871099918619091*^9, 3.871101035367697*^9, 3.871101562068532*^9, 
   3.871102317812722*^9, 3.871103087426694*^9, 3.8711035293909273`*^9, 
   3.8711039528840933`*^9, {3.871104201091629*^9, 3.871104255426037*^9}, 
   3.871104294846979*^9, 3.8732864509082813`*^9, 3.873300219572545*^9, 
   3.873300261403163*^9, 3.87330042936665*^9, 3.873300884284112*^9, 
   3.8733011765015383`*^9, 3.873343921748156*^9, 3.873343966859973*^9, 
   3.873344421414043*^9, 3.873368552695751*^9, 3.873368591248509*^9, {
   3.873368622254558*^9, 3.87336864922145*^9}, 3.873436707670142*^9, 
   3.873436946040662*^9, 3.8734391948429337`*^9, 3.8734419319766083`*^9, 
   3.873442987727706*^9, 3.873456269020688*^9, 3.8736997028892317`*^9, 
   3.873786125168817*^9, 3.8737992117591476`*^9, 3.873799253017666*^9, 
   3.873799300869413*^9, 3.8737996625200157`*^9, 3.8738001206478653`*^9, 
   3.8742319675699883`*^9, 3.87431574860039*^9, 3.874315925916491*^9, 
   3.874316043117511*^9, 3.874316108714541*^9, 3.874316474983405*^9, 
   3.8743181344793262`*^9, {3.8743241016358423`*^9, 3.87432412735009*^9}, 
   3.87432430845601*^9, 3.874324376805215*^9, 3.874384450136052*^9, 
   3.874384498095954*^9, 3.8743845788871937`*^9, 3.8743847781673603`*^9, 
   3.874390510165132*^9, 3.874391090489292*^9, 3.874476520284431*^9, 
   3.8744768023462067`*^9, 3.874491382896029*^9, 3.874491564949348*^9},
 CellLabel->
  "Out[133]=",ExpressionUUID->"a564143e-cdbc-44ef-9b5a-4223aad4b1a1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Current", "Subsubsection",
 CellChangeTimes->{{3.874315977848963*^9, 3.87431597944289*^9}, {
  3.874316953993548*^9, 
  3.8743169562414293`*^9}},ExpressionUUID->"7e2bde79-e4c7-4244-b3d4-\
2839701b982b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Piecewise", "[", 
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["kv", "co"]}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"\[CapitalPi]v", "[", "x", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", 
             RowBox[{"zv", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
          RowBox[{
           SubscriptBox["kv", "oc"], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"\[CapitalPi]v", "[", "x", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", 
             RowBox[{"zv", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], ",", " ", 
         RowBox[{"x", ">", "div"}]}], "}"}], " ", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["kv", "co"]}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"\[CapitalPi]sv", "[", "x", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", 
             RowBox[{"zsv", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
          RowBox[{
           SubscriptBox["kv", "oc"], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"\[CapitalPi]sv", "[", "x", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", 
             RowBox[{"zsv", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], ",", 
         RowBox[{
          RowBox[{"-", "div"}], "<", "x", "<", "div"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SubscriptBox["kv", "co"]}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"\[CapitalPi]leftv", "[", "x", "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", 
             RowBox[{"zv", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "+", 
          RowBox[{
           SubscriptBox["kv", "oc"], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"\[CapitalPi]leftv", "[", "x", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", 
             RowBox[{"zv", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], ",", 
         RowBox[{"x", "<", 
          RowBox[{"-", "div"}]}]}], "}"}]}], " ", "}"}], "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "Lv"}], "/", "3"}], ",", 
     RowBox[{"Lv", "/", "3"}]}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", " ", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "div"}], ",", "div"}], "}"}], ",", " ", 
      RowBox[{"{", "}"}]}], "}"}]}], ",", " ", 
   RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8743170078044252`*^9, 3.87431709528893*^9}, {
  3.874317174341976*^9, 3.8743172176944027`*^9}, {3.874317289858109*^9, 
  3.874317290910363*^9}, {3.8743173211046457`*^9, 3.8743173236680098`*^9}, {
  3.874491711316629*^9, 3.874491712613965*^9}},
 CellLabel->
  "In[144]:=",ExpressionUUID->"5834d40b-cd33-4a7a-ada9-ebdc138b4b7e"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJw123c8le//B/BjZO+9915RSMK5lZE9Mxt2CKGibA3Jyigkm4QQkjK6rrtS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       "]]},
     Annotation[#, "Charting`Private`Tag$11459#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{{-1, 1}, {}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->NCache[{{
      Rational[-50, 3], 
      Rational[
      50, 3]}, {-0.03926702950446326, -3.4212871982079035`*^-9}}, \
{{-16.666666666666668`, 
    16.666666666666668`}, {-0.03926702950446326, -3.4212871982079035`*^-9}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.874317096187192*^9, {3.874317198795115*^9, 3.8743172183186007`*^9}, 
   3.874317291363812*^9, 3.874317324115828*^9, 3.874318134657127*^9, {
   3.8743241017859077`*^9, 3.874324127542303*^9}, 3.874324308619192*^9, 
   3.8743243770707827`*^9, 3.874384450564842*^9, 3.874384498620531*^9, 
   3.874384579015037*^9, 3.874390510579625*^9, 3.874391090792488*^9, 
   3.874476520471735*^9, 3.874491383100039*^9, 3.8744915650547256`*^9, 
   3.874491786671054*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"69ab0953-3f5e-426a-adb4-b034a47662c4"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plotting \[Delta]N fixing all variables but one", "Subsection",
 CellChangeTimes->{{3.873436628793715*^9, 
  3.8734366465238934`*^9}},ExpressionUUID->"6f492177-ef02-4409-8227-\
9a384110cb13"],

Cell["\<\
In this section I assign values to all the variables but one or two and I \
plot the function \[Delta]N as a function of these 2 variables\
\>", "Text",
 CellChangeTimes->{{3.873439880204649*^9, 
  3.8734399458190823`*^9}},ExpressionUUID->"f2826917-998c-4a2a-8d25-\
5ac5c38bfc8f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]Nlong", "=", 
   RowBox[{"\[Delta]N", " ", "/.", 
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", 
       RowBox[{"eig", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", 
       RowBox[{"eig", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", 
       RowBox[{"eigs", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "+"], "\[Rule]", 
       RowBox[{"eigs", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.873441837518633*^9, 3.873441897862712*^9}, {
   3.873441978641306*^9, 3.8734419858405952`*^9}, 3.873456236337948*^9},
 CellLabel->
  "In[135]:=",ExpressionUUID->"ad5d31ec-e2de-432b-946d-4dc32e838518"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Delta]Nlong", " ", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["k", "oc"], "->", 
     SubscriptBox["kv", "oc"]}], ",", " ", 
    RowBox[{
     SubscriptBox["k", "co"], " ", "->", " ", 
     SubscriptBox["kv", "co"]}], ",", " ", 
    RowBox[{
     SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
     SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
    RowBox[{
     SubscriptBox["\[Gamma]", "co"], " ", "->", 
     SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
    RowBox[{
     SubscriptBox["D", "o"], " ", "->", 
     SubscriptBox["Dv", "o"]}], ",", " ", 
    RowBox[{
     SubscriptBox["D", "c"], " ", "->", 
     SubscriptBox["Dv", "c"]}], ",", " ", 
    RowBox[{
     SubscriptBox["k", "off"], " ", "->", 
     SubscriptBox["kv", "off"]}], ",", " ", 
    RowBox[{
     SubscriptBox["k", "on"], "\[Rule]", " ", 
     SubscriptBox["kv", "on"]}], ",", 
    RowBox[{
     SubscriptBox["N", "tot"], "\[Rule]", " ", 
     SubscriptBox["Nv", "tot"]}], ",", 
    RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
    RowBox[{"di", "\[Rule]", " ", "div"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.873456246579873*^9, 3.8734562483219843`*^9}, {
  3.873456318586794*^9, 3.873456360681459*^9}},
 CellLabel->
  "In[136]:=",ExpressionUUID->"35f751fa-cb5c-442e-a61d-8fef1ac27128"],

Cell[BoxData["23.956689506831307`"], "Output",
 CellChangeTimes->{
  3.873456270130809*^9, 3.87345636168736*^9, 3.873699703494997*^9, 
   3.873786125605513*^9, 3.873799212404068*^9, 3.8737992535961857`*^9, 
   3.873799301368115*^9, 3.873799663007554*^9, 3.8738001211801233`*^9, 
   3.874231968169348*^9, 3.874315749064041*^9, 3.874318134962824*^9, {
   3.87432410208962*^9, 3.874324127836473*^9}, 3.874324308920282*^9, 
   3.874324377371736*^9, 3.874384450850593*^9, 3.8743844990336733`*^9, 
   3.874384579232314*^9, 3.874390517080083*^9, 3.874391097385478*^9, 
   3.874476527358673*^9, 3.874491387916155*^9, 3.874491569426189*^9},
 CellLabel->
  "Out[136]=",ExpressionUUID->"3e76bad6-7714-4bed-bbee-17aaa3bebad0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fDC", "[", "DC_", "]"}], "=", 
   RowBox[{
    RowBox[{"\[Delta]Nlong", "/", 
     SubscriptBox["N", "tot"]}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["k", "oc"], "->", 
       SubscriptBox["kv", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "co"], " ", "->", " ", 
       SubscriptBox["kv", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
       SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "co"], " ", "->", 
       SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "o"], " ", "->", 
       SubscriptBox["Dv", "o"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "c"], " ", "\[Rule]", 
       RowBox[{"y", "*", 
        SubscriptBox["Dv", "o"]}]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "off"], " ", "->", 
       SubscriptBox["kv", "off"]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
      RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
      RowBox[{
       SubscriptBox["c", "1"], "\[Rule]", " ", 
       SubscriptBox["cv", "1"]}], ",", 
      RowBox[{
       SubscriptBox["c", "2"], "\[Rule]", " ", 
       SubscriptBox["cv", "2"]}], ",", 
      RowBox[{"di", "\[Rule]", " ", "div"}], ",", 
      RowBox[{
       SubscriptBox["k", "on"], "\[Rule]", " ", 
       SubscriptBox["kv", "on"]}], ",", 
      RowBox[{
       SubscriptBox["N", "tot"], "\[Rule]", " ", 
       SubscriptBox["Nv", "tot"]}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{"LogLinearPlot", "[", 
  RowBox[{
   RowBox[{"fDC", "[", "y", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0.001", ",", "10"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0.1"}], "}"}], ",", " ", 
      RowBox[{"{", "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(D\), \(c\)]\)/\!\(\*SubscriptBox[\(D\), \(o\)]\
\)\>\"", ",", " ", "\"\<\[Delta]N/\!\(\*SubscriptBox[\(N\), \(tot\)]\)\>\""}],
      " ", "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", " ", "Medium"}], "]"}]}]}], "]"}], "\n", 
 RowBox[{
  RowBox[{"fD", "[", 
   RowBox[{"DO_", ",", "DC_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"\[Delta]Nlong", "/", 
    SubscriptBox["N", "tot"]}], " ", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", "DO"}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "\[Rule]", "DC"}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
     RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
     RowBox[{
      SubscriptBox["c", "1"], "\[Rule]", " ", 
      SubscriptBox["cv", "1"]}], ",", 
     RowBox[{
      SubscriptBox["c", "2"], "\[Rule]", " ", 
      SubscriptBox["cv", "2"]}], ",", 
     RowBox[{"di", "\[Rule]", " ", "div"}], ",", 
     RowBox[{
      SubscriptBox["k", "on"], "\[Rule]", " ", 
      SubscriptBox["kv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["N", "tot"], "\[Rule]", " ", 
      SubscriptBox["Nv", "tot"]}]}], "}"}]}]}], "\n", 
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"fD", "[", 
      RowBox[{"DO", ",", "DC"}], "]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"DO", ",", "0.01", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"DC", ",", "0.001", ",", "0.1"}], "}"}], ",", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Frame", "\[Rule]", " ", "False"}], ","}], "*)"}], 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(D\), \(o\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(D\), \(c\)]\)\>\""}], "  ", "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", " ", "Medium"}], "]"}]}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<SunsetColors\>\""}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"ScalingFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "\"\<Linear\>\""}], 
     "}"}]}]}], "]"}], "\n", 
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"fD", "[", 
      RowBox[{"DO", ",", "DC"}], "]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"DO", ",", "0.01", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"DC", ",", "0.001", ",", "0.1"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", " ", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(D\), \(o\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(D\), \(c\)]\)\>\""}], "  ", "}"}]}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<SunsetColors\>\""}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.873786465657452*^9, 3.873786466025345*^9}, 
   3.874465062020158*^9},
 CellLabel->
  "In[137]:=",ExpressionUUID->"3873999b-9d08-4f9f-8d19-f674cbe40f15"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Xk8VdsXAHCuRkqmO3vk5UV6IUlE9uURJWSqRDIkopIhISGZMkQZK0NI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       "]]},
     Annotation[#, "Charting`Private`Tag$10389#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*SubscriptBox[\\(D\\), \
\\(c\\)]\\)/\\!\\(\\*SubscriptBox[\\(D\\), \\(o\\)]\\)\"", TraditionalForm], 
    FormBox[
    "\"\[Delta]N/\\!\\(\\*SubscriptBox[\\(N\\), \\(tot\\)]\\)\"", 
     TraditionalForm]},
  AxesOrigin->{-6.907755278982137, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Part[#, 2]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Part[#, 2]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{{0, -2.3025850929940455`}, {}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->Directive[Bold, Medium],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotRange->NCache[{{-6.907755278982137, 
      Log[10]}, {0., 0.9999453312212851}}, {{-6.907755278982137, 
    2.302585092994046}, {0., 0.9999453312212851}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
     Automatic}, {{{-6.907755278982137, 
       FormBox["0.001`", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.010\"", 0.01, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.100\"", 0.1, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-8.517193191416238, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-8.111728083308073, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.824046010856292, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.600902459542082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.418580902748128, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.264430222920869, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.1308988302963465`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-7.013115794639964, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-6.214608098422191, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.809142990314028, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.521460917862246, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.298317366548036, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-5.115995809754082, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.961845129926823, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.8283137373023015`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-4.710530701645918, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.995732273553991, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.4011973816621555`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.6888794541139363`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.0943445622221, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.248495242049359, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.382026634673881, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.499809670330265, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      4.605170185988092, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}}, 
     Automatic}]]], "Output",
 CellChangeTimes->{3.874476587726417*^9, 3.874491443503207*^9, 
  3.874491623723653*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"dd2963bc-1944-4ebb-b5e3-15f4b81596bf"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{
          FractionBox["1", "75"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FractionBox[
              RowBox[{
               TemplateBox[{"19"},
                "OutputSizeLimit`Skeleton"], "+", 
               FractionBox[
                RowBox[{"236.36842105263153`", " ", 
                 SqrtBox[
                  FractionBox[
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                   RowBox[{"DC", " ", "DO"}]]], " ", 
                 TemplateBox[{"3"},
                  "OutputSizeLimit`Skeleton"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "+", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", 
                    RowBox[{"Sinh", "[", 
                    FractionBox[
                    SqrtBox[
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    RowBox[{"DC", " ", "DO"}]]], 
                    SqrtBox["2"]], "]"}]}], "+", 
                   RowBox[{"Sinh", "[", 
                    RowBox[{"25", " ", 
                    SqrtBox["2"], " ", 
                    SqrtBox[
                    FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    RowBox[{"DC", " ", "DO"}]]]}], "]"}]}], ")"}]}], 
                RowBox[{
                 SqrtBox[
                  FractionBox[
                   RowBox[{
                    RowBox[{"0.12000000000000001`", " ", "DC"}], "+", 
                    RowBox[{"0.01`", " ", "DO"}], "+", 
                    SqrtBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]]}], 
                   RowBox[{"DC", " ", "DO"}]]], " ", 
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "+", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], "-", 
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}]]}], 
              RowBox[{
               RowBox[{"-", "4.151578947368421`"}], "+", 
               TemplateBox[{"20"},
                "OutputSizeLimit`Skeleton"]}]]}], "-", 
            FractionBox[
             RowBox[{
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"], "-", 
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"]}], 
             RowBox[{
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"], "-", 
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"]}]], "+", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "3.151578947368421`"}], "+", 
                TemplateBox[{"20"},
                 "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    RowBox[{"DO", " ", 
                    SqrtBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]], " ", 
                    RowBox[{"(", 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], ")"}]}]], "+", 
                   TemplateBox[{"17"},
                    "OutputSizeLimit`Skeleton"], "+", 
                   FractionBox[
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], 
                    TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"]]}], ")"}], " ", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"]}], "-", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]}], ")"}]}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "4.151578947368421`"}], "+", 
                TemplateBox[{"20"},
                 "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "4.151578947368421`"}], "+", 
                   TemplateBox[{"20"},
                    "OutputSizeLimit`Skeleton"]}], ")"}]}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}], " ", 
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}]}]}], ")"}]}]]}], ")"}]}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{74.5546875, {4., 11.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{64.46484375, {0., 11.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 139, 24408456342082606278, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{74.68359375, {0., 11.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 139, 24408456342082606278, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{55.34765625, {0., 11.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 139, 24408456342082606278, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{95.87109375, {1., 11.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[24408456342082606278 === $SessionID, 
   Out[139], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.874476587726417*^9, 3.874491443503207*^9, 
  3.874491628891973*^9},
 CellLabel->
  "Out[139]=",ExpressionUUID->"6b0d69f9-6332-4f90-bbae-c5180fb378ac"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJxd1z1oE2EcwOFwQYpnRUxMG2pF/BgcC4JToOJQoiCI0E1FBYsoqIM4uYrg
IoiLmy6KFCuKXVRIsHT1YwiIgW4dhIKgOLQdYnu95y93hRIe3rwfP2jv48Dl
m2evJJVKZXXjd/OzMT3/4c31Wvfp4OGTB8/2dk9dOrLcH9sdHvw4tm/48a7w
tT/jty7+Hg73dlQX3p1Jw8cP/2xsfz0Unm19uXp+57bwSLZfEk76m+sPOvw9
W28tPJfN/xseyr7/K/w2G18Ov8/cC1fyH9a7de6x6GW9rJf1sl7Wy3pZL+tl
vayX9bJe1st60+adlaVBM3pZL+tlvayX9bJe1st6WS/rZb2sl/Wy3snsnKPR
y3pZL+tlvayX9bJe1st6WS/rZb2sl/Xenjg3efTCSPSyXtbLelkv62W9rJf1
sl7Wy3pZL+tlvS+z7zWil/WyXtbLelkv62W9rJf1sl7Wy3pZL+tdap94dP9j
PXpZL+tlvayX9bJe1st6WS/rZb2sl/Wy3nr+qZf1st564bqehvWyXtbLelkv
62W9rJf1sl7W28479bJe1tsu3LfSsF7Wy3pZL+tlvayX9bJe1st61/MuvayX
9a4X7stpWC/rZb2sl/WyXtbLelkv62W9M3mHXtbLemcKzx1pWC/rZb2sl/Wy
XtbLelkv62W93/Jz62W9rJf1sl7Wy3pZL+tlvayX9bJe1st6W/k59bJe1tsq
PDemYb2sl/WyXtbLelkv62W9rJf1vsjPpZf1sl7Wy3pZL+tlvayX9bJe1st6
WS83CtfpJHp5UPg/T6KXe4W/kyR6ebawTxK9rJf1sl7Wy3pZL+vlif6Nr1ML
G9fxeyfn9q/+f3/grfmLHTafzd+6n1dLzy/VmF92ef/i+9xivM8ZL5/fegeb
tam7o7Xuq08rh6ZPmz/fYeNrn9efj++pxjg7b3m+/c0v72++8fL7p/WsX97f
ev8AyqXl5Q==
      "], {{{
         EdgeForm[], 
         GrayLevel[0.8], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
            
            "]]}]}, {}, {}, {}, {}, {}, {}}}, VertexColors -> CompressedData["

1:eJxdmHk0lO//xotUsqTCRymkSEokpSxdkpR9KS3WomihrKUU2kSEJGT9lJKs
2bdobGNn7GPGMsa+DiVLPuXnn+845/ec85znnNc/9/s5133d7+t+77S8Y3iN
ZdWqVQvLL+uq/z1T8HfL6DE1GsLvBp+k05Y1+B+3iSaIB9oM49GN12tFgxqZ
/MFMqr+94wjef9nwIvxiK5PvOX60LOrhKPbu1uJ7ub2DyVcnhw76Px/DZM7R
Vas7O5n8xN153rAb4ygyWbtR1oPG5DE1ahOxf8ZB22ITP/uXzuQmtU+kbvtM
IOeAfQCXyQCTm3PRBEM2TKJF9O8RGZ8hJq9K1FW64DEJwxueKgWPR5i8TDZp
Jm5wEmMNzm8OqIwxOQtPyMHDKgzY3csQkykdZ/IdA8efnvdjQPct7ZoU5yST
6/O3GdBqGLhEaPAlCDGY/P9/JVxnBizCGVjM3LlD6lovMh8op4Rsz0L+BomR
kW8MmDomsdgO0+GoPndJTiEPypqJpN4uBviVy/24jfvxayEga2hPIYhFs6YL
fxlw5FXq2VI3gDTtGqmvfgTmOiSNn7WreIcgONe4s9+7ismVAl9Zx5kOg/ZL
LT3y5oqO7sfdjQtjRxCRtvbLLo42Jg912Sy3SB+F54vrLccDKEzOTp1OLd0y
jgiPj41/uruZPIIu5p9fMw6eq5LO6ntW9HqpzZMdcHUCaxcshPIL+pl8p1VT
TfD4BJxjasW81q3oNbO7Ys8Py0lMvGuMWLtuRS+bh9SfZRWT6PDKe5GXP8rk
TcPUnGlBBmZ5JB4+EB+HY2+gc+eeCewkRV3c+5SM9d4c516FEGDbUOCe+nQS
DjnpoChR4UguqkxPycTgkQdu560YmLj+s0BhvgsDIQXtVwSTcfG4bmWSFwMz
UvvTdb1pKHkjaRVXmo7a60N5iokMnBVrNDwoSkfNAIWzSygHa9reue1tZOCA
0A5Zh5o+tJ22PtkbWwAB9VdvReaX67v7eqO+5wBmzs0Pn9i9opfl488piuxD
uBlQXkNXWNFLzqMnnfx4GPwy6nT96RW9JDaX1ftPjKAnVG3/Pf52Ji/3/vNX
QG0MiWX/pUxPUplcu2Hi0W/LcSQ8DjGPsFzx11SWjAUv+wTeZCx9vibTx+Sz
lpSrEuET2FxbTDgfu+IvY9FXWnN8kzh/WkjdLH8I7vN9x4L1R8B46NnfVE9C
8Uaf8CzhRlADhjTnkkexYTxQNs63GUZe6tzrF2oQL73N5sHEGGZv70v142zD
v2+UxVcpETG0xtGj58AE1Db5zR97TQZtf46c/l0Ctp+4n96/7NuQih8/jx+m
4qDMP7mvGzMx479ZxMGaAZQZu7cqdyNMcJ6tlJyM6BnPoycDGCA9LxEPHabB
celEWVRVBiS5WOs78xgwULllc4RIh+Z6p0yRrlxI2OcfejjAwPtaFW6d1H4c
vZCt2raxiPm/F3zjhB65D8JyH2FiUaecyT9c29aSs20YH53uXyW7kZjc3tO4
Q/3DCOJd423b2VZ89IXVTEOYcwzHX7F3K+5e0eUIQ2rbjTPjGONcHxXa08Pk
jrtrDN9PjeOH3+bywuV6z1hy1jQ10cFpvcGEPaoKMsmBHTOhZNjd3uRbGD+A
je0Da3KXanG3ak7g9OVW3GsNtHQ6OAyfkh2+21lJiPTN3ijn2YRHmjUOUaMj
GNUx6qplbQJL8PneQ24NEJoKuC8tPgZOSV21moct6CY8c9IiVeG0Vx/3Nrdx
hOW59/wr0Y4oWrs15Wspzkp/1bRc9u3l6eqbplwUzFxYuP/fjnwYlv/ZlGe8
7KPFA45c8l24GSwQVcWVCD7xc2Z/XjCwK/yKFWcoDUHVc83FY+no95wrpGUz
cF/Lgv79Ix3VQQZzvE9yIVR7qEh9kAEZ+edD+3L7Ifygr3x+z4oud/taFX99
GMRt+dY64fNEJh+m0KUfGw6DC8Lbe06t+MWn6NqsXt8IZtsflJpOr+jy3cSe
MKM9hriJ95JrN3YiUkb533QPKuzKODX2+5ci+GC4Zvelbgx9ehgacIUGkyil
ca90IhzmXDtszagwNhJu8Eym42PWUu4D+yrMj9/x1Ckhw/NbXd7BmX6o5+/2
3StRC36VJfddUm0osC1ft898CCKhcSfm2Rsg4cyXMnWnGSblPK6Vb0fAHhto
HXupEbuJWhejPUk4K+Qe0Tk+CtV3a8wb2FsQ/3m1L6W9GqI2HDynrccx4R0f
TP3bhr3WtvQwnjIEio9uSV41iUjnz494jlBAf8XFdtUqD3IfVonevsJAeMUT
Kee6Lgwfu/h+KS4Jtk/+se0LYiB6Z/Ss8qZePIgbDzh6NBNJZTN2J8sZ4Az8
5siu3ofAw5pXRo7mQ7CQ+59dcww4rz/LOOwyAKMUm0d7+FbOsW5iYP9dwyE4
x82819BZyQ+DqyU1nFhGkJjw6whHaTP0g5bkNsu2oPlOjq6JXSE61XjItvZU
sHc8Mb0XsryvoxM1dRqL0XI9VtpoFQ2351+a8XztxAneelLXyTKYj3ukyyR3
4aNG+einSzR4knc58H4hYiPnnnM21lTUl3l0hN6ng/fHcIenbBUCJz12yv1Z
7gOVtw8XkvqxW5l9ruVPDfRI85fNjdoguEU5Zs+dIYzzBGxVEWpA7DGyY4Jp
M4hNa+QsCSMYXtg9xJ/aiHIOzxepQiRQjrEUMJbzQi7v7/+c0lvQY5nHqmO0
7Eu7zqapwXHMC7V5TK0iI5113zh7cTEYMRa1WsmT2HQr29ogkIqsjijGJpkM
iNuxL+i6MsBjd/vjvfoe5DbZlltzpUHT6GOJYDIDu3dutJCXp+N097A7z8Uc
PNTNEQ3pZaBlg/9kyNN+5H1mUxoOK1zxxXUhzxsRg9D+KR/qKkyE1tvK62s7
62A9px3HX5yF1JLt9tQzLXiuXCnnQWmCRAFds8C1AI8uJE1HR3VA5l7jHweh
Nsy6cJ2z3kGA/ZkxbWuubnDcrfettevAs5vn4sgGJSALlrR4ePVA/a9ojJlI
FxbuFPUOeZUhk8tQ5oFdF+6bGpouhi/rZtcsxTdHBE9+0I1T26lo5o9Jlh+h
o/Yo+0R5ThVavpUP+LqTsSRXxc3qPYBCnictH8m1sDdVnr7xvBX5MT8z2DyH
wTvwaJxVloQTisK9nHuacO3JjS+mtqOItZI8y72+GTr7yvBFvA70B9kyVjvG
sS2j71ScbRteJvfO5FmUI4815tbf6QmEh58XjBKg4K8gIq1H8zC+65rh+DUG
9FlpAYdku9FivTF1e14yFlhq1AiRDEgOcXI0efRC/MnIWr5rWegM7tx/vpkB
FZ1/c5v6+pCilr5PfrAA79p8Lq1vLkf8tRnF0dpUFJ901JiKq8NAp6z5z5la
9O7euvhNIAvhZqcMexOb8TZHMlfoSiMeUcvlKIZ5yDKYr+uLbEdDg3Pmq50t
UAw1G9MwKkRd09OMxUtUjEavO0Jf3Y4QgaL2raUErOe4Trmh2oOr843ydY4U
iLBpGH6eKMFen8zTtj+6QbI0o4Xe7Ya36ZLtobPlCJ4iJBkkdiLej+3EkHcv
9nPo/dy1pRJBXfvJutwUdBpa7WM50I+2JY0EX8Ua9Iu8rWTlbsetiTfRpbJD
SPyRIiPeVo8wpa+eMu+bkd0UcaGWOoJNNi5WvION2PBVwffs9wZ4cMx0yYSN
QX+fyc37V1rB/lWoR6SsAlOTWc+dHkyA9CUgplmiAy7UQ1fjDhfB46qiadJy
vyjp2ecwdbgLtVMHpEo2JKKFRhlTfMOAu4u/rBBfL8LqDiiUqWbCzjqVZbvu
d3xv/sCTUx+HhBvCZWpq5VCxm4vMkCBirjRUqWf3V6Tx//1sJFiPv7ohHW/P
14DPN6ygYzQD1RlXtlkFNWE+TNTxFt9y3878ZPPiTg7+niztl6e04tguz9nN
b5tQqt4q+2bLsq73XfS10YGSUHPXhHPL+zGwnFHJ+x3KaXaOWOzE64ceMvnP
yXDif6ugV1GMK59nCbxsNHTIf7x68GUnSoJbjVSlytClVs+SXNKFM6lzfOrv
aAgw0tvO8YuIXbYhbw4LUUEm87gFaPZBTfoc29991eBROLdRgIeMfN+yO1WX
B3FSbY2RM7UOgZ3rfzgEtOBsAlvQ8+cjKBsR3st2rBHBM8Maq+JIOJq8bUpM
dzlfpXCcnKltge2HWW9/gSqohjudZj8+ATGqydmPqWS82jHbGCZDQKBCf+0V
TQbo0lZeN2o6Ia4trSj9TyLE+FwOn/meBZJrN130awwWW8o+b/MrRKJP+e+p
dgI873xtnXsZD+4Tj4yf0Il4HR0ks9OzHEeum1TsOJeKhTClJe0jdZCvfab0
oawK9451lawmpiOxy+X72ceNiNsxJH5BtB5CHfn7DGayoLDEuhjj2oKp2xWb
7Z0b8Y5nu8iqO3kIKSgaEc1ph6NNVrOrZAs+zGgkn7EsxAuxe9lbl8/5Bm+v
pFSddtTHOlec/U2AD0/cI5svPbgS0GkRa0BFcUHyzWTHUmiK5g0uOXVDjk9i
gW8DDS1KqT38mkS07+TVSiFQ4V30dJ1+HR3EQLe1LiFVOFQjHnE4moxnPNkx
vxYGcNni0nzq5ToEhOjQhNa0oi/SZlTXcgQhvkVjlj9IuG5jWfZzlgQOYzt9
9aNjKPlTIsr7vgXc9Tu3ijyqwkyyyrnVRyZQ2htp7B1DRr2wjddzIwIUCjBN
CkxCfMH4UGVDMG4Le/2g2GRAhW9du5d+Hvo2LX666fABwSo6oU6yxdhScHHI
uZeAyOoG5daweNz6tXrhDoMIH831hYGpZdisE7JXfncKvAT2K0xuq0VC1btn
G70rcc3xbL5ZTxr0nO74qyWQcFvIauREVi0sFm1fG41mwm3JxjHSsxmjnt1z
lBwS0rbvE5E3zcWeXiH50ew2XM+Tkox2bkacb9VdnUvfUMrqAbY7FIj/x81L
jF/OU8Tjs1JPCPDdLJR0oaobBgcfs9VlU1Bd/Xwd+EvB6592kFzTDZ5pt/Hs
mB6w1I1Vvl5DhIhWjT6BZTl3fX9tFp9Ax+ciwbV8dlXQ9trK6V1ORmlFhEnG
jwF8OGVsynaxDm6/c61NOFuhESFA7LIdgVU19XHgukZ8s3mumtJNguTr2Xta
BmOQf/KGS625BZpijDH+DVXY2v+P7Lf6f5Gu5VD06pE3VAo9VVe1xSHGUOzU
jqR02IUkJ4kdjoCwhuz+cPM8DIH0cY9NPi4fHAi8oRSLZt14YgGjGNfCuEJz
/yWgMdT8zWOFeDiasX12CyXiUxSPiiJnGc7cUzM5eiQZ5ysPuLAq10A8d6/7
rYIK2FsOy6prpmFoyPsphEmY1rH0D6fXwNf93atO/Uy89i5JeTzdhBH7YwK/
L5DAuWgW9ISUgzxpw4ZPcm24S/N5KS/RvHwPNb/1e6QA2cqTT+XXURDXfvlU
nWsbLA5F5ClYECDvUCEg6d0N5wCioEMCBe5Z2nrd3KU41Z4jS23qxu86p1c2
5T1w+fjh3SZBIlqPGWmZT1ChfsrA1p+ynGMPTHeqxVXBmlgVdSCAjMRgvfdN
qoNIOLjEmZJThwkd1XqHtBb8Ve1NMHg/go4K+V0V9o24Z1Nyfqs1Cbk5zS5i
9Few/qf3nF+5C9K0vv9h1QlGZpLmfVp+AsK08/2u338DrwZ7aoREOibCNUgm
jzMxV/ZwZx8tCrMaTyPFOwugnv3z5N7CfBx+fCB8s1ssqi67ieyVLAH9tuo7
RQcCujWGn+r9+ozmUQOd2eX8f+FYYZtDXilqgx4itDAJMwLCId611bBg3Z7m
a1OBUVJYk+RyruKjRY/61DaAg+0L98KnGhRxlmt93Z0J6Z9Nlw0qm6AV0Gco
qUfCfPVSQmJpDlKaE38lSbRh0V03ukm5GSOWInUu7N9wSLXZLmg3BULmr7rN
stpwSEAv0diXAGkRrSInSjdGM2y4I0Sp4LVK63p3vhTHDMikFP9uKMSFGdor
0xCeIO5m/YIIme+9D254UVHBedL63YU+ZDscPRygWA2xvtxI7dVkuHLXJvv3
D8Jq6/wI0bUehb9NCiYWmjH+gny5t99BSf8/Aaf2zcZKzz7qJQ7ruSoVEM9E
9sh8AHHAwTLo8Uvk67m9lsiJh7AHgyvaIxUFJg01lT9CMC75PG1wOc8IpLw6
wP8gC0TpL9F6WjH4wntB+J8DhRiU4G8O5y6AdIvsx+vZsTA1zJh/eKUE82c9
M/zcCPjH/1PfhTXxaB+e/Pr7KhExe+9PviCWIi05IT2elIT3xS9U9burkdtS
5CARUIHYgIKRtZJp0HfUnZRaTUKHWJr768UabNM+mMFplYlSbFe/x9KM71TK
q8Z3JDBobQ2OMrkweLO2dZt/GwZr16RPf21GLkeeuVzaN8Q7OY8vEiiQdm+3
c7/UDhWSEdskSzH6F97ecszrQSDXjXvmWzthZo37wyOlEI3YYJLK0o30v+TT
vZ00FF15c73kVAUGM/4EeDQu+0Rc+cQxoX4Yfrq8N0OiBjueDQ+OC7dDMSpW
7cwUAzP8JHkTiQH4mZCF5C59h6K1G+c/NAYCje8vF9qPfPPPkqq3VnJ4mF9A
k48jA+YBLpTUyAkmPzi2yHFz+b4lUt336I74JGj2FRdmQyOwcZ4u5bbtGV5c
JtbUFn1AuKaQz1k8BM1dTulm8FUEHqFzecg8RUD+EwN6Wh/O5IhtMP5cDYXj
ekuU8HZUFt905rlDh6GdSuWkWBUIfnxe4uwrc1dtzo3ZmrQheCq2TT/Tb2Dy
gKArKmeGGODl8leUfsvAmXe3GlyW3uCAvJhd5K5HkP5oYfZlXwQaj+gIdDgN
ILtDvf81oRbaZ8L5tCJX5r2J0aqPWU4P4jL/8SaJb6VMfsbGkPD+GwNSaeJz
PZ2T+JVhFjR/3A/5eT6ze4KdEb3eXPWEzBvE6cx+Jg304Rid08h4oBoie5ZO
TlqszLUKu/mmtv83gE2PdvxKiypm8ucWG8znfjJwovP0+aUaBhK3XjxxQ/A5
fnyVrzApvo2vrGE7XJL9wGpg/zu3vB+79lhRkqdqoOFz6Vb3lZU5gOZQrKFr
xBD+ulovcJnXrcyZ+1IOXapmIDJ7q7m4AAPUXWJubQ9uoSLwpdRJtnNI6iov
ZU10xDX1FxNLqn3gaFbYNSdajS02xaeTBMj4P11/LqE=
       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}], 
       Charting`ScaledTicks[{Log, Exp}]}, 
     AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}}, GridLines -> {None, None}, 
     AxesLabel -> {
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(o\\)]\\)\"", TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(c\\)]\\)\"", TraditionalForm]}, 
     FrameLabel -> {{None, None}, {None, None}}, DisplayFunction -> Identity, 
     AspectRatio -> 1, Axes -> True, AxesLabel -> {
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(o\\)]\\)\"", TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(c\\)]\\)\"", TraditionalForm]}, 
     DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{None, None}, {None, None}}, FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> Directive[Bold, Medium], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultPlotStyle" -> Automatic, "GridLinesInFront" -> True}, 
     PlotRange -> {{-4.605170185988091, 
        0}, {-6.907755278982137, -2.3025850929940455`}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}], 
       Charting`ScaledTicks[{Log, Exp}]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx11wdQE+u7BnBQPBQVK1IVQeRIUREbRXlEkCMqgihgF4+iiChgRRRQUERB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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -112.49999999999999`}, {7.5, 112.5}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -72.88550057537398}, 
                    Offset[{4., 0}, {7.5, -72.88550057537398}]}, {{
                    7.5, -21.101841196777894`}, 
                    Offset[{4., 0}, {7.5, -21.101841196777894`}]}, {{7.5, 
                    30.68181818181819}, 
                    Offset[{4., 0}, {7.5, 30.68181818181819}]}, {{7.5, 
                    82.46547756041427}, 
                    Offset[{4., 0}, {7.5, 82.46547756041427}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -111.72324510932104`}, 
                    Offset[{2.5, 0.}, {7.5, -111.72324510932104`}]}, {{
                    7.5, -98.77733026467203}, 
                    Offset[{2.5, 0.}, {7.5, -98.77733026467203}]}, {{
                    7.5, -85.831415420023}, 
                    Offset[{2.5, 0.}, {7.5, -85.831415420023}]}, {{
                    7.5, -59.93958573072496}, 
                    Offset[{2.5, 0.}, {7.5, -59.93958573072496}]}, {{
                    7.5, -46.99367088607594}, 
                    Offset[{2.5, 0.}, {7.5, -46.99367088607594}]}, {{
                    7.5, -34.047756041426915`}, 
                    Offset[{2.5, 0.}, {7.5, -34.047756041426915`}]}, {{
                    7.5, -8.155926352128875}, 
                    Offset[{2.5, 0.}, {7.5, -8.155926352128875}]}, {{7.5, 
                    4.7899884925201475`}, 
                    Offset[{2.5, 0.}, {7.5, 4.7899884925201475`}]}, {{7.5, 
                    17.735903337169187`}, 
                    Offset[{2.5, 0.}, {7.5, 17.735903337169187`}]}, {{7.5, 
                    43.62773302646721}, 
                    Offset[{2.5, 0.}, {7.5, 43.62773302646721}]}, {{7.5, 
                    56.573647871116236`}, 
                    Offset[{2.5, 0.}, {7.5, 56.573647871116236`}]}, {{7.5, 
                    69.51956271576526}, 
                    Offset[{2.5, 0.}, {7.5, 69.51956271576526}]}, {{7.5, 
                    95.4113924050633}, 
                    Offset[{2.5, 0.}, {7.5, 95.4113924050633}]}, {{7.5, 
                    108.35730724971232`}, 
                    Offset[{2.5, 0.}, {7.5, 108.35730724971232`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.2\"", 0.2, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -72.88550057537398}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.4\"", 0.4, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -21.101841196777894`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.6\"", 0.6, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 30.68181818181819}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.8\"", 0.8, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 82.46547756041427}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, Medium]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, Medium]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, Medium]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, Medium]]}}, StripOnInput -> 
                    False]}, {}}, {{
                    Directive[
                    Opacity[1], 
                    Directive[Bold, Medium]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, Medium]]}}, StripOnInput -> False], {
                   "GraphicsLabel"}, StripOnInput -> False]}, {
                 "GraphicsTicks"}, StripOnInput -> False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {
          Directive[Bold, Medium], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"SunsetColors\"", ",", "#1"}], "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.04739257897133046`", ",", "0.9157926291117355`"}],
                  "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "Medium"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "225"}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.874476587726417*^9, 3.874491443503207*^9, 
  3.874491689102401*^9},
 CellLabel->
  "Out[140]=",ExpressionUUID->"ff3b7176-cf9d-475a-afe1-95fc7b14dfea"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJxl2AtUjnccwPFXrivNbDYWurgddErmlnH8zdyyTFZHl63o4rJkTW8l1625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      "], {{{
         EdgeForm[], 
         GrayLevel[0.8], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJxNmHe80FUVwH+XEBEnU1GmykbmYykiiMKTpQIyFeQxVBBcoIiAOAAFB4KZ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            "]], 
           
           PolygonBox[{{368, 351, 352, 401}, {386, 10, 9, 374}, {369, 4, 218, 
            394}, {391, 15, 14, 379}, {400, 291, 1, 367}, {381, 5, 4, 369}, {
            382, 6, 5, 370}, {385, 9, 8, 373}, {384, 8, 7, 372}, {402, 352, 
            216, 397}, {392, 16, 15, 395}, {388, 12, 11, 376}, {393, 218, 351,
             368}, {387, 11, 10, 375}, {397, 216, 291, 399}, {389, 13, 12, 
            377}, {390, 14, 13, 378}, {383, 7, 6, 
            371}}]}]}, {}, {}, {}, {}, {}, {}}}, 
      VertexColors -> CompressedData["
1:eJzteWk01V/YtjFDGStEVJQkMylUVyFKoohEKKRMRaO5NJqHaCT1V2aZ53me
D8cxHPM8HsMpiUj1ni9P74f3+/vp2V/uta619m/da+97X8P67bK6aXCVgY6O
Lpyejo6R7n/WV1Rf7k54lbwA/Qu/P387RgFnfUrIj3PdMJxX/nUtoQI5s6OC
1ZuH0e5mZ65SNQu/7c4CTXmdiHIIWDvxpxaXtUsPNJpQUV2ROp69cQBt7L1S
va+TsEPuzQ3pj1S4845/OBw3guGFT5PvCDm47XE0pZJMBf+KM5fj1nFsJHMy
SzoV43/6YduQGbKDfRJ1yv3H9zNW/sN35lUxbfGYgmYWx+Fbt5v/4VLXggNq
8qYhuXXr0tts0j88vFaQMtk0A1fhDXdeRnX9wwOvLN2JK6MgWGeGQ5er9x9+
2ipzz9qbWRgkNX0zFB34h9/S8v9F0JvD80DJG04bh//hZ11uHzyQN4ffrnGx
b1pG/uHB5iLf9fnmkfpuvTzCbuwfbubgSLnmNA/nY7uTFkfG4X2TW96jvBEO
cYNtXl5ZiLXa+NheigSGI/Rm5Z/HsXlF1f1sQxMeHNlYo/2c1v/ujZb8myhw
2/CA7bsWCc+GShNPjbTAxG9P6Mkjc7ANMlz+mNIFEWf2ms2EavzS0nhVwLyA
8hXxbfLHejF/iYOwrFSArK3zuy9domLWWe9NpdkAuhuGDBJdkkGga90S/JAK
Jo2f4hkaw3jF4bt3mTUTNZIaNx7S7vGgcoDcUOIIvr/7WutNzgEK5AU4S6jo
6mXOpKeMQu45k9iTowUgskUEtndREVXnzfGdfRxWyR8Ck88WY1VG1OTEAhVv
gs3+EHgm0F0uZt4tVPbvfEw16ufK1yegf1c43Sim4h/+Se74XsbiSeiIVhW8
2lj3D/e8N9v13XEKy2Hmg6Ic/3ceqmVuHTfkmQbTJKtzx0Uitp6TDjBaqcC1
vHTeIukkkFoNjv+6Xo9+UYYl3gPDiMofHLTzqsWAm9ThqZA+LI2+5VtKmQCH
o3tOGRMBha58Zx6YdWL0xT6F949n0H7hXID8gTYsqX77Y5VERH9C6MHDQrOI
eZ2k02HbAd6vzzd/ZmjE5ePDS/vd5+BS/OJElTgZ499/79yVU4X959c0z6TN
g8NgPbjrRQ/qTxwRSdIvxruf66aDVQtQT+5weVPShxlLo5s+lzPxoy7+qIwV
FXqcrMwnBwcQG95/pb4jBau8SsJd7lS8b11yDmccRvJJI9Jj0wyIjD998TCM
ivjfk3ey6EcQc59jgMqRjTxCYszdOCq+6WV4JM+N4En5gsSRoFxE8De4LBRQ
ka59RXq9dhS2nftaVIfykVXjoLmtmYpI2UcnU16MQdJaW8GRrQhc/LEK2weo
EKLaT9meG4eSq4ONGXcJXm4OeTkhXIieNAtldpZPkOZ96L5SUgH1xWX/KY0+
rAzNvHe3r8KUUW1Io8cgKhjWfpU8GcVpNmEXIhrgLVwaHfS1G1FzDGYGOpO4
ZR7EFlNOwBV+kwBqQgfeUJqODBrOICFlZcChk4jlC4/m9gi0ofRlrubyKwpq
M/DCx7wdfOxnlJqtmrHpjX/WptxZTAhLrpi/70RvI2NEt2odsoWYY1fy59BF
fs9W8JmMrRhxtouoRM/1TbGMsfM4f+Ret6J3Dw7+fPxYI7UYu9KuT/7xWkAw
faSPs3wfXn/Y1sM0lo2dzr/3VGtRMTGn3CBR3Q/+ysvtqReTYbpGF3rHjoov
vokT13wGQe1RdIwKTUXcd+ZYHU8q5DwFZcZpfDpo4Ts49SwDHgWBgstBVPDE
yuvT9Q7jtJEPy9x/ND74zB76OpqKuV66bfciRuD79Xzvkfc5sDammocWZiGq
QbL8UFkUKuKPj3K0FEJ7C9OQNZmM2pJPc3EWFVicZSVCYRjX5WQfyV0dxqP0
PT/7cmsRrcXbqXexD+JfL3YPD47Bp6ZGknegEYKj+9UI18jICdl11bh5EvRB
evr9Zi34m+7KYre1AxT+EynHT83AniO8TrSciI3fGL77y7Uh78mAdIAxBZWD
V0N1+km4MhbYtOpPgO3+9J+ZOrMwNaPfw1bbAZkCS2l7iQaUKerl2UrOwTy4
ZrT8WRcCq2wejIvVgP7+Rhn61Tn4eMmaS+3pRpJP4OV1pwrcKHnNt6FgHg7b
DrUax/Xg3Y8P2prLRRDPeeB63XEBw7Kblfdx9sHgwFBV6ZMctFqdfJizhYqP
Kk0ot+yHTnzYhpOLqQibXuv/e5kKdntev6aqAZiyy27JD0wBQ8atlr0uVLQ7
JujwygxhWNtig6JiOjgHKAH/mafizJrc3cc7XuHmmXzFqY/ZsNEMHTn9oRN8
/L1vn/uUId8wxS728gDoucUE+bMHkMDjcIp/qBr3vr76lrRtABuIXq7x20Yx
3f58+EdZPc6bD4tx2/cg/9vQZ56ecfx9kjhdy9KM9V/kSsrpLmin9O0LV5/C
Uj4pcsNMCxz1U/oR0o5AlovPOM7NQFCvVLG2lYgZReGKaJE2cAZPRlIOUXBn
njLW/5GE5i3vI+U3t4ChvvGBMOcsUqcCRR/rdsBYOD54+WgjNg2ofE9rn0W1
zXbGtu5O/BZWuB2RWQvhFy2K0wFzuMnw28FYh4xL4cO6r6yroL7bT9vv0Dxe
LO3kivrcDd9Hno6jp8pxp6GVda13HsbqRcUulB48U9xC4igtxOHFp/IWdxbQ
8Z33w06RPlTejl4OVMvBhpPDovHMVDw7ZDMWeLwfFpeef3nFmI5dAh8ERH3i
YfddWLx1Rxh856Mrz1DT8PnCOxu5hXb8Hoz66sJegi/YJaywpQ9/GIvts4z7
8FlBdFvW3SrouPZE7nQZhPUt/rqh4mHMPX/LG7ijDnkZSo+JP3rBHO1XKn9h
DCZZvbc3qzVCwkNQtZK+G6c/TZh0/zeBURWG554rzdCyL2YSvN6JgKvvP37K
mIKdWNqTj06tOBTMcEaVpx02XCtZI1YzWJT2MfP7ToTghv8MYn4QwZinlyQs
S4G1qvsJpSCaLr85z3n8WAvehcS7D8xRcG8uTriNrQMTPSu+XeRGRNgIZahE
z6JrV6FohFMncvrrZKwS6nCPFO7ZpjmHoz5vRUuLunBx055tN5OqcUxDeWVh
ZA4sgmXHJ5bJYJX1D+HqroCIyhHL6HvzECK1h4jt6kGu2/2n4yaliJdsjC5h
XADviWQZ5cO9yGblbjygXYC52GxhXaEYbKEe4BC18gdBf8MP8tsEPNhVEjf0
ioTUL7WuCnxFcLv053Dp8R6wm6qflbjbA5s0V+kjxpXgi67dZvhoCFu3zeK3
7hCIajc/yrbX4IrSBrk0eRr/OX0nKIiOguOns/m+xnrcUmJRs7jcg1CNz1GC
huNgyJd+23mtCaLeyo5zY13orcjd26E7iW8hDjofqwjo2pStzx/XgTuLLA5G
QtNg82iQbZttheyl+wG6b0koDOH083CfgRXz2QfDom0Q+/Vs+XIZEUOZGmcd
5SnIeHaArTOMBIH9LPaxB1oQZ6QSUNZP0wXnv0xeM+3o5o1z+7qrCZ9jKj7/
9KL5PJmE4BGpTnCVWw1+OVwP98GNFqf55iCuKL7iYNGFWsZ9H4wf1oByb/ZT
RtwcFDyaQngeknFn/GKs03QllJM7Rddk5/HsoeS0c3g3JDmFcg+7lGNYI96A
404kVr21Qs/RPYEbFzHuWlwMGpe6/RO821Bwlidy3KsAbgImncw1ZNQnaAUK
zJLBTyDr0TlUYNe3V4vf5Gj6oC8buP/JAFq2LG/1rKyGyGvBul6lAYy3fTnK
tHsEAlc/Faa/q4NpVBF3/cNeNIVNd3FjDMsGrZWaIo0QOLL3r6hwNzL5g69P
7pnAXc7wPB/rZrxYYBMrWerE6cXvA4Njk+iS9mT4cb8FIlahh3LW2iFJCFIN
fjiNBU9vRyMFInarvFtxESchvVqsyuvlDDS9HQI5Lrah13J+q44PEcnX5bk9
1Cj4uO1wPH0cCUL9NtevsbTAdTQjk0KmwOt5C3fzUDvi64kSew81gXtzYdCC
wyxcGdg0Mllpuszv9y46pB6dc5ZDLj9ncTonXShQtAsqHZESEWy1yM/X3XLQ
ew6eacZvhmTIGDUpmvGLqcJfj2gjTakI2G7NUZ208aL5xsOs/tcj0e/x5Vpq
BBEv8ngeLEvkg1Nedm0HzT/PaRSJ5FZ0oVDAfevFiHIE1E56qMwOQr+4xUOC
uR8+b1Q6yANV4DmwXirOOYhtcns47+kNo1iKcrggshYnN9kPC9zuQ8KJU8up
xqMYV3BeI7E2QLzBJoK4uwez0RvUxKTHcTCu1dtHtQlP1TaX0XGREd465v+l
fwLajAmnC48QQIj/626ypxOpexlt/Wj+1XK/+MwOoVZ4pywvxFi2Y2+dKV/v
yDTOzJtdsHckoo7lVerG/DZMn+H/+yhzBpsMrT5phLfhq1yUVvhRIvJ+LOkn
6lDwllX7551qEp7s/u4eWUEAQ0D+zqZeCuaGCAibaAdz3fCxeckmrFOY4uus
Z8EeVKZk8rMD28+Jvd+WUw/p0kfHLkzOQssgKF7tTycYDr6ZIF6qRal7NsMo
QyBKn67NX75+B02Nmy/cZAmH6Hu5GZfIVph+7pnhZMnDaIKPTItrJw59Yw6r
runEPQedA68KypAouuxLiRjACzfvZZvSXjTseeReJ1iFl9Pihn51g7DZ2HSD
IjsEhgKGVx0VNag5c6FGWr0fTdyh1MqQEfSyaG49L1SPbHWO/GcbevHlIq9x
L43P5V6+L+6n8bnfs50LDDQ+J4ZUSqWsjWP+R8arCdlmEDwzMhv2dOGmi+NZ
yQeTeNrTcqzgLwGfAxMLVx07sOfa0shxyhTWItOuq2S0QrB5lWOdSELk77uN
1odnEJVHTjGMI2JwO9/uHXptqH3cbZlKnMGzZb7SutY28IlW+DkvtiLfcyZd
15yCLR/3lZJnSBBVX1+ecSBg3bp+avMYBUcv5B+XXW7H7o4dXl1MTXj+xXY1
y2oWcRKiarLLHbhd+VmIo7AeLU+l1Lbb+sDsz6bUHaZ2iD/Y8DT503NM/R4v
p9NswdoH3lDyplzc5GFW8Q7pwMNdp/zZ5jrA8dL28nnPUlTfq/Hnd+rHXUEG
1shPPRCLuuy44lKJA/cvcq1eG8KtpcWqiO8DUHTtZf7DVIPqJ62fY3/0Y8OJ
1ZwdY8O0/NndpHymDsVu5QN2jb1gUEsoeRA9CidG37ZQiwZQlAT6Ddu7sfH0
kcf0yrRzbpNlEjjRBG+lvLyvTGRIlCm/MEmfQMs9vGtmJUAv72xf7IVOCO/9
qKLJOwU3Q+agi2ktyPG9ostd244ebYZ2HctpOCwpCbiLEMFxIWq/nC4Jylms
i8y2MyA0PAntWiWCMHjc3W6BiLBXHrm3qDOo8nRP8uYgofrvyLFfNq04Nl+2
V/cWBS30HWrLm9sxNDKwwXIjATe8UvnVqBSkpjFNhnB24HzGTb7l5ka8m/uS
E67rjDnXasnJsgv4EWmbJrHnHqbyOw4N8xNQt3B0REaBlm9bNu+LrGrHgbE+
+zDpDjxK0Qprsi2BgijvSz37PtC9uOa4kNyNLe5GkcKDFZjedInkuTQEkQQr
MfnBfrTKtey+ZlmN4yJRe5jDB8CdMXE65PQwMgkZt9Tf1EKeTT/J+l4fOPO/
V0T8GkFZHL82Z1Q9FiXOJMkG9sCaPm5y0XcMnCEjT9zvNYLpXUHumQYyGulU
avfS5rzOw/+xNm3OTULn5i3FuyAgNmnRZDiJjpie09+aCPhVlPxNNroD+yIq
5k68nUJVmc4Rv7Ot2PfpMuewVDtSJjWZlAnTyOOOWuO/TAQ/rC/fp811uHSa
wKngGdw8WWb1VqcN9x2vFfSGEWEBz4e3OSlwibjXnXqahNlmF1bnrhZc6vCM
mval4Lcrr+i54+24s+ORht2n/8nj/+8qnVn91cHZDJl7v4K3umTjqjbxehAX
7d6eCcwcfNqO/S4uLV4uxRAupz8e/rQXg78aL1LbyAjgzvb4YlqBwkQToQCZ
Ydjnq+x6Mt2HNvmhwtLmKiTEdSfYigyCRftSnYX/EDYmsM63r9TAfJ+lYT9n
Pw4LXPT4Yz+CRbEqxxvUOpDCq+qOyvXilK/pYWXqKMoJ4pwLpQ3Y6bnhS+n9
brS+9lQWNxlHnFZ4Qp9TE5ZmoocVBrtg1KmooZk0AZMLfD7+9ARIfz5SGWDR
CfYzs66D05MYdH5SNufVgofv7U+x/WhHMkW10ptvGm/Mgo3YJ1tx+XEdU2M0
ibZfMVv8wAyUzEsO7o4mwlq5Wek5TVe7Y04StHJmEGSZfq31TRteiJjsPHSI
iGbtC7y3pSk4pWIQ0e9HQkWIlANFuwWNqUoKxk+60O7rxR9zrRxzj26Ld70e
RHxWnUaUQzt+5uOJtG4x6Iapp+qtekH/YOaollYbgtzcNYr3F+CP5ZSlvSsZ
+jyVwz3mrRghrrLL9uaibGbw6rJeJ75YKFb3hC7gWGBYhPqFPoy+Fnv56UA2
RuxFPLjOTsDm469c8stm2PqoPJus7gRvdHxlaC8Vj0+lCA8pjYMuyOpUUWUx
/LXf+6c7D4LhqrHKF/0aGO0w2J6c2g9vzn7+Fck+aDPLX35tVoXx4OKMr36D
UP7PwHBnYTcU5gvHXk1W4MXqqtTNuSHI/v7yt2u8GWqeR/fScdDe6atiL+rH
drC8EaCfn+/CO74Jn5DscoyEWe3Q3TsES2LLpcmpRky3+DcceJcFic36BHlt
EkLJq/Ungmh+f1T3kua1MlBHv1pKnBzA4n8Dzyc1GvDplkzxweuZuLreUj20
rw1MjFvEP9h1IMY0rVq3tASq5+44Thb1oYj/9rtto3Uwz//qeMc2A528RhbP
VIhwUX1S4Xe7HdOjTdmFF4ohqboxK8ipF4HG2zbxZtXiflPs9VS/dLwd3cdn
RG5B2N8F44e0/HbsvXejyu4imLviK0mvBx7UE9HfkmsQqC5l/CM8DaF0b290
uBCgaR1gyzvTBp9rRT8WBQpBLx8b9M6oG1d2hyaQqqvhobr4n5xGKtQinOmJ
B5vhqU6obNemzZN5oOdf6QK4s/rff+ZORmHSwwPmZtUwt397/VniF6T9MTB7
ntCEnf5/BAMjLbG5zebvLhZtPNT4uzrkehXT3WyGB/8QsTV2K39JZT4Whwy2
POYjY75RwH5ZmAL39bvrTfYk1O716BYJaQGbe/wS0+IMbNeOMMXzkvDV5m6H
xMVWDEhvg6ptD3gePQkzPFOJhsWpB020d0t/ncflUVwX7gscTXr+sBylu1nF
NGsHcV585KV2QQdCzq1VWyiU4mBuBusuiX7MUfmytFTaUbPhRHcnQzE2xQ9t
vCrSC4ujRYnbmEg48U56i9GxQtzyqQsydO9GcaHJn3SmNrjUffKWas7H7UBb
Pf0dZIQVTqVYShPxkE226MaLPOy7ci68aq0TchWetRm0HK48q5ES/DQXlY2/
IjnoOiEoVXJTIJGAvqqa2l+RORi3HtNWF+/AnAGd09WQZhj63ecub8lGAJ/t
3zHbdtSvHRT/dpGCXuG6KKExEsQkt0xf9CDgWI+DdU5rByqD3ylyGJbikvru
4++0+vFUKfHRC3US1jfI2l6KLIS52VKYUms3zXdorjqn9KOQgaKYfbwappqK
5KNpA6j4ovGihuYXywQZ77Yu5EHCIjFx8mwXtnvt+ZQ10IOIl3qFsRGVkFjq
PsmoPYRNYq0vqJwtiBlfZpKZzIFjLdd5F4cODGyO4OApJmM1zretVKcCMtb8
62k7hhHiMoQbPU2wS+JKk9bJxokatqtasySEuF1qLlHqArG5ovazdDlEf/ae
z9g/CJ9X1WYOmxoRFdbkrbeWibChu2v8mW24wtSut7DUAQfbDcOn/EoxGxM0
K+XWD1kTNzVSQD34WHeICI1mQCRmJYSUQgSXoKnxf7T8VjsRa0dgLMHTVyKu
dJx9qHB5Gk13og4yPAn76JbScfDsOf7I9624uvGT4r4N7ah+dqPHNL8I3CPa
+xa7e+DuXJrEs78W3nbxdW/E07G/x31rkEgLXhx+6ZZ7nIRtu17WC70rRIqf
1nu2lm5IaFXwNirV4MZDr4vGk6lg9z+w92trM7rDTBqXXrZhm+teSfKHAhzj
jDz5ZZyMmENaCryTtFzVEfMjfroM9ZdCjrSUD0CYy/aYbGY7+Po9tzJmFcPU
uOpycmUvfMIkz86wkSBXdqys+WQhwmOH6w496oZuwJ9xQjERgjd6pZys81Fv
tC3oU0kXxrwWlepo/Hzq5QfnXTR+domszZ2h8fPc7CfVl+9pem93OvxNeA7u
q9uLOYvQ5ulWVbaSaDO+19quKzzIxuRt+4Lc7bQcxh438buvERu9bhB9w7Kg
84FrSBAkzAxPWLSWNSAjV1TAuzITlZki/ZtoebXYokPURI8MFcZzj1vWynHh
ouBl3aQhZOotH7TI7YB2x7n0nTKleJl72VBqdz/sbMKCtWk+Okczh77brggT
dgpiJSE9uHnH8RWbaRss1EO1fE8W4PUMxVQznIzr7LvMlWWJeLpyJnz7yzx0
klj4NH53Yr5Q77/+2y1QLyPn58jmwuDKRTP69A4YiH19atvdjPn7k3xfGXNQ
1fl7n+ebdjgxORequTVByJ5njp8pG63xrQVzibQ82tjprXyqETGP/fjeimdh
1C8pzKavDfM/7dTWnErRbf9J1XF/HHYE9NEzpFRjaZ6rrPtoA9hv+O72s8nE
G5v5XmfxNuzVfphMSaDCZ4Vd4BDrKLZyCQzId+eCFuk+nqD5ENvPa/ZvaT5k
PapBxJ/mQwId1qp3VHVDNRmLP2YrsDV/zuT81BA+OajnP6qpR7hFe5XopkyY
3ao5x9hBhGVK4hxHdgm8JyQLVz7Forvv+55s6Wo0nOHpytlDwa1TRW7G7iQM
vJKIfODQAl/5uKSyG6U4LiPGu07rn04jeZcvrf8ejjduxpJtuMvVYsrCWIBz
2vWudw3IoNTNqJd+yMXIM9svbz0+YveWJym8JaWwrl1jP/2AALfrD1Sfe+Xg
KvugSz9bB0oMDFz0T2bgZ+qp7CyZt5gt8Xgk45GH+z5y3b/5GjEveOEcA0MW
FkSEXmsVtKF5NbhkMjcJ24xNNj++F479tqFu03sycSjluNQb3zq4a14vPbon
Ax0nmOedV1tRacjzqDP+M+7XGR74LhAMTZ5aQSfuFFwqpjve9bwGChJPy0ws
06C2a76k5hiB9t3xB77RH3DtzINJPbbnYDVOOz7lHouVAv8G6nQVIiSWshoZ
vuBUaM5hLo4mLPh/vu4b/xo/BXfyNKj54L/1kh/FPB/hu391nRhaCXbfN+sW
HMkgkAuuPlZpgPYsq0/zSii2J7oYWBe4oufXyoYmjtcQVxNbKHeqgLh7NkH9
aiJ6IixYOVPr8Iv12hTp8TOE/yfnrH7NGX36N6rFXgfj2pOel9G3y6HVu7Wx
4Wc8RiaDbiiZ1kLrq7Pe06Nu4DwpYaprY4XhO5P7D4n7IEQbYe8Vy2DPFZFm
VxSH0OFTyicUakCR5s4QMyuBV7+3opx1LGgKs6T7rQpC0eXJ50Kq4aR65j/V
H1/g1JOgJ0JtQmjKDRtbDQqSndgPjueQYGVy4fSfUQJstltautN4Vc7UVqhv
JAOlUyeHX9F4dSLpyrspUX2aP81ZOpymjDjfTeyz4kZw4j5NP8FFweHvnswR
eiQkzktKEFpbYLvO7JpLe9erb7mj3eyLkPkruMMwtAd3BjdyXqLldJ1F/2M9
gvUw2OF75xctpzea8fycDRhAasOerO111RBZ1P92R24Ax4jc+8jefTijJaKV
GFSFSZ4rBFPTQVjuUpjTT22FXuomMmFLHmKCj1758LQThGrdBoHEJnw7L/dt
WTwb/SPvEp0bSaBbZ1E1p+XmghY6MiNTJpoj9pCdm4kgNdF7VbnVwtQjQmjB
Mh3rtUwfXf1acPu8VP7O1GqsjsnNioimQurn5IE1gWYcoo780D1QhXlDszH2
38l4qyCi9UegEf1TorrjNB+BuxZioUWV6Nw/K88iOoTnMmxcNvpk/DgSkhP2
qxw5glM2+clDyK6YOxov14WbfWf1kiTLUaGhZicmPghmQ1XBx6sV+Civ9GBK
LgnK7iebvjrUg+KmHqPW2Q35AG+zmuUKGD41OsY5MARFRZYS6tEucDs+V+c9
UI64/rArASqD+MLp17dHtBN/+/blSjWVwsvF+GRUbj8qF9keSM2VI/GL5dKt
hASk26VG/f1di/OZqw6hJWTUKb7f0XW6Ak7mWQ7ZO4cxoMbkvt2oE+rbnTlv
bi3Dy90iJr2/+qHxsvHEd9UOJJ6xtDvtXgInwn55L88+bN8XdGI7YznsWR6l
9pyPR8Ip5rALFTWIUhKr8hjuQvhRjsvVSeXYRXSJZN06hBTxPyj368D8p6UY
4fkSHJAR+i9oqg+FR+OMQ2+1I1V4l7a+cTG2vy0kqTr2YiWV2eqrcBeuZFVN
sgiXQ3rBWyl30yDe9VOMJrpovM6aIuwzXYxOLYaTgUu9KI1ifdRZSYJOPlPY
MeMibPd99czVqwcc1jNPOSKpIFp1VdY5joBvLlhIWz7n339hg+nEPgbLKUQ7
NZvso/nb9fR5xoe3e/D2btsYjCrRVrGZpPF4CIY/zndeqSfDXeVqY55hBaiu
eXUcEsP4vumUoJ96N9pb1mcVPlTgXI21xG6BYYw8OZ7O3NSF0g9pn3dFlmOt
cevPoZVBHDpslXTxNBknfL4LfPxZDoejz/+oxg0h/eP52yepnVi4oSe/ZbkM
5mGz5w0IA5CwdRpW8ezC1B2tKwVXyrF6xV+4LXAQpANSv9xkOqGbTfdcbKAU
dfO37S/V9eO0+IjGT/UJGHD9iFN+1gwWTn2uivZO6Gww/JC2fwxKz0a8d7E0
4kXsR7OdirQ5mztj7f99GAcbRW8QL9dB7qS6YkNeLz5omI8OfO6Dz4sfHpc+
V6Fe5D9qneYgrGWaNDV7emk6GLOTJFmFtOJ9Ljr5g2hyrydqc/dAw2ySm1mw
EhQFo1PBRUP/zvl/6//W/63//+r/AWiUdCA=
       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic}, AxesOrigin -> {0.01, 0.001}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, AxesLabel -> {
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(o\\)]\\)\"", TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(c\\)]\\)\"", TraditionalForm]}, 
     FrameLabel -> {{None, None}, {None, None}}, DisplayFunction -> Identity, 
     AspectRatio -> 1, Axes -> True, AxesLabel -> {
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(o\\)]\\)\"", TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(c\\)]\\)\"", TraditionalForm]}, 
     DisplayFunction :> Identity, FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultPlotStyle" -> Automatic, "GridLinesInFront" -> True}, 
     PlotRange -> {{0.01, 1}, {0.001, 0.1}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx11wdQE+u7BnBQPBQVK1IVQeRIUREbRXlEkCMqgihgF4+iiChgRRRQUERB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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                
                LineBox[{{7.5, -112.49999999999999`}, {7.5, 
                 112.50000000000001`}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -94.18202764976958}, 
                    Offset[{4., 0}, {7.5, -94.18202764976958}]}, {{
                    7.5, -59.61981566820275}, 
                    Offset[{4., 0}, {7.5, -59.61981566820275}]}, {{
                    7.5, -25.057603686635925`}, 
                    Offset[{4., 0}, {7.5, -25.057603686635925`}]}, {{7.5, 
                    9.504608294930899}, 
                    Offset[{4., 0}, {7.5, 9.504608294930899}]}, {{7.5, 
                    44.06682027649772}, 
                    Offset[{4., 0}, {7.5, 44.06682027649772}]}, {{7.5, 
                    78.62903225806454}, 
                    Offset[{4., 0}, {7.5, 78.62903225806454}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -108.0069124423963}, 
                    Offset[{2.5, 0.}, {7.5, -108.0069124423963}]}, {{
                    7.5, -101.09447004608293`}, 
                    Offset[{2.5, 0.}, {7.5, -101.09447004608293`}]}, {{
                    7.5, -87.26958525345621}, 
                    Offset[{2.5, 0.}, {7.5, -87.26958525345621}]}, {{
                    7.5, -80.35714285714285}, 
                    Offset[{2.5, 0.}, {7.5, -80.35714285714285}]}, {{
                    7.5, -73.44470046082948}, 
                    Offset[{2.5, 0.}, {7.5, -73.44470046082948}]}, {{
                    7.5, -66.53225806451611}, 
                    Offset[{2.5, 0.}, {7.5, -66.53225806451611}]}, {{
                    7.5, -52.70737327188939}, 
                    Offset[{2.5, 0.}, {7.5, -52.70737327188939}]}, {{
                    7.5, -45.79493087557602}, 
                    Offset[{2.5, 0.}, {7.5, -45.79493087557602}]}, {{
                    7.5, -38.882488479262655`}, 
                    Offset[{2.5, 0.}, {7.5, -38.882488479262655`}]}, {{
                    7.5, -31.970046082949278`}, 
                    Offset[{2.5, 0.}, {7.5, -31.970046082949278`}]}, {{
                    7.5, -18.145161290322562`}, 
                    Offset[{2.5, 0.}, {7.5, -18.145161290322562`}]}, {{
                    7.5, -11.232718894009196`}, 
                    Offset[{2.5, 0.}, {7.5, -11.232718894009196`}]}, {{
                    7.5, -4.320276497695831}, 
                    Offset[{2.5, 0.}, {7.5, -4.320276497695831}]}, {{7.5, 
                    2.5921658986175338`}, 
                    Offset[{2.5, 0.}, {7.5, 2.5921658986175338`}]}, {{7.5, 
                    16.417050691244263`}, 
                    Offset[{2.5, 0.}, {7.5, 16.417050691244263`}]}, {{7.5, 
                    23.329493087557626`}, 
                    Offset[{2.5, 0.}, {7.5, 23.329493087557626`}]}, {{7.5, 
                    30.241935483870993`}, 
                    Offset[{2.5, 0.}, {7.5, 30.241935483870993`}]}, {{7.5, 
                    37.154377880184356`}, 
                    Offset[{2.5, 0.}, {7.5, 37.154377880184356`}]}, {{7.5, 
                    50.97926267281109}, 
                    Offset[{2.5, 0.}, {7.5, 50.97926267281109}]}, {{7.5, 
                    57.89170506912448}, 
                    Offset[{2.5, 0.}, {7.5, 57.89170506912448}]}, {{7.5, 
                    64.80414746543784}, 
                    Offset[{2.5, 0.}, {7.5, 64.80414746543784}]}, {{7.5, 
                    71.71658986175117}, 
                    Offset[{2.5, 0.}, {7.5, 71.71658986175117}]}, {{7.5, 
                    85.54147465437791}, 
                    Offset[{2.5, 0.}, {7.5, 85.54147465437791}]}, {{7.5, 
                    92.45391705069127}, 
                    Offset[{2.5, 0.}, {7.5, 92.45391705069127}]}, {{7.5, 
                    99.36635944700464}, 
                    Offset[{2.5, 0.}, {7.5, 99.36635944700464}]}, {{7.5, 
                    106.278801843318}, 
                    Offset[{2.5, 0.}, {7.5, 106.278801843318}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.1\"", 0.1, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -94.18202764976958}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.2\"", 0.2, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -59.61981566820275}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.3\"", 0.3, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -25.057603686635925`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.4\"", 0.4, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 9.504608294930899}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 44.06682027649772}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.6\"", 0.6, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 78.62903225806454}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"SunsetColors\"", ",", "#1"}], "]"}], "&"}], ",", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "0.047392578971317524`", ",", "0.6983208322039194`"}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "225"}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.874476587726417*^9, 3.874491443503207*^9, 
  3.874491783966421*^9},
 CellLabel->
  "Out[141]=",ExpressionUUID->"be4624f2-9b28-4ca1-913f-a6ae6096f709"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fON", "[", "kon_", "]"}], "=", 
   RowBox[{
    RowBox[{"\[Delta]Nlong", "/", 
     SubscriptBox["N", "tot"]}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox["k", "oc"], "->", 
       SubscriptBox["kv", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "co"], " ", "->", " ", 
       SubscriptBox["kv", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
       SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Gamma]", "co"], " ", "->", 
       SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "o"], " ", "->", 
       SubscriptBox["Dv", "o"]}], ",", " ", 
      RowBox[{
       SubscriptBox["D", "c"], " ", "->", 
       SubscriptBox["Dv", "c"]}], ",", " ", 
      RowBox[{
       SubscriptBox["k", "off"], " ", "\[Rule]", 
       SubscriptBox["kv", "off"]}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
      RowBox[{
       SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
      RowBox[{
       SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
      RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
      RowBox[{
       SubscriptBox["c", "1"], "\[Rule]", " ", 
       SubscriptBox["cv", "1"]}], ",", 
      RowBox[{
       SubscriptBox["c", "2"], "\[Rule]", " ", 
       SubscriptBox["cv", "2"]}], ",", 
      RowBox[{"di", "\[Rule]", " ", "div"}], ",", 
      RowBox[{
       SubscriptBox["k", "on"], "\[Rule]", " ", "kon"}], ",", 
      RowBox[{
       SubscriptBox["N", "tot"], "\[Rule]", " ", 
       SubscriptBox["Nv", "tot"]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8734427077345247`*^9, 3.873442754922022*^9}, {
  3.8737994082241573`*^9, 3.87379941477348*^9}, {3.873799446437233*^9, 
  3.8737994598761797`*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"3d65da30-c86d-4d65-9d7d-ea3fe1d9baa6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"fON", "[", "kon", "]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"kon", ",", "0.0001", ",", "1"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox["kv", "on"], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.873442774886919*^9, 3.8734428246315937`*^9}, {
   3.873442857601884*^9, 3.873442857732914*^9}, 3.873786087615622*^9, {
   3.873799358519664*^9, 3.873799362468265*^9}, {3.8737994196832542`*^9, 
   3.873799427837738*^9}, {3.87379946735249*^9, 3.87379947425882*^9}, {
   3.874323914902969*^9, 3.8743239601971416`*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"e126d4cc-6d63-4e6b-b8ad-76e8f4daa2bf"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1nk01PsbB3CJNio0tpJKIqQslVK8CYVkS7pkiyFXZUmLFKUkssuSmmRL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       "]]},
     Annotation[#, "Charting`Private`Tag$11414#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJxN0mtIEwAQB/AhPhDLB5qbrpePMjXTVjqzdJhGVnO5+ULzNdtMMJ/5QbFi
s8wF5VTUCpZFiFpK2ghHsZRsZQ0xa2or5zR1c5o5C03Y2FZB3HVwHD+4D8ef
88otZnGtCARC/J/+O0vvB1+ODvekEf7V+ey5IreOCHBWwTbappzj4NTSCD+B
NBmcuBZHfrPEAX8ITdii4ZeD6ycSG8vjr4JX28cTjhxoAs87uE1Vm9vAPSJ/
dUtAD9gcF2OUNzwF21avTlUZnoGjFhR5MtsBcKEN2ecebRB8ZvWu0l0vA7N/
HGanlwyBbzM9mvv85GDtkItI3TsMTiaq8qOD3oMNs2Ulav0oOOWYjbsV5SP4
ZCrVhSJUgEeSWcUWzRjmOW3oE++aANeSYpLKeJ/AUhVpkihTgq8n1EneeX/B
+3qXf5GqJsGnRcodDKkKzKRyWoUkNTg785KtJHMa85QM6CIZM2CPO86Vu43o
57Q9Zr7oK9iv3+nx2VOzYJW4wMltA00srONSb82Bt1t42pnYeXBXSkSGSYvm
+eZf0dVowN5y7ngaRQs+ERqwNUqBjqzov9nJXwBLeB5rNb46cKVF50CRoe1S
BAxO6SKYXLZSY++6BDZyfXUHB9E+oyPGfUXf8H8tNGuR4zKYbsenCqX/eUyQ
vZ71HdxEtDkUYEY/pDAjNY9WwLGunDBXuh73e7MWZxloTXyaSMxEXxMwrFip
6Lem8JH6XDRdtznPsRKd9ELSbN+ObksXx33uRK9vdBs7u9AtlAfsuCdoZceN
oFopOqOR/dpage4OzqgYG0ebhlMC25ToVjt6Q4waPXMxLLN6ER3iud+ZtYzm
SwJfeenR3j93+r9cQ18QklX1G2jZXndhjgHtJnc+GmJCc885rFss6N8qrTZo

       "]]},
     Annotation[#, "Charting`Private`Tag$11414#2"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{{0.03}, {}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.0001, 1}, {0., 0.4895009626995767}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.873786466406878*^9, 3.873799212954121*^9, 3.8737992540421886`*^9, 
   3.8737993017141733`*^9, 3.873799663346951*^9, 3.8738001215467587`*^9, 
   3.874231968419889*^9, 3.8743157494210253`*^9, 3.874318135335083*^9, {
   3.87432410251161*^9, 3.874324128392976*^9}, 3.8743243094049273`*^9, 
   3.874324377868277*^9, 3.87438445115442*^9, 3.874384499428801*^9, 
   3.874384579490334*^9, 3.874390523417963*^9, 3.874391104303165*^9, 
   3.874491786575687*^9},
 CellLabel->
  "Out[143]=",ExpressionUUID->"f9c00a9b-9866-4fed-90e4-17ee3228f563"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"fD", "[", 
   RowBox[{"di_", ",", "DC_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"\[Delta]Nlong", "/", 
    SubscriptBox["N", "tot"]}], " ", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["k", "oc"], "->", 
      SubscriptBox["kv", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "co"], " ", "->", " ", 
      SubscriptBox["kv", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "oc"], " ", "->", " ", 
      SubscriptBox["\[Gamma]v", "oc"]}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Gamma]", "co"], " ", "->", 
      SubscriptBox["\[Gamma]v", "co"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "o"], " ", "->", 
      SubscriptBox["Dv", "o"]}], ",", " ", 
     RowBox[{
      SubscriptBox["D", "c"], " ", "\[Rule]", "DC"}], ",", " ", 
     RowBox[{
      SubscriptBox["k", "off"], " ", "->", 
      SubscriptBox["kv", "off"]}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]", "-"], "\[Rule]", " ", "eig1"}], ",", " ", 
     RowBox[{
      SubscriptBox["\[Lambda]", "+"], "\[Rule]", " ", "eig2"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "-"], "\[Rule]", " ", "eigs1"}], ",", 
     RowBox[{
      SubscriptBox["\[Lambda]s", "+"], "\[Rule]", "eigs2"}], ",", 
     RowBox[{"L", "\[Rule]", " ", "Lv"}], ",", 
     RowBox[{
      SubscriptBox["c", "1"], "\[Rule]", " ", 
      SubscriptBox["cv", "1"]}], ",", 
     RowBox[{
      SubscriptBox["c", "2"], "\[Rule]", " ", 
      SubscriptBox["cv", "2"]}], ",", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"di", "\[Rule]", " ", "div"}], ","}], "*)"}], 
     RowBox[{
      SubscriptBox["k", "on"], "\[Rule]", " ", 
      SubscriptBox["kv", "on"]}], ",", 
     RowBox[{
      SubscriptBox["N", "tot"], "\[Rule]", " ", 
      SubscriptBox["Nv", "tot"]}]}], "}"}]}]}], "\n", 
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"fD", "[", 
      RowBox[{"di", ",", "DC"}], "]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"di", ",", "0.001", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"DC", ",", "0.001", ",", "0.1"}], "}"}], ",", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Frame", "\[Rule]", " ", "False"}], ","}], "*)"}], 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(D\), \(o\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(D\), \(c\)]\)\>\""}], "  ", "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Bold", ",", " ", "Medium"}], "]"}]}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<SunsetColors\>\""}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"ScalingFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "\"\<Linear\>\""}], 
     "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.874496303400653*^9, 3.874496362088558*^9}},
 CellLabel->
  "In[145]:=",ExpressionUUID->"ea32b06b-66ec-4494-8580-416cf2961895"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{
          FractionBox["1", "75"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FractionBox[
              RowBox[{
               RowBox[{"236.36842105263153`", " ", "di"}], "-", 
               FractionBox[
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]], "+", 
               TemplateBox[{"16"},
                "OutputSizeLimit`Skeleton"], "+", 
               FractionBox[
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"], 
                RowBox[{
                 SqrtBox[
                  FractionBox[
                   TemplateBox[{"1"},
                    "OutputSizeLimit`Skeleton"], "DC"]], " ", 
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}]}]]}], 
              TemplateBox[{"1"},
               "OutputSizeLimit`Skeleton"]]}], "-", 
            FractionBox[
             TemplateBox[{"1"},
              "OutputSizeLimit`Skeleton"], 
             TemplateBox[{"1"},
              "OutputSizeLimit`Skeleton"]], "+", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3.1515789473684204`"}], " ", "di"}], "+", 
                TemplateBox[{"20"},
                 "OutputSizeLimit`Skeleton"]}], ")"}], " ", 
              RowBox[{"(", 
               TemplateBox[{"1"},
                "OutputSizeLimit`Skeleton"], ")"}]}], 
             RowBox[{
              RowBox[{"(", 
               TemplateBox[{"1"},
                "OutputSizeLimit`Skeleton"], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  TemplateBox[{"1"},
                   "OutputSizeLimit`Skeleton"], ")"}], " ", 
                 TemplateBox[{"1"},
                  "OutputSizeLimit`Skeleton"]}], "-", 
                TemplateBox[{"1"},
                 "OutputSizeLimit`Skeleton"]}], ")"}]}]]}], ")"}]}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{74.5546875, {4., 11.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{64.46484375, {0., 11.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 145, 24408456342082606278, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{74.68359375, {0., 11.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 145, 24408456342082606278, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{55.34765625, {0., 11.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 145, 24408456342082606278, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{95.87109375, {1., 11.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[24408456342082606278 === $SessionID, 
   Out[145], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{3.874496376694088*^9},
 CellLabel->
  "Out[145]=",ExpressionUUID->"fd12c329-ed3e-4c79-bf32-b1556a845605"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     GraphicsComplexBox[CompressedData["
1:eJxdl39oVmUUx192iVvOyrne9uMaIZPojwSpJSGDRVjMP7JyChEWFS2NIgdW
RCBRUFL0w6w/FIYzkJmWidRy2Og8uoKR2mZYCwfvrT8qM+uure1S++Npzft5
Xs55YIwP55zvcz7w8r73Ln10y7qumlKp9Pfc3///9/q3d7/+fuL4P/HO4Nia
D5oC377st/IVhxsC7/isvH64vxz4x447dm4frA+8Yvzp0buG6gKXxldet/C9
q52+p9bkxyYvMvNedH8udu/vaqOhT+9tDvvD7A+zP8z+MPvD7A+zv86PTV5k
5r3o/lx0XuIWND53seIbw/4w+8PsD7M/zP4w+8Psr/NjkxeZeS+6Pxedl7j2
Yk/2h9kfZn+Y/WH2h9m/XX0Oa01+bPIiM+9F9+ei65m0m8/5Mys2tt/y0LXB
B8YHxgfGB8YHxgfGR+fHJi8y8150fy66nonOT9yBtpHND15ZDj4wPjA+MD4w
PjA+MD46PzZ5kZn3ovtz0fXMcCr6vsRVij3xg/GD8YPxg/GD8auo77lakx+b
vMjMe9H9ueh6ZjiVivlerd/Q//mRJxcHPxg/GD8YPxg/GD8YP50fm7zIzHvR
/bnoemY4FX1f4joeufHn8ea64AfjB+MH4wfjB+MH46fzY5MXmXkvuj8XXc8M
p6LvS9zsuUt74AfjB+MH4wfjB+MH46fzY5MXmXkvuj8XXc8Mp1Uujr4/cY9P
Lel+eHJh8IXxhfGF8YXxhfGF8dX5scmLzLwX3Z+LrmeG0yoXR9+fuDPzv+cL
gi+ML4wvjC+ML4wvjK/Oj01eZOa96P5cdD0znFa5OPr+xLUV9+IL4wvjC+ML
4wvjC+Or82OTF5l5L7o/F13PDKdVLo6+P3H7539vLgu+ML4wvjC+ML4wvjC+
Oj82eZGZ96L7c9H1zHBa5eLo+xNXnv9+rgm+ML4wvjC+ML4wvjC+Oj82eZGZ
96L7c9H1zHBa5eLAwx19t13Y1+yOvbLm4+v/qT6Pw9Qr5r0EvpQ/IpZtPnOw
3Yf51mXJE6taEnfoxMWWDXcngf/9ZrZvyTXki8Dk2n6bTz91+/5k85mf/mm2
e1PvTHjfWtU7NvX12anw/rK2s/X0s/dPiH5fyGTTrkN1y081utah4y+Xjv4e
nq+vGjzXWrP+F/O8mkrv6NCel+ae57avfHHjTe9Wn+/e+uOjrV8cGAvPQwen
997wyf5T4fnh+TeSw6NdB6u/v8Xpv2/81xcGFrnLG3q27v5yWp7a9kPn6XsS
91ff4PfH90zI5Mzom50tTc73L24anjkvZ0/uKP+5tMF1PbZuYN/OVAaO3rll
7dz9X217dVd39q3Mrl504sNb611P28hkz+ojcuG1B24+31Hn/gPuJQhP
      "], {{{
         EdgeForm[], 
         GrayLevel[0.8], 
         GraphicsGroupBox[{
           PolygonBox[CompressedData["
1:eJwBrART+yFib1JiAgAAAIkBAAADAAAA0QIOEgUGDwIDEAMEEQQFEwYHFwoL
FAcIFQgJFgkKGAsM7wzjGg0OHA8QHRARHhESGw4PHxITIRQVIhUWIxYXIBMU
JBcYQDIz8BjkJxobKBscKRwdKh0eMyUmKx4fLSAhLB8gLyIjMCMkNScodGVm
NigpNykqOCorOSssOiwtOy0uPC4vPS8wPjAx8THnJhkaLiEiQTM0XU5PRzk6
RDY3RTc4Rjg5SDo7Tj9ASTs8Sjw9Sz0+T0BBUEFCUUJDU0RFVEVGVUZHUkNE
VkdIWElKWUpLWktMV0hJ8kzqQjQ1QzU2Xk9QYlNUX1BRYFFSYVJTY1RVZ1hZ
ZFVWZVZXZldYaFla81rraltcbF1ebV5fbl9ga1xdb2BhcWJjcmNkc2RlcGFi
XE1ONCYndWZn9GjsfG1ue2xteGlqeWprfW5vf3BxgHFyj3+Afm9wemtsgXJz
gnN0hHV2h3d4iHh5inp7jHx9i3t8g3R1jX1+jn5/kICBiXl6kYGCo5OUl4eI
k4OElISFloaHmIiJnIyNmYmKmoqLm4uMnY2On4+QdmdopZWWoZGSopKTppaX
p5eYqpqboJCRqJiZqZmakoKDq5ucrJydrZ2esqKjr5+gsKChsaGitKSluKip
taWmtqant6eouamquqqru6usva2uvq6vv6+wvKytwLCx07TDxLS1xbW2wbGy
xra3rp6fx7e4ybm6zb2+yrq7y7u8zr6/z7/AAg8OyLi52dXB0tENzLy9EB0c
AxAPBRIRBxQTCBUUCRYVBhMSChcWDRoZDhsaDxwbCxgXBBEQno6PER4doLCv
GSYlFyQjFCEgFSIhGicmHCkoHSopKTc2GygnFiMiHisqHywrIS4tIi8uIzAv
5zHmJjQzJTMyIC0sJzU0KDY1Q1JRJDEwKjg3PUtKMkA/MD49LTs6Ljw7M0FA
NUNCNkRDKzk4NEJBLz08N0VEOEZFOkhHO0lIPEpJPkxLP05N6kzpOUdGQE9O
QVBPLDo5QlFQRFNSd4eGSVhXRlVUR1ZVSFdWSllYT15dS1pZTVxbTl1cUF9e
UWBfUmFgVGNiVWRjVmVkU2JhV2ZlWWhnW2ppXGtqWGdmXWxrRVRTXm1sYG9u
ZHNyYXBvYnFwZXRzZnV0anl4X25tZ3Z1aXh3Y3JxeIiHa3p5bXx7b359cH9+
cYB/bn18coGAdIOCdYSDdoWEc4KBbHt6Eh8eeYmIeoqJf4+Ofo6Ne4uKfIyL
gJCPgpKRg5OSkaGggZGQfY2MhJSThpaViJiXiZmYipqZjJybjp6djZ2ch5eW
j5+ekKCfkqKhi5uak6Oipra1mamolqall6emmKinmqqpnq6tm6uqnKyrna2s
n6+uobGwEyAfp7e2pLSzpbW0qLi3qbm4rLy7orKxqrq5q7u6laWkrb28rr69
r7++tcXEscHA29TTtMTDtsbFusrJt8fGuMjHucnIu8vKvMzLvc3Mv8/O1c/A
2tfRvs7NDdEOtNOz2NPD09Sz3drSwdXAsMC/3NbV0dcC4dvC0trR3tvY39zZ
2NvT4tzQ2t0B1dbP2dzV4NoB297C3N/Q2uDX3OLW2+HUG8QGIQ==
            "]], 
           
           PolygonBox[{{228, 24, 12, 239}, {229, 36, 24, 240}, {233, 76, 62, 
            232}, {232, 62, 49, 241}, {235, 90, 76, 242}, {236, 104, 90, 
            243}, {237, 118, 104, 244}, {230, 49, 36, 229}, {238, 133, 118, 
            237}}]}]}, {}, {}, {}, {}, {}, {}}}, 
      VertexColors -> CompressedData["
1:eJztl/k3Fuy3h4kMoYiKiCQZ4k2ZhQ+iUjJWCL2oNBkylTKXecoQhZKkTJnn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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}], 
       Charting`ScaledTicks[{Log, Exp}]}, 
     AxesOrigin -> {Automatic, Automatic}, FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}}, GridLines -> {None, None}, 
     AxesLabel -> {
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(o\\)]\\)\"", TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(c\\)]\\)\"", TraditionalForm]}, 
     FrameLabel -> {{None, None}, {None, None}}, DisplayFunction -> Identity, 
     AspectRatio -> 1, Axes -> True, AxesLabel -> {
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(o\\)]\\)\"", TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(c\\)]\\)\"", TraditionalForm]}, 
     DisplayFunction :> Identity, Frame -> True, 
     FrameLabel -> {{None, None}, {None, None}}, FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> Directive[Bold, Medium], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultPlotStyle" -> Automatic, "GridLinesInFront" -> True}, 
     PlotRange -> {{-6.907755278982137, 
        0}, {-6.907755278982137, -2.3025850929940455`}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}], 
       Charting`ScaledTicks[{Log, Exp}]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx11wdQE+u7BnBQPBQVK1IVQeRIUREbRXlEkCMqgihgF4+iiChgRRRQUERB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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                
                LineBox[{{7.5, -112.50000000000001`}, {7.5, 
                 112.50000000000001`}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -64.74056603773586}, 
                    Offset[{4., 0}, {7.5, -64.74056603773586}]}, {{
                    7.5, -11.6745283018868}, 
                    Offset[{4., 0}, {7.5, -11.6745283018868}]}, {{7.5, 
                    41.39150943396226}, 
                    Offset[{4., 0}, {7.5, 41.39150943396226}]}, {{7.5, 
                    94.45754716981132}, 
                    Offset[{4., 0}, {7.5, 94.45754716981132}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -107.1933962264151}, 
                    Offset[{2.5, 0.}, {7.5, -107.1933962264151}]}, {{
                    7.5, -96.5801886792453}, 
                    Offset[{2.5, 0.}, {7.5, -96.5801886792453}]}, {{
                    7.5, -85.96698113207549}, 
                    Offset[{2.5, 0.}, {7.5, -85.96698113207549}]}, {{
                    7.5, -75.35377358490567}, 
                    Offset[{2.5, 0.}, {7.5, -75.35377358490567}]}, {{
                    7.5, -54.127358490566046`}, 
                    Offset[{2.5, 0.}, {7.5, -54.127358490566046`}]}, {{
                    7.5, -43.514150943396224`}, 
                    Offset[{2.5, 0.}, {7.5, -43.514150943396224`}]}, {{
                    7.5, -32.900943396226424`}, 
                    Offset[{2.5, 0.}, {7.5, -32.900943396226424`}]}, {{
                    7.5, -22.287735849056613`}, 
                    Offset[{2.5, 0.}, {7.5, -22.287735849056613`}]}, {{
                    7.5, -1.0613207547169878`}, 
                    Offset[{2.5, 0.}, {7.5, -1.0613207547169878`}]}, {{7.5, 
                    9.551886792452825}, 
                    Offset[{2.5, 0.}, {7.5, 9.551886792452825}]}, {{7.5, 
                    20.165094339622637`}, 
                    Offset[{2.5, 0.}, {7.5, 20.165094339622637`}]}, {{7.5, 
                    30.778301886792466`}, 
                    Offset[{2.5, 0.}, {7.5, 30.778301886792466`}]}, {{7.5, 
                    52.00471698113207}, 
                    Offset[{2.5, 0.}, {7.5, 52.00471698113207}]}, {{7.5, 
                    62.617924528301884`}, 
                    Offset[{2.5, 0.}, {7.5, 62.617924528301884`}]}, {{7.5, 
                    73.23113207547169}, 
                    Offset[{2.5, 0.}, {7.5, 73.23113207547169}]}, {{7.5, 
                    83.84433962264151}, 
                    Offset[{2.5, 0.}, {7.5, 83.84433962264151}]}, {{7.5, 
                    105.07075471698113`}, 
                    Offset[{2.5, 0.}, {7.5, 105.07075471698113`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.05\"", 0.05, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 2}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -64.74056603773586}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.10\"", 0.1, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 2}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -11.6745283018868}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.15\"", 0.15, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 2}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 41.39150943396226}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox["\"0.20\"", 0.2, AutoDelete -> True], 
                    NumberForm[#, {
                    DirectedInfinity[1], 2}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 94.45754716981132}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, Medium]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, Medium]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1], 
                    Directive[Bold, Medium]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, Medium]]}}, StripOnInput -> 
                    False]}, {}}, {{
                    Directive[
                    Opacity[1], 
                    Directive[Bold, Medium]], 
                    Directive[
                    Opacity[1], 
                    Directive[Bold, Medium]]}}, StripOnInput -> False], {
                   "GraphicsLabel"}, StripOnInput -> False]}, {
                 "GraphicsTicks"}, StripOnInput -> False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {
          Directive[Bold, Medium], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"Blend", "[", 
                   RowBox[{"\"SunsetColors\"", ",", "#1"}], "]"}], "&"}], ",", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "0.005322701181270251`", ",", "0.2167452606079171`"}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"Bold", ",", "Medium"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "225"}], ",", 
           RowBox[{"Charting`TickAnnotations", "\[Rule]", "None"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.874496422459633*^9},
 CellLabel->
  "Out[146]=",ExpressionUUID->"41d22454-02e6-4a61-b451-c70be4ddfb08"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1440., 758.25},
WindowMargins->{{0, Automatic}, {0, Automatic}},
TaggingRules->{
 "WelcomeScreenSettings" -> {"FEStarting" -> False}, "TryRealOnly" -> False},
Magnification->1.5,
FrontEndVersion->"12.1 for Linux x86 (64-bit) (March 18, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"39a6dd4a-ad6e-49d3-84f7-f9b63ab736ed"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 525, 8, 146, "Title",ExpressionUUID->"5e68a840-5695-4b20-ab27-615771320821"],
Cell[CellGroupData[{
Cell[1130, 34, 184, 3, 103, "Chapter",ExpressionUUID->"f0f49cad-f21c-4e29-94be-1d0619cf1257"],
Cell[1317, 39, 870, 17, 156, "Text",ExpressionUUID->"ec134919-5e8f-40e1-b829-d32523a3f103"],
Cell[2190, 58, 248, 3, 45, "Input",ExpressionUUID->"ab62c68a-7687-4d90-8910-f65c8ec5063a"],
Cell[CellGroupData[{
Cell[2463, 65, 381, 11, 100, "Section",ExpressionUUID->"57593b15-bd54-4f15-b54e-28927b414cc1"],
Cell[2847, 78, 1447, 37, 74, "Input",ExpressionUUID->"5abff06d-aac8-4af6-a09b-8adecbf3271d"],
Cell[4297, 117, 955, 26, 74, "Input",ExpressionUUID->"63de950c-ff95-4ae7-bee2-1f4e3b8a7103"],
Cell[5255, 145, 591, 15, 43, "Input",ExpressionUUID->"3705c23f-518d-4d92-9cf6-e5128b9191c4"],
Cell[5849, 162, 469, 10, 43, "Input",ExpressionUUID->"69ce6edc-cf12-4847-b384-63ea52f98507"],
Cell[CellGroupData[{
Cell[6343, 176, 798, 16, 74, "Input",ExpressionUUID->"8221fea6-8128-4dca-9276-fc1808364d09"],
Cell[7144, 194, 1765, 33, 70, "Output",ExpressionUUID->"5da22d1c-60a0-4152-a47e-ee2e4606bac5"],
Cell[8912, 229, 1851, 35, 70, "Output",ExpressionUUID->"4b766eb1-1aed-4ab9-821b-6446d009ffe7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10800, 269, 783, 20, 43, "Input",ExpressionUUID->"60e2b40a-6321-4d29-8a33-2620d25f5597"],
Cell[11586, 291, 1366, 28, 70, "Output",ExpressionUUID->"2de70589-4b80-4e86-83f4-6aabecc91e0f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12989, 324, 434, 12, 74, "Input",ExpressionUUID->"f0c3e516-3b8d-454f-8ae2-25e2e7a3ab3d"],
Cell[13426, 338, 1447, 35, 70, "Output",ExpressionUUID->"56925133-f85c-4148-9f8b-8d460cb7ec5f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14910, 378, 666, 18, 43, "Input",ExpressionUUID->"c8560aa8-b81c-498d-ab17-ccdd766a0192"],
Cell[15579, 398, 1308, 31, 70, "Output",ExpressionUUID->"94022bbf-fb00-41bf-b207-4cf56ac88a9a"]
}, Open  ]],
Cell[16902, 432, 784, 24, 55, "Input",ExpressionUUID->"e3ca6e70-ed35-45ab-9fbf-2109a6055134"],
Cell[17689, 458, 524, 13, 51, "Text",ExpressionUUID->"6596a6d5-9b51-4e79-b00a-9c9798d9304b"],
Cell[18216, 473, 156, 3, 51, "Text",ExpressionUUID->"c2322349-cec7-4569-97dc-a15c9354deef"],
Cell[CellGroupData[{
Cell[18397, 480, 150, 2, 43, "Input",ExpressionUUID->"8bd3a987-a9d3-4aa7-a6dd-fea427c07af8"],
Cell[18550, 484, 1919, 53, 70, "Output",ExpressionUUID->"b526bb9d-c4ef-45af-9abe-b732389c8e8f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20506, 542, 172, 2, 43, "Input",ExpressionUUID->"d07dd06b-3b45-447f-b034-43c90f7ab1cd"],
Cell[20681, 546, 2039, 54, 70, "Output",ExpressionUUID->"5180799f-dc09-42be-a235-99cda2b2e732"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22757, 605, 201, 3, 96, "Subsection",ExpressionUUID->"9d26a5f2-0957-4c2b-a045-ccdb8f9b0c4d"],
Cell[22961, 610, 248, 6, 43, "Input",ExpressionUUID->"98193d95-5b3b-4497-9009-8c64c293de88"],
Cell[CellGroupData[{
Cell[23234, 620, 451, 8, 43, "Input",ExpressionUUID->"efccc9ec-c5d8-4b63-bcd6-1e0cd81ae83c"],
Cell[23688, 630, 3386, 89, 70, "Output",ExpressionUUID->"2e25ebbb-e210-48ac-9393-c927539c2785"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27111, 724, 518, 12, 74, "Input",ExpressionUUID->"29726819-8374-4bb3-999d-50fcb837e098"],
Cell[27632, 738, 3994, 102, 70, "Output",ExpressionUUID->"c235c802-0dd4-4f57-af42-2c5125740b7e"]
}, Open  ]],
Cell[31641, 843, 402, 7, 43, "Input",ExpressionUUID->"cc22fc24-0c11-4cb0-9337-b22687db6f2e"],
Cell[32046, 852, 716, 17, 74, "Input",ExpressionUUID->"29049ddc-b7ae-4181-bff0-d5e2b54618e3"],
Cell[32765, 871, 242, 5, 43, "Input",ExpressionUUID->"cd3ec990-8a3d-4569-9869-0817b33e0adf"],
Cell[33010, 878, 658, 14, 74, "Input",ExpressionUUID->"1cdb2e63-604e-4565-be6d-b03c6f45feb3"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33717, 898, 213, 4, 77, "Section",ExpressionUUID->"100e28e0-fb31-40db-9388-e5aa00f624c0"],
Cell[CellGroupData[{
Cell[33955, 906, 217, 4, 67, "Subsubsection",ExpressionUUID->"cc390b4b-4211-41cb-9b2b-ff4f77653b26"],
Cell[CellGroupData[{
Cell[34197, 914, 1006, 26, 54, "Input",ExpressionUUID->"823cb917-10a1-4ece-ace8-752b6bdec2f0"],
Cell[35206, 942, 1779, 37, 70, "Output",ExpressionUUID->"344a562e-2ef1-4420-b5c4-4d48689ba114"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37022, 984, 416, 8, 43, "Input",ExpressionUUID->"b93da27d-8f89-4a5c-bf73-3c8cfc5bab5a"],
Cell[37441, 994, 4782, 126, 70, "Output",ExpressionUUID->"db9494a1-5533-4124-9de6-061ea95044d0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42260, 1125, 372, 8, 43, "Input",ExpressionUUID->"e66c6d45-5910-4019-94b1-e90ce22446cd"],
Cell[42635, 1135, 3808, 115, 70, "Output",ExpressionUUID->"d72da9e5-98aa-4bb4-aa72-31fe4b3eee2f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46480, 1255, 330, 7, 43, "Input",ExpressionUUID->"f958b27d-b350-4851-bbfa-c7d7093d8690"],
Cell[46813, 1264, 4825, 133, 70, "Output",ExpressionUUID->"f1566a7e-ded2-4eaf-9fce-5c468c767f72"]
}, Open  ]],
Cell[51653, 1400, 182, 3, 51, "Text",ExpressionUUID->"c542aa86-285c-4531-ad19-0cf61c3d1b0b"],
Cell[CellGroupData[{
Cell[51860, 1407, 883, 23, 43, "Input",ExpressionUUID->"e9b92cc8-a535-42e8-b549-0503bbb46770"],
Cell[52746, 1432, 1134, 18, 70, "Output",ExpressionUUID->"f1d00de5-9bff-4b3a-b300-153e99fdaa6e"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53929, 1456, 256, 4, 55, "Subsection",ExpressionUUID->"48f017ca-83d7-4ba3-9b8c-6436db2f1ac7"],
Cell[CellGroupData[{
Cell[54210, 1464, 837, 22, 54, "Input",ExpressionUUID->"6394876f-f8a4-4b63-9cfb-33b25becc1a7"],
Cell[55050, 1488, 1685, 32, 70, "Output",ExpressionUUID->"beeb622d-02e8-4843-ba38-fff30b8f8c90"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56772, 1525, 347, 7, 43, "Input",ExpressionUUID->"91326ac0-d6f2-44d2-b92f-ebb5698be9a1"],
Cell[57122, 1534, 5127, 135, 70, "Output",ExpressionUUID->"31e13113-d0d5-4a30-bf6e-7295fd2bb561"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62286, 1674, 332, 7, 43, "Input",ExpressionUUID->"23258ae0-64e3-41e6-8e53-2633666415fe"],
Cell[62621, 1683, 5392, 143, 70, "Output",ExpressionUUID->"2fc10c55-6d40-4819-a447-8c318765a2ff"]
}, Open  ]],
Cell[68028, 1829, 198, 4, 51, "Text",ExpressionUUID->"9507ae1d-23ea-4b0a-90ea-08a52ba81d1b"],
Cell[CellGroupData[{
Cell[68251, 1837, 793, 21, 43, "Input",ExpressionUUID->"cdf35b9e-fd2d-4d43-82b6-4dd5fbb6f985"],
Cell[69047, 1860, 1058, 16, 70, "Output",ExpressionUUID->"185846f0-120e-4594-83a7-175a2e3f0278"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[70166, 1883, 223, 4, 77, "Section",ExpressionUUID->"81f83d68-cdc8-4da0-b761-4cef7c51dd29"],
Cell[CellGroupData[{
Cell[70414, 1891, 153, 3, 81, "Subsection",ExpressionUUID->"4312356b-87c6-4c6d-a1c8-f9ff9100efc9"],
Cell[70570, 1896, 1225, 33, 159, "Text",ExpressionUUID->"15b95e90-b047-4360-9621-b853767f7b16"],
Cell[71798, 1931, 219, 5, 52, "Text",ExpressionUUID->"06d5a56f-7c88-4f48-9229-4eb3e1d98ebb"],
Cell[72020, 1938, 1897, 55, 181, "Input",ExpressionUUID->"11c52818-a561-48a6-bc01-271128d163b8"],
Cell[CellGroupData[{
Cell[73942, 1997, 1792, 48, 145, "Input",ExpressionUUID->"1f6f1d75-4d42-4209-87ba-17fa7e869fa7"],
Cell[75737, 2047, 10630, 305, 455, "Output",ExpressionUUID->"4a92748d-2d37-4641-95dc-ade347433cd5"]
}, Open  ]],
Cell[86382, 2355, 269, 6, 52, "Text",ExpressionUUID->"9b07dcf9-4442-49ee-a3e9-f73f1c60e44d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86688, 2366, 588, 13, 81, "Subsection",ExpressionUUID->"f6992107-ad34-4713-a047-3741eadb70eb"],
Cell[87279, 2381, 172, 3, 52, "Text",ExpressionUUID->"6e61e6a2-ed9a-4c6b-8a68-9a40fa8986a5"],
Cell[87454, 2386, 294, 6, 52, "Text",ExpressionUUID->"a788cea3-1d27-4e18-90ff-6d17519102f7"],
Cell[CellGroupData[{
Cell[87773, 2396, 2384, 55, 200, "Input",ExpressionUUID->"220b45b8-2b0b-4ea3-9d37-a8ee6934a32c"],
Cell[90160, 2453, 11939, 303, 159, "Output",ExpressionUUID->"fe016348-38dc-43ba-a49b-66a03402163c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102136, 2761, 486, 13, 44, "Input",ExpressionUUID->"38192a75-e18e-4796-aa62-b18ef844e88b"],
Cell[102625, 2776, 18428, 456, 363, "Output",ExpressionUUID->"d1affc75-5f27-4e2d-baa6-5b8186dd6eb5"]
}, Open  ]],
Cell[121068, 3235, 389, 10, 44, "Input",ExpressionUUID->"623ba4ba-533b-45d0-88ee-55a584af48fd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121494, 3250, 262, 5, 81, "Subsection",ExpressionUUID->"fe86524f-3ab8-4c5f-90c2-628287b1b5ab"],
Cell[121759, 3257, 202, 3, 52, "Text",ExpressionUUID->"cbe2530b-c1fc-4332-874f-0dab9566262d"],
Cell[121964, 3262, 1130, 27, 44, "Input",ExpressionUUID->"4c51031a-8672-4629-b263-093e428abae2"],
Cell[123097, 3291, 480, 9, 44, "Input",ExpressionUUID->"94f0b82b-ac73-4e09-bbd7-d94e901cb57f"],
Cell[CellGroupData[{
Cell[123602, 3304, 506, 12, 44, "Input",ExpressionUUID->"465cab5d-0014-48cd-9640-de9bca842f69"],
Cell[124111, 3318, 16319, 405, 264, "Output",ExpressionUUID->"8ee1d980-2757-4af5-8c54-d0da2c7ad737"]
}, Open  ]],
Cell[CellGroupData[{
Cell[140467, 3728, 468, 10, 44, "Input",ExpressionUUID->"ce248066-0f38-4c62-85cb-7328ed4c7cc9"],
Cell[140938, 3740, 16201, 406, 264, "Output",ExpressionUUID->"00bb811d-8384-47bf-983d-5e2e03986015"]
}, Open  ]],
Cell[157154, 4149, 295, 6, 44, "Input",ExpressionUUID->"fee4a4a3-28f4-4dc9-9de8-97f691940960"],
Cell[CellGroupData[{
Cell[157474, 4159, 238, 4, 44, "Input",ExpressionUUID->"380cc118-316f-40fe-8853-55305544b0e6"],
Cell[157715, 4165, 15969, 411, 249, "Output",ExpressionUUID->"26460445-7a2f-4ad7-a2d7-6985e84a9c1b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173721, 4581, 199, 3, 44, "Input",ExpressionUUID->"967a2b16-3ba1-4036-9c83-f73b1081483d"],
Cell[173923, 4586, 15123, 379, 222, "Output",ExpressionUUID->"93d531fb-740f-410e-8095-d44ddc72fa3d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[189095, 4971, 223, 5, 81, "Subsection",ExpressionUUID->"5fcd1d6b-14f0-4e0f-9891-c7d2142cc0b9"],
Cell[CellGroupData[{
Cell[189343, 4980, 1347, 42, 48, "Input",ExpressionUUID->"a3d92836-eab4-45f5-bfdd-723d815b29af"],
Cell[190693, 5024, 916, 13, 50, "Output",ExpressionUUID->"4080f8fd-0d85-44f0-9577-f5c6c1c3b477"]
}, Open  ]],
Cell[191624, 5040, 426, 9, 87, "Text",ExpressionUUID->"683e555f-49cf-4091-8704-304d01475451"],
Cell[CellGroupData[{
Cell[192075, 5053, 1983, 57, 56, "Input",ExpressionUUID->"4630bc56-60bf-4e22-9204-6d3c67059c31"],
Cell[194061, 5112, 9386, 236, 141, "Output",ExpressionUUID->"d6f44326-a91f-4f7f-a948-d076bf95ba77"]
}, Open  ]],
Cell[203462, 5351, 294, 7, 52, "Text",ExpressionUUID->"d4d4237e-a947-4d62-b311-10d8c03fd13a"],
Cell[203759, 5360, 625, 13, 76, "Input",ExpressionUUID->"8fb1b804-8410-4f69-b5d7-9dc473c6e346"],
Cell[CellGroupData[{
Cell[204409, 5377, 523, 11, 44, "Input",ExpressionUUID->"9d01fa14-2399-4ab6-b003-8b02279f9288"],
Cell[204935, 5390, 871, 17, 39, "Message",ExpressionUUID->"c41deeb6-deef-4571-9082-fc1aba9f360e"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[205867, 5414, 385, 8, 102, "Section",ExpressionUUID->"4f5228d8-f075-433d-bc45-6672eb886da4"],
Cell[206255, 5424, 735, 14, 44, "Input",ExpressionUUID->"85f3d4dc-2e9e-4418-8025-dfc53ba66b87"],
Cell[206993, 5440, 3507, 59, 76, "Input",ExpressionUUID->"e07b083e-eb46-489e-a0a2-6786a4b5a649"],
Cell[CellGroupData[{
Cell[210525, 5503, 197, 3, 67, "Subsubsection",ExpressionUUID->"cae7e8c3-2ba1-45cc-b69d-e368966c29f4"],
Cell[CellGroupData[{
Cell[210747, 5510, 199, 4, 67, "Input",ExpressionUUID->"d0fba3f0-0d95-486c-87c4-e463c00566b1"],
Cell[210949, 5516, 1513, 23, 105, "Output",ExpressionUUID->"7863016f-68d5-417b-88a4-e7a118281cb7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[212499, 5544, 246, 6, 68, "Input",ExpressionUUID->"117361dc-a2ff-4d2e-a90d-fcd2c9b2847a"],
Cell[212748, 5552, 1498, 22, 105, "Output",ExpressionUUID->"f1fb0f0e-da17-4a1f-9d2b-760337eb0888"]
}, Open  ]],
Cell[CellGroupData[{
Cell[214283, 5579, 244, 6, 68, "Input",ExpressionUUID->"d9d4ed82-e5cf-49ea-9ee2-b419279d604d"],
Cell[214530, 5587, 1511, 22, 105, "Output",ExpressionUUID->"39bf5f8d-f322-44cc-8334-ed9c92b81997"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[216090, 5615, 279, 6, 57, "Subsection",ExpressionUUID->"239260a6-05e5-4a9f-a352-07c1971d347b"],
Cell[216372, 5623, 294, 7, 52, "Text",ExpressionUUID->"30a34616-13db-414b-bad9-04fdd8f47ad6"],
Cell[CellGroupData[{
Cell[216691, 5634, 2531, 68, 76, "Input",ExpressionUUID->"852bffad-239f-4324-81d1-c75c4ad1022d"],
Cell[219225, 5704, 3145, 45, 105, "Output",ExpressionUUID->"a6c60a27-0d69-4f83-b695-604d4d410199"],
Cell[222373, 5751, 3145, 45, 105, "Output",ExpressionUUID->"e785ba93-0fab-4d4c-9f49-6c13becd7666"]
}, Open  ]],
Cell[225533, 5799, 175, 3, 52, "Text",ExpressionUUID->"92e342be-dcee-4597-94d4-c2a706a0cc9c"],
Cell[CellGroupData[{
Cell[225733, 5806, 2174, 63, 76, "Input",ExpressionUUID->"a4fdd237-d391-471a-8e64-4995504fed33"],
Cell[227910, 5871, 2327, 33, 105, "Output",ExpressionUUID->"ebbfa17f-3822-4a45-b470-104f1b7887b7"],
Cell[230240, 5906, 2326, 33, 105, "Output",ExpressionUUID->"35436768-9ebb-4cb6-9cea-b9cb6ee2971b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[232603, 5944, 1767, 48, 76, "Input",ExpressionUUID->"7a2dc5b5-13ee-4e85-930b-603a16ed9205"],
Cell[234373, 5994, 373, 9, 105, "Output",ExpressionUUID->"14f98659-5820-4151-8c4c-c641dec3818c"]
}, Open  ]],
Cell[234761, 6006, 390, 8, 87, "Text",ExpressionUUID->"cb71b93f-8887-4d00-8548-e98bb1d3d478"],
Cell[CellGroupData[{
Cell[235176, 6018, 3814, 102, 138, "Input",ExpressionUUID->"6a09e365-51ab-4c28-9d29-8a54d389121f"],
Cell[238993, 6122, 1735, 25, 105, "Output",ExpressionUUID->"c0a2811e-bba8-4d3f-802c-4231c8f9e018"],
Cell[240731, 6149, 1734, 25, 105, "Output",ExpressionUUID->"85418f9d-fecb-4050-a4e9-377af336c3da"]
}, Open  ]],
Cell[242480, 6177, 172, 3, 52, "Text",ExpressionUUID->"71d23e3f-c697-4873-b3c5-9279f3144a19"],
Cell[CellGroupData[{
Cell[242677, 6184, 3725, 100, 138, "Input",ExpressionUUID->"16c83424-1cda-4bd7-a7d6-50c7b55a8219"],
Cell[246405, 6286, 2407, 35, 105, "Output",ExpressionUUID->"be3bfb3c-c01f-4d2e-a976-7913d5f791be"],
Cell[248815, 6323, 2412, 35, 105, "Output",ExpressionUUID->"fb23129b-093b-4917-b905-6bc5db984c53"]
}, Open  ]],
Cell[251242, 6361, 164, 3, 52, "Text",ExpressionUUID->"3428c1b6-27bd-4787-a506-eda4e44bcf4a"],
Cell[CellGroupData[{
Cell[251431, 6368, 2168, 60, 76, "Input",ExpressionUUID->"cee6ee6e-c813-45f6-822c-50f91a21f148"],
Cell[253602, 6430, 2361, 36, 105, "Output",ExpressionUUID->"99e1536e-c9b3-4500-bf8d-eefc0b74419d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[256000, 6471, 2174, 60, 76, "Input",ExpressionUUID->"bed96359-1dd5-455c-aab8-43252e4c9942"],
Cell[258177, 6533, 2333, 36, 105, "Output",ExpressionUUID->"b3c2b5f5-acd1-4842-9a1a-7e9891671a08"]
}, Open  ]],
Cell[260525, 6572, 167, 3, 52, "Text",ExpressionUUID->"7c55b855-6f5e-4f25-9c6b-9310d5fd1045"],
Cell[260695, 6577, 2157, 57, 76, "Input",ExpressionUUID->"a303cef5-047d-4401-8b2f-445baf523eb5"],
Cell[262855, 6636, 2113, 57, 76, "Input",ExpressionUUID->"593c6d77-8117-49df-a5d9-b143554c52af"],
Cell[264971, 6695, 2124, 57, 76, "Input",ExpressionUUID->"377ba47d-4a57-4e93-a206-4eafa31da1b9"],
Cell[267098, 6754, 236, 4, 52, "Text",ExpressionUUID->"56fed37e-3974-4deb-a136-bbcbd9bd322b"],
Cell[CellGroupData[{
Cell[267359, 6762, 2191, 59, 107, "Input",ExpressionUUID->"92e50df9-2c99-4745-9db7-1a9934f6a3f2"],
Cell[269553, 6823, 1941, 29, 105, "Output",ExpressionUUID->"fa6771ad-e588-45b6-bf9d-315ba9deedf7"]
}, Open  ]],
Cell[271509, 6855, 2579, 65, 76, "Input",ExpressionUUID->"d91d1fc3-f569-4123-b114-4440dfdc89a2"],
Cell[CellGroupData[{
Cell[274113, 6924, 178, 3, 67, "Subsubsection",ExpressionUUID->"173fb62c-4ad9-4118-8677-cb7723b21540"],
Cell[274294, 6929, 628, 14, 52, "Text",ExpressionUUID->"8c885f36-6934-4d45-a960-641bc0e83b66"],
Cell[274925, 6945, 374, 7, 87, "Text",ExpressionUUID->"a63e02f2-1aff-487b-a53d-1acbd023a17f"],
Cell[CellGroupData[{
Cell[275324, 6956, 3922, 114, 138, "Input",ExpressionUUID->"96d709c6-721d-46a3-a0b4-c34f25ea528f"],
Cell[279249, 7072, 405, 8, 105, "Output",ExpressionUUID->"ea3c2d57-14e9-4930-be73-9972f4a0b1bb"],
Cell[279657, 7082, 403, 8, 105, "Output",ExpressionUUID->"f4bad230-0872-45e5-9f18-cd448a173e0a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[280097, 7095, 314, 6, 44, "Input",ExpressionUUID->"fb2b2c4a-e0ea-42b2-9031-492e1e4dfcc1"],
Cell[280414, 7103, 561, 11, 105, "Message",ExpressionUUID->"dfef64b7-37e0-4e0f-904b-d8ef665dba10"],
Cell[280978, 7116, 286, 5, 105, "Output",ExpressionUUID->"6e18387b-4413-408c-8676-46d825bec60b"]
}, Open  ]],
Cell[281279, 7124, 828, 23, 44, "Input",ExpressionUUID->"0337135a-2c16-4c70-9a3e-140ef2a4b9ba"],
Cell[CellGroupData[{
Cell[282132, 7151, 1291, 36, 44, "Input",ExpressionUUID->"184888b8-0df0-4395-ac60-0a6dd26c9e21"],
Cell[283426, 7189, 294, 5, 105, "Output",ExpressionUUID->"00ab079b-afa8-4e8e-8048-103b6515e043"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[283781, 7201, 253, 4, 57, "Subsection",ExpressionUUID->"02b41595-27bb-4502-9e42-f0189b36b45b"],
Cell[284037, 7207, 208, 3, 52, "Text",ExpressionUUID->"f54e7d09-2e22-4a73-9ae7-0fb3848395f8"],
Cell[CellGroupData[{
Cell[284270, 7214, 232, 5, 44, "Input",ExpressionUUID->"3954073a-2c35-4fde-990f-2c2910abe976"],
Cell[284505, 7221, 463, 8, 50, "Output",ExpressionUUID->"192f0f20-7e13-4cd9-b5f0-a172d5c040b0"]
}, Open  ]],
Cell[284983, 7232, 206, 3, 52, "Text",ExpressionUUID->"9b9af6db-bc66-4280-83d6-ab28e5f04c19"],
Cell[CellGroupData[{
Cell[285214, 7239, 584, 11, 44, "Input",ExpressionUUID->"176edcd4-50fb-42d1-a2fb-a8ae55ea4275"],
Cell[285801, 7252, 1250, 18, 50, "Output",ExpressionUUID->"931e8a2f-7e29-4a0f-8581-048dd82d0558"]
}, Open  ]],
Cell[287066, 7273, 188, 3, 52, "Text",ExpressionUUID->"a2490635-7113-41b1-907d-8071963ce698"],
Cell[CellGroupData[{
Cell[287279, 7280, 959, 22, 44, "Input",ExpressionUUID->"d26a0a4e-ad98-4b11-b77b-df56a0d6968f"],
Cell[288241, 7304, 752, 11, 50, "Output",ExpressionUUID->"c0ee5d9a-b889-4a39-b92a-9336b92e050d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[289030, 7320, 294, 7, 44, "Input",ExpressionUUID->"804caa2b-b326-463d-85e1-cf62748f38a8"],
Cell[289327, 7329, 262, 4, 50, "Output",ExpressionUUID->"96760fce-4baf-49c7-8650-a4e51a06ad5e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[289626, 7338, 317, 5, 68, "Subsubsection",ExpressionUUID->"8e91f318-8bfb-46d9-9402-728f48263f3a"],
Cell[289946, 7345, 224, 5, 52, "Text",ExpressionUUID->"1e80cb5f-f892-4c52-a3b8-82f27ccfacd5"],
Cell[CellGroupData[{
Cell[290195, 7354, 2885, 71, 173, "Input",ExpressionUUID->"6b2e4326-21d6-41da-bda6-78ffa617dce1"],
Cell[293083, 7427, 30425, 556, 401, "Output",ExpressionUUID->"1478ea33-d48c-40d3-84d9-e0f6f8c722c3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[323557, 7989, 222, 4, 68, "Subsubsection",ExpressionUUID->"57dc040b-d7b3-438f-9a80-335d91737f9e"],
Cell[323782, 7995, 188, 3, 52, "Text",ExpressionUUID->"a93a6e85-519e-4d19-82a0-a6ae248bce2c"],
Cell[CellGroupData[{
Cell[323995, 8002, 2567, 67, 173, "Input",ExpressionUUID->"3f8e59e8-453d-4cb0-bcaa-940ad3f31948"],
Cell[326565, 8071, 33663, 624, 401, "Output",ExpressionUUID->"88294490-23da-4de7-bf0b-d01d2aec7730"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[360277, 8701, 216, 4, 68, "Subsubsection",ExpressionUUID->"1bc336bc-ee5f-477b-928d-a98fc6079376"],
Cell[CellGroupData[{
Cell[360518, 8709, 3333, 85, 205, "Input",ExpressionUUID->"79fdc70b-798b-40b4-b734-17618a1faadd"],
Cell[363854, 8796, 35230, 646, 401, "Output",ExpressionUUID->"a564143e-cdbc-44ef-9b5a-4223aad4b1a1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[399133, 9448, 208, 4, 68, "Subsubsection",ExpressionUUID->"7e2bde79-e4c7-4244-b3d4-2839701b982b"],
Cell[CellGroupData[{
Cell[399366, 9456, 3508, 97, 173, "Input",ExpressionUUID->"5834d40b-cd33-4a7a-ada9-ebdc138b4b7e"],
Cell[402877, 9555, 21565, 375, 396, "Output",ExpressionUUID->"69ab0953-3f5e-426a-adb4-b034a47662c4"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[424503, 9937, 197, 3, 81, "Subsection",ExpressionUUID->"6f492177-ef02-4409-8227-9a384110cb13"],
Cell[424703, 9942, 290, 6, 52, "Text",ExpressionUUID->"f2826917-998c-4a2a-8d25-5ac5c38bfc8f"],
Cell[424996, 9950, 968, 25, 45, "Input",ExpressionUUID->"ad5d31ec-e2de-432b-946d-4dc32e838518"],
Cell[CellGroupData[{
Cell[425989, 9979, 1314, 36, 77, "Input",ExpressionUUID->"35f751fa-cb5c-442e-a61d-8fef1ac27128"],
Cell[427306, 10017, 714, 11, 70, "Output",ExpressionUUID->"3e76bad6-7714-4bed-bbee-17aaa3bebad0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[428057, 10033, 6369, 172, 428, "Input",ExpressionUUID->"3873999b-9d08-4f9f-8d19-f674cbe40f15"],
Cell[434429, 10207, 13942, 306, 365, "Output",ExpressionUUID->"dd2963bc-1944-4ebb-b5e3-15f4b81596bf"],
Cell[448374, 10515, 14488, 371, 555, "Output",ExpressionUUID->"6b0d69f9-6332-4f90-bbae-c5180fb378ac"],
Cell[462865, 10888, 27687, 523, 552, "Output",ExpressionUUID->"ff3b7176-cf9d-475a-afe1-95fc7b14dfea"],
Cell[490555, 11413, 37935, 691, 569, "Output",ExpressionUUID->"be4624f2-9b28-4ca1-913f-a6ae6096f709"]
}, Open  ]],
Cell[528505, 12107, 2083, 55, 109, "Input",ExpressionUUID->"3d65da30-c86d-4d65-9d7d-ea3fe1d9baa6"],
Cell[CellGroupData[{
Cell[530613, 12166, 828, 20, 45, "Input",ExpressionUUID->"e126d4cc-6d63-4e6b-b8ad-76e8f4daa2bf"],
Cell[531444, 12188, 7562, 146, 373, "Output",ExpressionUUID->"f9c00a9b-9866-4fed-90e4-17ee3228f563"]
}, Open  ]],
Cell[CellGroupData[{
Cell[539043, 12339, 3065, 83, 237, "Input",ExpressionUUID->"ea32b06b-66ec-4494-8580-416cf2961895"],
Cell[542111, 12424, 10842, 283, 217, "Output",ExpressionUUID->"fd12c329-ed3e-4c79-bf32-b1556a845605"],
Cell[552956, 12709, 28343, 535, 569, "Output",ExpressionUUID->"41d22454-02e6-4a61-b451-c70be4ddfb08"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

