function [coord,rota,tradefinv,detra2,traspo,R,R_]=local_sys(coordor)

% passaggio nel sistema cartesiano locale

point=[0,0,0;1,0,0;0,1,0;0,0,1];
P=zeros(4,3);
for ii=1:4
s=point(ii,1);
t=point(ii,2);
u=point(ii,3);
N1 = (1-s)*(1-t)*(1-u)/8;
N2 = (1+s)*(1-t)*(1-u)/8;
N3 = (1+s)*(1+t)*(1-u)/8;
N4 = (1-s)*(1+t)*(1-u)/8;
N5 = (1-s)*(1-t)*(1+u)/8;
N6 = (1+s)*(1-t)*(1+u)/8;
N7 = (1+s)*(1+t)*(1+u)/8;
N8 = (1-s)*(1+t)*(1+u)/8;
n=[N1,N2,N3,N4,N5,N6,N7,N8];
P(ii,:)=n*coordor;
end

% [Lmat]=Lmatrix;

O=P(1,:);
A=P(2,:);
B=P(3,:);
% C=P(4,:);

% Calculation of R and R_ matrices for transformation
v1 = A-O;
v2 = B-O;
v3 = cross(v1,v2);
v2 = cross(v3,v1);
r1 = v1/norm(v1);
r2 = v2/norm(v2);
r3 = v3/norm(v3);

Rot = [r1;r2;r3];
r = repmat({Rot},1,8);
R = blkdiag(r{:});
R_ = [
    r1(1)^2         r1(2)^2         r1(3)^2         r1(1)*r1(2)               r1(2)*r1(3)               r1(3)*r1(1)
    r2(1)^2         r2(2)^2         r2(3)^2         r2(1)*r2(2)               r2(2)*r2(3)               r2(3)*r2(1)
    r3(1)^2         r3(2)^2         r3(3)^2         r3(1)*r3(2)               r3(2)*r3(3)               r3(3)*r3(1)
    2*r1(1)*r2(1)   2*r1(2)*r2(2)   2*r1(3)*r2(3)   r1(1)*r2(2)+r2(1)*r1(2)   r1(2)*r2(3)+r2(2)*r1(3)   r1(3)*r2(1)+r2(3)*r1(1)
    2*r2(1)*r3(1)   2*r2(2)*r3(2)   2*r2(3)*r3(3)   r2(1)*r3(2)+r3(1)*r2(2)   r2(2)*r3(3)+r3(2)*r2(3)   r2(3)*r3(1)+r3(3)*r2(1)
    2*r3(1)*r1(1)   2*r3(2)*r1(2)   2*r3(3)*r1(3)   r3(1)*r1(2)+r1(1)*r3(2)   r3(2)*r1(3)+r1(2)*r3(3)   r3(3)*r1(1)+r1(3)*r3(1)
    ];

rota=cart_local(O,A,B);
%keyboard;
coord1=(rota*(coordor-[O;O;O;O;O;O;O;O])')';

% passaggio nel sistema cartesiano distorto

point=[0,0,0;1,0,0;0,1,0;0,0,1];
for ii=1:4
s=point(ii,1);
t=point(ii,2);
u=point(ii,3);
N1 = (1-s)*(1-t)*(1-u)/8;
N2 = (1+s)*(1-t)*(1-u)/8;
N3 = (1+s)*(1+t)*(1-u)/8;
N4 = (1-s)*(1+t)*(1-u)/8;
N5 = (1-s)*(1-t)*(1+u)/8;
N6 = (1+s)*(1-t)*(1+u)/8;
N7 = (1+s)*(1+t)*(1+u)/8;
N8 = (1-s)*(1+t)*(1+u)/8;
n=[N1,N2,N3,N4,N5,N6,N7,N8];
P(ii,:)=n*coord1;
end
O=P(1,:);
% A=P(2,:);
B=P(3,:);
C=P(4,:);

% v1=A-O;
v2=B-O;
v3=C-O;

% c1=v1/norm(v1);
c2=v2/norm(v2);
c3=v3/norm(v3);
%keyboard

% calcolo angoli di distorsione

a=asin(c2(1)); % angolo tra y e ys
d=acos(c3(3)); % angolo tra z e zs
t=atan2(c3(2),c3(1)); % angolo tra x e la proiezione dell'asse z sul piano xy

%keyboard
% matrice trasformazione coordinate

tra2=[1, -sin(a)/(cos(a)), sin(d).*(sin(a).*sin(t)-cos(a).*(cos(t)))/(cos(a).*cos(d));
    0, 1/(cos(a)), -sin(d)*sin(t)/(cos(a)*cos(d));
    0,0, 1/cos(d)];

% tra2al=inv([c1;c2;c3]');

detra2=cos(a).*cos(d);

% nuove coordinate nel sistema distorto
coord=(tra2*(coord1-[O;O;O;O;O;O;O;O])')';

% matrice trasformazione per spostamenti

traspo=[1, 0, 0;
    sin(a), cos(a), 0;
    cos(t).*sin(d), sin(t).*sin(d), cos(d)];
%invtraspo=inv(traspo);

% matrice trasformazione deformazioni

tradef=[1, 0, 0, 0, 0, 0;
        sin(a).^2, cos(a).^2, 0, cos(a).*sin(a), 0, 0;
        sin(d).^2.*cos(t).^2, sin(d).^2.*sin(t).^2, cos(d).^2, sin(d).^2.*cos(t).*sin(t), sin(d).*cos(d).*sin(t), sin(d).*cos(d).*cos(t);
        2*sin(a), 0, 0, cos(a), 0, 0;
        2*sin(a).*sin(d).*cos(t), 2*cos(a).*sin(d).*sin(t), 0, sin(d).*(cos(a).*cos(t)+sin(a).*sin(t)), cos(a).*cos(d), sin(a).*cos(d);
        2*sin(d).*cos(t), 0, 0, sin(d).*sin(t), 0, cos(d)];

tradefinv=inv(tradef);




%keyboard;
end