function [Ns21,Nt21,Nu21]= ShapeFunsP15


% 3x7 integration for normal strains
GaussP=[0.333333333333333,0.333333333333333   ,-0.774596669241483;
    0.797426985353087,0.101286507323456   ,-0.774596669241483;
    0.101286507323456,0.797426985353087   ,-0.774596669241483;
    0.101286507323456,0.101286507323456   , -0.774596669241483;
    0.470142064105115,0.059715871789770   ,-0.774596669241483;
    0.059715871789770,0.470142064105115   ,-0.774596669241483;
    0.470142064105115,0.470142064105115   ,-0.774596669241483;
    0.333333333333333,0.333333333333333 ,0;
    0.797426985353087,0.101286507323456 ,0;
    0.101286507323456,0.797426985353087 ,0;
    0.101286507323456,0.101286507323456 ,0;
    0.470142064105115,0.059715871789770 ,0;
    0.059715871789770,0.470142064105115 ,0;
    0.470142064105115,0.470142064105115 ,0;
    0.333333333333333,0.333333333333333   , 0.774596669241483;
    0.797426985353087,0.101286507323456   ,0.774596669241483;
    0.101286507323456,0.797426985353087   ,0.774596669241483;
    0.101286507323456,0.101286507323456   , 0.774596669241483;
    0.470142064105115,0.059715871789770   ,0.774596669241483;
    0.059715871789770,0.470142064105115   ,0.774596669241483;
    0.470142064105115,0.470142064105115   ,0.774596669241483];

for ii=1:21
    
    
    xi=GaussP(ii,1);
    et=GaussP(ii,2);
    ze=GaussP(ii,3);
    
    a=1-xi-et;
    
    N1xi=  0.5*(1-ze)*(4*xi+4*et+ze-2);
    N2xi=  0.5*(1-ze)*(4*xi-ze-2);
    N3xi=  0;
    N4xi=  0.5*(1+ze)*(4*xi+4*et-ze-2);
    N5xi=  0.5*(1+ze)*(4*xi+ze-2);
    N6xi=  0;
    N7xi=  2*(1-ze)*(1-2*xi-et);
    N8xi=  2*et*(1-ze);
    N9xi= -2*et*(1-ze);
    N10xi= 2*(1+ze)*(1-2*xi-et);
    N11xi= 2*et*(1+ze);
    N12xi= -2*et*(1+ze);
    N13xi= -(1-ze*ze);
    N14xi=  (1-ze*ze);
    N15xi=  0;
    
    N1et=  0.5*(1-ze)*(4*xi+4*et+ze-2);
    N2et= 0;
    N3et= 0.5*(1-ze)*(4*et-ze-2);
    N4et= 0.5*(1+ze)*(4*xi+4*et-ze-2);
    N5et= 0;
    N6et= 0.5*(1+ze)*(4*et+ze-2);
    N7et= -2*xi*(1-ze);
    N8et= 2*xi*(1-ze);
    N9et= 2*(1-ze)*(1-xi-2*et);
    N10et=-2*xi*(1+ze);
    N11et= 2*xi*(1+ze);
    N12et= 2*(1+ze)*(1-xi-2*et);
    N13et=-(1-ze*ze);
    N14et= 0;
    N15et= (1-ze*ze);
    
    N1ze=  a*(xi+et+ze-0.5);
    N2ze= xi*(-xi+ze+0.5);
    N3ze= et*(-et+ze+0.5);
    N4ze=  a*(-xi-et+ze+0.5);
    N5ze= xi*(xi+ze-0.5);
    N6ze= et*(et+ze-0.5);
    N7ze= -2*xi*a;
    N8ze= -2*xi*et;
    N9ze= -2*et*a;
    N10ze= 2*xi*a;
    N11ze= 2*xi*et;
    N12ze= 2*et*a;
    N13ze=-2*a*ze;
    N14ze=-2*xi*ze;
    N15ze=-2*et*ze;
    
    Ns21(ii,:)=[N1xi,N2xi,N3xi,N4xi,N5xi,N6xi,N7xi,N8xi,N9xi,N10xi,N11xi,N12xi,N13xi,N14xi,N15xi];
    Nt21(ii,:)=[N1et,N2et,N3et,N4et,N5et,N6et,N7et,N8et,N9et,N10et,N11et,N12et,N13et,N14et,N15et];
    Nu21(ii,:)=[N1ze,N2ze,N3ze,N4ze,N5ze,N6ze,N7ze,N8ze,N9ze,N10ze,N11ze,N12ze,N13ze,N14ze,N15ze];
    
    
    
    
end

end % function end