function [n,Ns,Nt,Nu]=ShapeFuns8

pos=sqrt(3)/3;

GaussP=[-pos,-pos,-pos;
    pos,-pos,-pos;
    pos,pos,-pos;
    -pos,pos,-pos;
    -pos,-pos,pos;
    pos,-pos,pos;
    pos,pos,pos;
    -pos,pos,pos];

n=zeros(3,24,8);
Ns=zeros(8);
Nt=zeros(8);
Nu=zeros(8);

for gp=1:8
    
    s=GaussP(gp,1);
    t=GaussP(gp,2);
    u=GaussP(gp,3);
    
    N1 = (1-s)*(1-t)*(1-u)/8;
    N2 = (1+s)*(1-t)*(1-u)/8;
    N3 = (1+s)*(1+t)*(1-u)/8;
    N4 = (1-s)*(1+t)*(1-u)/8;
    N5 = (1-s)*(1-t)*(1+u)/8;
    N6 = (1+s)*(1-t)*(1+u)/8;
    N7 = (1+s)*(1+t)*(1+u)/8;
    N8 = (1-s)*(1+t)*(1+u)/8;
    
    % matrice funzioni di forma
    n(:,:,gp)=[N1,N2,N3,N4,N5,N6,N7,N8,zeros(1,16)
        zeros(1,8),N1,N2,N3,N4,N5,N6,N7,N8,zeros(1,8)
        zeros(1,16),N1,N2,N3,N4,N5,N6,N7,N8];

    
    N1s=-(1 - t)*(1 - u)/8;
    N2s=(1 - t)*(1 - u)/8;
    N3s=(t + 1)*(1 - u)/8;
    N4s=-(t + 1)*(1 - u)/8;
    N5s=-(1 - t)*(u + 1)/8;
    N6s=(1 - t)*(u + 1)/8;
    N7s=(t + 1)*(u + 1)/8;
    N8s=-(t + 1)*(u + 1)/8;
    
    N1t=-(1 - s)*(1 - u)/8;
    N2t=-(s + 1)*(1 - u)/8;
    N3t=(s + 1)*(1 - u)/8;
    N4t=(1 - s)*(1 - u)/8;
    N5t=-(1 - s)*(u + 1)/8;
    N6t=-(s + 1)*(u + 1)/8;
    N7t=(s + 1)*(u + 1)/8;
    N8t=(1 - s)*(u + 1)/8;
    
    N1u=-(1 - s)*(1 - t)/8;
    N2u=-(s + 1)*(1 - t)/8;
    N3u=-(s + 1)*(t + 1)/8;
    N4u=-(1 - s)*(t + 1)/8;
    N5u=(1 - s)*(1 - t)/8;
    N6u=(s + 1)*(1 - t)/8;
    N7u=(s + 1)*(t + 1)/8;
    N8u=(1 - s)*(t + 1)/8;
    
    Ns(gp,:)=[N1s,N2s,N3s,N4s,N5s,N6s,N7s,N8s];
    Nt(gp,:)=[N1t,N2t,N3t,N4t,N5t,N6t,N7t,N8t];
    Nu(gp,:)=[N1u,N2u,N3u,N4u,N5u,N6u,N7u,N8u];
    
end

end % function end