function [M] = MassMatrix(A,Ip,Iy,Iz,rhob,lb,phiy,phiz)
%% Mass matrix construction
% See Mass matrix for beam element in Lupos (page 32/370).

% Timoshenko rod element - mass matrix construction
M1 = zeros(12,12);
M2 = zeros(12,12);

multi1 = rhob * lb / 420;
multi2 = rhob / lb / 30;

%% M1
m1y = 156 + 294*phiy + 140*phiy^2;
m2y = 22 + 38.5*phiy + 17.5*phiy^2;
m3y = 54 + 126*phiy + 70*phiy^2;
m4y = 13 + 31.5*phiy + 17.5*phiy^2;
m5y = 4 + 7*phiy + 3.5*phiy^2;
m6y = 3 + 7*phiy + 3.5*phiy^2;
m7y = 36;
m8y = 3 - 15*phiy;
m9y = 4 + 5*phiy + 10*phiy^2;
m10y = 1 + 5*phiy - 5*phiy^2;

m1z = 156 + 294*phiz + 140*phiz^2;
m2z = 22 + 38.5*phiz + 17.5*phiz^2;
m3z = 54 + 126*phiz + 70*phiz^2;
m4z = 13 + 31.5*phiz + 17.5*phiz^2;
m5z = 4 + 7*phiz + 3.5*phiz^2;
m6z = 3 + 7*phiz + 3.5*phiz^2;
m7z = 36;
m8z = 3 - 15*phiz;
m9z = 4 + 5*phiz + 10*phiz^2;
m10z = 1 + 5*phiz - 5*phiz^2;

M1(1,1) = 140 * A;
M1(2,2) = m1y * A/(1+phiy)^2;
M1(3,3) = m1z * A/(1+phiz)^2;
M1(4,4) = 140 * Ip;
M1(5,5) = m5z * lb^2 * A/(1+phiz)^2;
M1(6,6) = m5y * lb^2 * A/(1+phiy)^2;

M1(7,7) = M1(1,1);
M1(8,8) = M1(2,2);
M1(9,9) = M1(3,3);
M1(10,10) = M1(4,4);
M1(11,11) = M1(5,5);
M1(12,12) = M1(6,6);

M1(1,7) = 70 * A;
M1(2,8) = m3y * A/(1+phiy)^2;
M1(3,9) = m3z * A/(1+phiz)^2;
M1(4,10) = 70 * Ip;
M1(5,11) = -m6z * lb^2 * A/(1+phiz)^2;
M1(6,12) = -m6y * lb^2 * A/(1+phiy)^2;

M1(7,1) = 70 * A;
M1(8,2) = m3y * A/(1+phiy)^2;
M1(9,3) = m3z * A/(1+phiz)^2;
M1(10,4) = 70 * Ip;
M1(11,5) = -m6z * lb^2 * A/(1+phiz)^2;
M1(12,6) = -m6y * lb^2 * A/(1+phiy)^2;

M1(5,3) = -m2z * lb * A/(1+phiz)^2;
M1(6,2) = +m2y * lb * A/(1+phiy)^2;
M1(3,5) = -m2z * lb * A/(1+phiz)^2;
M1(2,6) = +m2y * lb * A/(1+phiy)^2;

M1(5,9) = -m4z * lb * A/(1+phiz)^2;
M1(6,8) = +m4y * lb * A/(1+phiy)^2;
M1(9,5) = -m4z * lb * A/(1+phiz)^2;
M1(8,6) = +m4y * lb * A/(1+phiy)^2;

M1(12,8) = -m2y * lb * A/(1+phiy)^2;
M1(11,9) = +m2z * lb * A/(1+phiz)^2;
M1(8,12) = -m2y * lb * A/(1+phiy)^2;
M1(9,11) = +m2z * lb * A/(1+phiz)^2;

M1(12,2) = -m4y * lb * A/(1+phiy)^2;
M1(11,3) = +m4z * lb * A/(1+phiz)^2;
M1(2,12) = -m4y * lb * A/(1+phiy)^2;
M1(3,11) = +m4z * lb * A/(1+phiz)^2;

%% M2
M2(2,2) = m7y * Iz/(1+phiy)^2;
M2(2,6) = m8y * lb * Iz/(1+phiy)^2;
M2(2,8) = -m7y * Iz/(1+phiy)^2;
M2(2,12) = m8y * lb * Iz/(1+phiy)^2;

M2(3,3) = m7z * Iy/(1+phiz)^2;
M2(3,5) = -m8z * lb * Iy/(1+phiz)^2;
M2(3,9) = -m7z * Iy/(1+phiz)^2;
M2(3,11) = -m8z * lb * Iy/(1+phiz)^2;

M2(5,3) = -m8z *lb * Iy/(1+phiz)^2;
M2(5,5) = m9z *lb^2 * Iy/(1+phiz)^2;
M2(5,9) = m8z * lb * Iy/(1+phiz)^2;
M2(5,11) = -m10z * lb^2 * Iy/(1+phiz)^2;

M2(6,2) = m8y *lb * Iz/(1+phiy)^2;
M2(6,6) = m9y *lb^2 * Iz/(1+phiy)^2;
M2(6,8) = -m8y * lb * Iz/(1+phiy)^2;
M2(6,12) = -m10y * lb^2 * Iz/(1+phiy)^2;

M2(8,2) = -m7y * Iz/(1+phiy)^2;
M2(8,6) = -m8y * lb * Iz/(1+phiy)^2;
M2(8,8) = m7y * Iz/(1+phiy)^2;
M2(8,12) = -m8y * lb * Iz/(1+phiy)^2;

M2(9,3) = -m7z * Iy/(1+phiz)^2;
M2(9,5) = m8z * lb * Iy/(1+phiz)^2;
M2(9,9) = m7z * Iy/(1+phiz)^2;
M2(9,11) = m8z * lb * Iy/(1+phiz)^2;

M2(11,3) = -m8z *lb * Iy/(1+phiz)^2;
M2(11,5) = -m10z *lb^2 * Iy/(1+phiz)^2;
M2(11,9) = m8z *lb * Iy/(1+phiz)^2;
M2(11,11) = m9z *lb^2 * Iy/(1+phiz)^2;

M2(12,2) = m8y *lb * Iz/(1+phiy)^2;
M2(12,6) = -m10y *lb^2 * Iz/(1+phiy)^2;
M2(12,8) = -m8y *lb * Iz/(1+phiy)^2;
M2(12,12) = m9y *lb^2 * Iz/(1+phiy)^2;

%% Total M
M = multi1*M1 + multi2*M2;
